/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NatsThread
extends Thread {
    public static final String DEFAULT_NAME = "NatsThread";
    private static volatile boolean debugLifecycle = false;
    private static final AtomicInteger created = new AtomicInteger();
    private static final AtomicInteger alive = new AtomicInteger();
    private CountDownLatch startSignal = null;
    private CountDownLatch doneSignal = null;
    private final Logger logger = LoggerFactory.getLogger(NatsThread.class);

    public NatsThread(Runnable r) {
        this(r, DEFAULT_NAME);
    }

    public NatsThread(Runnable runnable, String name) {
        super(runnable, name + "-" + created.incrementAndGet());
        this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                NatsThread.this.logger.debug("UNCAUGHT in thread {}", (Object)t.getName(), (Object)e);
            }
        });
    }

    public NatsThread(Runnable r, String poolName, CountDownLatch startSignal, CountDownLatch doneSignal) {
        super(r, poolName);
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
    }

    @Override
    public void run() {
        boolean debug = debugLifecycle;
        if (debug) {
            this.logger.trace("Created {}", (Object)this.getName());
        }
        try {
            if (this.startSignal != null) {
                this.startSignal.await();
            }
            alive.incrementAndGet();
            super.run();
        }
        catch (InterruptedException e) {
            this.logger.trace("Interrupted: ", e);
        }
        finally {
            if (this.doneSignal != null) {
                this.doneSignal.countDown();
            }
            alive.decrementAndGet();
            if (debug) {
                this.logger.trace("Exiting {}", (Object)this.getName());
            }
        }
    }

    public static int getThreadsCreated() {
        return created.get();
    }

    public static int getThreadsAlive() {
        return alive.get();
    }

    public static boolean getDebug() {
        return debugLifecycle;
    }

    public static void setDebug(boolean b) {
        debugLifecycle = b;
    }
}

