/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapi;

import com.bloomberglp.blpapi.impl.infr.util.f;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;

public final class Datetime
implements Cloneable {
    public static final short YEAR = 128;
    public static final byte MONTH = 64;
    public static final byte DAY_OF_MONTH = 32;
    public static final byte HOUR = 16;
    public static final byte MINUTE = 8;
    public static final byte SECOND = 4;
    public static final byte MILLISECOND = 2;
    public static final byte TIME_ZONE_OFFSET = 1;
    public static final short DATE = 224;
    public static final short TIME = 28;
    public static final short TIMEMILLI = 30;
    public static final short MICROSECOND = 258;
    public static final short NANOSECOND = 770;
    public static final short PICOSECOND = 1794;
    private int h;
    private short[] i;
    private Calendar j;
    private long k;
    private int l = 1000;
    private int m = 1000000;
    private long n = 1000000000L;

    public Datetime() {
        this.init();
    }

    public Datetime(Datetime datetime) {
        this.init();
        this.j = null;
        this.h = datetime.h;
        this.k = datetime.k;
        System.arraycopy(datetime.i, 0, this.i, 0, this.i.length);
    }

    public Datetime(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.init();
        this.setDatetime(n2, n3, n4, n5, n6, n7, n8);
    }

    public Datetime(int n2, int n3, int n4) {
        this.init();
        this.setDate(n2, n3, n4);
    }

    public Datetime(int n2, int n3, int n4, int n5) {
        this.init();
        this.setTime(n2, n3, n4, n5);
    }

    public Datetime(Calendar calendar) {
        this.init();
        this.setDatetimeTz(calendar);
    }

    private void init() {
        this.i = new short[8];
        this.clear();
    }

    public int year() {
        return this.i[0];
    }

    public int month() {
        return this.i[1];
    }

    public int dayOfMonth() {
        return this.i[2];
    }

    public int hour() {
        return this.i[3];
    }

    public int minute() {
        return this.i[4];
    }

    public int second() {
        return this.i[5];
    }

    public int milliSecond() {
        return this.millisecond();
    }

    public int millisecond() {
        return this.i[6];
    }

    public int microsecond() {
        return (int)((this.k + (long)this.millisecond() * 1000000000L) / 1000000L);
    }

    public int nanosecond() {
        return (int)((this.k + (long)this.millisecond() * 1000000000L) / 1000L);
    }

    public long picosecond() {
        return this.k + (long)this.millisecond() * 1000000000L;
    }

    public int timezoneOffsetMinutes() {
        return this.i[7];
    }

    public Calendar calendar() {
        if (this.j == null) {
            this.j = Calendar.getInstance();
        }
        this.j.clear();
        if (this.hasParts(128)) {
            this.j.set(1, this.i[0]);
        }
        if (this.hasParts(64)) {
            this.j.set(2, this.i[1] - 1);
        }
        if (this.hasParts(32)) {
            this.j.set(5, this.i[2]);
        }
        if (this.hasParts(16)) {
            this.j.set(11, this.i[3]);
        }
        if (this.hasParts(8)) {
            this.j.set(12, this.i[4]);
        }
        if (this.hasParts(4)) {
            this.j.set(13, this.i[5]);
        }
        if (this.hasParts(2)) {
            this.j.set(14, this.i[6]);
        }
        if (this.hasParts(1)) {
            if (this.i[7] == 0) {
                this.j.setTimeZone(TimeZone.getTimeZone("GMT"));
            } else {
                Calendar calendar = Calendar.getInstance();
                TimeZone timeZone = calendar.getTimeZone();
                Calendar calendar2 = this.hasParts(128) ? this.j : calendar;
                int n2 = ((calendar2.get(11) * 60 + calendar2.get(12)) * 60 + calendar2.get(13)) * 1000 + calendar2.get(14);
                int n3 = timeZone.getOffset(calendar2.get(0), calendar2.get(1), calendar2.get(2), calendar2.get(5), calendar2.get(7), n2) / 60000;
                if (n3 != this.i[7]) {
                    this.j.setTimeZone(TimeZone.getTimeZone("GMT"));
                    if (this.hasParts(16)) {
                        this.j.setTimeInMillis(this.j.getTimeInMillis() + (long)(this.i[7] * 60 * 1000));
                    }
                }
            }
        }
        return this.j;
    }

    public boolean isValidField(int n2) {
        return this.hasParts(n2);
    }

    public int parts() {
        return this.h;
    }

    public boolean hasParts(int n2) {
        return n2 == (this.h & n2);
    }

    public boolean isValid() {
        if ((this.hasParts(128) || this.hasParts(64) || this.hasParts(32)) && !this.b()) {
            return false;
        }
        return !this.hasParts(16) && !this.hasParts(8) && !this.hasParts(4) && !this.hasParts(2) || this.c();
    }

    public void setDatetime(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.setYear(n2);
        this.setMonth(n3);
        this.setDayOfMonth(n4);
        this.setHour(n5);
        this.setMinute(n6);
        this.setSecond(n7);
        this.setMillisecond(n8);
    }

    public void setDatetimeTz(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setDatetime(n2, n3, n4, n5, n6, n7, n8);
        this.setTimezoneOffsetMinutes(n9);
    }

    public void setDate(int n2, int n3, int n4) {
        this.setYear(n2);
        this.setMonth(n3);
        this.setDayOfMonth(n4);
    }

    public void setDateTz(int n2, int n3, int n4, int n5) {
        this.setDate(n2, n3, n4);
        this.setTimezoneOffsetMinutes(n5);
    }

    public void setTime(int n2, int n3, int n4, int n5) {
        this.setHour(n2);
        this.setMinute(n3);
        this.setSecond(n4);
        this.setMillisecond(n5);
    }

    public void setTimeTz(int n2, int n3, int n4, int n5, int n6) {
        this.setTime(n2, n3, n4, n5);
        this.setTimezoneOffsetMinutes(n6);
    }

    public void setDatetimeTz(Calendar calendar) {
        this.setDatetime(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
        int n2 = ((calendar.get(11) * 60 + calendar.get(12)) * 60 + calendar.get(13)) * 1000 + calendar.get(14);
        int n3 = calendar.getTimeZone().getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), n2) / 60000;
        this.setTimezoneOffsetMinutes(n3);
    }

    public void setYear(int n2) {
        this.i[0] = (short)n2;
        this.h |= 0x80;
    }

    public void setMonth(int n2) {
        this.i[1] = (byte)n2;
        this.h |= 0x40;
    }

    public void setDayOfMonth(int n2) {
        this.i[2] = (byte)n2;
        this.h |= 0x20;
    }

    public void setHour(int n2) {
        this.i[3] = (byte)n2;
        this.h |= 0x10;
    }

    public void setMinute(int n2) {
        this.i[4] = (byte)n2;
        this.h |= 8;
    }

    public void setSecond(int n2) {
        this.i[5] = (byte)n2;
        this.h |= 4;
    }

    public void setMilliSecond(int n2) {
        this.setMillisecond(n2);
    }

    public void setMillisecond(int n2) {
        this.i[6] = (short)n2;
        this.h |= 2;
    }

    public void setMicrosecond(int n2) {
        this.setMillisecond(n2 / this.l % 1000);
        this.k = (long)(n2 % 1000) * 1000000L;
        this.h |= 0x102;
    }

    public void setNanosecond(int n2) {
        this.setMillisecond(n2 / this.m % 1000);
        this.k = (long)n2 % 1000000L * 1000L;
        this.h |= 0x302;
    }

    public void setPicosecond(long l2) {
        this.setMillisecond((int)(l2 / this.n % 1000L));
        this.k = l2 % 1000000000L;
        this.h |= 0x702;
    }

    public void setTimezoneOffsetMinutes(int n2) {
        this.i[7] = (short)n2;
        this.h |= 1;
    }

    public void clear() {
        this.h = 0;
        this.i[0] = 1;
        this.i[1] = 1;
        this.i[2] = 1;
        this.i[3] = 24;
        this.i[4] = 0;
        this.i[5] = 0;
        this.i[6] = 0;
        this.i[7] = 0;
        this.j = null;
        this.k = 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Datetime) {
            Datetime datetime = (Datetime)object;
            if ((this.h & 0xFF) == (datetime.h & 0xFF) && Arrays.equals(this.i, datetime.i) && this.k == datetime.k) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        return new Datetime(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10);
        char c2 = '\u0000';
        if (this.hasParts(128) || this.hasParts(64) || this.hasParts(32)) {
            stringBuilder.append(f.i(this));
            c2 = 'T';
        }
        if (this.hasParts(16) || this.hasParts(8) || this.hasParts(4) || this.hasParts(2)) {
            if (c2 != '\u0000') {
                stringBuilder.append(c2);
            }
            stringBuilder.append(f.k(this));
        }
        if (this.hasParts(1)) {
            f.g(stringBuilder, this);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        Long l2 = new Long((long)(this.i[0] + this.i[1] + this.i[2] * 3600000 + this.i[3] * 3600000 + this.i[4] * 60000 + this.i[5] * 1000 + this.i[6] + this.i[7]) + this.k);
        return l2.hashCode();
    }

    private boolean isLeapYear(int n2) {
        return 0 == n2 % 4 && (n2 <= 1752 || 0 != n2 % 100 || 0 == n2 % 400);
    }

    private boolean b() {
        int n2 = this.year();
        int n3 = this.month();
        int n4 = this.dayOfMonth();
        if (n2 <= 0 || n2 > 9999 || n3 <= 0 || n3 > 12 || n4 <= 0 || n4 > 31) {
            return false;
        }
        if (n4 < 29) {
            return true;
        }
        if (n2 == 1752 && n3 == 9 && n4 > 2 && n4 < 14) {
            return false;
        }
        switch (n3) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return true;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return n4 <= 30;
            }
            case 2: {
                if (this.isLeapYear(n2)) {
                    return n4 <= 29;
                }
                return n4 <= 28;
            }
        }
        return true;
    }

    private boolean c() {
        int n2 = this.hour();
        int n3 = this.minute();
        int n4 = this.second();
        long l2 = this.picosecond();
        if (n2 == 24) {
            return n3 == 0 && n4 == 0 && l2 == 0L;
        }
        return n2 >= 0 && n2 < 24 && n3 >= 0 && n3 < 60 && n4 >= 0 && n4 < 60 && l2 >= 0L && l2 < 1000000000000L;
    }
}

