/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps.util.argparser;

import com.bloomberglp.blpapiexamples.demoapps.util.argparser.Arg;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArgGroup {
    private static final int DESCRIPTION_POSITION = 24;
    protected static final String DESCRIPTION_INDENTATION = ArgGroup.getIndentation(24);
    protected final String description;
    protected final List<Arg> args = new ArrayList<Arg>();

    public ArgGroup(String description, Arg ... args) {
        if (description == null) {
            throw new IllegalArgumentException("description must not be null");
        }
        this.description = description;
        this.add(args);
    }

    public String getDescription() {
        return this.description;
    }

    public ArgGroup add(Arg ... newArgs) {
        if (newArgs == null) {
            throw new IllegalArgumentException("args must not be null");
        }
        for (Arg arg : newArgs) {
            this.args.add(arg);
        }
        return this;
    }

    public Arg add(String ... forms) {
        Arg arg = new Arg(forms);
        this.add(arg);
        return arg;
    }

    public List<Arg> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    private static String getArgFullDescription(Arg arg) {
        StringBuilder sb = new StringBuilder();
        String argDescription = arg.getDescription() == null ? "" : arg.getDescription();
        String[] descriptionLines = argDescription.split("[\r\n]+");
        String firstLineDescription = descriptionLines[0];
        String defaultValue = arg.defaultValueToString();
        String helpAndDefault = (firstLineDescription + " " + defaultValue).trim();
        sb.append(helpAndDefault);
        if (arg.getMode().allowMultipleValues()) {
            if (sb.length() > 0) {
                sb.append(". ");
            }
            sb.append("Can be specified multiple times.");
        }
        String eol = System.lineSeparator();
        for (int i2 = 1; i2 < descriptionLines.length; ++i2) {
            sb.append(eol).append(DESCRIPTION_INDENTATION).append(descriptionLines[i2]);
        }
        if (!arg.getChoices().isEmpty()) {
            if (sb.length() > 0) {
                sb.append(eol).append(DESCRIPTION_INDENTATION);
            }
            sb.append("(Choices: " + arg.getChoices() + ")");
        }
        return sb.toString();
    }

    public void printHelp(PrintWriter pw) {
        pw.println(this.description + ":");
        if (this.args.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(200);
        for (Arg arg : this.args) {
            String fullName = arg.getFullName();
            sb.append("  ").append(fullName);
            String fullDescription = ArgGroup.getArgFullDescription(arg);
            if (!fullDescription.isEmpty()) {
                int length = 2 + fullName.length();
                if (length + 2 > 24) {
                    sb.append(System.lineSeparator());
                    length = 0;
                }
                sb.append(ArgGroup.getIndentation(24 - length));
                sb.append(fullDescription);
            }
            pw.println(sb);
            sb.delete(0, sb.length());
        }
    }

    public String toString() {
        return this.description;
    }

    private static String getIndentation(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i2 = 0; i2 < length; ++i2) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

