/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps.util.argparser;

import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class Arg {
    private static final char PREFIX_CHAR = '-';
    private String shortForm;
    private String longForm;
    private String metaVar;
    private String description;
    private ArgMode mode = ArgMode.SINGLE_VALUE;
    private String defaultValue;
    private Consumer<String> action;
    private boolean required = false;
    private List<String> choices = new ArrayList<String>();

    public Arg(String ... forms) {
        if (forms == null || forms.length == 0) {
            throw new IllegalArgumentException("no short or long form was specified");
        }
        for (String form : forms) {
            this.assignForm(form);
        }
    }

    private void assignForm(String form) {
        if (form == null) {
            throw new IllegalArgumentException("Null form");
        }
        int len = form.length();
        if (len < 2 || form.charAt(0) != '-') {
            throw new IllegalArgumentException("Invalid form: " + form);
        }
        if (form.charAt(1) == '-') {
            if (len < 4) {
                throw new IllegalArgumentException("Invalid long form: " + form);
            }
            if (this.longForm != null) {
                throw new IllegalArgumentException("Long form was specified more than once");
            }
            this.longForm = form;
        } else {
            if (len != 2) {
                throw new IllegalArgumentException("Invalid short form: " + form);
            }
            if (this.shortForm != null) {
                throw new IllegalArgumentException("Short form was specified more than once");
            }
            this.shortForm = form;
        }
    }

    public String getShortForm() {
        return this.shortForm;
    }

    public String getLongForm() {
        return this.longForm;
    }

    public String getMetaVar() {
        return this.metaVar;
    }

    public Arg setMetaVar(String metaVar) {
        if (metaVar == null || metaVar.isEmpty()) {
            throw new IllegalArgumentException("metaVar must not be empty");
        }
        this.metaVar = metaVar;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Arg setDescription(String description) {
        this.description = description;
        return this;
    }

    public ArgMode getMode() {
        return this.mode;
    }

    public Arg setMode(ArgMode mode) {
        this.mode = mode;
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Arg setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    Consumer<String> getAction() {
        return this.action;
    }

    public Arg setAction(Consumer<String> action) {
        this.action = action;
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Arg setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public Arg setChoices(String ... values) {
        if (values == null) {
            throw new IllegalArgumentException("choices must not be null");
        }
        for (String c2 : values) {
            this.choices.add(c2);
        }
        return this;
    }

    public boolean isValidChoice(String value) {
        return this.choices.isEmpty() || this.choices.contains(value);
    }

    public List<String> getChoices() {
        return Collections.unmodifiableList(this.choices);
    }

    String getFullName() {
        String forms = this.shortForm == null ? this.longForm : (this.longForm == null ? this.shortForm : this.shortForm + ", " + this.longForm);
        if (!this.mode.requiresValue()) {
            return forms;
        }
        String mv = this.metaVar;
        if (mv == null) {
            mv = this.longForm == null ? "VALUE" : this.longForm.substring(2).toUpperCase();
        }
        return forms + " " + mv;
    }

    String defaultValueToString() {
        return this.defaultValue == null ? "" : "(default: " + this.defaultValue + ")";
    }

    public String toString() {
        return "[" + this.getFullName() + "]";
    }
}

