/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps.snippets.instruments;

import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.InvalidConversionException;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.NotFoundException;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapiexamples.demoapps.snippets.instruments.InstrumentsFilter;
import java.util.List;

public class CurveListRequests {
    private static final Name NAME_DESCRIPTION = Name.getName("description");
    private static final Name NAME_QUERY = Name.getName("query");
    private static final Name NAME_RESULTS = Name.getName("results");
    private static final Name NAME_MAX_RESULTS = Name.getName("maxResults");
    private static final Name NAME_CURVE = Name.getName("curve");
    private static final Name[] CURVE_RESPONSE_ELEMENTS = new Name[]{Name.getName("country"), Name.getName("currency"), Name.getName("curveid"), Name.getName("type"), Name.getName("subtype"), Name.getName("publisher"), Name.getName("bbgid")};

    public static Request createRequest(Service instrumentsService, String query, int maxResults, List<InstrumentsFilter> filters) {
        Request request = instrumentsService.createRequest("curveListRequest");
        request.set(NAME_QUERY, query);
        request.set(NAME_MAX_RESULTS, maxResults);
        for (InstrumentsFilter filter : filters) {
            try {
                request.set(filter.name, filter.value);
            }
            catch (NotFoundException e2) {
                throw new IllegalArgumentException("Filter not found: " + filter.name, e2);
            }
            catch (InvalidConversionException e3) {
                throw new IllegalArgumentException("Invalid value: " + filter.value + " for filter: " + filter.name, e3);
            }
        }
        return request;
    }

    public static void processResponse(Message msg) {
        Element results = msg.getElement(NAME_RESULTS);
        int numResults = results.numValues();
        System.out.println("Processing " + numResults + " results:");
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < numResults; ++i2) {
            Element result = results.getValueAsElement(i2);
            for (Name n2 : CURVE_RESPONSE_ELEMENTS) {
                if (sb.length() != 0) {
                    sb.append(" ");
                }
                sb.append(n2).append("=").append(result.getElementAsString(n2));
            }
            String curve = result.getElementAsString(NAME_CURVE);
            String description = result.getElementAsString(NAME_DESCRIPTION);
            System.out.println("    " + (i2 + 1) + " " + curve + " - " + description + ", " + sb);
            sb.delete(0, sb.length());
        }
    }
}

