/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.Session;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.SubscriptionList;
import com.bloomberglp.blpapi.TlsOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.MaxEventsOption;
import com.bloomberglp.blpapiexamples.demoapps.util.SubscriptionOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import java.io.IOException;
import java.util.Iterator;

public class SubscriptionWithEventPollingExample {
    private static final Name SERVICE_NAME = Name.getName("serviceName");

    private static void printContactSupportMessage(Message message) {
        String requestId = message.getRequestId();
        if (requestId != null) {
            System.err.println("When contacting support, please provide RequestId " + requestId + '.');
        }
    }

    private static boolean processGenericMessage(Event.EventType eventType, Message message) {
        Name messageType = message.messageType();
        if (eventType == Event.EventType.SESSION_STATUS) {
            if (messageType.equals(Names.SESSION_TERMINATED) || messageType.equals(Names.SESSION_STARTUP_FAILURE)) {
                System.err.println("Session failed to start or terminated.");
                SubscriptionWithEventPollingExample.printContactSupportMessage(message);
                return true;
            }
        } else if (eventType == Event.EventType.SERVICE_STATUS && messageType.equals(Names.SERVICE_OPEN_FAILURE)) {
            String serviceName = message.getElementAsString(SERVICE_NAME);
            System.err.println("Failed to open " + serviceName + ".");
            SubscriptionWithEventPollingExample.printContactSupportMessage(message);
        }
        return false;
    }

    private static void checkFailures(Session session) {
        block0: while (true) {
            Message msg;
            Event event;
            if ((event = session.tryNextEvent()) == null) {
                return;
            }
            Iterator<Message> iterator = event.iterator();
            do {
                if (!iterator.hasNext()) continue block0;
                msg = iterator.next();
                System.out.println(msg);
            } while (!SubscriptionWithEventPollingExample.processGenericMessage(event.eventType(), msg));
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(String[] args) throws IOException, InterruptedException, TlsOptions.TlsInitializationException {
        ArgParser argParser = new ArgParser("Subscription example with event polling", SubscriptionWithEventPollingExample.class);
        ConnectionAndAuthOptions connectionAndAuthOptions = new ConnectionAndAuthOptions(argParser);
        SubscriptionOptions subscriptionOptions = new SubscriptionOptions(argParser);
        MaxEventsOption maxEventsConfig = new MaxEventsOption(argParser);
        try {
            argParser.parse(args);
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return;
        }
        SessionOptions sessionOptions = connectionAndAuthOptions.createSessionOption("Subscriber");
        subscriptionOptions.setSessionOptions(sessionOptions);
        Session session = new Session(sessionOptions);
        try {
            if (!session.start()) {
                System.err.println("Failed to start session.");
                SubscriptionWithEventPollingExample.checkFailures(session);
                return;
            }
            if (!session.openService(subscriptionOptions.service)) {
                SubscriptionWithEventPollingExample.checkFailures(session);
                return;
            }
            SubscriptionList subscriptions = subscriptionOptions.createSubscriptionList((index, topic) -> new CorrelationID(topic));
            session.subscribe(subscriptions);
            int maxEvents = maxEventsConfig.getMaxEvents();
            int eventCount = 0;
            boolean done = false;
            while (!done) {
                Event event = session.nextEvent();
                Event.EventType eventType = event.eventType();
                for (Message msg : event) {
                    String topic2;
                    System.out.println(msg);
                    Name messageType = msg.messageType();
                    CorrelationID msgCorrelationId = msg.correlationID();
                    if (eventType == Event.EventType.SUBSCRIPTION_STATUS) {
                        if (!messageType.equals(Names.SUBSCRIPTION_FAILURE) && !messageType.equals(Names.SUBSCRIPTION_TERMINATED)) continue;
                        topic2 = (String)msgCorrelationId.object();
                        System.err.println("Subscription failed for topic " + topic2);
                        SubscriptionWithEventPollingExample.printContactSupportMessage(msg);
                        continue;
                    }
                    if (eventType == Event.EventType.SUBSCRIPTION_DATA) {
                        topic2 = (String)msgCorrelationId.object();
                        System.out.println("Received subscription data for topic " + topic2);
                        if (msg.recapType() != Message.Recap.SOLICITED || msg.getRequestId() == null) continue;
                        System.out.println("Received init paint with RequestId " + msg.getRequestId());
                        continue;
                    }
                    done = SubscriptionWithEventPollingExample.processGenericMessage(eventType, msg);
                }
                if (eventType != Event.EventType.SUBSCRIPTION_DATA || ++eventCount < maxEvents) continue;
                break;
            }
        }
        finally {
            session.stop();
        }
    }

    public static void main(String[] args) {
        try {
            SubscriptionWithEventPollingExample.run(args);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

