/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.EventHandler;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.Session;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.SubscriptionList;
import com.bloomberglp.blpapi.TlsOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.SubscriptionOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import java.io.IOException;
import java.time.LocalDateTime;

public class SubscriptionExample {
    private ConnectionAndAuthOptions connectionAndAuthOptions;
    private SubscriptionOptions subscriptionOptions;
    private SubscriptionList subscriptions;
    private int eventQueueSize = 10000;

    public static void main(String[] args) {
        SubscriptionExample example = new SubscriptionExample();
        try {
            example.run(args);
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args) throws InterruptedException, TlsOptions.TlsInitializationException, IOException {
        if (!this.parseCommandLine(args)) {
            return;
        }
        SessionOptions sessionOptions = this.connectionAndAuthOptions.createSessionOption("Subscriber");
        this.subscriptionOptions.setSessionOptions(sessionOptions);
        sessionOptions.setMaxEventQueueSize(this.eventQueueSize);
        Session session = new Session(sessionOptions, new SubscriptionEventHandler());
        try {
            if (!session.start()) {
                System.err.println("Failed to start session.");
                return;
            }
            System.out.println("Session started successfully.");
            if (!session.openService(this.subscriptionOptions.service)) {
                System.err.println("Failed to open service " + this.subscriptionOptions.service);
                return;
            }
            System.out.println("Subscribing...");
            this.subscriptions = this.subscriptionOptions.createSubscriptionList((index, topic) -> new CorrelationID(topic));
            session.subscribe(this.subscriptions);
            System.out.println("Press ENTER to quit");
            System.in.read();
        }
        finally {
            session.stop();
        }
    }

    private boolean parseCommandLine(String[] args) {
        ArgParser argParser = new ArgParser("Asynchronous subscription with event handler", SubscriptionExample.class);
        this.connectionAndAuthOptions = new ConnectionAndAuthOptions(argParser);
        this.subscriptionOptions = new SubscriptionOptions(argParser);
        try {
            argParser.addArg("-q", "--event-queue-size").setMetaVar("eventQueueSize").setDescription("The maximum number of events that is buffered by the session").setDefaultValue(Integer.toString(this.eventQueueSize)).setAction(value -> {
                this.eventQueueSize = Integer.parseInt(value);
            });
            argParser.parse(args);
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return false;
        }
        return true;
    }

    class SubscriptionEventHandler
    implements EventHandler {
        SubscriptionEventHandler() {
        }

        @Override
        public void processEvent(Event event, Session session) {
            try {
                switch (event.eventType().intValue()) {
                    case 8: {
                        this.processSubscriptionDataEvent(event);
                        break;
                    }
                    case 3: {
                        this.processSubscriptionStatus(event);
                        break;
                    }
                    default: {
                        this.processGenericEvent(event);
                        break;
                    }
                }
            }
            catch (Exception e2) {
                System.err.println("Failed to process event " + event + " " + e2);
            }
        }

        private void processSubscriptionStatus(Event event) {
            for (Message msg : event) {
                CorrelationID cid = msg.correlationID();
                String topic = (String)cid.object();
                System.out.println(LocalDateTime.now() + ": " + topic);
                System.out.println("MESSAGE: " + msg);
                if (Names.SUBSCRIPTION_FAILURE.equals(msg.messageType())) {
                    System.err.println("Subscription for " + topic + " failed.");
                    continue;
                }
                if (!Names.SUBSCRIPTION_TERMINATED.equals(msg.messageType())) continue;
                System.err.println("Subscription for " + topic + " terminated.");
            }
        }

        private void processSubscriptionDataEvent(Event event) {
            for (Message msg : event) {
                String topic = (String)msg.correlationID().object();
                System.out.println(LocalDateTime.now() + ": " + topic);
                System.out.println(msg);
            }
        }

        private void processGenericEvent(Event event) {
            for (Message msg : event) {
                if (Names.SLOW_CONSUMER_WARNING.equals(msg.messageType())) {
                    System.out.println(Names.SLOW_CONSUMER_WARNING + " - The event queue is beginning to approach its maximum capacity and the application is not processing the data fast enough. This could lead to ticks being dropped (DataLoss).");
                    System.out.println();
                    continue;
                }
                if (Names.SLOW_CONSUMER_WARNING_CLEARED.equals(msg.messageType())) {
                    System.out.println(Names.SLOW_CONSUMER_WARNING_CLEARED + " - the event queue has shrunk enough that there is no longer any immediate danger of overflowing the queue. If any precautionary actions were taken when SlowConsumerWarning message was delivered, it is now safe to continue as normal.");
                    System.out.println();
                    continue;
                }
                System.out.println(msg);
                if (Names.DATA_LOSS.equals(msg.messageType())) {
                    CorrelationID cid = msg.correlationID();
                    String topic = (String)cid.object();
                    System.out.println(Names.DATA_LOSS + " - The application is too slow to process events and the event queue is overflowing. Data is lost for topic " + topic + ".");
                    System.out.println();
                    continue;
                }
                if (Event.EventType.SESSION_STATUS != event.eventType() || !Names.SESSION_TERMINATED.equals(msg.messageType())) continue;
                System.out.println("Session terminated.");
                return;
            }
        }
    }
}

