/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.Session;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapiexamples.demoapps.snippets.instruments.CurveListRequests;
import com.bloomberglp.blpapiexamples.demoapps.snippets.instruments.GovtListRequests;
import com.bloomberglp.blpapiexamples.demoapps.snippets.instruments.InstrumentListRequests;
import com.bloomberglp.blpapiexamples.demoapps.snippets.instruments.InstrumentsFilter;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.Arg;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgGroup;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgMode;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SecurityLookupExample {
    private static final Name ERROR_RESPONSE = Name.getName("ErrorResponse");
    private static final Name INSTRUMENT_LIST_RESPONSE = Name.getName("InstrumentListResponse");
    private static final Name CURVE_LIST_RESPONSE = Name.getName("CurveListResponse");
    private static final Name GOVT_LIST_RESPONSE = Name.getName("GovtListResponse");
    private static final String INSTRUMENT_LIST_REQUEST = "instrumentListRequest";
    private static final String CURVE_LIST_REQUEST = "curveListRequest";
    private static final String GOVT_LIST_REQUEST = "govtListRequest";
    private static final String INSTRUMENT_SERVICE = "//blp/instruments";
    private static final String[] FILTERS_INSTRUMENTS = new String[]{"yellowKeyFilter", "languageOverride"};
    private static final String[] FILTERS_GOVT = new String[]{"ticker", "partialMatch"};
    private static final String[] FILTERS_CURVE = new String[]{"countryCode", "currencyCode", "type", "subtype", "curveid", "bbgid"};
    private ConnectionAndAuthOptions connectionAndAuthOptions;
    private String query;
    private String requestType;
    private int maxResults;
    private List<InstrumentsFilter> filters = new ArrayList<InstrumentsFilter>();

    private boolean parseCommandLine(String[] args) {
        ArgParser argParser = new ArgParser("Security Lookup Example", SecurityLookupExample.class);
        this.connectionAndAuthOptions = new ConnectionAndAuthOptions(argParser);
        try {
            ArgGroup argGroupLookup = new ArgGroup("Security Lookup Options", new Arg[0]);
            argGroupLookup.add("-r", "--request").setMetaVar("requestType").setDescription("specify the request type").setDefaultValue(INSTRUMENT_LIST_REQUEST).setChoices(INSTRUMENT_LIST_REQUEST, CURVE_LIST_REQUEST, GOVT_LIST_REQUEST).setAction(value -> {
                this.requestType = value;
            });
            argGroupLookup.add("-S", "--security").setMetaVar("security").setDescription("security query string").setDefaultValue("IBM").setAction(value -> {
                this.query = value;
            });
            argGroupLookup.add("--max-results").setMetaVar("maxResults").setDescription("max results returned in the response").setDefaultValue("10").setAction(value -> {
                this.maxResults = Integer.parseInt(value);
            });
            String eol = System.lineSeparator();
            argGroupLookup.add("-F", "--filter").setMetaVar("<filter>=<value>").setMode(ArgMode.MULTIPLE_VALUES).setDescription("filter and value separated by '=', e.g., countryCode=US" + eol + "The applicable filters for each request:" + eol + INSTRUMENT_LIST_REQUEST + ": " + Arrays.toString(FILTERS_INSTRUMENTS) + eol + CURVE_LIST_REQUEST + ": " + Arrays.toString(FILTERS_CURVE) + eol + GOVT_LIST_REQUEST + ": " + Arrays.toString(FILTERS_GOVT)).setAction(value -> {
                String[] tokens = value.split("=");
                if (tokens.length != 2) {
                    throw new IllegalArgumentException("Invalid filter option " + value);
                }
                this.filters.add(new InstrumentsFilter(Name.getName(tokens[0]), tokens[1]));
            });
            argParser.addGroup(argGroupLookup);
            argParser.parse(args);
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return false;
        }
        return true;
    }

    private static void processResponseEvent(Event event) {
        for (Message msg : event) {
            Name msgType = msg.messageType();
            if (msgType.equals(ERROR_RESPONSE)) {
                System.out.println("Received error: " + msg);
                continue;
            }
            if (msgType.equals(INSTRUMENT_LIST_RESPONSE)) {
                InstrumentListRequests.processResponse(msg);
                continue;
            }
            if (msgType.equals(CURVE_LIST_RESPONSE)) {
                CurveListRequests.processResponse(msg);
                continue;
            }
            if (msgType.equals(GOVT_LIST_RESPONSE)) {
                GovtListRequests.processResponse(msg);
                continue;
            }
            System.err.println("Unknown message received: " + msgType);
        }
    }

    private static void waitForResponse(Session session) throws InterruptedException {
        boolean done = false;
        block0: while (!done) {
            Event event = session.nextEvent();
            Event.EventType eventType = event.eventType();
            if (eventType == Event.EventType.PARTIAL_RESPONSE) {
                System.out.println("Processing Partial Response");
                SecurityLookupExample.processResponseEvent(event);
                continue;
            }
            if (eventType == Event.EventType.RESPONSE) {
                System.out.println("Processing Response");
                SecurityLookupExample.processResponseEvent(event);
                done = true;
                continue;
            }
            for (Message msg : event) {
                Name msgType;
                System.out.println(msg);
                if (eventType != Event.EventType.SESSION_STATUS || (msgType = msg.messageType()) != Names.SESSION_TERMINATED && msgType != Names.SESSION_STARTUP_FAILURE) continue;
                done = true;
                continue block0;
            }
        }
    }

    private void sendRequest(Session session) throws IOException {
        Request request;
        Service instrumentsService = session.getService(INSTRUMENT_SERVICE);
        switch (this.requestType) {
            case "instrumentListRequest": {
                request = InstrumentListRequests.createRequest(instrumentsService, this.query, this.maxResults, this.filters);
                break;
            }
            case "curveListRequest": {
                request = CurveListRequests.createRequest(instrumentsService, this.query, this.maxResults, this.filters);
                break;
            }
            case "govtListRequest": {
                request = GovtListRequests.createRequest(instrumentsService, this.query, this.maxResults, this.filters);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown request " + this.requestType);
            }
        }
        System.out.println("Sending request: " + request);
        session.sendRequest(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args) throws Exception {
        if (!this.parseCommandLine(args)) {
            return;
        }
        SessionOptions sessionOptions = this.connectionAndAuthOptions.createSessionOption("SecurityLookup");
        Session session = new Session(sessionOptions);
        try {
            if (!session.start()) {
                System.err.println("Failed to start session.");
                return;
            }
            if (!session.openService(INSTRUMENT_SERVICE)) {
                System.err.println("Failed to open //blp/instruments");
                return;
            }
            this.sendRequest(session);
            SecurityLookupExample.waitForResponse(session);
        }
        finally {
            session.stop();
        }
    }

    public static void main(String[] args) {
        SecurityLookupExample example = new SecurityLookupExample();
        try {
            example.run(args);
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }
}

