/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.Session;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.TlsOptions;
import com.bloomberglp.blpapiexamples.demoapps.snippets.requestresponse.HistoricalDataRequests;
import com.bloomberglp.blpapiexamples.demoapps.snippets.requestresponse.IntradayBarRequests;
import com.bloomberglp.blpapiexamples.demoapps.snippets.requestresponse.IntradayTickRequests;
import com.bloomberglp.blpapiexamples.demoapps.snippets.requestresponse.ReferenceDataRequests;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.RequestOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import java.io.IOException;

public class RequestResponseExample {
    private static final Name SERVICE_NAME = Name.getName("serviceName");
    private static final Name REASON = Name.getName("reason");
    private ConnectionAndAuthOptions connectionAndAuthOptions;
    private RequestOptions requestOptions;

    public static void main(String[] args) {
        RequestResponseExample example = new RequestResponseExample();
        try {
            example.run(args);
            System.out.println("Press ENTER to quit");
            System.in.read();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args) throws InterruptedException, IOException, TlsOptions.TlsInitializationException {
        if (!this.parseCommandLine(args)) {
            return;
        }
        SessionOptions sessionOptions = this.connectionAndAuthOptions.createSessionOption("Requester");
        Session session = new Session(sessionOptions);
        try {
            if (!session.start()) {
                System.err.println("Failed to start session.");
                RequestResponseExample.checkFailures(session);
                return;
            }
            if (!session.openService(this.requestOptions.service)) {
                RequestResponseExample.checkFailures(session);
                return;
            }
            this.sendRequest(session);
            this.waitForResponse(session);
        }
        finally {
            session.stop();
        }
    }

    private static void printContactSupportMessage(Message message) {
        String requestId = message.getRequestId();
        if (requestId != null) {
            System.err.println("When contacting support, please provide RequestId " + requestId + '.');
        }
    }

    private static boolean processGenericEvent(Event event) {
        Event.EventType eventType = event.eventType();
        for (Message msg : event) {
            System.out.println(msg);
            Name messageType = msg.messageType();
            if (eventType == Event.EventType.SESSION_STATUS) {
                if (!messageType.equals(Names.SESSION_TERMINATED) && !messageType.equals(Names.SESSION_STARTUP_FAILURE)) continue;
                System.err.println("Session failed to start or terminated.");
                RequestResponseExample.printContactSupportMessage(msg);
                return true;
            }
            if (eventType != Event.EventType.SERVICE_STATUS || !messageType.equals(Names.SERVICE_OPEN_FAILURE)) continue;
            String serviceName = msg.getElementAsString(SERVICE_NAME);
            System.err.println("Failed to open " + serviceName + ".");
            RequestResponseExample.printContactSupportMessage(msg);
        }
        return false;
    }

    private static void checkFailures(Session session) {
        Event event;
        while ((event = session.tryNextEvent()) != null && !RequestResponseExample.processGenericEvent(event)) {
        }
    }

    private void waitForResponse(Session session) throws InterruptedException {
        boolean done = false;
        while (!done) {
            Event event = session.nextEvent();
            Event.EventType eventType = event.eventType();
            if (eventType == Event.EventType.PARTIAL_RESPONSE) {
                System.out.println("Processing Partial Response");
                this.processResponseEvent(event);
                continue;
            }
            if (eventType == Event.EventType.RESPONSE) {
                System.out.println("Processing Response");
                this.processResponseEvent(event);
                done = true;
                continue;
            }
            if (eventType == Event.EventType.REQUEST_STATUS) {
                for (Message msg : event) {
                    System.out.println(msg);
                    if (!msg.messageType().equals(Names.REQUEST_FAILURE)) continue;
                    Element reason = msg.getElement(REASON);
                    System.err.println("Request failed: " + reason);
                    RequestResponseExample.printContactSupportMessage(msg);
                    done = true;
                }
                continue;
            }
            done = RequestResponseExample.processGenericEvent(event);
        }
    }

    private void processResponseEvent(Event event) {
        switch (this.requestOptions.requestType) {
            case "IntradayBarRequest": {
                IntradayBarRequests.processResponseEvent(event);
                break;
            }
            case "IntradayTickRequest": {
                IntradayTickRequests.processResponseEvent(event);
                break;
            }
            case "ReferenceDataRequest": 
            case "ReferenceDataRequestOverride": 
            case "ReferenceDataRequestTableOverride": {
                ReferenceDataRequests.processResponseEvent(event);
                break;
            }
            case "HistoricalDataRequest": {
                HistoricalDataRequests.processResponseEvent(event);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown request type: " + this.requestOptions.requestType);
            }
        }
    }

    private void sendRequest(Session session) throws IOException {
        Request request;
        Service service = session.getService(this.requestOptions.service);
        switch (this.requestOptions.requestType) {
            case "IntradayBarRequest": {
                request = IntradayBarRequests.createRequest(service, this.requestOptions);
                break;
            }
            case "IntradayTickRequest": {
                request = IntradayTickRequests.createRequest(service, this.requestOptions);
                break;
            }
            case "ReferenceDataRequest": 
            case "ReferenceDataRequestOverride": {
                request = ReferenceDataRequests.createRequest(service, this.requestOptions);
                break;
            }
            case "ReferenceDataRequestTableOverride": {
                request = ReferenceDataRequests.createTableOverrideRequest(service, this.requestOptions);
                break;
            }
            case "HistoricalDataRequest": {
                request = HistoricalDataRequests.createRequest(service, this.requestOptions);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown request type: " + this.requestOptions.requestType);
            }
        }
        System.out.println("Sending Request " + request.getRequestId() + ": " + request);
        session.sendRequest(request, null);
    }

    private boolean parseCommandLine(String[] args) {
        ArgParser argParser = new ArgParser("Request/Response Example", RequestResponseExample.class);
        this.connectionAndAuthOptions = new ConnectionAndAuthOptions(argParser);
        this.requestOptions = new RequestOptions(argParser);
        try {
            argParser.parse(args);
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return false;
        }
        this.requestOptions.setDefaultValues();
        return true;
    }
}

