/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.AbstractSession;
import com.bloomberglp.blpapi.AuthOptions;
import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Identity;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.Session;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.TlsOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.ExampleState;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgMode;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import com.bloomberglp.blpapiexamples.demoapps.util.events.SessionRouter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class EntitlementsVerificationRequestResponseExample {
    private static final Name RESPONSE_ERROR = Name.getName("responseError");
    private static final Name SECURITY_DATA = Name.getName("securityData");
    private static final Name SECURITY = Name.getName("security");
    private static final Name EID_DATA = Name.getName("eidData");
    private static final Name ENTITLEMENT_CHANGED = Name.getName("EntitlementChanged");
    private static final Name SERVICE_NAME = Name.getName("serviceName");
    private static final Name SECURITIES = Name.getName("securities");
    private static final Name FIELDS = Name.getName("fields");
    private static final Name RETURN_EIDS = Name.getName("returnEids");
    private static final String REF_DATA_SVC_NAME = "//blp/refdata";
    private final SessionRouter<Session> router = new SessionRouter();
    private final List<String> securities = new ArrayList<String>();
    private ConnectionAndAuthOptions connectionAndAuthOptions;
    private Session session;
    private Service blpRefDataSvc;
    private final AtomicReference<ExampleState> exampleState = new AtomicReference<ExampleState>(ExampleState.STARTING);
    private final Map<CorrelationID, Identity> identitiesByCorrelationId = new HashMap<CorrelationID, Identity>();
    private final List<Event> responses = new ArrayList<Event>();
    private boolean finalResponseReceived = false;

    public EntitlementsVerificationRequestResponseExample() {
        this.router.addExceptionHandler(this::handleException);
        this.router.addMessageHandler(Names.SESSION_STARTED, this::handleSessionStarted);
        this.router.addMessageHandler(Names.SESSION_STARTUP_FAILURE, this::handleSessionStartupFailure);
        this.router.addMessageHandler(Names.SESSION_TERMINATED, this::handleSessionTerminated);
        this.router.addMessageHandler(Names.SERVICE_OPENED, this::handleServiceOpened);
        this.router.addMessageHandler(Names.SERVICE_OPEN_FAILURE, this::handleServiceOpenFailure);
        this.router.addMessageHandler(ENTITLEMENT_CHANGED, this::handleEntitlementChanged);
    }

    public static void main(String[] args) throws Exception {
        EntitlementsVerificationRequestResponseExample example = new EntitlementsVerificationRequestResponseExample();
        if (!example.parseCommandLine(args)) {
            return;
        }
        example.run();
        while (example.exampleState.get() != ExampleState.TERMINATED) {
            Thread.sleep(100L);
        }
    }

    private void run() throws IOException, InterruptedException, TlsOptions.TlsInitializationException {
        this.createAndStartSession();
    }

    private void stop() {
        this.session.cancel(new ArrayList<CorrelationID>(this.identitiesByCorrelationId.keySet()));
        try {
            this.session.stop(AbstractSession.StopOption.ASYNC);
        }
        catch (InterruptedException ex2) {
            ex2.printStackTrace();
        }
    }

    private void handleException(Session sess, Event event, Exception exception) {
        exception.printStackTrace();
        this.stop();
    }

    private void createAndStartSession() throws IOException, InterruptedException, TlsOptions.TlsInitializationException {
        SessionOptions sessionOptions = this.connectionAndAuthOptions.createSessionOption("RequestEntitlements");
        this.session = new Session(sessionOptions, this.router::processEvent);
        this.session.startAsync();
    }

    private void handleSessionStarted(Session sess, Event event, Message message) throws IOException {
        this.exampleState.set(ExampleState.STARTED);
        this.router.addMessageHandler(Names.AUTHORIZATION_SUCCESS, this::handleAuthorizationSuccess);
        this.router.addMessageHandler(Names.AUTHORIZATION_FAILURE, this::handleAuthorizationFailure);
        this.router.addMessageHandler(Names.AUTHORIZATION_REVOKED, this::handleAuthorizationRevoked);
        this.authorizeUsers();
        this.openServices();
    }

    private void handleSessionStartupFailure(Session sess, Event event, Message message) {
        System.out.println("Failed to start session. Exiting...");
        this.exampleState.set(ExampleState.TERMINATED);
    }

    private void handleSessionTerminated(Session sess, Event event, Message message) {
        this.exampleState.set(ExampleState.TERMINATED);
    }

    private void openServices() throws IOException {
        this.session.openServiceAsync(REF_DATA_SVC_NAME);
    }

    private void handleServiceOpened(Session sess, Event event, Message message) throws IOException {
        String serviceName = message.getElementAsString(SERVICE_NAME);
        Service service = this.session.getService(serviceName);
        switch (serviceName) {
            case "//blp/refdata": {
                this.blpRefDataSvc = service;
                this.sendRefDataRequest();
                break;
            }
            default: {
                System.out.println("A service was opened: " + serviceName);
            }
        }
    }

    private void handleServiceOpenFailure(Session sess, Event event, Message message) {
        String serviceName;
        switch (serviceName = message.getElementAsString(SERVICE_NAME)) {
            case "//blp/refdata": {
                System.out.println("Failed to open service '" + serviceName + "', stopping application...");
                this.stop();
                break;
            }
            default: {
                throw new RuntimeException("A service which is unknown failed to open: " + serviceName);
            }
        }
    }

    private void authorizeUsers() {
        Map<String, AuthOptions> authOptionsByIdentifier = this.connectionAndAuthOptions.createClientServerSetupAuthOptions();
        for (Map.Entry<String, AuthOptions> entry : authOptionsByIdentifier.entrySet()) {
            String userIdentifier = entry.getKey();
            AuthOptions authOptions = entry.getValue();
            CorrelationID correlationId = new CorrelationID(userIdentifier);
            this.session.generateAuthorizedIdentity(authOptions, correlationId);
        }
    }

    private void sendRefDataRequest() throws IOException {
        Request request = this.blpRefDataSvc.createRequest("ReferenceDataRequest");
        Element securitiesElement = request.getElement(SECURITIES);
        for (String security : this.securities) {
            securitiesElement.appendValue(security);
        }
        Element fields = request.getElement(FIELDS);
        fields.appendValue("PX_LAST");
        fields.appendValue("DS002");
        request.set(RETURN_EIDS, true);
        this.router.addEventHandler(Event.EventType.REQUEST_STATUS, this::processRequestStatus);
        this.router.addEventHandler(Event.EventType.PARTIAL_RESPONSE, this::processPartialResponseStatus);
        this.router.addEventHandler(Event.EventType.RESPONSE, this::processResponseStatus);
        System.out.println("Sending RefDataRequest ...");
        this.session.sendRequest(request, new CorrelationID());
    }

    private void processRequestStatus(Session sess, Event event) {
        for (Message message : event) {
            if (!message.messageType().equals(Names.REQUEST_FAILURE)) continue;
            System.out.println("Request failed, stopping application...");
            this.stop();
            return;
        }
    }

    private void processPartialResponseStatus(Session sess, Event event) {
        System.out.println("Received partial response");
        this.responses.add(event);
    }

    private void processResponseStatus(Session sess, Event event) {
        System.out.println("Received final response");
        this.finalResponseReceived = true;
        this.responses.add(event);
        for (Map.Entry<CorrelationID, Identity> entry : this.identitiesByCorrelationId.entrySet()) {
            String userIdentifier = (String)entry.getKey().object();
            this.distributeResponses(userIdentifier, entry.getValue());
        }
    }

    private void handleAuthorizationSuccess(Session sess, Event event, Message message) {
        CorrelationID correlationId = message.correlationID();
        String userIdentifier = (String)correlationId.object();
        System.out.println("Successfully authorized " + userIdentifier);
        Identity identity = this.session.getAuthorizedIdentity(correlationId);
        this.identitiesByCorrelationId.put(correlationId, identity);
        if (this.finalResponseReceived) {
            this.distributeResponses(userIdentifier, identity);
        }
    }

    private void handleAuthorizationFailure(Session sess, Event event, Message message) {
        CorrelationID correlationId = message.correlationID();
        this.router.removeMessageHandler(correlationId);
        String userIdentifier = (String)correlationId.object();
        System.out.println("Failed to authorize " + userIdentifier);
    }

    private void handleAuthorizationRevoked(Session sess, Event event, Message message) {
        CorrelationID correlationId = message.correlationID();
        this.router.removeMessageHandler(correlationId);
        String userIdentifier = (String)correlationId.object();
        System.out.println("Authorization revoked for " + userIdentifier);
        this.identitiesByCorrelationId.remove(correlationId);
    }

    private void handleEntitlementChanged(Session sess, Event event, Message message) {
        String userIdentifier = (String)message.correlationID().object();
        System.out.println("Entitlements updated for " + userIdentifier);
    }

    private void distributeResponses(String userIdentifier, Identity identity) {
        for (Event event : this.responses) {
            EntitlementsVerificationRequestResponseExample.distributeResponse(event, userIdentifier, identity);
        }
    }

    private static void distributeResponse(Event event, String userIdentifier, Identity identity) {
        ArrayList<Integer> failedEntitlements = new ArrayList<Integer>();
        for (Message msg : event) {
            if (msg.hasElement(RESPONSE_ERROR)) continue;
            Service service = msg.service();
            Element securitiesElement = msg.getElement(SECURITY_DATA);
            int numSecurities = securitiesElement.numValues();
            System.out.println("Processing " + numSecurities + " securities:");
            for (int i2 = 0; i2 < numSecurities; ++i2) {
                Element security = securitiesElement.getValueAsElement(i2);
                String ticker = security.getElementAsString(SECURITY);
                if (security.hasElement(EID_DATA, true)) {
                    Element entitlements = security.getElement(EID_DATA);
                    failedEntitlements.clear();
                    if (identity.hasEntitlements(entitlements, service, failedEntitlements)) {
                        System.out.println(userIdentifier + " is entitled to get data for: " + ticker);
                        continue;
                    }
                    System.out.println(userIdentifier + " is NOT entitled to get data for: " + ticker + " - Failed EIDs: " + failedEntitlements);
                    continue;
                }
                System.out.println("No entitlements are required for: " + ticker);
            }
        }
    }

    private boolean parseCommandLine(String[] args) {
        ArgParser argParser = new ArgParser("Entitlements Verification Request/Response Example", EntitlementsVerificationRequestResponseExample.class);
        try {
            this.connectionAndAuthOptions = ConnectionAndAuthOptions.forClientServerSetup(argParser);
            argParser.addArg("-S", "--security").setMetaVar("security").setDefaultValue("IBM US Equity").setDescription("security used in ReferenceDataRequest").setMode(ArgMode.MULTIPLE_VALUES).setAction(this.securities::add);
            argParser.parse(args);
            if (this.connectionAndAuthOptions.numClientServerSetupAuthOptions() == 0) {
                throw new IllegalArgumentException("No userId:IP or token specified.");
            }
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return false;
        }
        return true;
    }
}

