/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.EventFormatter;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.ProviderEventHandler;
import com.bloomberglp.blpapi.ProviderSession;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.ServiceRegistrationOptions;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.Topic;
import com.bloomberglp.blpapi.TopicList;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.MaxEventsOption;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.Arg;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgGroup;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgMode;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import java.util.ArrayList;
import java.util.List;

public class BroadcastPublisherExample {
    private static final Name HIGH = Name.getName("HIGH");
    private static final Name LENGTH = Name.getName("length");
    private static final Name LOW = Name.getName("LOW");
    private static final Name MARKET_DATA_EVENTS = Name.getName("MarketDataEvents");
    private static final Name ROW_NUM = Name.getName("rowNum");
    private static final Name ROW_UPDATE = Name.getName("RowUpdate");
    private static final Name SPAN_UPDATE = Name.getName("spanUpdate");
    private static final Name START_COL = Name.getName("startCol");
    private static final Name TEXT = Name.getName("text");
    private static final String DEFAULT_MKTDATA_TOPIC = "IBM US Equity";
    private static final String DEFAULT_PAGE_TOPIC = "178/1/1";
    private ConnectionAndAuthOptions connectionAndAuthOptions;
    private MaxEventsOption maxEventsOption;
    private String serviceName;
    private final List<String> topics = new ArrayList<String>();
    private String groupId = null;
    private int priority;
    private volatile boolean isRunning = true;
    private boolean isPageEnabled = false;

    private boolean parseCmdLine(String[] args) {
        ArgParser argParser = new ArgParser("Broadcast publisher example", BroadcastPublisherExample.class);
        this.connectionAndAuthOptions = new ConnectionAndAuthOptions(argParser);
        this.maxEventsOption = new MaxEventsOption(argParser);
        try {
            ArgGroup argGroupPublisher = new ArgGroup("Broadcast Publisher Options", new Arg[0]);
            argGroupPublisher.add("-s", "--service").setDescription("the service name").setMetaVar("service").setRequired(true).setAction(value -> {
                this.serviceName = value;
            });
            argGroupPublisher.add("-t", "--topic").setDescription("topic to publish (default: mktdata \"IBM US Equity\", page \"178/1/1\")").setMode(ArgMode.MULTIPLE_VALUES).setMetaVar("topic").setAction(this.topics::add);
            argGroupPublisher.add("-g", "--group-id").setDescription("publisher's group ID, default to an automatically generated unique value").setMetaVar("groupId").setAction(value -> {
                this.groupId = value;
            });
            argGroupPublisher.add("-p", "--priority").setDescription("publisher's priority").setMetaVar("priority").setDefaultValue(String.valueOf(Integer.MAX_VALUE)).setAction(value -> {
                this.priority = Integer.parseInt(value);
            });
            argGroupPublisher.add("-P", "--page").setDescription("enable publish as page").setMode(ArgMode.NO_VALUE).setAction(value -> {
                this.isPageEnabled = true;
            });
            argParser.addGroup(argGroupPublisher);
            argParser.parse(args);
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return false;
        }
        if (this.topics.isEmpty()) {
            this.topics.add(this.isPageEnabled ? DEFAULT_PAGE_TOPIC : DEFAULT_MKTDATA_TOPIC);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) throws Exception {
        if (!this.parseCmdLine(args)) {
            return;
        }
        SessionOptions sessionOptions = this.connectionAndAuthOptions.createSessionOption("BroadcastPublisher");
        ProviderSession session = new ProviderSession(sessionOptions, new MyEventHandler());
        try {
            if (!session.start()) {
                System.err.println("Failed to start session");
                return;
            }
            if (this.groupId != null) {
                ServiceRegistrationOptions serviceRegistrationOptions = new ServiceRegistrationOptions();
                serviceRegistrationOptions.setGroupId(this.groupId);
                serviceRegistrationOptions.setServicePriority(this.priority);
                if (!session.registerService(this.serviceName, session.getSessionIdentity(), serviceRegistrationOptions)) {
                    System.out.print("Failed to register " + this.serviceName);
                    return;
                }
            }
            TopicList topicList = new TopicList();
            for (String topic : this.topics) {
                String userTopic = topic;
                if (!userTopic.isEmpty() && userTopic.charAt(0) != '/') {
                    userTopic = "/" + userTopic;
                }
                topicList.add(this.serviceName + userTopic, new CorrelationID(new MyStream(topic)));
            }
            session.createTopics(topicList, ProviderSession.ResolveMode.AUTO_REGISTER_SERVICES);
            ArrayList<MyStream> myStreams = new ArrayList<MyStream>();
            for (int i2 = 0; i2 < topicList.size(); ++i2) {
                MyStream stream = (MyStream)topicList.correlationIdAt(i2).object();
                if (topicList.statusAt(i2) == TopicList.Status.CREATED) {
                    Message msg = topicList.messageAt(i2);
                    stream.topic = session.getTopic(msg);
                    myStreams.add(stream);
                    System.out.println("Topic created: " + topicList.topicStringAt(i2));
                    continue;
                }
                System.out.println("Stream '" + stream.id + "': topic not resolved, status = " + (Object)((Object)topicList.statusAt(i2)));
            }
            Service service = session.getService(this.serviceName);
            if (service == null) {
                System.err.println("Service registration failed: " + this.serviceName);
                return;
            }
            if (myStreams.isEmpty()) {
                System.err.println("No topics created for publishing");
                return;
            }
            int maxEvents = this.maxEventsOption.getMaxEvents();
            for (int eventCount = 0; eventCount < maxEvents; ++eventCount) {
                if (!this.isRunning) {
                    break;
                }
                Event event = service.createPublishEvent();
                EventFormatter eventFormatter = new EventFormatter(event);
                for (MyStream myStream : myStreams) {
                    Topic topic = myStream.topic;
                    if (!topic.isActive()) {
                        System.out.println("[WARNING] Publishing on an inactive topic: " + myStream.id + ".");
                    }
                    if (this.isPageEnabled) {
                        BroadcastPublisherExample.formatPageEvent(eventFormatter, topic);
                        continue;
                    }
                    BroadcastPublisherExample.formatMarketDataEvent(eventFormatter, topic);
                }
                System.out.println("Publishing event: " + event);
                session.publish(event);
                Thread.sleep(2000L);
            }
        }
        finally {
            session.stop();
        }
    }

    private static void formatMarketDataEvent(EventFormatter eventFormatter, Topic topic) {
        eventFormatter.appendMessage(MARKET_DATA_EVENTS, topic);
        eventFormatter.setElement(HIGH, 1.0);
        eventFormatter.setElement(LOW, 0.5);
    }

    private static void formatPageEvent(EventFormatter eventFormatter, Topic topic) {
        int numRows = 5;
        for (int i2 = 1; i2 <= numRows; ++i2) {
            eventFormatter.appendMessage(ROW_UPDATE, topic);
            eventFormatter.setElement(ROW_NUM, i2);
            eventFormatter.pushElement(SPAN_UPDATE);
            eventFormatter.appendElement();
            eventFormatter.setElement(START_COL, 1);
            eventFormatter.setElement(LENGTH, "100");
            eventFormatter.setElement(TEXT, "row " + i2);
            eventFormatter.popElement();
            eventFormatter.popElement();
        }
    }

    public static void main(String[] args) throws Exception {
        BroadcastPublisherExample example = new BroadcastPublisherExample();
        example.run(args);
        System.out.println("Press ENTER to quit");
        System.in.read();
    }

    private class MyEventHandler
    implements ProviderEventHandler {
        private MyEventHandler() {
        }

        @Override
        public void processEvent(Event event, ProviderSession session) {
            System.out.println("Received event " + event);
            if (event.eventType() != Event.EventType.SESSION_STATUS) {
                return;
            }
            for (Message msg : event) {
                if (msg.messageType() != Names.SESSION_TERMINATED) continue;
                System.out.println("Session terminated, stopping application...");
                BroadcastPublisherExample.this.isRunning = false;
                break;
            }
        }
    }

    private static class MyStream {
        final String id;
        Topic topic;

        public MyStream(String id2) {
            this.id = id2;
        }
    }
}

