/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.Session;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.TlsOptions;
import com.bloomberglp.blpapiexamples.demoapps.snippets.apiflds.CategorizedFieldSearchRequests;
import com.bloomberglp.blpapiexamples.demoapps.snippets.apiflds.FieldInfoRequests;
import com.bloomberglp.blpapiexamples.demoapps.snippets.apiflds.FieldListRequests;
import com.bloomberglp.blpapiexamples.demoapps.snippets.apiflds.FieldSearchRequests;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import java.io.IOException;

public class ApiFieldsExample {
    private static final String APIFLDS_SVC = "//blp/apiflds";
    private static final String CATEGORIZED_FIELD_SEARCH_REQUEST = "CategorizedFieldSearchRequest";
    private static final String FIELD_INFO_REQUEST = "FieldInfoRequest";
    private static final String FIELD_LIST_REQUEST = "FieldListRequest";
    private static final String FIELD_SEARCH_REQUEST = "FieldSearchRequest";
    private String requestType;

    public static void main(String[] args) {
        try {
            new ApiFieldsExample().run(args);
            System.out.println("Press ENTER to quit");
            System.in.read();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args) throws IOException, InterruptedException, TlsOptions.TlsInitializationException {
        ArgParser argParser = new ArgParser("Find API data fields", ApiFieldsExample.class);
        ConnectionAndAuthOptions connectionAndAuthOptions = new ConnectionAndAuthOptions(argParser);
        try {
            argParser.addArg("-r", "--request").setMetaVar("requestType").setDescription("Specify API fields request type").setRequired(true).setChoices(CATEGORIZED_FIELD_SEARCH_REQUEST, FIELD_INFO_REQUEST, FIELD_LIST_REQUEST, FIELD_SEARCH_REQUEST).setAction(value -> {
                this.requestType = value;
            });
            argParser.parse(args);
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return;
        }
        SessionOptions sessionOptions = connectionAndAuthOptions.createSessionOption("ApiFields");
        Session session = new Session(sessionOptions);
        try {
            if (!session.start()) {
                System.err.println("Failed to start session.");
                return;
            }
            if (!session.openService(APIFLDS_SVC)) {
                System.out.println("Failed to open service: //blp/apiflds");
                return;
            }
            Request request = this.createRequest(session);
            System.out.println("Sending request: " + request);
            session.sendRequest(request, new CorrelationID());
            boolean done = false;
            block7: while (!done) {
                Event event = session.nextEvent();
                Event.EventType eventType = event.eventType();
                if (eventType == Event.EventType.REQUEST_STATUS) {
                    for (Message msg : event) {
                        if (!msg.messageType().equals(Names.REQUEST_FAILURE)) continue;
                        System.out.println(msg);
                        done = true;
                        continue block7;
                    }
                    continue;
                }
                if (eventType != Event.EventType.RESPONSE && eventType != Event.EventType.PARTIAL_RESPONSE) continue;
                this.processResponse(event);
                System.out.println();
                if (eventType != Event.EventType.RESPONSE) continue;
                done = true;
            }
        }
        finally {
            session.stop();
        }
    }

    Request createRequest(Session session) {
        Service apifldsService = session.getService(APIFLDS_SVC);
        switch (this.requestType) {
            case "CategorizedFieldSearchRequest": {
                return CategorizedFieldSearchRequests.createRequest(apifldsService);
            }
            case "FieldInfoRequest": {
                return FieldInfoRequests.createRequest(apifldsService);
            }
            case "FieldListRequest": {
                return FieldListRequests.createRequest(apifldsService);
            }
            case "FieldSearchRequest": {
                return FieldSearchRequests.createRequest(apifldsService);
            }
        }
        throw new IllegalArgumentException("Unknown request type: " + this.requestType);
    }

    void processResponse(Event event) {
        switch (this.requestType) {
            case "CategorizedFieldSearchRequest": {
                CategorizedFieldSearchRequests.processResponse(event);
                break;
            }
            case "FieldInfoRequest": {
                FieldInfoRequests.processResponse(event);
                break;
            }
            case "FieldListRequest": {
                FieldListRequests.processResponse(event);
                break;
            }
            case "FieldSearchRequest": {
                FieldSearchRequests.processResponse(event);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown request type: " + this.requestType);
            }
        }
    }
}

