/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps.util.events;

import com.bloomberglp.blpapi.AbstractSession;
import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapiexamples.demoapps.util.events.ExceptionHandler;
import com.bloomberglp.blpapiexamples.demoapps.util.events.RouterEventHandler;
import com.bloomberglp.blpapiexamples.demoapps.util.events.RouterMessageHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionRouter<T extends AbstractSession> {
    private final Map<Event.EventType, RouterEventHandler<T>> eventHandlersByEventType = new HashMap<Event.EventType, RouterEventHandler<T>>();
    private final Map<Event.EventType, RouterMessageHandler<T>> messageHandlersByEventType = new HashMap<Event.EventType, RouterMessageHandler<T>>();
    private final Map<Name, RouterMessageHandler<T>> messageHandlersByMessageType = new HashMap<Name, RouterMessageHandler<T>>();
    private final Map<CorrelationID, RouterMessageHandler<T>> messageHandlersByCorrelationId = new HashMap<CorrelationID, RouterMessageHandler<T>>();
    private final List<ExceptionHandler<T>> exceptionHandlers = new ArrayList<ExceptionHandler<T>>();

    public void addEventHandler(Event.EventType eventType, RouterEventHandler<T> handler) {
        this.eventHandlersByEventType.put(eventType, handler);
    }

    public void addMessageHandler(Event.EventType eventType, RouterMessageHandler<T> handler) {
        this.messageHandlersByEventType.put(eventType, handler);
    }

    public void addMessageHandler(Name messageType, RouterMessageHandler<T> handler) {
        this.messageHandlersByMessageType.put(messageType, handler);
    }

    public void addMessageHandler(CorrelationID correlationId, RouterMessageHandler<T> handler) {
        this.messageHandlersByCorrelationId.put(correlationId, handler);
    }

    public void removeMessageHandler(CorrelationID correlationId) {
        this.messageHandlersByCorrelationId.remove(correlationId);
    }

    public void addExceptionHandler(ExceptionHandler<T> handler) {
        this.exceptionHandlers.add(handler);
    }

    public void processEvent(Event event, T session) {
        try {
            SessionRouter.printEvent(event);
            RouterEventHandler<T> eventTypeEventHandler = this.eventHandlersByEventType.get(event.eventType());
            if (eventTypeEventHandler != null) {
                eventTypeEventHandler.accept(session, event);
            }
            for (Message message : event) {
                RouterMessageHandler<T> messageTypeMessageHandler;
                CorrelationID cid;
                for (int i2 = 0; i2 < message.numCorrelationIds() && (cid = message.correlationID(i2)) != null; ++i2) {
                    RouterMessageHandler<T> correlationIdMessageHandler = this.messageHandlersByCorrelationId.get(cid);
                    if (correlationIdMessageHandler == null) continue;
                    correlationIdMessageHandler.accept(session, event, message);
                }
                RouterMessageHandler<T> eventTypeMessageHandler = this.messageHandlersByEventType.get(event.eventType());
                if (eventTypeMessageHandler != null) {
                    eventTypeMessageHandler.accept(session, event, message);
                }
                if ((messageTypeMessageHandler = this.messageHandlersByMessageType.get(message.messageType())) == null) continue;
                messageTypeMessageHandler.accept(session, event, message);
            }
        }
        catch (Exception exception) {
            for (ExceptionHandler<T> handler : this.exceptionHandlers) {
                handler.accept(session, event, exception);
            }
        }
    }

    private static void printEvent(Event event) {
        for (Message message : event) {
            Service service = message.service();
            if (service != null) {
                System.out.println("Service: " + service.name());
            }
            System.out.println(message);
        }
    }
}

