/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps.snippets.requestresponse;

import com.bloomberglp.blpapi.Datetime;
import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapiexamples.demoapps.util.RequestOptions;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;

public class IntradayBarRequests {
    private static final Name BAR_DATA = new Name("barData");
    private static final Name BAR_TICK_DATA = new Name("barTickData");
    private static final Name OPEN = new Name("open");
    private static final Name HIGH = new Name("high");
    private static final Name LOW = new Name("low");
    private static final Name CLOSE = new Name("close");
    private static final Name VOLUME = new Name("volume");
    private static final Name NUM_EVENTS = new Name("numEvents");
    private static final Name TIME = new Name("time");
    private static final Name RESPONSE_ERROR = new Name("responseError");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy k:mm");
    private static final NumberFormat DECIMAL_FORMAT = new DecimalFormat();

    public static Request createRequest(Service service, RequestOptions options) {
        Request request = service.createRequest("IntradayBarRequest");
        request.set("security", options.securities.get(0));
        request.set("eventType", options.eventTypes.get(0));
        request.set("interval", options.barInterval);
        request.set("startDateTime", options.startDateTime);
        request.set("endDateTime", options.endDateTime);
        if (options.gapFillInitialBar) {
            request.set("gapFillInitialBar", options.gapFillInitialBar);
        }
        return request;
    }

    public static void processResponseEvent(Event response) {
        for (Message msg : response) {
            System.out.println("Received response to request " + msg.getRequestId());
            if (msg.hasElement(RESPONSE_ERROR)) {
                Element responseError = msg.getElement(RESPONSE_ERROR);
                System.out.println("REQUEST FAILED: " + responseError);
                continue;
            }
            Element data = msg.getElement(BAR_DATA).getElement(BAR_TICK_DATA);
            int numBars = data.numValues();
            System.out.println("Response contains " + numBars + " bars");
            String header = String.join((CharSequence)"\t\t\t", "Datetime", "Open", "High", "Low", "Close", "NumEvents", "Volume");
            System.out.println(header);
            for (int i2 = 0; i2 < numBars; ++i2) {
                Element bar = data.getValueAsElement(i2);
                Datetime time = bar.getElementAsDate(TIME);
                double open = bar.getElementAsFloat64(OPEN);
                double high = bar.getElementAsFloat64(HIGH);
                double low = bar.getElementAsFloat64(LOW);
                double close = bar.getElementAsFloat64(CLOSE);
                int numEvents = bar.getElementAsInt32(NUM_EVENTS);
                long volume = bar.getElementAsInt64(VOLUME);
                String row = String.join((CharSequence)"\t\t\t", DATE_FORMAT.format(time.calendar().getTime()), DECIMAL_FORMAT.format(open), DECIMAL_FORMAT.format(high), DECIMAL_FORMAT.format(low), DECIMAL_FORMAT.format(close), DECIMAL_FORMAT.format(numEvents), DECIMAL_FORMAT.format(volume));
                System.out.println(row);
            }
        }
    }
}

