/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps.snippets.instruments;

import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.InvalidConversionException;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.NotFoundException;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapiexamples.demoapps.snippets.instruments.InstrumentsFilter;
import java.util.List;

public class InstrumentListRequests {
    private static final Name NAME_DESCRIPTION = Name.getName("description");
    private static final Name NAME_QUERY = Name.getName("query");
    private static final Name NAME_RESULTS = Name.getName("results");
    private static final Name NAME_MAX_RESULTS = Name.getName("maxResults");
    private static final Name NAME_SECURITY = Name.getName("security");

    public static Request createRequest(Service instrumentsService, String query, int maxResults, List<InstrumentsFilter> filters) {
        Request request = instrumentsService.createRequest("instrumentListRequest");
        request.set(NAME_QUERY, query);
        request.set(NAME_MAX_RESULTS, maxResults);
        for (InstrumentsFilter filter : filters) {
            try {
                request.set(filter.name, filter.value);
            }
            catch (NotFoundException e2) {
                throw new IllegalArgumentException("Filter not found: " + filter.name, e2);
            }
            catch (InvalidConversionException e3) {
                throw new IllegalArgumentException("Invalid value: " + filter.value + " for filter: " + filter.name, e3);
            }
        }
        return request;
    }

    public static void processResponse(Message msg) {
        Element results = msg.getElement(NAME_RESULTS);
        int numResults = results.numValues();
        System.out.println("Processing " + numResults + " results:");
        for (int i2 = 0; i2 < numResults; ++i2) {
            Element result = results.getValueAsElement(i2);
            String security = result.getElementAsString(NAME_SECURITY);
            String description = result.getElementAsString(NAME_DESCRIPTION);
            System.out.println("    " + (i2 + 1) + " " + security + " - " + description);
        }
    }
}

