/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps.snippets.apiflds;

import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.Name;

public class ApiFieldsRequestUtils {
    private static final int ID_LEN = 13;
    private static final int MNEMONIC_LEN = 36;
    private static final int DESC_LEN = 40;
    private static final String PADDING = "                                            ";
    private static final Name FIELD_ID = new Name("id");
    private static final Name FIELD_MNEMONIC = new Name("mnemonic");
    private static final Name FIELD_DESC = new Name("description");
    private static final Name FIELD_INFO = new Name("fieldInfo");
    private static final Name FIELD_ERROR = new Name("fieldError");
    private static final Name FIELD_MSG = new Name("message");

    public static String padString(String str, int width) {
        if (str.length() >= width || str.length() >= PADDING.length()) {
            return str;
        }
        return str + PADDING.substring(0, width - str.length());
    }

    public static void printHeader() {
        System.out.println(ApiFieldsRequestUtils.padString("FIELD ID", 13) + ApiFieldsRequestUtils.padString("MNEMONIC", 36) + ApiFieldsRequestUtils.padString("DESCRIPTION", 40));
        System.out.println(ApiFieldsRequestUtils.padString("-----------", 13) + ApiFieldsRequestUtils.padString("-----------", 36) + ApiFieldsRequestUtils.padString("-----------", 40));
    }

    public static void printField(Element field) {
        String fieldId = field.getElementAsString(FIELD_ID);
        if (field.hasElement(FIELD_INFO)) {
            Element fldInfo = field.getElement(FIELD_INFO);
            String fieldMnemonic = fldInfo.getElementAsString(FIELD_MNEMONIC);
            String fieldDesc = fldInfo.getElementAsString(FIELD_DESC);
            System.out.println(ApiFieldsRequestUtils.padString(fieldId, 13) + ApiFieldsRequestUtils.padString(fieldMnemonic, 36) + ApiFieldsRequestUtils.padString(fieldDesc, 40));
        } else {
            Element fieldError = field.getElement(FIELD_ERROR);
            String fieldDesc = fieldError.getElementAsString(FIELD_MSG);
            System.out.println("\n ERROR: " + fieldId + " - " + fieldDesc);
        }
    }
}

