/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps.snippets.apiflds;

import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapiexamples.demoapps.snippets.apiflds.ApiFieldsRequestUtils;

public class CategorizedFieldSearchRequests {
    private static final String CATEGORIZED_FIELD_SEARCH_REQUEST = "CategorizedFieldSearchRequest";
    private static final int CAT_NAME_LEN = 40;
    private static final Name SEARCH_SPEC = new Name("searchSpec");
    private static final Name EXCLUDE = new Name("exclude");
    private static final Name FIELD_TYPE = new Name("fieldType");
    private static final Name STATIC = new Name("Static");
    private static final Name CATEGORY = new Name("category");
    private static final Name CATEGORY_NAME = new Name("categoryName");
    private static final Name CATEGORY_ID = new Name("categoryId");
    private static final Name FIELD_DATA = new Name("fieldData");
    private static final Name RETURN_FIELD_DOCUMENTATION = new Name("returnFieldDocumentation");
    private static final Name FIELD_SEARCH_ERROR = new Name("fieldSearchError");

    public static Request createRequest(Service apifldsService) {
        Request request = apifldsService.createRequest(CATEGORIZED_FIELD_SEARCH_REQUEST);
        request.set(SEARCH_SPEC, "last price");
        Element exclude = request.getElement(EXCLUDE);
        exclude.setElement(FIELD_TYPE, STATIC);
        request.set(RETURN_FIELD_DOCUMENTATION, false);
        return request;
    }

    public static void processResponse(Event event) {
        for (Message msg : event) {
            if (msg.hasElement(FIELD_SEARCH_ERROR)) {
                System.out.println(msg);
                continue;
            }
            Element categories = msg.getElement(CATEGORY);
            int numCategories = categories.numValues();
            for (int catIdx = 0; catIdx < numCategories; ++catIdx) {
                Element category = categories.getValueAsElement(catIdx);
                String name = category.getElementAsString(CATEGORY_NAME);
                String id = category.getElementAsString(CATEGORY_ID);
                System.out.println("\nCategory Name:" + ApiFieldsRequestUtils.padString(name, 40) + "\tId:" + id);
                ApiFieldsRequestUtils.printHeader();
                Element fields = category.getElement(FIELD_DATA);
                for (int i2 = 0; i2 < fields.numValues(); ++i2) {
                    ApiFieldsRequestUtils.printField(fields.getValueAsElement(i2));
                }
            }
        }
    }
}

