/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.EventFormatter;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.ProviderEventHandler;
import com.bloomberglp.blpapi.ProviderSession;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.TlsOptions;
import com.bloomberglp.blpapiexamples.demoapps.RequestServiceConsumerExample;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;
import java.io.IOException;

public class RequestServiceProviderExample {
    private static final String SERVICE = "//example/refdata";
    private static final Name REFERENCE_DATA_REQUEST = Name.getName("ReferenceDataRequest");
    private static final Name TIMESTAMP = Name.getName("timestamp");
    private static final Name FIELD_DATA = Name.getName("fieldData");
    private static final Name FIELD_ID = Name.getName("fieldId");
    private static final Name FIELDS = Name.getName("fields");
    private static final Name SECURITY = Name.getName("security");
    private static final Name SECURITIES = Name.getName("securities");
    private static final Name SECURITY_DATA = Name.getName("securityData");
    private static final Name DATA = Name.getName("data");
    private static final Name DOUBLE_VALUE = Name.getName("doubleValue");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(String[] args) throws InterruptedException, TlsOptions.TlsInitializationException, IOException {
        ArgParser argParser = new ArgParser("Request Service Provider Example, to be used in conjunction with " + RequestServiceConsumerExample.class.getSimpleName(), RequestServiceProviderExample.class);
        ConnectionAndAuthOptions connectionAndAuthOptions = new ConnectionAndAuthOptions(argParser);
        try {
            argParser.parse(args);
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return;
        }
        SessionOptions sessionOptions = connectionAndAuthOptions.createSessionOption();
        ProviderSession providerSession = new ProviderSession(sessionOptions, new ServerEventHandler());
        try {
            if (!providerSession.start()) {
                System.err.println("Failed to start session");
                return;
            }
            if (!providerSession.registerService(SERVICE, providerSession.getSessionIdentity())) {
                System.err.println("Failed to register //example/refdata");
                return;
            }
            System.out.println("Service is registered successfully");
            System.out.println("Waiting for requests..., Press ENTER to quit");
            System.in.read();
        }
        finally {
            providerSession.stop();
        }
    }

    private static double getTimestamp() {
        return (double)System.nanoTime() / 1.0E9;
    }

    public static void main(String[] args) {
        try {
            RequestServiceProviderExample.run(args);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static class ServerEventHandler
    implements ProviderEventHandler {
        private ServerEventHandler() {
        }

        @Override
        public void processEvent(Event event, ProviderSession session) {
            System.out.println("Received event " + event);
            Event.EventType eventType = event.eventType();
            if (eventType == Event.EventType.REQUEST) {
                for (Message msg : event) {
                    if (!msg.messageType().equals(REFERENCE_DATA_REQUEST)) continue;
                    Service service = session.getService(RequestServiceProviderExample.SERVICE);
                    if (msg.hasElement(TIMESTAMP)) {
                        double requestTime = msg.getElementAsFloat64(TIMESTAMP);
                        double latency = RequestServiceProviderExample.getTimestamp() - requestTime;
                        System.out.format("Request latency = %.4f\n", latency);
                    }
                    Event response = service.createResponseEvent(msg.correlationID());
                    EventFormatter ef = new EventFormatter(response);
                    ef.appendResponse(REFERENCE_DATA_REQUEST);
                    Element securitiesElement = msg.getElement(SECURITIES);
                    Element fieldsElement = msg.getElement(FIELDS);
                    ef.setElement(TIMESTAMP, RequestServiceProviderExample.getTimestamp());
                    ef.pushElement(SECURITY_DATA);
                    for (int i2 = 0; i2 < securitiesElement.numValues(); ++i2) {
                        ef.appendElement();
                        ef.setElement(SECURITY, securitiesElement.getValueAsString(i2));
                        ef.pushElement(FIELD_DATA);
                        for (int j2 = 0; j2 < fieldsElement.numValues(); ++j2) {
                            ef.appendElement();
                            ef.setElement(FIELD_ID, fieldsElement.getValueAsString(j2));
                            ef.pushElement(DATA);
                            ef.setElement(DOUBLE_VALUE, RequestServiceProviderExample.getTimestamp());
                            ef.popElement();
                            ef.popElement();
                        }
                        ef.popElement();
                        ef.popElement();
                    }
                    ef.popElement();
                    System.out.println("Publishing Response: " + response);
                    session.sendResponse(response);
                }
                System.out.println("Waiting for requests..., Press ENTER to quit");
            }
        }
    }
}

