/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.Session;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapiexamples.demoapps.RequestServiceProviderExample;
import com.bloomberglp.blpapiexamples.demoapps.util.ConnectionAndAuthOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;

public class RequestServiceConsumerExample {
    private static final String SERVICE = "//example/refdata";
    private static final Name TIMESTAMP = Name.getName("timestamp");
    private static final Name FIELDS = Name.getName("fields");
    private static final Name SECURITIES = Name.getName("securities");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(String[] args) throws Exception {
        ArgParser argParser = new ArgParser("Request Service Consumer Example, to be used in conjunction with " + RequestServiceProviderExample.class.getSimpleName(), RequestServiceConsumerExample.class);
        ConnectionAndAuthOptions connectionAndAuthOptions = new ConnectionAndAuthOptions(argParser);
        try {
            argParser.parse(args);
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return;
        }
        SessionOptions sessionOptions = connectionAndAuthOptions.createSessionOption();
        Session session = new Session(sessionOptions);
        try {
            if (!session.start()) {
                System.err.println("Failed to start session");
                return;
            }
            if (!session.openService(SERVICE)) {
                System.err.println("Failed to open //example/refdata");
                return;
            }
            Service service = session.getService(SERVICE);
            Request request = service.createRequest("ReferenceDataRequest");
            String[] securities = new String[]{"IBM US Equity", "MSFT US Equity"};
            Element securitiesElement = request.getElement(SECURITIES);
            for (String security : securities) {
                securitiesElement.appendValue(security);
            }
            String[] fields = new String[]{"PX_LAST", "DS002"};
            Element fieldsElement = request.getElement(FIELDS);
            for (String field : fields) {
                fieldsElement.appendValue(field);
            }
            request.set(TIMESTAMP, RequestServiceConsumerExample.getTimestamp());
            System.out.println("Sending Request: " + request);
            session.sendRequest(request, new CorrelationID());
            boolean done = false;
            while (!done) {
                Event event = session.nextEvent();
                System.out.println("Received an event: " + event);
                Event.EventType eventType = event.eventType();
                if (eventType == Event.EventType.REQUEST_STATUS) {
                    for (Message msg : event) {
                        if (!msg.messageType().equals(Names.REQUEST_FAILURE)) continue;
                        System.err.println("Request failed!");
                        done = true;
                    }
                    continue;
                }
                if (eventType != Event.EventType.RESPONSE) continue;
                for (Message msg : event) {
                    if (!msg.hasElement(TIMESTAMP)) continue;
                    double responseTime = msg.getElementAsFloat64(TIMESTAMP);
                    double latency = RequestServiceConsumerExample.getTimestamp() - responseTime;
                    System.out.format("Response latency = %.4f\n", latency);
                }
                done = true;
            }
        }
        finally {
            session.stop();
        }
    }

    private static double getTimestamp() {
        return (double)System.nanoTime() / 1.0E9;
    }

    public static void main(String[] args) {
        try {
            RequestServiceConsumerExample.run(args);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

