/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapiexamples.demoapps;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.Names;
import com.bloomberglp.blpapi.Session;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.Arg;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgGroup;
import com.bloomberglp.blpapiexamples.demoapps.util.argparser.ArgParser;

public class GenerateTokenExample {
    private static final String AUTH_USER = "AuthenticationType=OS_LOGON";
    private static final String AUTH_APP_PREFIX = "AuthenticationMode=APPLICATION_ONLY;ApplicationAuthenticationType=APPNAME_AND_KEY;ApplicationName=";
    private static final String AUTH_USER_APP_PREFIX = "AuthenticationMode=USER_AND_APPLICATION;AuthenticationType=OS_LOGON;ApplicationAuthenticationType=APPNAME_AND_KEY;ApplicationName=";
    private static final String AUTH_DIR_PREFIX = "AuthenticationType=DIRECTORY_SERVICE;DirSvcPropertyName=";
    private static final String AUTH_OPTION_USER = "user";
    private static final String AUTH_OPTION_APP = "app";
    private static final String AUTH_OPTION_USER_APP = "userapp";
    private static final String AUTH_OPTION_DIR = "dir";
    private String serverHost;
    private int serverPort;
    private String authOptions;

    public static void main(String[] args) throws Exception {
        GenerateTokenExample example = new GenerateTokenExample();
        example.run(args);
        System.out.println("Press ENTER to quit");
        System.in.read();
    }

    private void parseAuthOptions(String value) {
        String authType;
        String[] tokens = value.split("=");
        switch (authType = tokens[0]) {
            case "user": {
                this.authOptions = AUTH_USER;
                break;
            }
            case "app": {
                if (tokens.length == 1) {
                    throw new IllegalArgumentException("auth " + authType + "= is missing application name");
                }
                this.authOptions = AUTH_APP_PREFIX + tokens[1];
                break;
            }
            case "userapp": {
                if (tokens.length == 1) {
                    throw new IllegalArgumentException("auth " + authType + "= is missing application name");
                }
                this.authOptions = AUTH_USER_APP_PREFIX + tokens[1];
                break;
            }
            case "dir": {
                if (tokens.length == 1) {
                    throw new IllegalArgumentException("auth " + authType + "= is missing directory property");
                }
                this.authOptions = AUTH_DIR_PREFIX + tokens[1];
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid authentication option: " + value);
            }
        }
    }

    private void parseServerPort(String value) {
        String[] tokens = value.split(":");
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Invalid server option: " + value);
        }
        this.serverHost = tokens[0];
        try {
            this.serverPort = Integer.parseInt(tokens[1]);
        }
        catch (NumberFormatException ex2) {
            throw new IllegalArgumentException("Invalid port: " + ex2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args) throws Exception {
        ArgParser argParser = new ArgParser("Generate a token for a user to be used on the server side", GenerateTokenExample.class);
        try {
            Arg argServer = new Arg("-H", "--host").setMetaVar("host:port").setDescription("Server name or IP and port separated by ':'").setRequired(true).setAction(value -> this.parseServerPort((String)value));
            ArgGroup groupServer = new ArgGroup("Connections", argServer);
            argParser.addGroup(groupServer);
            String eol = System.lineSeparator();
            Arg argAuth = new Arg("-a", "--auth").setMetaVar("option").setDescription("Authentication option " + eol + "      user              as a user using OS logon information" + eol + "      dir=<property>    as a user using directory services" + eol + "      app=<app>         as the specified application" + eol + "      userapp=<app>     as user and application using logon information for the user").setRequired(true).setAction(value -> this.parseAuthOptions((String)value));
            ArgGroup groupAuth = new ArgGroup("Authentication", argAuth);
            argParser.addGroup(groupAuth);
            argParser.parse(args);
        }
        catch (Exception ex2) {
            System.err.println("Failed to parse arguments: " + ex2.getMessage());
            argParser.printHelp();
            return;
        }
        SessionOptions sessionOptions = new SessionOptions();
        sessionOptions.setServerHost(this.serverHost);
        sessionOptions.setServerPort(this.serverPort);
        sessionOptions.setAuthenticationOptions(this.authOptions);
        System.out.println("Connecting to " + this.serverHost + ":" + this.serverPort);
        Session session = new Session(sessionOptions);
        try {
            Event event;
            if (!session.start()) {
                System.err.println("Failed to start session.");
                return;
            }
            session.generateToken(new CorrelationID());
            while ((event = session.nextEvent()).eventType() != Event.EventType.TOKEN_STATUS) {
            }
            for (Message msg : event) {
                Name messageType = msg.messageType();
                if (messageType.equals(Names.TOKEN_GENERATION_SUCCESS)) {
                    String token = msg.getElementAsString("token");
                    System.out.println("Token is successfully generated: " + token);
                    continue;
                }
                if (!messageType.equals(Names.TOKEN_GENERATION_FAILURE)) continue;
                System.out.println("Failed to generate token: " + msg);
            }
        }
        finally {
            session.stop();
        }
    }
}

