/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import yeti.lang.compiler.ArithOp;
import yeti.lang.compiler.BindRef;
import yeti.lang.compiler.Binder;
import yeti.lang.compiler.BoolOpFun;
import yeti.lang.compiler.BuiltIn;
import yeti.lang.compiler.Closure;
import yeti.lang.compiler.Compare;
import yeti.lang.compiler.CompileException;
import yeti.lang.compiler.Compiler;
import yeti.lang.compiler.JavaClassNotFoundException;
import yeti.lang.compiler.JavaType;
import yeti.lang.compiler.Regex;
import yeti.lang.compiler.Scope;
import yeti.lang.compiler.StrOp;
import yeti.lang.compiler.TypeException;
import yeti.lang.compiler.YType;
import yeti.lang.compiler.YetiParser;

public class YetiType
implements YetiParser {
    static final int VAR = 0;
    static final int UNIT = 1;
    static final int STR = 2;
    static final int NUM = 3;
    static final int BOOL = 4;
    static final int CHAR = 5;
    static final int NONE = 6;
    static final int LIST_MARKER = 7;
    static final int MAP_MARKER = 8;
    static final int PRIMITIVE_END = 8;
    static final int FUN = 9;
    static final int MAP = 10;
    static final int STRUCT = 11;
    static final int VARIANT = 12;
    static final int JAVA = 13;
    static final int JAVA_ARRAY = 14;
    static final int OPAQUE_TYPES = 65536;
    static final int FL_ORDERED_REQUIRED = 1;
    static final int FL_TAINTED_VAR = 2;
    static final int FL_AMBIGUOUS_OPAQUE = 4;
    static final int FL_ANY_CASE = 8;
    static final int FL_FLEX_TYPEDEF = 16;
    static final int FL_ERROR_IS_HERE = 256;
    static final int FL_ANY_PATTERN = 16384;
    static final int FL_PARTIAL_PATTERN = 32768;
    static final int FIELD_NON_POLYMORPHIC = 1;
    static final int FIELD_MUTABLE = 2;
    static final YType[] NO_PARAM = new YType[0];
    static final YType UNIT_TYPE = new YType(1, NO_PARAM);
    static final YType NUM_TYPE = new YType(3, NO_PARAM);
    static final YType STR_TYPE = new YType(2, NO_PARAM);
    static final YType BOOL_TYPE = new YType(4, NO_PARAM);
    static final YType CHAR_TYPE = new YType(5, NO_PARAM);
    static final YType NO_TYPE = new YType(6, NO_PARAM);
    static final YType LIST_TYPE = new YType(7, NO_PARAM);
    static final YType MAP_TYPE = new YType(8, NO_PARAM);
    static final YType ORDERED = YetiType.orderedVar(1);
    static final YType A = new YType(1);
    static final YType B = new YType(1);
    static final YType C = new YType(1);
    static final YType EQ_TYPE = YetiType.fun2Arg(A, A, BOOL_TYPE);
    static final YType LG_TYPE = YetiType.fun2Arg(ORDERED, ORDERED, BOOL_TYPE);
    static final YType NUMOP_TYPE = YetiType.fun2Arg(NUM_TYPE, NUM_TYPE, NUM_TYPE);
    static final YType BOOLOP_TYPE = YetiType.fun2Arg(BOOL_TYPE, BOOL_TYPE, BOOL_TYPE);
    static final YType A_B_LIST_TYPE = new YType(10, new YType[]{A, B, LIST_TYPE});
    static final YType NUM_LIST_TYPE = new YType(10, new YType[]{NUM_TYPE, B, LIST_TYPE});
    static final YType A_B_MAP_TYPE = new YType(10, new YType[]{B, A, MAP_TYPE});
    static final YType A_B_C_MAP_TYPE = new YType(10, new YType[]{B, A, C});
    static final YType A_LIST_TYPE = new YType(10, new YType[]{A, NO_TYPE, LIST_TYPE});
    static final YType C_LIST_TYPE = new YType(10, new YType[]{C, NO_TYPE, LIST_TYPE});
    static final YType STRING_ARRAY = new YType(10, new YType[]{STR_TYPE, NUM_TYPE, LIST_TYPE});
    static final YType CONS_TYPE = YetiType.fun2Arg(A, A_B_LIST_TYPE, A_LIST_TYPE);
    static final YType LAZYCONS_TYPE = YetiType.fun2Arg(A, YetiType.fun(UNIT_TYPE, A_B_LIST_TYPE), A_LIST_TYPE);
    static final YType A_TO_BOOL = YetiType.fun(A, BOOL_TYPE);
    static final YType LIST_TO_A = YetiType.fun(A_B_LIST_TYPE, A);
    static final YType MAP_TO_BOOL = YetiType.fun(A_B_C_MAP_TYPE, BOOL_TYPE);
    static final YType MAP_TO_NUM = YetiType.fun(A_B_C_MAP_TYPE, NUM_TYPE);
    static final YType LIST_TO_LIST = YetiType.fun(A_B_LIST_TYPE, A_LIST_TYPE);
    static final YType IN_TYPE = YetiType.fun2Arg(A, A_B_C_MAP_TYPE, BOOL_TYPE);
    static final YType COMPOSE_TYPE = YetiType.fun2Arg(YetiType.fun(B, C), YetiType.fun(A, B), YetiType.fun(A, C));
    static final YType BOOL_TO_BOOL = YetiType.fun(BOOL_TYPE, BOOL_TYPE);
    static final YType NUM_TO_NUM = YetiType.fun(NUM_TYPE, NUM_TYPE);
    static final YType STR_TO_NUM_TO_STR = YetiType.fun2Arg(STR_TYPE, NUM_TYPE, STR_TYPE);
    static final YType FOR_TYPE = YetiType.fun2Arg(A_B_LIST_TYPE, YetiType.fun(A, UNIT_TYPE), UNIT_TYPE);
    static final YType STR2_PRED_TYPE = YetiType.fun2Arg(STR_TYPE, STR_TYPE, BOOL_TYPE);
    static final YType SYNCHRONIZED_TYPE = YetiType.fun2Arg(A, YetiType.fun(UNIT_TYPE, B), B);
    static final YType CLASS_TYPE = new YType("Ljava/lang/Class;");
    static final YType OBJECT_TYPE = new YType("Ljava/lang/Object;");
    static final YType WITH_EXIT_TYPE = YetiType.fun(YetiType.fun(YetiType.fun(A, B), A), A);
    static final YType THROW_TYPE = YetiType.fun(new YType("Ljava/lang/Throwable;"), A);
    static final YType[] PRIMITIVES = new YType[]{null, UNIT_TYPE, STR_TYPE, NUM_TYPE, BOOL_TYPE, CHAR_TYPE, NO_TYPE, LIST_TYPE, MAP_TYPE};
    static final String[] TYPE_NAMES = new String[]{"var", "()", "string", "number", "boolean", "char", "none", "list", "hash", "fun", "list", "struct", "variant", "object"};
    static final Scope ROOT_SCOPE = YetiType.bindCompare("==", EQ_TYPE, 0, YetiType.bindCompare("!=", EQ_TYPE, 1, YetiType.bindCompare("<", LG_TYPE, 2, YetiType.bindCompare("<=", LG_TYPE, 5, YetiType.bindCompare(">", LG_TYPE, 4, YetiType.bindCompare(">=", LG_TYPE, 3, YetiType.bindPoly(".", COMPOSE_TYPE, new BuiltIn(6), YetiType.bindPoly("in", IN_TYPE, new BuiltIn(2), YetiType.bindPoly("::", CONS_TYPE, new BuiltIn(3), YetiType.bindPoly(":.", LAZYCONS_TYPE, new BuiltIn(4), YetiType.bindPoly("for", FOR_TYPE, new BuiltIn(5), YetiType.bindPoly("nullptr?", A_TO_BOOL, new BuiltIn(8), YetiType.bindPoly("defined?", A_TO_BOOL, new BuiltIn(9), YetiType.bindPoly("empty?", MAP_TO_BOOL, new BuiltIn(10), YetiType.bindPoly("same?", EQ_TYPE, new BuiltIn(21), YetiType.bindPoly("head", LIST_TO_A, new BuiltIn(11), YetiType.bindPoly("tail", LIST_TO_LIST, new BuiltIn(12), YetiType.bindPoly("synchronized", SYNCHRONIZED_TYPE, new BuiltIn(7), YetiType.bindPoly("withExit", WITH_EXIT_TYPE, new BuiltIn(24), YetiType.bindPoly("length", MAP_TO_NUM, new BuiltIn(25), YetiType.bindPoly("throw", WITH_EXIT_TYPE, new BuiltIn(26), YetiType.bindArith("+", "add", YetiType.bindArith("-", "sub", YetiType.bindArith("*", "mul", YetiType.bindArith("/", "div", YetiType.bindArith("%", "rem", YetiType.bindArith("div", "intDiv", YetiType.bindArith("shl", "shl", YetiType.bindArith("shr", "shr", YetiType.bindArith("b_and", "and", YetiType.bindArith("b_or", "or", YetiType.bindArith("xor", "xor", YetiType.bindScope("=~", new BuiltIn(13), YetiType.bindScope("!~", new BuiltIn(14), YetiType.bindScope("not", new BuiltIn(15), YetiType.bindScope("and", new BoolOpFun(false), YetiType.bindScope("or", new BoolOpFun(true), YetiType.bindScope("undef_bool", new BuiltIn(17), YetiType.bindScope("false", new BuiltIn(18), YetiType.bindScope("true", new BuiltIn(19), YetiType.bindScope("negate", new BuiltIn(20), YetiType.bindScope("undef_str", new BuiltIn(23), YetiType.bindScope("strChar", new BuiltIn(16), YetiType.bindStr("strLength", YetiType.fun(STR_TYPE, NUM_TYPE), "length", "()I", YetiType.bindStr("strUpper", YetiType.fun(STR_TYPE, STR_TYPE), "toUpperCase", "()Ljava/lang/String;", YetiType.bindStr("strLower", YetiType.fun(STR_TYPE, STR_TYPE), "toLowerCase", "()Ljava/lang/String;", YetiType.bindStr("strTrim", YetiType.fun(STR_TYPE, STR_TYPE), "trim", "()Ljava/lang/String;", YetiType.bindStr("strSlice", YetiType.fun2Arg(STR_TYPE, NUM_TYPE, YetiType.fun(NUM_TYPE, STR_TYPE)), "substring", "(II)Ljava/lang/String;", YetiType.bindStr("strRight", YetiType.fun2Arg(STR_TYPE, NUM_TYPE, STR_TYPE), "substring", "(I)Ljava/lang/String;", YetiType.bindStr("strStarts?", YetiType.fun2Arg(STR_TYPE, STR_TYPE, BOOL_TYPE), "startsWith", "(Ljava/lang/String;)Z", YetiType.bindStr("strEnds?", YetiType.fun2Arg(STR_TYPE, STR_TYPE, BOOL_TYPE), "endsWith", "(Ljava/lang/String;)Z", YetiType.bindStr("strIndexOf", YetiType.fun2Arg(STR_TYPE, STR_TYPE, YetiType.fun(NUM_TYPE, NUM_TYPE)), "indexOf", "(Ljava/lang/String;I)I", YetiType.bindStr("strLastIndexOf", YetiType.fun2Arg(STR_TYPE, STR_TYPE, YetiType.fun(NUM_TYPE, NUM_TYPE)), "lastIndexOf", "(Ljava/lang/String;I)I", YetiType.bindStr("strLastIndexOf'", YetiType.fun2Arg(STR_TYPE, STR_TYPE, NUM_TYPE), "lastIndexOf", "(Ljava/lang/String;)I", YetiType.bindRegex("strSplit", "yeti/lang/StrSplit", YetiType.fun2Arg(STR_TYPE, STR_TYPE, STRING_ARRAY), YetiType.bindRegex("like", "yeti/lang/Like", YetiType.fun2Arg(STR_TYPE, STR_TYPE, YetiType.fun(UNIT_TYPE, STRING_ARRAY)), YetiType.bindRegex("substAll", "yeti/lang/SubstAll", YetiType.fun2Arg(STR_TYPE, STR_TYPE, YetiType.fun(STR_TYPE, STR_TYPE)), YetiType.bindRegex("matchAll", "yeti/lang/MatchAll", YetiType.fun2Arg(STR_TYPE, YetiType.fun(STRING_ARRAY, A), YetiType.fun2Arg(YetiType.fun(STR_TYPE, A), STR_TYPE, A_LIST_TYPE)), YetiType.bindImport("EmptyArray", "yeti/lang/EmptyArrayException", YetiType.bindImport("Failure", "yeti/lang/FailureException", YetiType.bindImport("NoSuchKey", "yeti/lang/NoSuchKeyException", YetiType.bindImport("Exception", "java/lang/Exception", YetiType.bindImport("RuntimeException", "java/lang/RuntimeException", YetiType.bindImport("NumberFormatException", "java/lang/NumberFormatException", YetiType.bindImport("IllegalArgumentException", "java/lang/IllegalArgumentException", YetiType.bindImport("Math", "java/lang/Math", YetiType.bindImport("Object", "java/lang/Object", YetiType.bindImport("Boolean", "java/lang/Boolean", YetiType.bindImport("Integer", "java/lang/Integer", YetiType.bindImport("Long", "java/lang/Long", YetiType.bindImport("Double", "java/lang/Double", YetiType.bindImport("String", "java/lang/String", null))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
    static final Scope ROOT_SCOPE_SYS = YetiType.bindImport("System", "java/lang/System", YetiType.bindImport("Class", "java/lang/Class", ROOT_SCOPE));
    static final JavaType COMPARABLE = JavaType.fromDescription("Ljava/lang/Comparable;");
    private static final int RESTRICT_PROTECT = 1;
    private static final int RESTRICT_CONTRA = 2;
    static final int RESTRICT_ALL = 4;
    static final int RESTRICT_POLY = 8;
    static final int STRUCT_VAR = 16;
    private static final StructVar DENY = new StructVar(1, null);

    static Scope bindScope(String string2, Binder binder, Scope scope) {
        return new Scope(scope, string2, binder);
    }

    static Scope bindCompare(String string2, YType yType, int n, Scope scope) {
        return YetiType.bindPoly(string2, yType, new Compare(yType, n, string2), scope);
    }

    static Scope bindArith(String string2, String string3, Scope scope) {
        return YetiType.bindScope(string2, new ArithOp(string2, string3, NUMOP_TYPE), scope);
    }

    static Scope bindStr(String string2, YType yType, String string3, String string4, Scope scope) {
        return YetiType.bindScope(string2, new StrOp(string2, string3, string4, yType), scope);
    }

    static Scope bindRegex(String string2, String string3, YType yType, Scope scope) {
        return YetiType.bindPoly(string2, yType, new Regex(string2, string3, yType), scope);
    }

    static Scope bindImport(String string2, String string3, Scope scope) {
        scope = new Scope(scope, string2, null);
        scope.importClass = new ClassBinding(new YType('L' + string3 + ';'));
        return scope;
    }

    static YType fun(YType yType, YType yType2) {
        return new YType(9, new YType[]{yType, yType2});
    }

    static YType fun2Arg(YType yType, YType yType2, YType yType3) {
        return new YType(9, new YType[]{yType, new YType(9, new YType[]{yType2, yType3})});
    }

    static YType mutableFieldRef(YType yType) {
        YType yType2 = new YType(yType.depth);
        yType2.ref = yType.ref;
        yType2.flags = yType.flags;
        yType2.field = 2;
        return yType2;
    }

    static YType fieldRef(int n, YType yType, int n2) {
        YType yType2 = new YType(n);
        yType2.ref = yType.deref();
        yType2.field = n2;
        yType2.doc = yType.doc;
        return yType2;
    }

    static YType orderedVar(int n) {
        YType yType = new YType(n);
        yType.flags = 1;
        return yType;
    }

    static void limitDepth(YType yType, int n, int n2) {
        yType = yType.deref();
        if (yType.type != 0) {
            if (yType.seen) {
                return;
            }
            yType.seen = true;
            int n3 = yType.param.length;
            while (--n3 >= 0) {
                YetiType.limitDepth(yType.param[n3], n, n2);
            }
            yType.seen = false;
        } else {
            if (yType.depth > n) {
                yType.depth = n;
            }
            yType.flags |= n2;
        }
    }

    static void mismatch(YType yType, YType yType2) throws TypeException {
        throw new TypeException(yType, yType2);
    }

    static void finalizeStruct(YType yType, YType yType2) throws TypeException {
        if (yType2.allowedMembers == null || yType.requiredMembers == null) {
            return;
        }
        Object[] objectArray = yType.requiredMembers.entrySet().toArray();
        Object var3_3 = null;
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                Map.Entry entry = (Map.Entry)objectArray[i];
                Object k = entry.getKey();
                YType yType3 = (YType)yType2.allowedMembers.get(k);
                if (yType3 == null) {
                    if ((yType.flags & 8) != 0) continue;
                    throw new TypeException(yType2, " => ", yType, " (member missing: " + k + ")");
                }
                YType yType4 = (YType)entry.getValue();
                if (yType4.field == 2 && yType3.field != 2) {
                    throw new TypeException("Field '" + k + "' constness mismatch: " + yType2 + " => " + yType);
                }
                var3_3 = k;
                YetiType.unify(yType4, yType3);
                var3_3 = null;
            }
        }
        catch (TypeException typeException) {
            if (var3_3 != null) {
                typeException.trace.add(var3_3);
                typeException.trace.add(yType);
                typeException.trace.add(yType2);
            }
            throw typeException;
        }
    }

    static void unifyMembers(YType yType, YType yType2) throws TypeException {
        YType yType3 = yType2.ref;
        Object var3_3 = null;
        try {
            Object object;
            Map map3;
            Object object2;
            Map.Entry entry;
            int n;
            yType2.ref = yType;
            if (((yType.flags | yType2.flags) & 0x10) != 0 && ((n = (yType.allowedMembers != null ? 1 : 0) | (yType.requiredMembers != null ? 2 : 0) | (yType2.allowedMembers != null ? 4 : 0) | (yType2.requiredMembers != null ? 8 : 0)) == 6 || n == 9)) {
                entry = (yType.flags & 0x10) != 0 ? yType : yType2;
                object2 = ((YType)((Object)entry)).allowedMembers;
                ((YType)((Object)entry)).allowedMembers = ((YType)((Object)entry)).requiredMembers;
                ((YType)((Object)entry)).requiredMembers = object2;
                ((YType)((Object)entry)).flags &= 0xFFFFFFEF;
            }
            yType.flags &= 0xFFFFFFEF;
            if (((yType.flags ^ yType2.flags) & 1) != 0) {
                if ((yType.flags & 1) != 0) {
                    YetiType.requireOrdered(yType2);
                } else {
                    YetiType.requireOrdered(yType);
                }
            }
            if (yType.allowedMembers == null) {
                map3 = yType2.allowedMembers;
            } else if (yType2.allowedMembers == null) {
                map3 = yType.allowedMembers;
            } else {
                map3 = new IdentityHashMap(yType.allowedMembers);
                Iterator iterator = map3.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    var3_3 = entry.getKey();
                    object2 = (YType)yType2.allowedMembers.get(var3_3);
                    if (object2 != null) {
                        object = (YType)entry.getValue();
                        YetiType.unify((YType)object2, (YType)object);
                        if (((YType)object).field == ((YType)object2).field) continue;
                        if (((YType)object).field == 0) {
                            object = object2;
                            entry.setValue(object);
                        }
                        ((YType)object).field = 1;
                        continue;
                    }
                    iterator.remove();
                }
                var3_3 = null;
                if (map3.isEmpty()) {
                    YetiType.mismatch(yType, yType2);
                }
            }
            YetiType.finalizeStruct(yType, yType2);
            YetiType.finalizeStruct(yType2, yType);
            if (map3 != null && (yType2.flags & 8) != 0) {
                if ((yType.flags & 8) != 0) {
                    yType.requiredMembers = null;
                }
            } else if (yType.requiredMembers == null || map3 != null && (yType.flags & 8) != 0) {
                yType.requiredMembers = yType2.requiredMembers;
            } else if (yType2.requiredMembers != null) {
                Object[] objectArray = yType.requiredMembers.entrySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    object2 = (Map.Entry)objectArray[i];
                    var3_3 = object2.getKey();
                    object = (YType)yType2.requiredMembers.get(var3_3);
                    if (object == null) continue;
                    YetiType.unify((YType)object2.getValue(), (YType)object);
                    if (((YType)object).field < 1) continue;
                    object2.setValue(object);
                }
                var3_3 = null;
                yType.requiredMembers.putAll(yType2.requiredMembers);
            }
            yType.allowedMembers = map3;
            yType.flags &= yType2.flags | 0xFFFFFFE7;
            if (map3 == null) {
                map3 = yType.requiredMembers;
            } else if (yType.requiredMembers != null) {
                map3 = new IdentityHashMap(map3);
                map3.putAll(yType.requiredMembers);
            }
            YetiType.unify(yType.param[0], yType2.param[0]);
            YetiType.structParam(yType, map3, yType.param[0].deref());
            yType2.type = 0;
            yType2.ref = yType;
            if ((yType.param[0].flags & 2) != 0) {
                YetiType.limitDepth(yType, yType.param[0].depth, 2);
            }
        }
        catch (TypeException typeException) {
            yType2.ref = yType3;
            if (var3_3 != null) {
                typeException.trace.add(var3_3);
                typeException.trace.add(yType);
                typeException.trace.add(yType2);
            }
            throw typeException;
        }
    }

    static void structParam(YType yType, Map map3, YType yType2) {
        if (yType2.type != 0 || yType2.ref != null) {
            throw new IllegalStateException("non-freevar struct depth: " + yType2);
        }
        YType[] yTypeArray = new YType[map3.size() + 1];
        yTypeArray[0] = yType2;
        Iterator iterator = map3.values().iterator();
        int n = 1;
        while (iterator.hasNext()) {
            yTypeArray[n] = (YType)iterator.next();
            ++n;
        }
        yType.param = yTypeArray;
    }

    static void unifyJava(YType yType, YType yType2) throws TypeException {
        String string2 = yType.javaType.description;
        if (yType2.type != 13) {
            if (yType2.type == 1 && string2 == "V") {
                return;
            }
            YetiType.mismatch(yType, yType2);
        }
        if (string2 == yType2.javaType.description) {
            return;
        }
        YetiType.mismatch(yType, yType2);
    }

    static void requireOrdered(YType yType) throws TypeException {
        switch (yType.type) {
            case 12: {
                if ((yType.flags & 1) == 0) {
                    Iterator iterator;
                    if (yType.requiredMembers != null) {
                        iterator = yType.requiredMembers.values().iterator();
                        while (iterator.hasNext()) {
                            YetiType.requireOrdered((YType)iterator.next());
                        }
                    }
                    if (yType.allowedMembers != null) {
                        iterator = yType.allowedMembers.values().iterator();
                        while (iterator.hasNext()) {
                            YetiType.requireOrdered((YType)iterator.next());
                        }
                        yType.flags |= 1;
                    }
                }
                return;
            }
            case 10: {
                YetiType.requireOrdered(yType.param[2]);
                YetiType.requireOrdered(yType.param[0]);
                return;
            }
            case 0: {
                if (yType.ref != null) {
                    YetiType.requireOrdered(yType.ref);
                } else {
                    yType.flags |= 1;
                }
            }
            case 2: 
            case 3: 
            case 7: {
                return;
            }
            case 13: {
                try {
                    if (COMPARABLE.isAssignable(yType.javaType) >= 0) {
                        return;
                    }
                    break;
                }
                catch (JavaClassNotFoundException javaClassNotFoundException) {
                    throw new TypeException("Unknown class: " + javaClassNotFoundException.getMessage());
                }
            }
        }
        TypeException typeException = new TypeException(yType + " is not an ordered type");
        typeException.special = true;
        throw typeException;
    }

    static void occursCheck(YType yType, YType yType2) throws TypeException {
        if ((yType = yType.deref()) == yType2) {
            TypeException typeException = new TypeException("Cyclic types are not allowed");
            typeException.special = true;
            throw typeException;
        }
        if (yType.param != null && yType.type != 12 && yType.type != 11) {
            int n = yType.param.length;
            while (--n >= 0) {
                YetiType.occursCheck(yType.param[n], yType2);
            }
        }
    }

    static void unifyToVar(YType yType, YType yType2) throws TypeException {
        YetiType.occursCheck(yType2, yType);
        if ((yType.flags & 1) != 0) {
            YetiType.requireOrdered(yType2);
        }
        YetiType.limitDepth(yType2, yType.depth, yType.flags & 2);
        yType.ref = yType2;
    }

    static void unify(YType yType, YType yType2) throws TypeException {
        if ((yType = yType.deref()) == (yType2 = yType2.deref())) {
            return;
        }
        if (yType.type == 0) {
            YetiType.unifyToVar(yType, yType2);
            return;
        }
        if (yType2.type == 0) {
            YetiType.unifyToVar(yType2, yType);
            return;
        }
        if (yType.type != yType2.type) {
            YType yType3 = null;
            if (yType.type >= 65536 && (yType.flags & 4) != 0) {
                yType3 = yType;
            } else if (yType2.type >= 65536 && (yType2.flags & 4) != 0) {
                yType3 = yType2;
            }
            if (yType3 != null) {
                yType3.ref = (YType)yType3.allowedMembers.values().toArray()[0];
                yType3.type = 0;
                YetiType.unify(yType, yType2);
                return;
            }
        }
        if (yType.type == 13) {
            YetiType.unifyJava(yType, yType2);
        } else if (yType2.type == 13) {
            YetiType.unifyJava(yType2, yType);
        } else if (yType.type != yType2.type) {
            YetiType.mismatch(yType, yType2);
        } else if (yType.type == 11 || yType.type == 12) {
            YetiType.unifyMembers(yType, yType2);
        } else if (yType.type == 10 && (yType.param[1].type ^ yType2.param[1].type) == 5 && (yType.param[1].type == 6 || yType2.param[1].type == 6)) {
            YetiType.mismatch(yType, yType2);
        } else {
            int n = yType.param.length;
            for (int i = 0; i < n; ++i) {
                YetiType.unify(yType.param[i], yType2.param[i]);
            }
            if (yType.type >= 65536 && (yType.flags & yType2.flags & 4) == 0) {
                yType.flags &= 0xFFFFFFFB;
                yType2.flags &= 0xFFFFFFFB;
            }
        }
    }

    static void unify(YType yType, YType yType2, YetiParser.Node node, Scope scope, YType yType3, YType yType4, String string2) {
        try {
            YetiType.unify(yType, yType2);
        }
        catch (TypeException typeException) {
            throw new CompileException(node, scope, yType3, yType4, string2, typeException);
        }
    }

    static void unify(YType yType, YType yType2, YetiParser.Node node, Scope scope, String string2) {
        YetiType.unify(yType, yType2, node, scope, yType, yType2, string2);
    }

    static YType mergeOrUnify(YType yType, YType yType2) throws TypeException {
        YType yType3 = JavaType.mergeTypes(yType, yType2);
        if (yType3 != null) {
            return yType3;
        }
        YetiType.unify(yType, yType2);
        return yType;
    }

    static Map copyTypeMap(Map map3, Map map4, Map map5) {
        IdentityHashMap identityHashMap = new IdentityHashMap(map3.size());
        Iterator iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            YType yType = (YType)entry.getValue();
            YType yType2 = YetiType.copyType(yType, map4, map5);
            if (yType.field != yType2.field) {
                if (yType.field != 0) {
                    YType yType3 = new YType(0);
                    yType3.ref = yType2;
                    yType2 = yType3;
                }
                yType2.field = yType.field;
                yType2.flags = yType.flags;
            }
            identityHashMap.put(entry.getKey(), yType2);
        }
        return identityHashMap;
    }

    static YType copyType(YType yType, Map map3, Map map4) {
        YType yType2 = yType.deref();
        if (yType2.type == 0) {
            YType yType3;
            return map3 != null && (yType3 = (YType)map3.get(yType2)) != null ? yType3 : yType2;
        }
        if (yType2.param.length == 0 && yType2.type < 65536) {
            return yType;
        }
        YType yType4 = (YType)map4.get(yType2);
        if (yType4 != null) {
            return yType4;
        }
        if (!(yType2.type != 11 && yType2.type != 12 || map3 == null || map3.containsKey(yType2.param[0]))) {
            return yType2;
        }
        YType[] yTypeArray = new YType[yType2.param.length];
        yType4 = new YType(yType2.type, yTypeArray);
        yType4.doc = yType;
        YType yType5 = yType4;
        if (yType.field >= 1) {
            yType5 = YetiType.mutableFieldRef(yType);
            yType5.field = yType.field;
            yType5.ref = yType4;
        }
        map4.put(yType2, yType5);
        int n = yTypeArray.length;
        while (--n >= 0) {
            yTypeArray[n] = YetiType.copyType(yType2.param[n], map3, map4);
        }
        if (yType2.requiredMembers != null) {
            yType4.flags = yType2.flags & 0x18;
            yType4.requiredMembers = YetiType.copyTypeMap(yType2.requiredMembers, map3, map4);
        }
        if (yType2.allowedMembers != null) {
            yType4.flags |= yType2.flags & 0x10;
            yType4.allowedMembers = YetiType.copyTypeMap(yType2.allowedMembers, map3, map4);
        }
        return yType5;
    }

    static Map createFreeVars(YType[] yTypeArray, int n) {
        IdentityHashMap<YType, YType> identityHashMap = new IdentityHashMap<YType, YType>(yTypeArray.length);
        int n2 = yTypeArray.length;
        while (--n2 >= 0) {
            YType yType = yTypeArray[n2];
            YType yType2 = new YType(n);
            yType2.flags = yType.flags;
            yType2.field = yType.field;
            identityHashMap.put(yType, yType2);
        }
        return identityHashMap;
    }

    private static BindRef resolveRef(String string2, YetiParser.Node node, Scope scope, Scope[] scopeArray) {
        while (scope != null) {
            if (scope.name == string2 && scope.binder != null) {
                scopeArray[0] = scope;
                return scope.binder.getRef(node.line);
            }
            if (scope.closure != null) {
                return scope.closure.refProxy(YetiType.resolveRef(string2, node, scope.outer, scopeArray));
            }
            scope = scope.outer;
        }
        throw new CompileException(node, "Unknown identifier: " + string2);
    }

    static BindRef resolve(String string2, YetiParser.Node node, Scope scope, int n) {
        Scope[] scopeArray = new Scope[1];
        BindRef bindRef = YetiType.resolveRef(string2, node, scope, scopeArray);
        if (scopeArray[0].free != null && (bindRef.polymorph || scopeArray[0].free.length != 0)) {
            bindRef = bindRef.unshare();
            Map map3 = YetiType.createFreeVars(scopeArray[0].free, n + 1);
            bindRef.type = YetiType.copyType(bindRef.type, map3, new IdentityHashMap());
        }
        return bindRef;
    }

    static YType resolveClass(String string2, Scope scope, boolean bl) {
        if (string2.indexOf(47) >= 0) {
            return JavaType.typeOfClass(null, string2);
        }
        while (scope != null) {
            if (scope.name == string2) {
                if (scope.importClass != null) {
                    return scope.importClass.type;
                }
                if (bl) break;
            }
            scope = scope.outer;
        }
        return null;
    }

    static ClassBinding resolveFullClass(String string2, Scope scope, boolean bl, YetiParser.Node node) {
        String string3 = scope.ctx.packageName;
        if (string2.indexOf(47) >= 0) {
            string3 = null;
        } else if (bl) {
            ArrayList<Closure> arrayList = new ArrayList<Closure>();
            Scope scope2 = scope;
            while (scope2 != null) {
                if (scope2.name == string2 && scope2.importClass != null) {
                    return scope2.importClass.dup(arrayList);
                }
                if (scope2.closure != null) {
                    arrayList.add(scope2.closure);
                }
                scope2 = scope2.outer;
            }
        } else {
            YType yType = YetiType.resolveClass(string2, scope, false);
            if (yType != null) {
                return new ClassBinding(yType);
            }
        }
        if (node != null && (scope.ctx.compiler.globalFlags & 0x10) != 0) {
            throw new CompileException(node, string2 + " is not imported");
        }
        return new ClassBinding(JavaType.typeOfClass(string3, string2));
    }

    static YType resolveFullClass(String string2, Scope scope) {
        YType yType = YetiType.resolveClass(string2, scope, false);
        return yType == null ? JavaType.typeOfClass(scope.ctx.packageName, string2) : yType;
    }

    static boolean hasMutableStore(Map map3, YType yType, boolean bl) {
        if (!yType.seen) {
            if (yType.field >= 1) {
                bl = true;
            }
            YType yType2 = yType.deref();
            if (yType2.type == 0) {
                return bl && map3.containsKey(yType2);
            }
            if (yType2.type == 10 && yType2.param[1] != NO_TYPE) {
                bl = true;
            }
            yType.seen = true;
            int n = yType2.param.length;
            while (--n >= 0) {
                if (!YetiType.hasMutableStore(map3, yType2.param[n], bl || n == 0 && yType2.type == 9)) continue;
                yType.seen = false;
                return true;
            }
            yType.seen = false;
        }
        return false;
    }

    static void restrictArg(YType yType, int n, boolean bl) {
        if (yType.seen) {
            return;
        }
        if (yType.field >= 1) {
            bl = true;
        }
        YType yType2 = yType.deref();
        int n2 = yType2.type;
        if (n2 != 0) {
            yType.seen = true;
            int n3 = yType2.param.length;
            while (--n3 >= 0) {
                if (n3 == 1 && !bl) {
                    YType yType3;
                    bl = n2 == 10 && (yType3 = yType2.param[1].deref()) != NO_TYPE && (yType3.type != 0 || yType2.param[2] != LIST_TYPE);
                }
                YetiType.restrictArg(yType2.param[n3], n, bl);
            }
            yType.seen = false;
        } else if (bl && yType2.depth >= n) {
            yType2.flags |= 2;
        }
    }

    private static void addFreeVar(Map map3, StructVar structVar, YType yType, int n) {
        if ((n & 4) != 0) {
            yType.flags |= 2;
            structVar = DENY;
        } else if ((n & 0xA) == 2 && (yType.flags & 2) != 0) {
            structVar = DENY;
        }
        StructVar structVar2 = map3.put(yType, structVar);
        if (structVar2 == null && (n & 0x10) == 0 || structVar == DENY) {
            return;
        }
        if (structVar2 == DENY) {
            structVar = DENY;
        } else {
            structVar = new StructVar(0, structVar);
            structVar.link = structVar2;
        }
        map3.put(yType, structVar);
    }

    private static void scanFreeVar(Map map3, StructVar structVar, YType yType, int n, int n2) {
        if (yType.seen) {
            return;
        }
        if (yType.field >= 1) {
            n |= (n & 1) == 0 ? 4 : 2;
        }
        YType yType2 = yType.deref();
        int n3 = yType2.type;
        if (n3 == 11 || n3 == 12) {
            yType.seen = true;
            YetiType.scanFreeVar(map3, structVar, yType2.param[0], n | 0x10, n2);
            structVar = (StructVar)map3.get(yType2.param[0].deref());
            for (int i = 1; i < yType2.param.length; ++i) {
                YetiType.scanFreeVar(map3, structVar, yType2.param[i], n, n2);
            }
            yType.seen = false;
        } else if (n3 != 0) {
            if (n3 == 9) {
                n |= 1;
            }
            yType.seen = true;
            int n4 = yType2.param.length;
            while (--n4 >= 0) {
                if (n4 == 0 && n3 == 9) {
                    n |= 2;
                } else if (n4 == 1 && n3 == 10 && yType2.param[1].deref() != NO_TYPE) {
                    n |= (n & 1) == 0 ? 4 : 2;
                }
                YetiType.scanFreeVar(map3, structVar, yType2.param[n4], n, n2);
            }
            yType.seen = false;
        } else if (yType2.depth > n2) {
            YetiType.addFreeVar(map3, structVar, yType2, n);
        } else if ((n & 4) != 0 && yType2.depth == n2) {
            yType2.flags |= 2;
        }
    }

    private static boolean purgeNonFree(StructVar structVar) {
        structVar.deny = -1;
        if (structVar.next != null && structVar.next.deny != 0 && (structVar.next.deny > 0 || YetiType.purgeNonFree(structVar.next)) || structVar.link != null && structVar.link.deny != 0 && (structVar.link.deny > 0 || YetiType.purgeNonFree(structVar.link))) {
            structVar.deny = 1;
            return true;
        }
        return false;
    }

    static YType[] getFreeVar(Map map3, YType yType, int n, int n2) {
        YetiType.scanFreeVar(map3, null, yType, n, n2);
        if ((n & 4) != 0) {
            return NO_PARAM;
        }
        YType[] yTypeArray = new YType[map3.size()];
        StructVar[] structVarArray = new StructVar[yTypeArray.length];
        int n3 = 0;
        Iterator iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            yTypeArray[n3] = (YType)entry.getKey();
            structVarArray[n3] = (StructVar)entry.getValue();
            StructVar structVar = structVarArray[n3];
            if (structVar != null && structVar.deny == 0 && YetiType.purgeNonFree(structVar)) {
                structVar.deny = 1;
            }
            ++n3;
        }
        n3 = 0;
        for (int i = 0; i < yTypeArray.length; ++i) {
            if (structVarArray[i] != null && structVarArray[i].deny > 0) continue;
            yTypeArray[n3++] = yTypeArray[i];
        }
        YType[] yTypeArray2 = new YType[n3];
        System.arraycopy(yTypeArray, 0, yTypeArray2, 0, n3);
        return yTypeArray2;
    }

    static void getAllTypeVar(List list2, List list3, YType yType, boolean bl) {
        if (yType.seen) {
            return;
        }
        YType yType2 = yType.deref();
        if (yType2.type != 0) {
            yType.seen = true;
            int n = -1;
            if (list3 != null && (yType2.type == 11 || yType2.type == 12)) {
                n = 0;
                YetiType.getAllTypeVar(list3, null, yType2.param[0], false);
                if (bl) {
                    if (yType2.allowedMembers == null) {
                        yType2.allowedMembers = yType2.requiredMembers;
                    } else {
                        yType2.requiredMembers = yType2.allowedMembers;
                    }
                    yType2.flags &= 0xFFFFFFEF;
                }
            }
            while (++n < yType2.param.length) {
                YetiType.getAllTypeVar(list2, list3, yType2.param[n], bl);
            }
            yType.seen = false;
        } else if (list2.indexOf(yType2) < 0) {
            list2.add(yType2);
        }
    }

    static void removeStructs(YType yType, Collection collection) {
        if (!yType.seen) {
            if (yType.type != 0) {
                int n = 0;
                if (yType.type == 11 || yType.type == 12) {
                    collection.remove(yType.param[0].deref());
                    n = 1;
                } else if (yType.type == 10) {
                    collection.remove(yType.param[2].deref());
                }
                yType.seen = true;
                while (n < yType.param.length) {
                    YetiType.removeStructs(yType.param[n++], collection);
                }
                yType.seen = false;
            } else if (yType.ref != null) {
                YetiType.removeStructs(yType.ref, collection);
            }
        }
    }

    static void normalizeFlexType(YType yType, boolean bl) {
        yType = yType.deref();
        if (yType.type != 0 && !yType.seen) {
            if ((yType.flags & 0x10) != 0 && (yType.type == 11 || yType.type == 12)) {
                Map map3;
                if (yType.type == 11 ^ (map3 = yType.requiredMembers) != null ^ bl && (map3 == null || yType.allowedMembers == null)) {
                    yType.requiredMembers = yType.allowedMembers;
                    yType.allowedMembers = map3;
                }
                yType.flags &= 0xFFFFFFEF;
            }
            yType.seen = true;
            for (int i = 0; i < yType.param.length; ++i) {
                YetiType.normalizeFlexType(yType.param[i], (i == 0 && yType.type == 9) ^ bl);
            }
            yType.seen = false;
        }
    }

    static void stripFlexTypes(YType yType, boolean bl) {
        if (yType.type != 0 && !yType.seen) {
            if (bl) {
                yType.flags &= 0xFFFFFFEF;
            } else if ((yType.type == 11 || yType.type == 12) && yType.requiredMembers == null ^ yType.allowedMembers == null) {
                yType.flags |= 0x10;
            }
            yType.seen = true;
            for (int i = 0; i < yType.param.length; ++i) {
                YetiType.stripFlexTypes(yType.param[i].deref(), bl);
            }
            yType.seen = false;
        }
    }

    static Scope bind(String string2, YType yType, Binder binder, int n, int n2, Scope scope) {
        scope = new Scope(scope, string2, binder);
        scope.free = YetiType.getFreeVar(new IdentityHashMap(), yType, n, n2);
        if (scope.free.length == 0) {
            scope.free = null;
        }
        return scope;
    }

    static Scope bindPoly(String string2, YType yType, Binder binder, Scope scope) {
        return YetiType.bind(string2, yType, binder, 8, 0, scope);
    }

    static YType resolveTypeDef(Scope scope, String string2, YType[] yTypeArray, int n, YetiParser.TypeNode typeNode, int n2) {
        while (scope != null) {
            YType[] yTypeArray2;
            if (scope.name == string2 && (yTypeArray2 = scope.typedef(true)) != null) {
                if (yTypeArray2.length - 1 != yTypeArray.length) {
                    throw new CompileException((YetiParser.Node)typeNode, "Type " + string2 + " expects " + (yTypeArray2.length == 2 ? "1 parameter" : yTypeArray2.length - 1 + " parameters") + ", not " + yTypeArray.length);
                }
                if (scope.free == null) {
                    if (n2 >= 0 && n2 != 3) break;
                    return yTypeArray2[0];
                }
                if (n2 == 3) break;
                Map map3 = YetiType.createFreeVars(scope.free, n);
                int n3 = yTypeArray.length;
                while (--n3 >= 0) {
                    map3.put(yTypeArray2[n3], yTypeArray[n3]);
                }
                YType yType = YetiType.copyType(yTypeArray2[yTypeArray.length], map3, new IdentityHashMap());
                if (typeNode.exact) {
                    YetiType.stripFlexTypes(yType, true);
                }
                return yType;
            }
            scope = scope.outer;
        }
        throw new CompileException((YetiParser.Node)typeNode, "Unknown type: " + string2);
    }

    private static void prepareOpaqueCast(YType yType, boolean[] blArray) {
        if (yType.seen) {
            return;
        }
        YType yType2 = yType.deref();
        if (yType2.type != 0) {
            yType.seen = true;
            if (yType2.type >= 65536 && blArray[yType2.type - 65536]) {
                yType2.flags |= 4;
            }
            int n = yType2.param.length;
            while (--n >= 0) {
                YetiType.prepareOpaqueCast(yType2.param[n], blArray);
            }
            yType.seen = false;
        }
    }

    private static Map opaqueMembers(Map identityHashMap, Map map3) {
        if (identityHashMap != null) {
            identityHashMap = new IdentityHashMap(identityHashMap);
            Iterator iterator = identityHashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object v2 = map3.get(entry.getKey());
                if (v2 == null) continue;
                entry.setValue(v2);
            }
        }
        return identityHashMap;
    }

    private static YType deriveOpaque(YType yType, YType yType2, Map map3, boolean[] blArray) {
        YType yType3 = (YType)map3.get(yType2 = yType2.deref());
        if (yType3 != null) {
            return yType3;
        }
        if (yType2.type >= 65536 && blArray[yType2.type - 65536]) {
            map3.put(yType2, yType2);
            return yType2;
        }
        boolean bl = false;
        if (yType2.type == 11 || yType2.type == 12) {
            yType3 = new YType(yType.type, NO_PARAM);
            map3.put(yType2, yType3);
            IdentityHashMap identityHashMap = new IdentityHashMap(yType2.allowedMembers != null ? yType2.allowedMembers : yType2.requiredMembers);
            Iterator iterator = identityHashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                YType yType4 = (YType)(yType.allowedMembers != null ? yType.allowedMembers : yType.requiredMembers).get((entry = iterator.next()).getKey());
                if (yType4 == null) {
                    iterator.remove();
                    continue;
                }
                YType yType5 = YetiType.deriveOpaque(yType4.deref(), (YType)entry.getValue(), map3, blArray);
                if (yType5 == entry.getValue()) continue;
                entry.setValue(yType5);
                bl = true;
            }
            if (bl) {
                yType3.allowedMembers = YetiType.opaqueMembers(yType.allowedMembers, identityHashMap);
                yType3.requiredMembers = YetiType.opaqueMembers(yType.requiredMembers, identityHashMap);
                YetiType.structParam(yType3, yType3.requiredMembers != null ? yType3.requiredMembers : yType3.allowedMembers, yType.param[0].deref());
                return yType3;
            }
        } else if (yType2.type > 8 && yType2.param.length != 0 && yType2.param.length == yType.param.length) {
            yType3 = new YType(yType.type, new YType[yType.param.length]);
            map3.put(yType2, yType3);
            for (int i = 0; i < yType3.param.length; ++i) {
                YType yType6;
                YType yType7 = yType.param[i].deref();
                yType3.param[i] = yType6 = YetiType.deriveOpaque(yType7, yType2.param[i], map3, blArray);
                bl |= yType7 != yType6;
            }
            if (bl) {
                return yType3;
            }
        } else {
            yType3 = null;
        }
        if (yType3 != null) {
            yType3.type = 0;
            yType3.ref = yType;
            yType3.param = null;
        }
        map3.put(yType2, yType);
        return yType;
    }

    static YType opaqueCast(YType yType, YType yType2, Scope scope) throws TypeException {
        YType yType3;
        if (yType.deref().type == 0) {
            throw new TypeException("Illegal as cast from 'a to non-Java type");
        }
        boolean[] blArray = new boolean[scope.ctx.opaqueTypes.size() + 1];
        while (scope != null) {
            YType[] yTypeArray = scope.typedef(false);
            if (yTypeArray != null) {
                yType3 = yTypeArray[yTypeArray.length - 1];
                if (yType3.type >= 65536 && yType3.allowedMembers != null) {
                    blArray[yType3.type - 65536] = true;
                }
            }
            scope = scope.outer;
        }
        yType2 = yType2.deref();
        yType3 = YetiType.copyType(yType2, null, new IdentityHashMap());
        YetiType.prepareOpaqueCast(yType3, blArray);
        YetiType.unify(yType, yType3);
        return YetiType.deriveOpaque(yType.deref(), yType2, new IdentityHashMap(), blArray);
    }

    static YType withDoc(YType yType, String string2) {
        if (string2 == null) {
            return yType;
        }
        if (yType.type > 0 && yType.type <= 8) {
            YType yType2 = yType;
            yType = new YType(0);
            yType.ref = yType2;
        }
        yType.doc = string2;
        return yType;
    }

    static class StructVar {
        int deny;
        StructVar link;
        StructVar next;

        StructVar(int n, StructVar structVar) {
            this.deny = n;
            this.next = structVar;
        }
    }

    static final class ScopeCtx {
        final String packageName;
        final String className;
        final Map opaqueTypes;
        final Compiler compiler;

        ScopeCtx(String string2, Compiler compiler) {
            this.packageName = JavaType.packageOfClass(string2);
            this.className = string2;
            this.opaqueTypes = compiler.opaqueTypes;
            this.compiler = compiler;
        }
    }

    static class ClassBinding {
        final YType type;

        ClassBinding(YType yType) {
            this.type = yType;
        }

        BindRef[] getCaptures() {
            return null;
        }

        ClassBinding dup(List list2) {
            return this;
        }
    }
}

