/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import yeti.lang.compiler.Apply;
import yeti.lang.compiler.BindRef;
import yeti.lang.compiler.Binder;
import yeti.lang.compiler.Capture;
import yeti.lang.compiler.CaptureWrapper;
import yeti.lang.compiler.CapturingClosure;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.Ctx;
import yeti.lang.compiler.Function;
import yeti.lang.compiler.LoadVar;
import yeti.lang.compiler.StructField;
import yeti.lang.compiler.UnitConstant;
import yeti.lang.compiler.YType;
import yeti.renamed.asm3.Label;

final class StructConstructor
extends CapturingClosure
implements Comparator {
    StructField[] fields;
    StructField[] fieldsOrigOrder;
    int fieldCount;
    StructField properties;
    String impl;
    int arrayVar = -1;
    private boolean mustGen;
    private Code withParent;
    private String[] withFields;

    StructConstructor(int n) {
        this.fields = new StructField[n];
    }

    Binder bind(StructField structField) {
        return new Bind(structField);
    }

    void add(StructField structField) {
        if (structField.name == null) {
            throw new IllegalArgumentException();
        }
        this.fields[this.fieldCount++] = structField;
        if (structField.property != 0) {
            structField.nextProperty = this.properties;
            this.properties = structField;
        }
    }

    public int compare(Object object, Object object2) {
        return ((StructField)object).name.compareTo(((StructField)object2).name);
    }

    void close() {
        this.fieldsOrigOrder = new StructField[this.fields.length];
        System.arraycopy(this.fields, 0, this.fieldsOrigOrder, 0, this.fields.length);
        Arrays.sort(this.fields, 0, this.fieldCount, this);
        for (int i = 0; i < this.fieldCount; ++i) {
            StructField structField = this.fields[i];
            structField.javaName = "_".concat(Integer.toString(i));
            structField.index = i;
            if (structField.property == 0) continue;
            this.mustGen = true;
        }
    }

    void publish() {
        for (int i = 0; i < this.fieldCount; ++i) {
            if (this.fields[i].property > 0) continue;
            Code code = this.fields[i].value;
            while (code instanceof BindRef) {
                code = ((BindRef)code).unref(true);
            }
            if (!(code instanceof Function)) continue;
            ((Function)code).publish = true;
        }
    }

    Map getDirect() {
        HashMap<String, Code> hashMap = new HashMap<String, Code>(this.fieldCount);
        for (int i = 0; i < this.fieldCount; ++i) {
            if (this.fields[i].mutable || this.fields[i].property > 0) {
                hashMap.put(this.fields[i].name, null);
                continue;
            }
            if (this.fields[i].binder != null) continue;
            Code code = this.fields[i].value;
            while (code instanceof BindRef) {
                code = ((BindRef)code).unref(false);
            }
            if (code == null || !code.flagop(1)) continue;
            hashMap.put(this.fields[i].name, code);
        }
        return hashMap;
    }

    void captureInit(Ctx ctx, Capture capture, int n) {
        ctx.cw.visitField(4096, capture.getId(ctx), capture.captureType(), null, null).visitEnd();
    }

    void gen(Ctx ctx) {
        boolean bl = false;
        if (this.mustGen || this.fieldCount > 6 && this.fieldCount <= 15) {
            this.impl = this.genStruct(ctx);
            bl = true;
        } else if (this.fieldCount <= 3) {
            this.impl = "yeti/lang/Struct3";
        } else if (this.fieldCount <= 6) {
            this.impl = "yeti/lang/Struct6";
        }
        for (int i = 0; i < this.fieldCount; ++i) {
            if (this.fields[i].binder == null) continue;
            ((Bind)this.fields[i].binder).initGen(ctx);
        }
        String string2 = this.impl != null ? this.impl : "yeti/lang/GenericStruct";
        ctx.typeInsn(187, string2);
        ctx.insn(89);
        if (this.withParent != null) {
            this.withParent.gen(ctx);
            ctx.visitInit(string2, "(Lyeti/lang/Struct;)V");
        } else if (bl) {
            ctx.visitInit(string2, "()V");
        } else {
            ctx.constants.structInitArg(ctx, this.fields, this.fieldCount, false);
            ctx.visitInit(string2, "([Ljava/lang/String;[Z)V");
        }
        if (this.arrayVar != -1) {
            ctx.varInsn(58, this.arrayVar);
        }
        int n = this.fieldCount;
        for (int i = 0; i < n; ++i) {
            if (this.fields[i].property != 0 || this.fields[i].inherited) continue;
            if (this.arrayVar != -1) {
                ctx.load(this.arrayVar);
            } else {
                ctx.insn(89);
            }
            if (this.impl == null) {
                ctx.ldcInsn(this.fields[i].name);
            }
            if (this.fields[i].binder != null) {
                this.fields[i].binder.gen(ctx);
                ((Function)this.fields[i].value).finishGen(ctx);
            } else {
                this.fields[i].value.gen(ctx);
            }
            if (this.impl != null) {
                ctx.fieldInsn(181, this.impl, this.fields[i].javaName, "Ljava/lang/Object;");
                continue;
            }
            ctx.methodInsn(182, "yeti/lang/GenericStruct", "set", "(Ljava/lang/String;Ljava/lang/Object;)V");
        }
        if (this.arrayVar != -1) {
            ctx.load(this.arrayVar);
        }
        Capture capture = this.captures;
        while (capture != null) {
            ctx.insn(89);
            capture.captureGen(ctx);
            ctx.fieldInsn(181, this.impl, capture.id, capture.captureType());
            capture = capture.next;
        }
    }

    String genStruct(Ctx ctx) {
        String string2;
        Label[] labelArray;
        Label label;
        Object object;
        Label label2;
        String string3;
        Object object2;
        StructField structField;
        int n;
        String string4 = null;
        Label label3 = null;
        if (this.mustGen) {
            for (n = 0; n < this.fieldCount; ++n) {
                structField = this.fields[n];
                if (structField.mutable || structField.property != 0 || structField.inherited || !structField.value.prepareConst(ctx)) continue;
                structField.property = -1;
            }
        } else {
            object2 = new StringBuffer();
            for (n = 0; n < this.fields.length; ++n) {
                ((StringBuffer)object2).append(this.fields[n].mutable ? (char)';' : ',').append(this.fields[n].name);
            }
            string4 = ((StringBuffer)object2).toString();
            string3 = (String)ctx.constants.structClasses.get(string4);
            if (string3 != null) {
                return string3;
            }
        }
        string3 = ctx.compilation.createClassName(ctx, ctx.className, "");
        if (string4 != null) {
            ctx.constants.structClasses.put(string4, string3);
        }
        object2 = ctx.newClass(48, string3, "yeti/lang/AStruct", null, this.fieldsOrigOrder[0].line);
        ((Ctx)object2).fieldCounter = this.fieldCount;
        this.mergeCaptures((Ctx)object2, true);
        Ctx ctx2 = ((Ctx)object2).newMethod(1, "<init>", this.withParent == null ? "()V" : "(Lyeti/lang/Struct;)V");
        ctx2.load((int)0).constants.structInitArg(ctx2, this.fields, this.fieldCount, this.withParent != null);
        ctx2.visitInit("yeti/lang/AStruct", "([Ljava/lang/String;[Z)V");
        if (this.withParent != null) {
            ctx2.intConst(2);
            ctx2.visitIntInsn(188, 10);
            ctx2.varInsn(58, 4);
            ctx2.intConst(this.withFields.length - 2);
            ctx2.varInsn(54, 3);
            ctx2.load(1).methodInsn(185, "yeti/lang/Struct", "count", "()I");
            ctx2.varInsn(54, 2);
            label2 = new Label();
            Label label4 = new Label();
            object = new Label();
            label = new Label();
            ctx2.visitLabel(label2);
            ctx2.visitIntInsn(132, 2);
            ctx2.load(1).varInsn(21, 2);
            ctx2.methodInsn(185, "yeti/lang/Struct", "name", "(I)Ljava/lang/String;");
            ctx2.constants.stringArray(ctx2, this.withFields);
            ctx2.varInsn(21, 3);
            ctx2.insn(50);
            ctx2.jumpInsn(166, label4);
            ctx2.load(0).load(1).varInsn(21, 2);
            ctx2.load(4).intConst(0);
            ctx2.methodInsn(185, "yeti/lang/Struct", "ref", "(I[II)Ljava/lang/Object;");
            labelArray = new Label[this.withFields.length - 1];
            for (n = 0; n < labelArray.length; ++n) {
                labelArray[n] = new Label();
            }
            ctx2.load(0).load(4).intConst(0);
            ctx2.insn(46);
            ctx2.load(0).load(4).intConst(1);
            ctx2.insn(46);
            if (labelArray.length > 1) {
                label3 = new Label();
                ctx2.varInsn(21, 3);
                ctx2.switchInsn(0, labelArray.length - 1, label3, null, labelArray);
            }
            n = 0;
            int n2 = 0;
            while (n2 < labelArray.length) {
                if (this.fields[n].inherited) {
                    ctx2.visitLabel(labelArray[n2++]);
                    string2 = Integer.toString(n);
                    ctx2.fieldInsn(181, string3, "h".concat(string2), "Z");
                    ctx2.fieldInsn(181, string3, "i".concat(string2), "I");
                    ctx2.fieldInsn(181, string3, this.fields[n].javaName, "Ljava/lang/Object;");
                    ctx2.jumpInsn(167, label);
                }
                ++n;
            }
            if (labelArray.length > 1) {
                ctx2.visitLabel(label3);
                ctx2.popn(6);
            }
            ctx2.visitLabel(label);
            ctx2.visitIntInsn(132, 3);
            ctx2.varInsn(21, 3);
            ctx2.jumpInsn(155, (Label)object);
            ctx2.visitLabel(label4);
            ctx2.varInsn(21, 2);
            ctx2.jumpInsn(157, label2);
            ctx2.visitLabel((Label)object);
        }
        ctx2.insn(177);
        ctx2.closeMethod();
        for (n = 0; n < this.fieldCount; ++n) {
            structField = this.fields[n];
            if (structField.property == 0) {
                ((Ctx)object2).cw.visitField(structField.inherited ? 18 : 4096, structField.javaName, "Ljava/lang/Object;", null, null).visitEnd();
            }
            if (!structField.inherited) continue;
            string2 = Integer.toString(n);
            ((Ctx)object2).cw.visitField(18, "i".concat(string2), "I", null, null).visitEnd();
            ((Ctx)object2).cw.visitField(18, "h".concat(string2), "Z", null, null).visitEnd();
        }
        ctx2 = ((Ctx)object2).newMethod(1, "get", "(Ljava/lang/String;)Ljava/lang/Object;");
        ctx2.load(0);
        label2 = null;
        for (n = 0; n < this.fieldCount; ++n) {
            label = new Label();
            structField = this.fieldsOrigOrder[n];
            ctx2.load(1).ldcInsn(structField.name);
            ctx2.jumpInsn(166, label);
            if (structField.property != 0) {
                ctx2.intConst(structField.index);
                ctx2.methodInsn(182, string3, "get", "(I)Ljava/lang/Object;");
            } else {
                ctx2.fieldInsn(180, string3, structField.javaName, "Ljava/lang/Object;");
            }
            if (structField.inherited) {
                if (label2 == null) {
                    label2 = new Label();
                }
                ctx2.load(0).fieldInsn(180, string3, "i" + structField.index, "I");
                ctx2.insn(89);
                ctx2.jumpInsn(156, label2);
                ctx2.insn(87);
            }
            ctx2.insn(176);
            ctx2.visitLabel(label);
        }
        ctx2.typeInsn(187, "java/lang/NoSuchFieldException");
        ctx2.insn(89);
        ctx2.load(1).visitInit("java/lang/NoSuchFieldException", "(Ljava/lang/String;)V");
        ctx2.insn(191);
        if (label2 != null) {
            ctx2.visitLabel(label2);
            ctx2.methodInsn(185, "yeti/lang/Struct", "get", "(I)Ljava/lang/Object;");
            ctx2.insn(176);
        }
        ctx2.closeMethod();
        ctx2 = ((Ctx)object2).newMethod(1, "get", "(I)Ljava/lang/Object;");
        ctx2.localVarCount = 2;
        ctx2.load(0).varInsn(21, 1);
        labelArray = new Label[this.fieldCount];
        int n3 = 0;
        for (n = 0; n < this.fieldCount; ++n) {
            labelArray[n] = new Label();
            if (!this.fields[n].mutable) continue;
            ++n3;
        }
        label3 = new Label();
        ctx2.switchInsn(0, this.fieldCount - 1, label3, null, labelArray);
        if (label2 != null) {
            label2 = new Label();
        }
        for (n = 0; n < this.fieldCount; ++n) {
            structField = this.fields[n];
            ctx2.visitLabel(labelArray[n]);
            if (structField.property > 0) {
                new Apply(null, structField.value, new UnitConstant(null), structField.line).gen(ctx2);
            } else if (structField.property < 0) {
                structField.value.gen(ctx2);
            } else {
                ctx2.fieldInsn(180, string3, structField.javaName, "Ljava/lang/Object;");
            }
            if (structField.inherited) {
                ctx2.load(0).fieldInsn(180, string3, "i" + n, "I");
                ctx2.insn(89);
                ctx2.jumpInsn(156, label2);
                ctx2.insn(87);
            }
            ctx2.insn(176);
        }
        ctx2.visitLabel(label3);
        ctx2.insn(1);
        ctx2.insn(176);
        if (label2 != null) {
            ctx2.visitLabel(label2);
            ctx2.methodInsn(185, "yeti/lang/Struct", "get", "(I)Ljava/lang/Object;");
            ctx2.insn(176);
        }
        ctx2.closeMethod();
        if (this.withParent != null) {
            ctx2 = ((Ctx)object2).newMethod(1, "ref", "(I[II)Ljava/lang/Object;");
            object = null;
            Label label5 = null;
            labelArray = new Label[this.fieldCount];
            for (n = 0; n < this.fieldCount; ++n) {
                if (this.fields[n].inherited) {
                    labelArray[n] = new Label();
                    continue;
                }
                if (this.fields[n].mutable || this.fields[n].property > 0) {
                    if (label5 == null) {
                        label5 = new Label();
                    }
                    labelArray[n] = label5;
                    continue;
                }
                if (object == null) {
                    object = new Label();
                }
                labelArray[n] = object;
            }
            label3 = new Label();
            label = new Label();
            ctx2.load(0).load(2).varInsn(21, 3);
            ctx2.varInsn(21, 1);
            ctx2.switchInsn(0, this.fieldCount - 1, label3, null, labelArray);
            int n4 = 0;
            for (n = 0; n < this.fieldCount; ++n) {
                if (!this.fields[n].inherited) continue;
                ++n4;
                ctx2.visitLabel(labelArray[n]);
                string2 = Integer.toString(n);
                ctx2.load(0).fieldInsn(180, string3, "i".concat(string2), "I");
                ctx2.insn(79);
                ctx2.fieldInsn(180, string3, this.fields[n].javaName, "Ljava/lang/Object;");
                ctx2.load(0).fieldInsn(180, string3, "h".concat(string2), "Z");
                ctx2.jumpInsn(167, label);
            }
            if (label5 != null) {
                ctx2.visitLabel(label5);
                ctx2.varInsn(21, 1);
                ctx2.insn(79);
                ctx2.intConst(0);
                ctx2.jumpInsn(167, label);
            }
            if (object != null) {
                ctx2.visitLabel((Label)object);
                ctx2.intConst(-1);
                ctx2.insn(79);
                ctx2.varInsn(21, 1);
                ctx2.methodInsn(182, string3, "get", "(I)Ljava/lang/Object;");
                ctx2.intConst(0);
            }
            ctx2.visitLabel(label);
            ctx2.varInsn(54, 1);
            ctx2.load(2).varInsn(21, 3);
            ctx2.intConst(1);
            ctx2.insn(96);
            ctx2.varInsn(21, 1);
            ctx2.insn(79);
            ctx2.insn(176);
            ctx2.visitLabel(label3);
            ctx2.insn(1);
            ctx2.insn(176);
            ctx2.closeMethod();
            if (n4 > 0) {
                ctx2 = ((Ctx)object2).newMethod(1, "eqName", "(I)Ljava/lang/String;");
                label3 = new Label();
                labelArray = new Label[this.fieldCount];
                for (n = 0; n < this.fieldCount; ++n) {
                    labelArray[n] = this.fields[n].inherited ? new Label() : label3;
                }
                ctx2.load(0).varInsn(21, 1);
                ctx2.switchInsn(0, this.fieldCount - 1, label3, null, labelArray);
                Label label6 = new Label();
                for (n = 0; n < this.fieldCount; ++n) {
                    if (!this.fields[n].inherited) continue;
                    ctx2.visitLabel(labelArray[n]);
                    ctx2.fieldInsn(180, string3, "h".concat(Integer.toString(n)), "Z");
                    if (--n4 <= 0) break;
                    ctx2.jumpInsn(167, label6);
                }
                ctx2.visitLabel(label6);
                label = new Label();
                ctx2.jumpInsn(153, label);
                ctx2.ldcInsn("");
                ctx2.insn(176);
                ctx2.visitLabel(label);
                ctx2.load(0).visitLabel(label3);
                ctx2.varInsn(21, 1);
                ctx2.methodInsn(182, string3, "name", "(I)Ljava/lang/String;");
                ctx2.insn(176);
                ctx2.closeMethod();
            }
        }
        if (n3 == 0) {
            return string3;
        }
        ctx2 = ((Ctx)object2).newMethod(1, "set", "(Ljava/lang/String;Ljava/lang/Object;)V");
        ctx2.localVarCount = 3;
        ctx2.load(0);
        for (n = 0; n < this.fieldCount; ++n) {
            structField = this.fieldsOrigOrder[n];
            if (!structField.mutable) continue;
            label = new Label();
            ctx2.load(1).ldcInsn(structField.name);
            ctx2.jumpInsn(166, label);
            if (structField.property != 0) {
                object = new LoadVar();
                ((LoadVar)object).var = 2;
                new Apply(null, structField.setter, (Code)object, structField.line).gen(ctx2);
                ctx2.insn(88);
            } else if (structField.inherited) {
                ctx2.fieldInsn(180, string3, structField.javaName, "Ljava/lang/Object;");
                ctx2.load(1).load(2).methodInsn(185, "yeti/lang/Struct", "set", "(Ljava/lang/String;Ljava/lang/Object;)V");
            } else {
                ctx2.load(2).fieldInsn(181, string3, structField.javaName, "Ljava/lang/Object;");
            }
            ctx2.insn(177);
            ctx2.visitLabel(label);
        }
        ctx2.insn(87);
        ctx2.insn(177);
        ctx2.closeMethod();
        return string3;
    }

    void genWith(Ctx ctx, Code code, Map hashMap) {
        hashMap = new HashMap(hashMap);
        for (int i = 0; i < this.fieldCount; ++i) {
            hashMap.remove(this.fields[i].name);
        }
        if (hashMap.isEmpty()) {
            this.gen(ctx);
            return;
        }
        this.mustGen = true;
        this.withParent = code;
        StructField[] structFieldArray = new StructField[this.fieldCount + hashMap.size()];
        Object[] objectArray = hashMap.keySet().toArray();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            StructField structField = new StructField();
            structField.name = (String)objectArray[i];
            structField.inherited = true;
            structField.mutable = ((YType)hashMap.get((Object)structField.name)).field == 2;
            structFieldArray[i] = structField;
        }
        this.withFields = new String[objectArray.length + 1];
        System.arraycopy(objectArray, 0, this.withFields, 1, objectArray.length);
        System.arraycopy(this.fields, 0, structFieldArray, hashMap.size(), this.fieldCount);
        this.fields = structFieldArray;
        this.fieldCount = structFieldArray.length;
        this.close();
        this.gen(ctx);
    }

    private class Bind
    extends BindRef
    implements Binder,
    CaptureWrapper {
        private StructField field;
        private boolean fun;
        private boolean direct;
        private boolean mutable;
        private int var;

        Bind(StructField structField) {
            this.type = structField.value.type;
            this.binder = this;
            this.mutable = structField.mutable;
            this.fun = structField.value instanceof Function;
            this.field = structField;
        }

        void initGen(Ctx ctx) {
            if (this.prepareConst(ctx)) {
                this.direct = true;
                this.field.binder = null;
                return;
            }
            if (!this.mutable && this.fun) {
                ((Function)this.field.value).prepareGen(ctx, false);
                this.var = ctx.localVarCount++;
                ctx.varInsn(58, this.var);
            } else {
                if (StructConstructor.this.arrayVar == -1) {
                    StructConstructor.this.arrayVar = ctx.localVarCount++;
                }
                this.var = StructConstructor.this.arrayVar;
                this.field.binder = null;
            }
        }

        public BindRef getRef(int n) {
            this.field.binder = this;
            return this;
        }

        public CaptureWrapper capture() {
            return !this.fun || this.mutable ? this : null;
        }

        public boolean flagop(int n) {
            if ((n & 4) != 0) {
                return this.mutable;
            }
            if ((n & 2) != 0) {
                return !this.mutable;
            }
            if ((n & 0x20) != 0) {
                return this.direct;
            }
            if ((n & 1) != 0) {
                return this.direct || !this.mutable && this.field.value.flagop(1);
            }
            return false;
        }

        boolean prepareConst(Ctx ctx) {
            return this.direct || !this.mutable && this.field.value.prepareConst(ctx);
        }

        void gen(Ctx ctx) {
            if (this.direct) {
                this.field.value.gen(ctx);
            } else {
                ctx.load(this.var);
            }
        }

        public void genPreGet(Ctx ctx) {
            if (this.direct) {
                ctx.insn(1);
            } else {
                ctx.load(this.var);
            }
        }

        public void genGet(Ctx ctx) {
            if (this.direct) {
                ctx.insn(87);
                this.field.value.gen(ctx);
            } else if (StructConstructor.this.impl == null) {
                ctx.ldcInsn(this.field.name);
                ctx.methodInsn(185, "yeti/lang/Struct", "get", "(Ljava/lang/String;)Ljava/lang/Object;");
            } else if (this.field.property != 0) {
                ctx.intConst(this.field.index);
                ctx.methodInsn(185, "yeti/lang/Struct", "get", "(I)Ljava/lang/Object;");
            } else {
                ctx.fieldInsn(180, StructConstructor.this.impl, this.field.javaName, "Ljava/lang/Object;");
            }
        }

        public void genSet(Ctx ctx, Code code) {
            if (StructConstructor.this.impl != null && this.field.property == 0) {
                code.gen(ctx);
                ctx.fieldInsn(181, StructConstructor.this.impl, this.field.javaName, "Ljava/lang/Object;");
                return;
            }
            ctx.ldcInsn(this.field.name);
            code.gen(ctx);
            ctx.methodInsn(185, "yeti/lang/Struct", "set", "(Ljava/lang/String;Ljava/lang/Object;)V");
        }

        public Object captureIdentity() {
            return this.direct ? null : StructConstructor.this;
        }

        public String captureType() {
            return StructConstructor.this.impl != null ? 'L' + StructConstructor.this.impl + ';' : "Lyeti/lang/Struct;";
        }
    }
}

