/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import yeti.lang.BigNum;
import yeti.lang.IntNum;
import yeti.lang.Num;
import yeti.lang.RatNum;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.CodeGen;
import yeti.lang.compiler.Ctx;
import yeti.lang.compiler.SimpleCode;
import yeti.lang.compiler.YetiType;

final class NumericConstant
extends Code
implements CodeGen {
    Num num;

    NumericConstant(Num num) {
        this.type = YetiType.NUM_TYPE;
        this.num = num;
    }

    boolean flagop(int n) {
        return (n & 8) != 0 && this.num instanceof IntNum || (n & 0x23) != 0;
    }

    void genInt(Ctx ctx, int n, boolean bl) {
        if (bl) {
            ctx.ldcInsn(new Long(this.num.longValue()));
        } else {
            ctx.intConst(this.num.intValue());
        }
    }

    public void gen2(Ctx ctx, Code code, int n) {
        ctx.typeInsn(187, "yeti/lang/RatNum");
        ctx.insn(89);
        RatNum ratNum = ((RatNum)this.num).reduce();
        ctx.intConst(ratNum.numerator());
        ctx.intConst(ratNum.denominator());
        ctx.visitInit("yeti/lang/RatNum", "(II)V");
    }

    void gen(Ctx ctx) {
        if (ctx.constants.constants.containsKey(this.num)) {
            ctx.constant(this.num, this);
            return;
        }
        if (this.num instanceof RatNum) {
            ctx.constant(this.num, new SimpleCode(this, null, YetiType.NUM_TYPE, 0));
            return;
        }
        Impl impl = new Impl();
        if (this.num instanceof IntNum) {
            impl.jtype = "yeti/lang/IntNum";
            if (IntNum.__1.compareTo(this.num) <= 0 && IntNum._9.compareTo(this.num) >= 0) {
                ctx.fieldInsn(178, impl.jtype, IntNum.__1.equals(this.num) ? "__1" : (IntNum.__2.equals(this.num) ? "__2" : "_" + this.num), "Lyeti/lang/IntNum;");
                ctx.forceType("yeti/lang/Num");
                return;
            }
            impl.val = new Long(this.num.longValue());
            impl.sig = "(J)V";
        } else if (this.num instanceof BigNum) {
            impl.jtype = "yeti/lang/BigNum";
            impl.val = this.num.toString();
            impl.sig = "(Ljava/lang/String;I)V";
        } else {
            impl.jtype = "yeti/lang/FloatNum";
            impl.val = new Double(this.num.doubleValue());
            impl.sig = "(D)V";
        }
        impl.type = YetiType.NUM_TYPE;
        ctx.constant(this.num, impl);
    }

    Object valueKey() {
        return this.num;
    }

    private static final class Impl
    extends Code {
        String jtype;
        String sig;
        Object val;

        private Impl() {
        }

        void gen(Ctx ctx) {
            ctx.typeInsn(187, this.jtype);
            ctx.insn(89);
            ctx.ldcInsn(this.val);
            if (this.val instanceof String) {
                ctx.intConst(10);
            }
            ctx.visitInit(this.jtype, this.sig);
        }
    }
}

