/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.CompileException;
import yeti.lang.compiler.Compiler;
import yeti.lang.compiler.JavaClass;
import yeti.lang.compiler.JavaClassNotFoundException;
import yeti.lang.compiler.JavaTypeReader;
import yeti.lang.compiler.Scope;
import yeti.lang.compiler.TypeException;
import yeti.lang.compiler.YType;
import yeti.lang.compiler.YetiParser;
import yeti.lang.compiler.YetiType;

class JavaType
implements Cloneable {
    private static final JavaType[] EMPTY_JTARR = new JavaType[0];
    static final Map JAVA_PRIM = new HashMap();
    final String description;
    private boolean resolved;
    private Map fields;
    private Map staticFields;
    private Method[] methods;
    private Method[] staticMethods;
    private Method[] constructors;
    private JavaType parent;
    private HashMap interfaces;
    private static HashMap CACHE = new HashMap();
    int publicMask = 1;
    int access;
    JavaClass implementation;
    static final String[] NUMBER_TYPES = new String[]{"Ljava/lang/Byte;", "Ljava/lang/Short;", "Ljava/lang/Float;", "Ljava/lang/Integer;", "Ljava/lang/Long;", "Ljava/math/BigInteger;", "Ljava/math/BigDecimal;"};
    YType[] TRY_SMART = new YType[]{YetiType.BOOL_TYPE, YetiType.STR_TYPE, YetiType.NUM_TYPE};

    static void checkPackage(YetiParser.Node node, String string2, String string3, String string4, String string5) {
        if (!JavaType.packageOfClass(string3).equals(string2)) {
            throw new CompileException(node, "Non-public " + string4 + ' ' + string3.replace('/', '.') + (string5 == null ? "" : "#".concat(string5)) + " cannot be accessed from different package (" + string2.replace('/', '.') + ")");
        }
    }

    void checkPackage(YetiParser.Node node, String string2) {
        if ((this.access & 1) == 0) {
            JavaType.checkPackage(node, string2, this.className(), (this.access & 0x200) != 0 ? "interface" : "class", null);
        }
    }

    boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    static String descriptionOf(YType yType) {
        if (yType.type == 0) {
            if (yType.ref != null) {
                return JavaType.descriptionOf(yType.ref);
            }
            return "Ljava/lang/Object;";
        }
        String string2 = "";
        while (yType.type == 14) {
            string2 = string2.concat("[");
            yType = yType.param[0];
        }
        if (yType.type != 13) {
            return "Ljava/lang/Object;";
        }
        return string2.concat(yType.javaType.description);
    }

    static YType convertValueType(YType yType) {
        if (yType.type != 13) {
            return yType;
        }
        String string2 = yType.javaType.description;
        if (string2 == "Ljava/lang/String;" || string2 == "C") {
            return YetiType.STR_TYPE;
        }
        if (string2 == "Ljava/lang/Boolean;" || string2 == "Z") {
            return YetiType.BOOL_TYPE;
        }
        if (string2 == "Lyeti/lang/Num;" || string2.length() == 1 && "BDFIJS".indexOf(string2.charAt(0)) >= 0) {
            return YetiType.NUM_TYPE;
        }
        if (string2 == "V") {
            return YetiType.UNIT_TYPE;
        }
        return yType;
    }

    private static JavaType getClass(YType yType) {
        switch (yType.type) {
            case 13: {
                return yType.javaType;
            }
            case 3: {
                return JavaType.fromDescription("Lyeti/lang/Num;");
            }
            case 2: {
                return JavaType.fromDescription("Ljava/lang/String;");
            }
            case 4: {
                return JavaType.fromDescription("Ljava/lang/Boolean;");
            }
            case 10: {
                switch (yType.param[2].type) {
                    case 7: {
                        return JavaType.fromDescription(yType.param[1].type == 3 ? "Lyeti/lang/MList;" : "Lyeti/lang/AList;");
                    }
                    case 8: {
                        return JavaType.fromDescription("Ljava/util/Map;");
                    }
                }
                return JavaType.fromDescription("Lyeti/lang/ByKey;");
            }
            case 9: {
                return JavaType.fromDescription("Lyeti/lang/Fun;");
            }
            case 12: {
                return JavaType.fromDescription("Lyeti/lang/Tag;");
            }
            case 11: {
                return JavaType.fromDescription("Lyeti/lang/Struct;");
            }
            case 0: 
            case 1: {
                return JavaType.fromDescription("Ljava/lang/Object;");
            }
        }
        return null;
    }

    static void checkUnsafeCast(YetiParser.Node node, YType yType, YType yType2) {
        if (yType.type != 13 && yType2.type != 13 && yType2.type != 14) {
            throw new CompileException(node, "Illegal cast from " + yType + " to " + yType2 + " (neither side is java object)");
        }
        JavaType javaType = JavaType.getClass(yType);
        if (javaType == null) {
            throw new CompileException(node, "Illegal cast from " + yType);
        }
        JavaType javaType2 = JavaType.getClass(yType2);
        if (yType.type == 0 && (javaType2 == null || javaType2.description != "Ljava/lang/Object;")) {
            yType.type = 13;
            yType.param = YetiType.NO_PARAM;
            yType.javaType = JavaType.fromDescription("Ljava/lang/Object;");
        }
        if (javaType2 == null) {
            if (javaType.description == "Ljava/lang/Object;" && yType2.type == 14) {
                return;
            }
            throw new CompileException(node, "Illegal cast to " + yType2);
        }
        if (yType2.type == 13 && (javaType.access & 0x200) != 0) {
            return;
        }
        try {
            if (javaType2.isAssignable(javaType) < 0 && (yType.type != 13 || javaType.isAssignable(javaType2) < 0)) {
                throw new CompileException(node, "Illegal cast from " + yType + " to " + yType2);
            }
        }
        catch (JavaClassNotFoundException javaClassNotFoundException) {
            throw new CompileException(node, javaClassNotFoundException);
        }
    }

    private JavaType(String string2) {
        this.description = string2.intern();
    }

    static JavaType createNewClass(String string2, JavaClass javaClass) {
        JavaType javaType = new JavaType('L' + string2 + ';');
        javaType.implementation = javaClass;
        return javaType;
    }

    boolean isCollection() {
        return this.description == "Ljava/util/List;" || this.description == "Ljava/util/Collection;" || this.description == "Ljava/util/Set;";
    }

    String className() {
        if (!this.description.startsWith("L")) {
            throw new RuntimeException("No className for " + this.description);
        }
        return this.description.substring(1, this.description.length() - 1);
    }

    String dottedName() {
        return this.className().replace('/', '.');
    }

    private static void putMethods(Map map3, Method[] methodArray) {
        int n = methodArray.length;
        while (--n >= 0) {
            Method method = methodArray[n];
            map3.put(method.sig, method);
        }
    }

    private static void putMethods(Map map3, List list2) {
        int n = list2.size();
        while (--n >= 0) {
            Method method = (Method)list2.get(n);
            map3.put(method.sig, method);
        }
    }

    private static Method[] methodArray(Collection collection) {
        return collection.toArray(new Method[collection.size()]);
    }

    private synchronized void resolve() throws JavaClassNotFoundException {
        if (this.resolved) {
            return;
        }
        if (!this.description.startsWith("L")) {
            this.resolved = true;
            return;
        }
        JavaTypeReader javaTypeReader = ((Compiler)Compiler.currentCompiler.get()).classPath.readClass(this.className());
        if (javaTypeReader == null) {
            throw new JavaClassNotFoundException(this.dottedName());
        }
        this.resolve(javaTypeReader);
    }

    void resolve(JavaTypeReader javaTypeReader) throws JavaClassNotFoundException {
        Cloneable cloneable;
        this.access = javaTypeReader.access;
        this.interfaces = new HashMap();
        if (javaTypeReader.interfaces != null) {
            int n = javaTypeReader.interfaces.length;
            while (--n >= 0) {
                cloneable = JavaType.fromDescription('L' + javaTypeReader.interfaces[n] + ';');
                super.resolve();
                this.interfaces.putAll(((JavaType)cloneable).interfaces);
                this.interfaces.put(((JavaType)cloneable).description, cloneable);
            }
        }
        this.fields = new HashMap();
        this.staticFields = new HashMap();
        HashMap hashMap = new HashMap();
        cloneable = new HashMap();
        if (javaTypeReader.parent != null) {
            this.parent = javaTypeReader.parent;
            this.parent.resolve();
        }
        Iterator iterator = this.interfaces.values().iterator();
        while (iterator.hasNext()) {
            JavaType javaType = (JavaType)iterator.next();
            this.staticFields.putAll(javaType.staticFields);
            JavaType.putMethods(hashMap, javaType.methods);
        }
        if (this.parent != null) {
            this.interfaces.putAll(this.parent.interfaces);
            this.fields.putAll(this.parent.fields);
            this.staticFields.putAll(this.parent.staticFields);
            JavaType.putMethods(hashMap, this.parent.methods);
            JavaType.putMethods((Map)((Object)cloneable), this.parent.staticMethods);
        }
        this.fields.putAll(javaTypeReader.fields);
        this.staticFields.putAll(javaTypeReader.staticFields);
        JavaType.putMethods(hashMap, javaTypeReader.methods);
        JavaType.putMethods((Map)((Object)cloneable), javaTypeReader.staticMethods);
        this.constructors = JavaType.methodArray(javaTypeReader.constructors);
        this.methods = JavaType.methodArray(hashMap.values());
        this.staticMethods = JavaType.methodArray(((HashMap)cloneable).values());
        this.resolved = true;
    }

    void checkAbstract() {
        if ((this.access & 0x400) != 0) {
            return;
        }
        int n = this.methods.length;
        while (--n >= 0) {
            if ((this.methods[n].access & 0x400) == 0) continue;
            this.access |= 0x400;
            return;
        }
    }

    int isAssignable(JavaType javaType) throws JavaClassNotFoundException {
        javaType.resolve();
        if (this == javaType) {
            return 0;
        }
        if (javaType.description.length() == 1) {
            return -1;
        }
        if (javaType.interfaces.containsKey(this.description)) {
            return 1;
        }
        javaType = javaType.parent;
        int n = 1;
        while (javaType != null) {
            if (this == javaType) {
                return n;
            }
            javaType.resolve();
            javaType = javaType.parent;
            ++n;
        }
        return -1;
    }

    private int isAssignableJT(YType yType, YType yType2, boolean bl) throws JavaClassNotFoundException, TypeException {
        if (yType2.type != 13 && this.description == "Ljava/lang/Object;") {
            return yType2.type == 0 ? 1 : 10;
        }
        switch (yType2.type) {
            case 2: {
                return "Ljava/lang/String;" == this.description ? 0 : ("Ljava/lang/CharSequence;" == this.description ? 1 : ("Ljava/lang/StringBuffer;" == this.description || "Ljava/lang/StringBuilder;" == this.description ? 2 : ("C" == this.description ? 3 : -1)));
            }
            case 3: {
                if (this.description == "D" || this.description == "Ljava/lang/Double;") {
                    return 3;
                }
                if (this.description.length() == 1) {
                    return "BFIJS".indexOf(this.description.charAt(0)) < 0 ? -1 : 4;
                }
                int n = NUMBER_TYPES.length;
                while (--n >= 0) {
                    if (NUMBER_TYPES[n] != this.description) continue;
                    return 4;
                }
                return this.description == "Ljava/lang/Number;" ? 1 : (this.description == "Lyeti/lang/Num;" ? 0 : -1);
            }
            case 4: {
                return this.description == "Z" || this.description == "Ljava/lang/Boolean;" ? 0 : -1;
            }
            case 9: {
                return this.description == "Lyeti/lang/Fun;" ? 0 : -1;
            }
            case 10: {
                int n;
                switch (yType2.param[2].deref().type) {
                    case 8: {
                        return "Ljava/util/Map;" == this.description && (yType.param.length == 0 || JavaType.isAssignable(yType.param[1], yType2.param[0], bl) == 0 && JavaType.isAssignable(yType2.param[1], yType.param[0], bl) >= 0) ? 0 : -1;
                    }
                    case 7: {
                        if ("Ljava/util/List;" == this.description || "Ljava/util/Collection;" == this.description || "Ljava/util/Set;" == this.description || "Lyeti/lang/AList;" == this.description || "Lyeti/lang/AIter;" == this.description) break;
                    }
                    default: {
                        return -1;
                    }
                }
                return yType.param.length == 0 || (n = JavaType.isAssignable(yType.param[0], yType2.param[0], bl)) == 0 || n > 0 && yType2.param[1].type == 6 ? 1 : -1;
            }
            case 11: {
                return this.description == "Lyeti/lang/Struct;" ? 0 : -1;
            }
            case 12: {
                return this.description == "Lyeti/lang/Tag;" ? 0 : -1;
            }
            case 13: {
                return this.isAssignable(yType2.javaType);
            }
            case 14: {
                return !("Ljava/util/Collection;" != this.description && "Ljava/util/List;" != this.description || yType.param.length != 0 && JavaType.isAssignable(yType.param[0], yType2.param[0], bl) != 0) ? 1 : -1;
            }
            case 0: {
                if (!bl) break;
                for (int i = 0; i < this.TRY_SMART.length; ++i) {
                    int n = this.isAssignableJT(yType, this.TRY_SMART[i], false);
                    if (n < 0) continue;
                    YetiType.unify(yType2, this.TRY_SMART[i]);
                    return n;
                }
                YetiType.unify(yType2, yType);
                return 1;
            }
        }
        return this.description == "Ljava/lang/Object;" ? 10 : -1;
    }

    private static int isAssignable(YType yType, YType yType2, boolean bl) throws JavaClassNotFoundException, TypeException {
        yType = yType.deref();
        yType2 = yType2.deref();
        if (yType.type == 13) {
            return yType.javaType.isAssignableJT(yType, yType2, bl);
        }
        if (yType.type == 14) {
            YType yType3 = yType.param[0];
            switch (yType2.type) {
                case 2: {
                    return yType3.type == 13 && yType3.javaType.description == "C" ? 1 : -1;
                }
                case 10: {
                    int n;
                    return yType2.param[2].type == 7 && (n = JavaType.isAssignable(yType.param[0], yType2.param[0], bl)) >= 0 ? 1 : -1;
                }
                case 14: {
                    return JavaType.isAssignable(yType.param[0], yType2.param[0], bl);
                }
            }
        }
        if (yType.type == 2 && yType2.type == 13 && yType2.javaType.description == "Ljava/lang/String;") {
            return 0;
        }
        return -1;
    }

    static int isAssignable(YetiParser.Node node, YType yType, YType yType2, boolean bl) {
        yType2 = yType2.deref();
        if (bl && yType2.type == 1) {
            return 0;
        }
        try {
            return JavaType.isAssignable(yType, yType2, bl);
        }
        catch (JavaClassNotFoundException javaClassNotFoundException) {
            throw new CompileException(node, javaClassNotFoundException);
        }
        catch (TypeException typeException) {
            throw new CompileException(node, typeException.getMessage());
        }
    }

    static boolean isSafeCast(Scope scope, YetiParser.Node node, YType yType, YType yType2, boolean bl) {
        yType = yType.deref();
        yType2 = yType2.deref();
        if (yType2.type == 14 && yType.type == 10) {
            YType yType3 = yType.param[2].deref();
            if (yType3.type == 7 || yType3.type == 0) {
                YType yType4 = yType2.param[0].deref();
                YType yType5 = yType.param[0].deref();
                try {
                    if (yType4.javaType != null && yType4.javaType.description.length() == 1) {
                        char c2 = yType4.javaType.description.charAt(0);
                        YetiType.unify(yType.param[1], YetiType.NO_TYPE);
                        YetiType.unify(yType.param[0], c2 == 'Z' ? YetiType.BOOL_TYPE : (c2 == 'C' ? YetiType.STR_TYPE : YetiType.NUM_TYPE));
                    } else if (yType5.type == 0) {
                        if (yType4 != yType5) {
                            YetiType.unifyToVar(yType5, yType4);
                        }
                    } else if (JavaType.isAssignable(node, yType5, yType4, false) < 0) {
                        return false;
                    }
                }
                catch (TypeException typeException) {
                    return false;
                }
                yType3.type = 7;
                yType3.param = YetiType.NO_PARAM;
                YType yType6 = yType.param[1].deref();
                if (yType6.type == 0) {
                    yType6.type = yType5.type == 2 ? 6 : 3;
                    yType6.param = YetiType.NO_PARAM;
                }
                if (yType6.type == 3 && yType5.type == 2) {
                    scope.ctx.compiler.warn(new CompileException(node, "Cast `as array<string>' is dangerous and deprecated.\n    Please use either `as list<string>' or `as array<~String>'"));
                }
                return true;
            }
        }
        if (yType.type == 13 && yType.javaType.description.length() == 1) {
            return false;
        }
        if (bl) {
            return JavaType.isAssignable(node, yType, yType2, true) >= 0;
        }
        boolean bl2 = true;
        boolean bl3 = false;
        while (yType2.type == 10 && yType2.param[2].type == 7 && (yType.type == 10 && yType2.param[1].type == 6 && yType.param[2].type == 7 && yType.param[1].type != 3 || yType.type == 14)) {
            if (yType.type == 14) {
                bl3 = true;
            }
            yType2 = yType2.param[0].deref();
            yType = yType.param[0].deref();
            bl2 = false;
        }
        if (yType.type == 2 && bl2 && yType2.type == 13 && yType2.javaType.description == "Ljava/lang/String;") {
            return true;
        }
        if (yType2.type != 13) {
            return false;
        }
        try {
            return yType.type == 13 && (yType.javaType != yType2.javaType || bl3) && (bl2 ? JavaType.isAssignable(node, yType, yType2, true) : yType.javaType.isAssignable(yType2.javaType)) >= 0;
        }
        catch (JavaClassNotFoundException javaClassNotFoundException) {
            throw new CompileException(node, javaClassNotFoundException);
        }
    }

    private Method resolveByArgs(YetiParser.Node node, Method[] methodArray, String string2, Code[] codeArray, YType yType) {
        int n;
        int n2;
        string2 = string2.intern();
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        int[] nArray = new int[methodArray.length];
        int n5 = 0;
        boolean bl = methodArray.length;
        while ((bl -= 1) >= false) {
            Method method = methodArray[bl];
            if (method.name != string2 || method.arguments.length != codeArray.length) continue;
            nArray[n5++] = bl;
        }
        boolean bl2 = bl = n5 == 1;
        block1: while (--n5 >= 0) {
            int n6 = nArray[n5];
            Method method = methodArray[n6];
            n2 = 0;
            for (int i = 0; i < codeArray.length; ++i) {
                int n7 = JavaType.isAssignable(node, method.arguments[i], codeArray[i].type, bl);
                if (n7 < 0) continue block1;
                if (n7 == 0) continue;
                n2 += n7 + 1;
            }
            if (method.returnType.javaType != null && (method.returnType.javaType.resolve((YetiParser.Node)node).access & 1) == 0) {
                n2 += 10;
            }
            if (n2 == 0) {
                n4 = n6;
                break;
            }
            if (n2 >= n3) continue;
            n4 = n6;
            n3 = n2;
        }
        if (n4 != -1) {
            return methodArray[n4].dup(methodArray, n4, yType);
        }
        StringBuffer stringBuffer = new StringBuffer("No suitable method ").append(string2).append('(');
        for (n = 0; n < codeArray.length; ++n) {
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(codeArray[n].type);
        }
        stringBuffer.append(") found in ").append(this.dottedName());
        n = 1;
        n2 = methodArray.length;
        while (--n2 >= 0) {
            if (methodArray[n2].name != string2) continue;
            if (n != 0) {
                stringBuffer.append("\nMethods named ").append(string2).append(':');
                n = 0;
            }
            stringBuffer.append("\n    ").append(methodArray[n2]);
        }
        throw new CompileException(node, stringBuffer.toString());
    }

    JavaType resolve(YetiParser.Node node) {
        try {
            this.resolve();
        }
        catch (JavaClassNotFoundException javaClassNotFoundException) {
            throw new CompileException(node, javaClassNotFoundException);
        }
        return this;
    }

    private static JavaType javaTypeOf(YetiParser.Node node, YType yType, String string2) {
        if (yType.type != 13) {
            throw new CompileException(node, string2 + yType + ", java object expected");
        }
        return yType.javaType.resolve(node);
    }

    static Method resolveConstructor(YetiParser.Node node, YType yType, Code[] codeArray, boolean bl) {
        JavaType javaType = yType.javaType.resolve(node);
        if ((javaType.access & 0x200) != 0) {
            throw new CompileException(node, "Cannot instantiate interface " + javaType.dottedName());
        }
        if (bl && (javaType.access & 0x400) != 0) {
            StringBuffer stringBuffer = new StringBuffer("Cannot construct abstract class ");
            stringBuffer.append(javaType.dottedName());
            int n = 0;
            for (int i = 0; i < javaType.methods.length; ++i) {
                if ((javaType.methods[i].access & 0x400) == 0) continue;
                if (++n == 1) {
                    stringBuffer.append("\nAbstract methods found in ");
                    stringBuffer.append(javaType.dottedName());
                    stringBuffer.append(':');
                } else if (n > 2) {
                    stringBuffer.append("\n    ...");
                    break;
                }
                stringBuffer.append("\n    ");
                stringBuffer.append(javaType.methods[i]);
            }
            throw new CompileException(node, stringBuffer.toString());
        }
        return javaType.resolveByArgs(node, javaType.constructors, "<init>", codeArray, yType);
    }

    static Method resolveMethod(YetiParser.ObjectRefOp objectRefOp, YType yType, Code[] codeArray, boolean bl) {
        yType = yType.deref();
        JavaType javaType = JavaType.javaTypeOf(objectRefOp, yType, "Cannot call method on ");
        return javaType.resolveByArgs(objectRefOp, bl ? javaType.staticMethods : javaType.methods, objectRefOp.name, codeArray, yType);
    }

    static Field resolveField(YetiParser.ObjectRefOp objectRefOp, YType yType, boolean bl) {
        yType = yType.deref();
        JavaType javaType = JavaType.javaTypeOf(objectRefOp, yType, "Cannot access field on ");
        Map map3 = bl ? javaType.staticFields : javaType.fields;
        Field field = (Field)map3.get(objectRefOp.name);
        if (field == null) {
            throw new CompileException((YetiParser.Node)objectRefOp, (bl ? "Static field " : "Field ") + objectRefOp.name + " not found in " + javaType.dottedName());
        }
        if (field.classType != yType) {
            if (!field.className.equals(yType.javaType.className())) {
                field = new Field(field.name, field.access, field.className, field.type);
                map3.put(field.name, field);
            }
            field.classType = yType;
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JavaType fromDescription(String string2) {
        HashMap hashMap = CACHE;
        synchronized (hashMap) {
            JavaType javaType = (JavaType)CACHE.get(string2);
            if (javaType == null) {
                javaType = new JavaType(string2);
                CACHE.put(string2, javaType);
            }
            return javaType;
        }
    }

    JavaType dup() {
        if (!this.resolved) {
            throw new IllegalStateException("Cannot clone unresolved class");
        }
        try {
            return (JavaType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static YType typeOfClass(String string2, String string3) {
        if (string2 != null && string2.length() != 0) {
            string3 = string2 + '/' + string3;
        }
        return new YType("L" + string3 + ';');
    }

    public String str() {
        switch (this.description.charAt(0)) {
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'V': {
                return "void";
            }
            case 'L': {
                return "~".concat(this.dottedName());
            }
        }
        return "~".concat(this.description);
    }

    static String packageOfClass(String string2) {
        if (string2 == null || string2.length() == 0) {
            return "";
        }
        int n = string2.lastIndexOf(47);
        return n < 0 ? "" : string2.substring(0, n);
    }

    private static List parentList(JavaType javaType) {
        ArrayList<JavaType> arrayList = new ArrayList<JavaType>();
        while (javaType != null) {
            arrayList.add(javaType);
            javaType = javaType.parent;
        }
        return arrayList;
    }

    static YType mergeTypes(YType yType, YType yType2) {
        yType = yType.deref();
        yType2 = yType2.deref();
        if (yType.type != 13 || yType2.type != 13) {
            YType yType3;
            if (yType.type == 10 && yType2.type == 10 && yType.param[1].type == 6 && yType.param[2].type == 7 && yType2.param[1].type == 6 && yType2.param[2].type == 7 && (yType3 = JavaType.mergeTypes(yType.param[0], yType2.param[0])) != null) {
                return new YType(10, new YType[]{yType3, YetiType.NO_TYPE, YetiType.LIST_TYPE});
            }
            if (yType.type == 1 && (yType2.type == 13 && yType2.javaType.description.length() != 1 || yType2.type == 14)) {
                return yType2;
            }
            if (yType2.type == 1 && (yType.type == 13 && yType.javaType.description.length() != 1 || yType.type == 14)) {
                return yType;
            }
            return null;
        }
        if (yType.javaType == yType2.javaType) {
            return yType;
        }
        List list2 = JavaType.parentList(yType.javaType);
        List list3 = JavaType.parentList(yType2.javaType);
        JavaType javaType = null;
        int n = list2.size();
        int n2 = list3.size();
        while (--n >= 0 && --n2 >= 0 && list2.get(n) == list3.get(n2)) {
            javaType = (JavaType)list2.get(n);
        }
        if (javaType == null) {
            return null;
        }
        JavaType javaType2 = yType.javaType;
        JavaType javaType3 = yType2.javaType;
        if (javaType.description == "Ljava/lang/Object;") {
            int n3 = -1;
            if (javaType3.interfaces.containsKey(javaType2.description)) {
                return yType;
            }
            if (javaType2.interfaces.containsKey(javaType3.description)) {
                return yType2;
            }
            HashMap hashMap = javaType3.interfaces;
            Iterator iterator = javaType2.interfaces.keySet().iterator();
            while (iterator.hasNext()) {
                Object v2 = hashMap.get(iterator.next());
                if (v2 == null) continue;
                JavaType javaType4 = (JavaType)v2;
                int n4 = javaType4.methods.length;
                if (n4 <= n3) continue;
                javaType = javaType4;
            }
        }
        YType yType4 = new YType(13, YetiType.NO_PARAM);
        yType4.javaType = javaType;
        return yType4;
    }

    static YType typeOfName(String string2, Scope scope) {
        YType yType;
        int n = 0;
        while (string2.endsWith("[]")) {
            ++n;
            string2 = string2.substring(0, string2.length() - 2);
        }
        String string3 = (String)JAVA_PRIM.get(string2);
        YType yType2 = string3 != null ? new YType(string3) : (yType = YetiType.resolveFullClass(n == 0 ? string2 : string2.intern(), scope));
        while (--n >= 0) {
            yType = new YType(14, new YType[]{yType});
        }
        return yType;
    }

    static {
        Map map3 = JAVA_PRIM;
        map3.put("int", "I");
        map3.put("long", "J");
        map3.put("boolean", "Z");
        map3.put("byte", "B");
        map3.put("char", "C");
        map3.put("double", "D");
        map3.put("float", "F");
        map3.put("short", "S");
        map3.put("number", "Lyeti/lang/Num;");
    }

    static class Method {
        int access;
        String name;
        YType[] arguments;
        YType returnType;
        YType classType;
        String className;
        String sig;
        String descr;

        Method() {
        }

        Method dup(Method[] methodArray, int n, YType yType) {
            if (yType == this.classType || this.className.equals(yType.javaType.className())) {
                this.classType = yType;
                return this;
            }
            Method method = new Method();
            method.access = this.access;
            method.name = this.name;
            method.arguments = this.arguments;
            method.returnType = this.returnType;
            method.classType = yType;
            method.className = this.className;
            method.sig = this.sig;
            method.descr = this.descr;
            methodArray[n] = method;
            return method;
        }

        Method check(YetiParser.Node node, String string2, int n) {
            this.classType.javaType.checkPackage(node, string2);
            if ((this.access & (this.classType.javaType.publicMask | n)) == 0) {
                JavaType.checkPackage(node, string2, this.className, "method", this.name);
            }
            return this;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.returnType.type == 1 ? "void" : this.returnType.toString());
            stringBuffer.append(' ');
            stringBuffer.append(this.name);
            stringBuffer.append('(');
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.arguments[i]);
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        YType convertedReturnType() {
            return JavaType.convertValueType(this.returnType);
        }

        String argDescr(int n) {
            return JavaType.descriptionOf(this.arguments[n]);
        }

        String descr(String string2) {
            if (this.descr != null) {
                return this.descr;
            }
            StringBuffer stringBuffer = new StringBuffer("(");
            for (int i = 0; i < this.arguments.length; ++i) {
                stringBuffer.append(this.argDescr(i));
            }
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(')');
            if (this.returnType.type == 1) {
                stringBuffer.append('V');
            } else {
                stringBuffer.append(JavaType.descriptionOf(this.returnType));
            }
            this.descr = stringBuffer.toString();
            return this.descr;
        }
    }

    static class Field {
        int access;
        String name;
        YType type;
        YType classType;
        String className;
        Object constValue;

        public Field(String string2, int n, String string3, YType yType) {
            this.access = n;
            this.type = yType;
            this.name = string2;
            this.className = string3;
        }

        YType convertedType() {
            return JavaType.convertValueType(this.type);
        }

        void check(YetiParser.Node node, String string2) {
            this.classType.javaType.checkPackage(node, string2);
            if ((this.access & this.classType.javaType.publicMask) == 0) {
                JavaType.checkPackage(node, string2, this.className, "field", this.name);
            }
        }
    }
}

