/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import yeti.lang.BigNum;
import yeti.lang.Num;
import yeti.lang.RatNum;

public final class IntNum
extends Num {
    public static final IntNum __2 = new IntNum(-2);
    public static final IntNum __1 = new IntNum(-1);
    public static final IntNum _0 = new IntNum(0);
    public static final IntNum _1 = new IntNum(1);
    public static final IntNum _2 = new IntNum(2);
    public static final IntNum _3 = new IntNum(3);
    public static final IntNum _4 = new IntNum(4);
    public static final IntNum _5 = new IntNum(5);
    public static final IntNum _6 = new IntNum(6);
    public static final IntNum _7 = new IntNum(7);
    public static final IntNum _8 = new IntNum(8);
    public static final IntNum _9 = new IntNum(9);
    private final long v;

    public IntNum(int n) {
        this.v = n;
    }

    public IntNum(long l2) {
        this.v = l2;
    }

    public Num add(Num num) {
        return num.add(this.v);
    }

    public Num add(RatNum ratNum) {
        return ratNum.add(this.v);
    }

    public Num add(long l2) {
        if (l2 > 0L ? l2 > 0x3FFFFFFFFFFFFFFFL || this.v > 0x3FFFFFFFFFFFFFFFL : l2 < -4611686018427387903L || this.v < -4611686018427387903L) {
            return new BigNum(BigInteger.valueOf(this.v).add(BigInteger.valueOf(l2)));
        }
        return new IntNum(this.v + l2);
    }

    public Num add(BigInteger bigInteger) {
        return new BigNum(BigInteger.valueOf(this.v).add(bigInteger));
    }

    public Num mul(Num num) {
        return num.mul(this.v);
    }

    public Num mul(long l2) {
        if (l2 < -2147483647L || l2 > Integer.MAX_VALUE || this.v < -2147483647L || this.v > Integer.MAX_VALUE) {
            return new BigNum(BigInteger.valueOf(this.v).multiply(BigInteger.valueOf(l2)));
        }
        return new IntNum(this.v * l2);
    }

    public Num mul(BigInteger bigInteger) {
        return new BigNum(BigInteger.valueOf(this.v).multiply(bigInteger));
    }

    public Num mul(RatNum ratNum) {
        return ratNum.mul(this.v);
    }

    public Num div(Num num) {
        return num.divFrom(this.v);
    }

    public Num div(long l2) {
        return RatNum.div(this.v, l2);
    }

    public Num divFrom(long l2) {
        return RatNum.div(l2, this.v);
    }

    public Num divFrom(RatNum ratNum) {
        return ratNum.div(this.v);
    }

    public Num intDiv(Num num) {
        return num.intDivFrom(this.v);
    }

    public Num intDiv(int n) {
        return new IntNum(this.v / (long)n);
    }

    public Num intDivFrom(long l2) {
        return new IntNum(l2 / this.v);
    }

    public Num intDivFrom(BigInteger bigInteger) {
        return new BigNum(bigInteger.divide(BigInteger.valueOf(this.v)));
    }

    public Num rem(Num num) {
        return num.remFrom(this.v);
    }

    public Num rem(int n) {
        return new IntNum(this.v % (long)n);
    }

    public Num remFrom(long l2) {
        return new IntNum(l2 % this.v);
    }

    public Num remFrom(BigInteger bigInteger) {
        return new BigNum(bigInteger.remainder(BigInteger.valueOf(this.v)));
    }

    public Num sub(Num num) {
        return num.subFrom(this.v);
    }

    public Num sub(long l2) {
        if (l2 < 0L ? l2 < -4611686018427387903L || this.v > 0x3FFFFFFFFFFFFFFFL : l2 > 0x3FFFFFFFFFFFFFFFL || this.v < -4611686018427387903L) {
            return new BigNum(BigInteger.valueOf(this.v).subtract(BigInteger.valueOf(l2)));
        }
        return new IntNum(this.v - l2);
    }

    public Num subFrom(long l2) {
        if (l2 < 0L ? l2 < -4611686018427387903L || this.v > 0x3FFFFFFFFFFFFFFFL : l2 > 0x3FFFFFFFFFFFFFFFL || this.v < -4611686018427387903L) {
            return new BigNum(BigInteger.valueOf(l2).subtract(BigInteger.valueOf(this.v)));
        }
        return new IntNum(l2 - this.v);
    }

    public Num subFrom(RatNum ratNum) {
        return ratNum.sub(this.v);
    }

    public Num subFrom(BigInteger bigInteger) {
        return new BigNum(bigInteger.subtract(BigInteger.valueOf(this.v)));
    }

    public Num and(Num num) {
        return new IntNum(num.longValue() & this.v);
    }

    public Num and(BigInteger bigInteger) {
        return new IntNum(bigInteger.longValue() & this.v);
    }

    public Num or(Num num) {
        return num.or(this.v);
    }

    public Num or(long l2) {
        return new IntNum(l2 | this.v);
    }

    public Num xor(Num num) {
        return num.xor(this.v);
    }

    public Num xor(long l2) {
        return new IntNum(l2 ^ this.v);
    }

    public byte byteValue() {
        return (byte)this.v;
    }

    public short shortValue() {
        return (short)this.v;
    }

    public int intValue() {
        return (int)this.v;
    }

    public long longValue() {
        return this.v;
    }

    public float floatValue() {
        return this.v;
    }

    public double doubleValue() {
        return this.v;
    }

    public int compareTo(Object object) {
        return ((Num)object).rCompare(this.v);
    }

    public int rCompare(long l2) {
        return this.v < l2 ? 1 : (this.v > l2 ? -1 : 0);
    }

    public int rCompare(RatNum ratNum) {
        return -ratNum.rCompare(this.v);
    }

    public int rCompare(BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.valueOf(this.v));
    }

    public BigDecimal toBigDecimal() {
        return BigDecimal.valueOf(this.v);
    }

    public String toString() {
        return Long.toString(this.v);
    }

    public int hashCode() {
        return (int)(this.v ^ this.v >>> 32);
    }
}

