/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.util.AbstractMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import yeti.lang.AIter;
import yeti.lang.AList;
import yeti.lang.ByKey;
import yeti.lang.Coll;
import yeti.lang.Fun;
import yeti.lang.MList;
import yeti.lang.NoSuchKeyException;

public class CHash
extends AbstractMap
implements ByKey,
Coll {
    static final int IDENTITY = 1;
    static final int CONCURRENT = 2;
    static final int WEAK = 3;
    private final int type;
    private final Fun cons;
    private final Map impl;
    private volatile Fun defaultFun;

    public CHash(int n, Fun fun) {
        this.type = n;
        this.cons = fun;
        switch (this.type) {
            case 0: {
                this.impl = (Map)fun.apply(null);
                break;
            }
            case 1: {
                this.impl = new IdentityHashMap();
                break;
            }
            case 2: {
                this.impl = new ConcurrentHashMap();
                break;
            }
            case 3: {
                this.impl = new WeakHashMap();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid CHash type " + n);
            }
        }
    }

    public void clear() {
        this.impl.clear();
    }

    public Set keySet() {
        return this.impl.keySet();
    }

    public Set entrySet() {
        return this.impl.entrySet();
    }

    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.impl.containsKey(object);
    }

    public Object get(Object object) {
        return this.impl.get(object);
    }

    public Object put(Object object, Object object2) {
        return this.impl.put(object, object2);
    }

    public void putAll(Map map3) {
        this.impl.putAll(map3);
    }

    public Object remove(Object object) {
        return this.impl.remove(object);
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public boolean equals(Object object) {
        return this.impl.equals(object);
    }

    public Object vget(Object object) {
        Object v2 = this.impl.get(object);
        if (v2 == null && !this.impl.containsKey(object)) {
            if (this.defaultFun != null) {
                return this.defaultFun.apply(object);
            }
            throw new NoSuchKeyException("Key not found (" + object + ")");
        }
        return v2;
    }

    public void removeAll(AList aList) {
        if (aList != null && !aList.isEmpty()) {
            for (AIter aIter = aList; aIter != null; aIter = aIter.next()) {
                this.impl.remove(aIter.first());
            }
        }
    }

    public int size() {
        return this.impl.size();
    }

    public long length() {
        return this.impl.size();
    }

    public AList asList() {
        return new MList(this.impl.values().toArray());
    }

    public void setDefault(Fun fun) {
        this.defaultFun = fun;
    }

    public Object copy() {
        CHash cHash = new CHash(this.type, this.cons);
        cHash.putAll((Map)this);
        cHash.defaultFun = this.defaultFun;
        return cHash;
    }
}

