/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.io.IOException;
import java.io.InputStream;
import yeti.lang.compiler.CompileException;
import yeti.lang.compiler.Compiler;
import yeti.lang.compiler.ModuleType;
import yeti.lang.compiler.TypeAttr;
import yeti.lang.compiler.YetiParser;
import yeti.renamed.asm3.AnnotationVisitor;
import yeti.renamed.asm3.Attribute;
import yeti.renamed.asm3.ClassReader;
import yeti.renamed.asm3.ClassVisitor;
import yeti.renamed.asm3.FieldVisitor;
import yeti.renamed.asm3.MethodVisitor;

class YetiTypeVisitor
implements ClassVisitor {
    TypeAttr typeAttr;
    private boolean deprecated;

    YetiTypeVisitor() {
    }

    public void visit(int n, int n2, String string2, String string3, String string4, String[] stringArray) {
        this.deprecated = (n2 & 0x20000) != 0;
    }

    public void visitEnd() {
    }

    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        return null;
    }

    public void visitAttribute(Attribute attribute) {
        if (attribute.type == "YetiModuleType") {
            if (this.typeAttr != null) {
                throw new RuntimeException("Multiple YetiModuleType attributes are forbidden");
            }
            this.typeAttr = (TypeAttr)attribute;
        }
    }

    public FieldVisitor visitField(int n, String string2, String string3, String string4, Object object) {
        return null;
    }

    public void visitInnerClass(String string2, String string3, String string4, int n) {
    }

    public MethodVisitor visitMethod(int n, String string2, String string3, String string4, String[] stringArray) {
        return null;
    }

    public void visitOuterClass(String string2, String string3, String string4) {
    }

    public void visitSource(String string2, String string3) {
    }

    static ModuleType readType(Compiler compiler, InputStream inputStream) throws IOException {
        YetiTypeVisitor yetiTypeVisitor = new YetiTypeVisitor();
        ClassReader classReader = new ClassReader(inputStream);
        classReader.accept(yetiTypeVisitor, new Attribute[]{new TypeAttr(null, compiler)}, 5);
        inputStream.close();
        if (yetiTypeVisitor.typeAttr == null) {
            return null;
        }
        ModuleType moduleType = yetiTypeVisitor.typeAttr.moduleType;
        if (moduleType != null) {
            moduleType.deprecated = yetiTypeVisitor.deprecated;
        }
        moduleType.name = classReader.getClassName();
        moduleType.fromClass = true;
        return moduleType;
    }

    static ModuleType getType(Compiler compiler, YetiParser.Node node, String string2, boolean bl) {
        String string3 = string2.toLowerCase();
        ModuleType moduleType = (ModuleType)compiler.types.get(string3);
        if (moduleType != null) {
            return moduleType;
        }
        try {
            int n;
            int n2 = n = bl ? 512 : 1;
            if (node == null && !bl) {
                moduleType = compiler.moduleType(string3);
                if (moduleType != null) {
                    return moduleType;
                }
                n |= 0x400;
            }
            if ((moduleType = (ModuleType)compiler.types.get(compiler.compile((String)string2, null, (int)(n | 0x80)).name)) == null) {
                throw new CompileException(node, "Could not compile `" + string2 + "' to a module");
            }
            if (!bl && !string3.equals(moduleType.name)) {
                throw new CompileException(node, "Found " + moduleType.name.replace('/', '.') + " instead of " + string2.replace('/', '.'));
            }
            if (!moduleType.directFields) {
                compiler.warn(new CompileException(node, "The `" + moduleType.name.replace('/', '.') + "' module is compiled " + "with pre-0.9.8 version\n    of Yeti compiler and " + "might not work with newer standard library."));
            }
            return moduleType;
        }
        catch (CompileException compileException) {
            if (compileException.line == 0 && node != null) {
                compileException.line = node.line;
                compileException.col = node.col;
            }
            throw compileException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CompileException(node, exception.getMessage());
        }
    }
}

