/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import yeti.lang.FloatNum;
import yeti.lang.IntNum;
import yeti.lang.compiler.AListPattern;
import yeti.lang.compiler.Apply;
import yeti.lang.compiler.BindExpr;
import yeti.lang.compiler.BindPattern;
import yeti.lang.compiler.BindRef;
import yeti.lang.compiler.Binder;
import yeti.lang.compiler.BuiltIn;
import yeti.lang.compiler.CaseExpr;
import yeti.lang.compiler.CasePattern;
import yeti.lang.compiler.Cast;
import yeti.lang.compiler.ClassField;
import yeti.lang.compiler.ClassOfExpr;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.CompileException;
import yeti.lang.compiler.Compiler;
import yeti.lang.compiler.ConcatStrings;
import yeti.lang.compiler.ConditionalExpr;
import yeti.lang.compiler.ConsPattern;
import yeti.lang.compiler.ConstPattern;
import yeti.lang.compiler.EvalBind;
import yeti.lang.compiler.Function;
import yeti.lang.compiler.InstanceOfExpr;
import yeti.lang.compiler.JavaArrayRef;
import yeti.lang.compiler.JavaType;
import yeti.lang.compiler.KeyRefExpr;
import yeti.lang.compiler.ListConstructor;
import yeti.lang.compiler.ListPattern;
import yeti.lang.compiler.LoadModule;
import yeti.lang.compiler.LoopExpr;
import yeti.lang.compiler.MapConstructor;
import yeti.lang.compiler.MethodCall;
import yeti.lang.compiler.MethodDesc;
import yeti.lang.compiler.ModuleType;
import yeti.lang.compiler.NewArrayExpr;
import yeti.lang.compiler.NewExpr;
import yeti.lang.compiler.NumericConstant;
import yeti.lang.compiler.Range;
import yeti.lang.compiler.RootClosure;
import yeti.lang.compiler.Scope;
import yeti.lang.compiler.SelectMember;
import yeti.lang.compiler.SelectMemberFun;
import yeti.lang.compiler.SeqExpr;
import yeti.lang.compiler.StaticRef;
import yeti.lang.compiler.StringConstant;
import yeti.lang.compiler.StructConstructor;
import yeti.lang.compiler.StructField;
import yeti.lang.compiler.StructPattern;
import yeti.lang.compiler.TryCatch;
import yeti.lang.compiler.TypeException;
import yeti.lang.compiler.TypeScope;
import yeti.lang.compiler.UnitConstant;
import yeti.lang.compiler.VariantConstructor;
import yeti.lang.compiler.VariantPattern;
import yeti.lang.compiler.WithStruct;
import yeti.lang.compiler.YType;
import yeti.lang.compiler.YetiEval;
import yeti.lang.compiler.YetiParser;
import yeti.lang.compiler.YetiType;
import yeti.lang.compiler.YetiTypeVisitor;

public final class YetiAnalyzer
extends YetiType {
    static final String NONSENSE_STRUCT = "No sense in empty struct";
    static final Object[][] PRIMITIVE_TYPE_MAPPING = new Object[][]{{"()", UNIT_TYPE}, {"boolean", BOOL_TYPE}, {"char", CHAR_TYPE}, {"number", NUM_TYPE}, {"string", STR_TYPE}};
    int flags;
    String canonicalFile;
    String sourceName;
    String sourceFile;
    String sourceDir;
    long targetTime;
    File targetFile;
    Compiler compiler;
    String[] preload;
    long depsModifiedTime;
    long sourceTime;
    String topDoc;
    ModuleType resolvedType;

    static void unusedBinding(Scope scope, YetiParser.Bind bind) {
        scope.ctx.compiler.warn(new CompileException((YetiParser.Node)bind, "Unused binding: " + bind.name));
    }

    /*
     * Enabled aggressive block sorting
     */
    static YetiParser.XNode shortLambda(YetiParser.BinOp binOp) {
        YetiParser.Sym sym;
        if (binOp.right.kind == "case-of") {
            YetiParser.Node[] nodeArray = ((YetiParser.XNode)binOp.right).expr;
            if (((YetiParser.XNode)binOp.right).expr[0].kind == "()" && ((YetiParser.XNode)nodeArray[0]).expr != null) {
                sym = new YetiParser.Sym(String.valueOf(nodeArray.hashCode()));
                nodeArray[0] = sym;
                return YetiParser.XNode.lambda(sym.pos(binOp.line, binOp.col), binOp.right, null);
            }
        }
        sym = new YetiParser.Sym("_");
        return YetiParser.XNode.lambda(sym.pos(binOp.line, binOp.col), binOp.right, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static YetiParser.XNode asLambda(YetiParser.Node node) {
        YetiParser.XNode xNode;
        if (node.kind == "lambda") {
            xNode = (YetiParser.XNode)node;
            return xNode;
        } else {
            if (!(node instanceof YetiParser.BinOp)) return null;
            YetiParser.BinOp binOp = (YetiParser.BinOp)node;
            if (binOp.op != "\\") return null;
            xNode = YetiAnalyzer.shortLambda(binOp);
        }
        return xNode;
    }

    static Code analyze(YetiParser.Node node, Scope scope, int n) {
        if (node instanceof YetiParser.Sym) {
            String string2 = ((YetiParser.Sym)node).sym;
            if (Character.isUpperCase(string2.charAt(0))) {
                return YetiAnalyzer.variantConstructor(string2, n);
            }
            return YetiAnalyzer.resolve(string2, node, scope, n);
        }
        if (node instanceof YetiParser.NumLit) {
            return new NumericConstant(((YetiParser.NumLit)node).num);
        }
        if (node instanceof YetiParser.Str) {
            return new StringConstant(((YetiParser.Str)node).str);
        }
        if (node instanceof YetiParser.Seq) {
            return YetiAnalyzer.analSeq((YetiParser.Seq)node, scope, n);
        }
        if (node instanceof YetiParser.Bind) {
            YetiParser.Bind bind = (YetiParser.Bind)node;
            Function function = YetiAnalyzer.singleBind(bind, scope, n);
            BindExpr bindExpr = (BindExpr)function.selfBind;
            if (bindExpr.refs == null) {
                YetiAnalyzer.unusedBinding(scope, bind);
            }
            bindExpr.genBind(null);
            return function;
        }
        String string3 = node.kind;
        if (string3 != null) {
            if (string3 == "listop") {
                YetiParser.ObjectRefOp objectRefOp = (YetiParser.ObjectRefOp)node;
                if (objectRefOp.right == null) {
                    return YetiAnalyzer.list(objectRefOp, objectRefOp.arguments, scope, n);
                }
                return YetiAnalyzer.keyRefExpr(YetiAnalyzer.analyze(objectRefOp.right, scope, n), objectRefOp, scope, n);
            }
            YetiParser.XNode xNode = (YetiParser.XNode)node;
            if (string3 == "()") {
                return new UnitConstant(null);
            }
            if (string3 == "list") {
                return YetiAnalyzer.list(xNode, xNode.expr, scope, n);
            }
            if (string3 == "lambda") {
                return YetiAnalyzer.lambda(new Function(null), xNode, scope, n);
            }
            if (string3 == "struct") {
                return YetiAnalyzer.structType(xNode, scope, n);
            }
            if (string3 == "if") {
                return YetiAnalyzer.cond(xNode, scope, n);
            }
            if (string3 == "_") {
                return new Cast(YetiAnalyzer.analyze(xNode.expr[0], scope, n), UNIT_TYPE, false, node.line);
            }
            if (string3 == "concat") {
                return YetiAnalyzer.concatStr(xNode, scope, n);
            }
            if (string3 == "case-of") {
                return YetiAnalyzer.caseType(xNode, scope, n);
            }
            if (string3 == "new") {
                String string4 = xNode.expr[0].sym();
                Code[] codeArray = YetiAnalyzer.mapArgs(1, xNode.expr, scope, n);
                YetiType.ClassBinding classBinding = YetiAnalyzer.resolveFullClass(string4, scope, true, xNode);
                return new NewExpr(JavaType.resolveConstructor(xNode, classBinding.type, codeArray, true).check(xNode, scope.ctx.packageName, 0), codeArray, classBinding, xNode.line);
            }
            if (string3 == "rsection") {
                return YetiAnalyzer.rsection(xNode, scope, n);
            }
            if (string3 == "try") {
                return YetiAnalyzer.tryCatch(xNode, scope, n);
            }
            if (string3 == "load") {
                String string5 = xNode.expr[0].sym();
                ModuleType moduleType = (ModuleType)xNode.expr[1];
                if (moduleType.deprecated) {
                    scope.ctx.compiler.warn(new CompileException(node, "Module " + string5.replace('/', '.') + " is deprecated"));
                }
                return new LoadModule(string5, moduleType, n);
            }
            if (string3 == "new-array") {
                return YetiAnalyzer.newArray(xNode, scope, n);
            }
            if (string3 == "classOf") {
                String string6 = xNode.expr[0].sym();
                int n2 = 0;
                while (string6.endsWith("[]")) {
                    ++n2;
                    string6 = string6.substring(0, string6.length() - 2);
                }
                if (n2 != 0) {
                    string6 = string6.intern();
                }
                YType yType = string6 != "module" ? null : YetiAnalyzer.resolveClass("module", scope, false);
                return new ClassOfExpr(yType != null ? yType.javaType : YetiAnalyzer.resolveFullClass((String)string6, (Scope)scope, (boolean)false, (YetiParser.Node)xNode).type.javaType.resolve(xNode), n2);
            }
        } else if (node instanceof YetiParser.BinOp) {
            YetiParser.BinOp binOp = (YetiParser.BinOp)node;
            String string7 = binOp.op;
            if (string7 == "") {
                return YetiAnalyzer.apply(binOp, YetiAnalyzer.analyze(binOp.left, scope, n), binOp.right, scope, n);
            }
            if (string7 == FIELD_OP) {
                if (binOp.right.kind == "listop") {
                    scope.ctx.compiler.warn(new CompileException(node, "Old-style .[] array/hash reference is deprecated (use [] instead)"));
                    return YetiAnalyzer.keyRefExpr(YetiAnalyzer.analyze(binOp.left, scope, n), (YetiParser.ObjectRefOp)binOp.right, scope, n);
                }
                return YetiAnalyzer.selectMember(binOp, YetiAnalyzer.getSelectorSym(binOp, binOp.right), YetiAnalyzer.analyze(binOp.left, scope, n), scope, n);
            }
            if (string7 == ":=") {
                return YetiAnalyzer.assignOp(binOp, scope, n);
            }
            if (string7 == "\\") {
                return YetiAnalyzer.lambda(new Function(null), YetiAnalyzer.shortLambda(binOp), scope, n);
            }
            if (string7 == "is" || string7 == "as" || string7 == "unsafely_as") {
                return YetiAnalyzer.isOp(binOp, ((YetiParser.TypeOp)binOp).type, YetiAnalyzer.analyze(binOp.right, scope, n), scope, n);
            }
            if (string7 == "#") {
                return YetiAnalyzer.objectRef((YetiParser.ObjectRefOp)binOp, scope, n);
            }
            if (string7 == "loop") {
                return YetiAnalyzer.loop(binOp, scope, n);
            }
            if (string7 == "-" && binOp.left == null) {
                return YetiAnalyzer.apply(binOp, YetiAnalyzer.resolve("negate", binOp, scope, n), binOp.right, scope, n);
            }
            if (string7 == "not") {
                return YetiAnalyzer.apply(binOp, YetiAnalyzer.resolve(string7, binOp, scope, n), binOp.right, scope, n);
            }
            if (string7 == "with") {
                return YetiAnalyzer.withStruct(binOp, scope, n);
            }
            if (string7 == "instanceof") {
                JavaType javaType = YetiAnalyzer.resolveFullClass((String)((YetiParser.InstanceOf)binOp).className, (Scope)scope).javaType.resolve(binOp);
                return new InstanceOfExpr(YetiAnalyzer.analyze(binOp.right, scope, n), javaType);
            }
            if (binOp.left == null) {
                throw new CompileException((YetiParser.Node)binOp, "Internal error (incomplete operator " + binOp.op + ")");
            }
            BindRef bindRef = YetiAnalyzer.resolve(string7, binOp, scope, n);
            if (string7 == "^" && StaticRef.std(bindRef, "$v")) {
                Code code = YetiAnalyzer.analyze(binOp.left, scope, n);
                YetiAnalyzer.unify(code.type, STR_TYPE, binOp.left, scope, "#0");
                Code code2 = YetiAnalyzer.analyze(binOp.right, scope, n);
                YetiAnalyzer.unify(code2.type, STR_TYPE, binOp.right, scope, "#0");
                if (code instanceof StringConstant && code2 instanceof StringConstant) {
                    return new StringConstant(((StringConstant)code).str + ((StringConstant)code2).str);
                }
                return new ConcatStrings(new Code[]{code, code2});
            }
            if (string7 == "|>" && StaticRef.std(bindRef, "$I$g")) {
                return YetiAnalyzer.apply(binOp, YetiAnalyzer.analyze(binOp.right, scope, n), binOp.left, scope, n);
            }
            return YetiAnalyzer.apply(binOp.right, YetiAnalyzer.apply(binOp, bindRef, binOp.left, scope, n), binOp.right, scope, n);
        }
        throw new CompileException(node, node.kind == "class" ? "Missing ; after class definition" : "I think that this " + node + " should not be here.");
    }

    static YType nodeToMembers(int n, YetiParser.TypeNode[] typeNodeArray, Map map3, Scope scope, int n2, int n3) {
        Object object;
        Object object2;
        IdentityHashMap<Object, YType> identityHashMap = new IdentityHashMap<Object, YType>(typeNodeArray.length);
        IdentityHashMap identityHashMap2 = new IdentityHashMap(typeNodeArray.length);
        YType[] yTypeArray = new YType[typeNodeArray.length + 1];
        yTypeArray[0] = new YType(n2);
        for (int i = 1; i <= typeNodeArray.length; ++i) {
            object2 = typeNodeArray[i - 1];
            yTypeArray[i] = YetiAnalyzer.withDoc(YetiAnalyzer.nodeToType(((YetiParser.TypeNode)object2).param[0], map3, scope, n2, n3), ((YetiParser.TypeNode)object2).doc);
            if (((YetiParser.TypeNode)object2).var) {
                yTypeArray[i] = YetiAnalyzer.fieldRef(n2, yTypeArray[i], 2);
            }
            object = ((YetiParser.TypeNode)object2).name;
            IdentityHashMap<Object, YType> identityHashMap3 = identityHashMap;
            if (((String)object).charAt(0) == '.') {
                object = ((String)object).substring(1).intern();
                identityHashMap3 = identityHashMap2;
            }
            if (identityHashMap3.put(object, yTypeArray[i]) == null) continue;
            throw new CompileException((YetiParser.Node)object2, "Duplicate field name " + (String)object + " in structure type");
        }
        YType yType = new YType(n, yTypeArray);
        if (identityHashMap.isEmpty()) {
            identityHashMap = null;
        } else if (identityHashMap2.isEmpty()) {
            identityHashMap2 = null;
        }
        if (identityHashMap != null && identityHashMap2 != null) {
            object2 = identityHashMap2.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                if (identityHashMap.containsKey(object.getKey())) continue;
                identityHashMap.put(object.getKey(), (YType)object.getValue());
            }
        }
        yType.allowedMembers = identityHashMap;
        yType.requiredMembers = identityHashMap2;
        if (n3 == 0 && (identityHashMap == null || identityHashMap2 == null)) {
            yType.flags |= 0x10;
        }
        return yType;
    }

    static void expectsParam(YetiParser.TypeNode typeNode, int n) {
        if (typeNode.param == null ? n != 0 : typeNode.param.length != n) {
            throw new CompileException((YetiParser.Node)typeNode, "type " + typeNode.name + " expects " + n + " parameters");
        }
    }

    static YType nodeToType(YetiParser.TypeNode typeNode, Map map3, Scope scope, int n, int n2) {
        YType yType;
        String string2 = typeNode.name;
        int n3 = PRIMITIVE_TYPE_MAPPING.length;
        while (--n3 >= 0) {
            if (PRIMITIVE_TYPE_MAPPING[n3][0] != string2) continue;
            YetiAnalyzer.expectsParam(typeNode, 0);
            return (YType)PRIMITIVE_TYPE_MAPPING[n3][1];
        }
        if (string2 == "") {
            if (typeNode.param.length == 0) {
                throw new CompileException((YetiParser.Node)typeNode, "Empty structure type not allowed");
            }
            return YetiAnalyzer.nodeToMembers(11, typeNode.param, map3, scope, n, n2);
        }
        if (string2 == "|") {
            return YetiAnalyzer.nodeToMembers(12, typeNode.param, map3, scope, n, n2);
        }
        if (string2 == "->") {
            YetiAnalyzer.expectsParam(typeNode, 2);
            YType[] yTypeArray = new YType[]{YetiAnalyzer.nodeToType(typeNode.param[0], map3, scope, n, n2), YetiAnalyzer.nodeToType(typeNode.param[1], map3, scope, n, n2)};
            return new YType(9, yTypeArray);
        }
        if (string2 == "array") {
            YetiAnalyzer.expectsParam(typeNode, 1);
            YType[] yTypeArray = new YType[]{YetiAnalyzer.nodeToType(typeNode.param[0], map3, scope, n, n2), NUM_TYPE, LIST_TYPE};
            return new YType(10, yTypeArray);
        }
        if (string2 == "list") {
            YetiAnalyzer.expectsParam(typeNode, 1);
            YType[] yTypeArray = new YType[]{YetiAnalyzer.nodeToType(typeNode.param[0], map3, scope, n, n2), NO_TYPE, LIST_TYPE};
            return new YType(10, yTypeArray);
        }
        if (string2 == "list?") {
            YetiAnalyzer.expectsParam(typeNode, 1);
            YType[] yTypeArray = new YType[]{YetiAnalyzer.nodeToType(typeNode.param[0], map3, scope, n, n2), new YType(n), LIST_TYPE};
            return new YType(10, yTypeArray);
        }
        if (string2 == "hash") {
            YetiAnalyzer.expectsParam(typeNode, 2);
            YType[] yTypeArray = new YType[]{YetiAnalyzer.nodeToType(typeNode.param[1], map3, scope, n, n2), YetiAnalyzer.nodeToType(typeNode.param[0], map3, scope, n, n2), MAP_TYPE};
            return new YType(10, yTypeArray);
        }
        if (string2 == "map") {
            YetiAnalyzer.expectsParam(typeNode, 2);
            YType[] yTypeArray = new YType[]{YetiAnalyzer.nodeToType(typeNode.param[1], map3, scope, n, n2), YetiAnalyzer.nodeToType(typeNode.param[0], map3, scope, n, n2), new YType(n)};
            return new YType(10, yTypeArray);
        }
        if (Character.isUpperCase(string2.charAt(0))) {
            return YetiAnalyzer.nodeToMembers(12, new YetiParser.TypeNode[]{typeNode}, map3, scope, n, n2);
        }
        char c2 = string2.charAt(0);
        if (c2 == '~') {
            YetiAnalyzer.expectsParam(typeNode, 0);
            yType = JavaType.typeOfName(string2.substring(1).replace('.', '/').intern(), scope);
        } else if (c2 == '\'' || c2 == '^') {
            yType = (YType)map3.get(string2);
            if (yType == null) {
                yType = new YType(n);
                yType = new YType(n);
                map3.put(string2, yType);
                if (c2 == '^') {
                    yType.flags = 1;
                }
                if (string2.charAt(1) == '_') {
                    yType.flags |= 2;
                }
            }
        } else {
            YType[] yTypeArray = new YType[typeNode.param.length];
            for (int i = 0; i < yTypeArray.length; ++i) {
                yTypeArray[i] = YetiAnalyzer.nodeToType(typeNode.param[i], map3, scope, n, n2);
            }
            yType = YetiAnalyzer.resolveTypeDef(scope, string2, yTypeArray, n, typeNode, n2);
        }
        return yType;
    }

    static Code isOp(YetiParser.Node node, YetiParser.TypeNode typeNode, Code code, Scope scope, int n) {
        String string2;
        YType yType = YetiAnalyzer.nodeToType(typeNode != null ? typeNode : ((YetiParser.Bind)node).type, new HashMap(), scope, n + 1, -1).deref();
        if (typeNode == null) {
            YetiAnalyzer.normalizeFlexType(yType, true);
        }
        YType yType2 = code.type.deref();
        if (node instanceof YetiParser.BinOp && (string2 = ((YetiParser.BinOp)node).op) != "is") {
            if ((yType.type == 13 || yType.type == 14) && code instanceof UnitConstant) {
                return new Cast(code, yType, false, node.line);
            }
            if (string2 == "unsafely_as" && (yType2.type != 0 || yType.type != 0)) {
                JavaType.checkUnsafeCast(node, yType2, yType);
            } else if (string2 == "as" && !JavaType.isSafeCast(scope, node, yType, yType2, true)) {
                try {
                    yType = YetiAnalyzer.opaqueCast(yType2, yType, scope);
                }
                catch (TypeException typeException) {
                    String string3 = "Impossible cast from #1 to #2";
                    if (yType.type != 13 && yType.type != 14 && yType2.type != 13 && yType2.type != 14) {
                        string3 = string3 + "\n    #0";
                    }
                    throw new CompileException(node, scope, yType2, yType, string3, typeException);
                }
                string2 = "is";
            }
            return new Cast(code, yType, string2 == "as", node.line);
        }
        YetiAnalyzer.unify(code.type, yType, node, scope, "#0 (when checking #1 is #2)");
        return code;
    }

    static Code[] mapArgs(int n, YetiParser.Node[] nodeArray, Scope scope, int n2) {
        if (nodeArray == null) {
            return null;
        }
        Code[] codeArray = new Code[nodeArray.length - n];
        for (int i = n; i < nodeArray.length; ++i) {
            codeArray[i - n] = YetiAnalyzer.analyze(nodeArray[i], scope, n2);
        }
        return codeArray;
    }

    static Code objectRef(YetiParser.ObjectRefOp objectRefOp, Scope scope, int n) {
        Object object;
        Code code = null;
        YType yType = null;
        if (objectRefOp.right instanceof YetiParser.Sym) {
            object = objectRefOp.right.sym();
            yType = YetiAnalyzer.resolveClass((String)object, scope, true);
            if (yType == null && Character.isUpperCase(object.charAt(0)) && (scope.ctx.compiler.globalFlags & 0x10) == 0) {
                yType = JavaType.typeOfClass(scope.ctx.packageName, (String)object);
            }
            if (object == "super") {
                int n2 = objectRefOp.right.line = objectRefOp.right.line > 0 ? -objectRefOp.right.line : -1;
            }
        }
        if (yType == null) {
            code = YetiAnalyzer.analyze(objectRefOp.right, scope, n);
            yType = code.type;
        }
        if (objectRefOp.arguments == null) {
            object = JavaType.resolveField(objectRefOp, yType, code == null);
            object.check(objectRefOp, scope.ctx.packageName);
            if (object.constValue instanceof Number) {
                Number number2 = (Number)object.constValue;
                return new NumericConstant(number2 instanceof Double || number2 instanceof Float ? new FloatNum(number2.doubleValue()) : new IntNum(number2.longValue()));
            }
            return new ClassField(code, (JavaType.Field)object, objectRefOp.line);
        }
        object = YetiAnalyzer.mapArgs(0, objectRefOp.arguments, scope, n);
        return new MethodCall(code, JavaType.resolveMethod(objectRefOp, yType, object, code == null).check(objectRefOp, scope.ctx.packageName, 0), (Code[])object, objectRefOp.line);
    }

    static Code newArray(YetiParser.XNode xNode, Scope scope, int n) {
        Code code = YetiAnalyzer.analyze(xNode.expr[1], scope, n);
        YetiAnalyzer.unify(code.type, NUM_TYPE, xNode.expr[1], scope, "array size must be a number (but here was #1)");
        return new NewArrayExpr(JavaType.typeOfName(xNode.expr[0].sym(), scope), code, xNode.line);
    }

    static Code tryCatch(YetiParser.XNode xNode, Scope scope, int n) {
        TryCatch tryCatch = new TryCatch();
        scope = new Scope(scope, null, null);
        scope.closure = tryCatch;
        tryCatch.setBlock(YetiAnalyzer.analyze(xNode.expr[0], scope, n));
        int n2 = xNode.expr.length - 1;
        if (xNode.expr[n2].kind != "catch") {
            tryCatch.cleanup = YetiAnalyzer.analyze(xNode.expr[n2], scope, n);
            YetiAnalyzer.expectUnit(tryCatch.cleanup, xNode.expr[n2], scope, "finally block must have a unit type", null);
            --n2;
        }
        for (int i = 1; i <= n2; ++i) {
            YetiParser.XNode xNode2 = (YetiParser.XNode)xNode.expr[i];
            YType yType = YetiAnalyzer.resolveFullClass(xNode2.expr[0].sym(), scope);
            yType.javaType.resolve(xNode2);
            TryCatch.Catch catch_ = tryCatch.addCatch(yType);
            String string2 = xNode2.expr[1].sym();
            catch_.handler = YetiAnalyzer.analyze(xNode2.expr[2], string2 == "_" ? scope : new Scope(scope, string2, catch_), n);
            YetiAnalyzer.unify(tryCatch.block.type, catch_.handler.type, xNode2.expr[2], scope, "This catch has #2 type, while try block was #1");
        }
        return tryCatch;
    }

    static Code apply(YetiParser.Node node, Code code, YetiParser.Node node2, Scope scope, int n) {
        Code code2;
        YType yType = code.type.deref();
        YType yType2 = yType.type == 9 ? yType.param[0].deref() : null;
        YetiParser.XNode xNode = YetiAnalyzer.asLambda(node2);
        Code code3 = code2 = xNode != null ? YetiAnalyzer.lambda(new Function(yType2), xNode, scope, n) : YetiAnalyzer.analyze(node2, scope, n);
        if (yType2 != null && JavaType.isSafeCast(scope, node, yType2, code2.type, false)) {
            code2 = new Cast(code2, yType2, true, node.line);
        }
        YType[] yTypeArray = new YType[]{code2.type, new YType(n + 1)};
        try {
            YetiAnalyzer.unify(code.type, new YType(9, yTypeArray));
        }
        catch (TypeException typeException) {
            if (yType.type == 1) {
                throw new CompileException(node, "Missing ; (Cannot apply ())");
            }
            if (yType.type != 9 && yType.type != 0) {
                if (code instanceof Apply || code.getClass().getName().indexOf(36) > 0) {
                    throw new CompileException(node, "Too many arguments applied to a function, maybe a missing `;'?\n    (cannot apply " + yType.toString(scope, null) + " to an argument)");
                }
                throw new CompileException(node, scope, code.type, null, "Cannot use #1 as a function", typeException);
            }
            YType yType3 = code2.type.deref();
            String string2 = "Cannot apply #1 function";
            if (node != node2 && node instanceof YetiParser.BinOp) {
                YetiParser.Node node3;
                YetiParser.BinOp binOp = (YetiParser.BinOp)node;
                String string3 = binOp.op;
                YetiParser.Node node4 = string3 == "" ? binOp.left : (node3 = string3 == "|>" ? binOp.right : null);
                if (node3 == null || node3 instanceof YetiParser.Sym && (string3 = node3.sym()) != null) {
                    string2 = string2 + " (" + string3 + ')';
                }
            }
            string2 = string2 + " to #2 argument\n    #0";
            if (yType2 != null && yType2.type != 9 && yType3.type == 9) {
                string2 = code2 instanceof Apply ? string2 + "\n    Maybe you should apply the function given as an argument to more arguments." : string2 + "\n    Maybe you should apply the function given as an argument to some arguments?";
            }
            throw new CompileException(node, scope, code.type, code2.type, string2, typeException);
        }
        return code.apply(code2, yTypeArray[1], node.line);
    }

    static Code rsection(YetiParser.XNode xNode, Scope scope, int n) {
        String string2 = xNode.expr[0].sym();
        if (string2 == FIELD_OP) {
            YType yType;
            String[] stringArray;
            ++n;
            LinkedList<String> linkedList = new LinkedList<String>();
            YetiParser.Node node = xNode.expr[1];
            while (node instanceof YetiParser.BinOp) {
                stringArray = (String[])node;
                if (stringArray.op != FIELD_OP) {
                    throw new CompileException((YetiParser.Node)stringArray, "Unexpected " + stringArray.op + " in field selector");
                }
                linkedList.addFirst(YetiAnalyzer.getSelectorSym((YetiParser.Node)stringArray, (YetiParser.Node)stringArray.right).sym);
                node = stringArray.left;
            }
            linkedList.addFirst(YetiAnalyzer.getSelectorSym((YetiParser.Node)xNode, (YetiParser.Node)node).sym);
            stringArray = linkedList.toArray(new String[linkedList.size()]);
            YType yType2 = yType = new YType(n);
            int n2 = stringArray.length;
            while (--n2 >= 0) {
                yType2 = YetiAnalyzer.selectMemberType(yType2, stringArray[n2], n);
            }
            return new SelectMemberFun(new YType(9, new YType[]{yType2, yType}), stringArray);
        }
        BindRef bindRef = YetiAnalyzer.resolve(string2, xNode, scope, n);
        Code code = YetiAnalyzer.analyze(xNode.expr[1], scope, n);
        YType[] yTypeArray = new YType[]{new YType(n), new YType(n)};
        YType[] yTypeArray2 = new YType[]{yTypeArray[0], new YType(9, new YType[]{code.type, yTypeArray[1]})};
        YetiAnalyzer.unify(bindRef.type, new YType(9, yTypeArray2), xNode, scope, bindRef.type, code.type, "Cannot apply #2 as a 2nd argument to #1\n    #0");
        return bindRef.apply2nd(code, new YType(9, yTypeArray), xNode.line);
    }

    static Code variantConstructor(String string2, int n) {
        YType yType = new YType(++n);
        YType yType2 = new YType(12, new YType[]{new YType(n), yType});
        yType2.requiredMembers = new IdentityHashMap();
        yType2.requiredMembers.put(string2, yType);
        YType[] yTypeArray = new YType[]{yType, yType2};
        return new VariantConstructor(new YType(9, yTypeArray), string2);
    }

    static YetiParser.Sym getSelectorSym(YetiParser.Node node, YetiParser.Node node2) {
        if (!(node2 instanceof YetiParser.Sym)) {
            if (node2 == null) {
                throw new CompileException(node, "What's that dot doing here?");
            }
            if (node2.kind != "``") {
                throw new CompileException(node2, "Illegal ." + node2);
            }
            node2 = ((YetiParser.XNode)node2).expr[0];
        }
        return (YetiParser.Sym)node2;
    }

    static YType selectMemberType(YType yType, String string2, int n) {
        YType yType2 = new YType(11, new YType[]{new YType(n), yType});
        yType2.requiredMembers = new IdentityHashMap();
        yType2.requiredMembers.put(string2, yType);
        return yType2;
    }

    static Code selectMember(YetiParser.Node node, YetiParser.Sym sym, Code code, Scope scope, int n) {
        final YType yType = new YType(++n);
        final String string2 = sym.sym;
        YType yType2 = YetiAnalyzer.selectMemberType(yType, string2, n);
        try {
            YetiAnalyzer.unify(yType2, code.type);
        }
        catch (TypeException typeException) {
            int n2 = code.type.deref().type;
            if (n2 == 13) {
                throw new CompileException(sym, scope, code.type, null, "Cannot use class #1 as a structure with ." + string2 + " field\n    " + "(use # instead of . to reference object fields/methods)", typeException);
            }
            if (code instanceof VariantConstructor) {
                throw new CompileException((YetiParser.Node)sym, "Cannot use variant constructor " + ((VariantConstructor)code).name + " as a structure with ." + string2 + " field\n    " + "(use # instead of . to reference class fields/methods)");
            }
            if (n2 != 11 && n2 != 0) {
                throw new CompileException((YetiParser.Node)sym, "Cannot use " + code.type.toString(scope, null) + " as a structure with ." + string2 + " field");
            }
            throw new CompileException(sym, scope, code.type, null, "#1 does not have ." + string2 + " field", typeException);
        }
        YetiAnalyzer.limitDepth(yType, yType2.deref().param[0].deref().depth, 0);
        boolean bl = code.polymorph && code.type.allowedMembers != null && ((YType)code.type.allowedMembers.get((Object)string2)).field == 0;
        return new SelectMember(yType, code, string2, node.line, bl){

            boolean mayAssign() {
                YType yType4;
                YType yType2 = this.st.type.deref();
                if (yType2.allowedMembers != null && (yType4 = (YType)yType2.allowedMembers.get(string2)) != null && yType4.field != 2) {
                    return false;
                }
                YType yType3 = (YType)yType2.requiredMembers.get(string2);
                if (yType3.field != 2) {
                    yType2.requiredMembers.put(string2, YetiType.mutableFieldRef(yType));
                }
                return true;
            }
        };
    }

    static Code keyRefExpr(Code code, YetiParser.ObjectRefOp objectRefOp, Scope scope, int n) {
        Code code2 = YetiAnalyzer.analyze(objectRefOp.arguments[0], scope, n);
        YType yType = code.type.deref();
        if (yType.type == 14) {
            YetiAnalyzer.unify(code2.type, NUM_TYPE, objectRefOp.arguments[0], scope, "Array index must be a number (but here was #1)");
            return new JavaArrayRef(yType.param[0], code, code2, objectRefOp.arguments[0].line);
        }
        YType[] yTypeArray = new YType[]{new YType(n), code2.type, new YType(n)};
        YetiAnalyzer.unify(code.type, new YType(10, yTypeArray), objectRefOp, scope, code.type, code2.type, "#1 cannot be referenced by #2 key");
        return new KeyRefExpr(yTypeArray[0], code, code2, objectRefOp.line);
    }

    static Code assignOp(YetiParser.BinOp binOp, Scope scope, int n) {
        Code code;
        try {
            code = YetiAnalyzer.analyze(binOp.left, scope, n);
        }
        catch (CompileException compileException) {
            if (compileException.cause == null || compileException.cause.kind != "var") {
                throw compileException;
            }
            throw new CompileException((YetiParser.Node)binOp, "Assignment operator := not expected in variable binding (use = instead)");
        }
        Code code2 = YetiAnalyzer.analyze(binOp.right, scope, n);
        YetiAnalyzer.unify(code.type, code2.type, binOp, scope, "#0");
        Code code3 = code.assign(code2);
        if (code3 == null) {
            throw new CompileException((YetiParser.Node)binOp, "Non-mutable expression on the left of the assign operator :=");
        }
        code3.type = UNIT_TYPE;
        return code3;
    }

    static Code concatStr(YetiParser.XNode xNode, Scope scope, int n) {
        Code[] codeArray = new Code[xNode.expr.length];
        for (int i = 0; i < codeArray.length; ++i) {
            codeArray[i] = YetiAnalyzer.analyze(xNode.expr[i], scope, n);
        }
        return new ConcatStrings(codeArray);
    }

    static YType mergeIfType(YetiParser.Node node, Scope scope, YType yType, YType yType2) {
        try {
            return YetiAnalyzer.mergeOrUnify(yType, yType2);
        }
        catch (TypeException typeException) {
            throw new CompileException(node, scope, yType2, yType, "This if branch has a #1 type, while another was a #2", typeException);
        }
    }

    static Code cond(YetiParser.XNode xNode, Scope scope, int n) {
        Code[][] codeArray;
        Code code;
        ArrayList<Code[]> arrayList = new ArrayList<Code[]>();
        YType yType = null;
        boolean bl = true;
        while (true) {
            code = YetiAnalyzer.analyze(xNode.expr[0], scope, n);
            YetiAnalyzer.unify(code.type, BOOL_TYPE, xNode.expr[0], scope, "if condition must have a boolean type (but here was #1)");
            codeArray = YetiAnalyzer.analyze(xNode.expr[1], scope, n);
            arrayList.add(new Code[]{codeArray, code});
            bl &= codeArray.polymorph;
            yType = yType == null ? codeArray.type : YetiAnalyzer.mergeIfType(xNode.expr[1], scope, yType, codeArray.type);
            if (xNode.expr[2].kind != "if") break;
            xNode = (YetiParser.XNode)xNode.expr[2];
        }
        code = xNode.expr[2].kind != "fi" ? YetiAnalyzer.analyze(xNode.expr[2], scope, n) : (yType.deref() == STR_TYPE ? BuiltIn.undef_str(null, xNode.line) : new UnitConstant(null));
        yType = YetiAnalyzer.mergeIfType(xNode.expr[2], scope, yType, code.type);
        arrayList.add(new Code[]{code});
        codeArray = (Code[][])arrayList.toArray((T[])new Code[arrayList.size()][]);
        return new ConditionalExpr(yType, codeArray, bl && code.polymorph);
    }

    static Code loop(YetiParser.BinOp binOp, Scope scope, int n) {
        LoopExpr loopExpr = new LoopExpr();
        scope = new Scope(scope, null, null);
        scope.closure = loopExpr;
        YetiParser.Node node = binOp.left != null ? binOp.left : binOp.right;
        loopExpr.cond = YetiAnalyzer.analyze(node, scope, n);
        YetiAnalyzer.unify(loopExpr.cond.type, BOOL_TYPE, node, scope, "Loop condition must have a boolean type (but here was #1)");
        if (binOp.left == null) {
            loopExpr.body = new UnitConstant(null);
            return loopExpr;
        }
        loopExpr.body = YetiAnalyzer.analyze(binOp.right, scope, n);
        YetiAnalyzer.expectUnit(loopExpr.body, binOp.right, scope, "Loop body must have a unit type", null);
        return loopExpr;
    }

    static Code withStruct(YetiParser.BinOp binOp, Scope scope, int n) {
        YType yType;
        Code code = YetiAnalyzer.analyze(binOp.left, scope, n);
        Code code2 = YetiAnalyzer.analyze(binOp.right, scope, n);
        YType yType2 = code2.type.deref();
        Map map3 = yType2.allowedMembers;
        if (map3 == null || yType2.type != 11) {
            throw new CompileException(binOp.right, "Right-hand side of with must be a structure with known member set");
        }
        YType yType3 = code.type.deref();
        if (yType3.type == 11 && yType3.allowedMembers != null) {
            IdentityHashMap identityHashMap;
            YetiAnalyzer.unify(yType3.param[0], yType2.param[0], binOp, scope, "Internal error (withStruct depth unify)");
            IdentityHashMap identityHashMap2 = new IdentityHashMap(yType3.allowedMembers);
            identityHashMap2.putAll(map3);
            if (yType2.requiredMembers == null) {
                yType2.requiredMembers = map3;
            } else {
                identityHashMap = new IdentityHashMap(map3);
                identityHashMap.keySet().removeAll(yType2.requiredMembers.keySet());
                yType2.requiredMembers.putAll(map3);
            }
            identityHashMap = new IdentityHashMap(yType3.allowedMembers);
            identityHashMap.keySet().removeAll(map3.keySet());
            if (yType3.requiredMembers != null) {
                identityHashMap.putAll(yType3.requiredMembers);
            }
            yType3.requiredMembers = identityHashMap;
            yType = new YType(11, null);
            yType.allowedMembers = identityHashMap2;
            YetiAnalyzer.structParam(yType, identityHashMap2, yType3.param[0].deref());
        } else {
            yType = new YType(11, null);
            yType.requiredMembers = new IdentityHashMap(map3);
            yType.param = yType2.param;
            YetiAnalyzer.unify(code.type, yType, binOp.right, scope, "Cannot extend #1 with #2");
        }
        return new WithStruct(yType, code, code2, map3.keySet().toArray(new String[map3.size()]));
    }

    static Function singleBind(YetiParser.Bind bind, Scope scope, int n) {
        if (bind.expr.kind != "lambda") {
            throw new CompileException((YetiParser.Node)bind, "Closed binding must be a function binding.\n    Maybe you meant := or == instead of =, or have missed ; somewhere.");
        }
        Function function = new Function(new YType(n + 1));
        BindExpr bindExpr = new BindExpr(function, bind.var);
        function.selfBind = bindExpr;
        if (!bind.noRec) {
            scope = new Scope(scope, bind.name, bindExpr);
        }
        YetiAnalyzer.lambdaBind(function, bind, scope, n);
        return function;
    }

    static Scope explodeStruct(YetiParser.Node node, LoadModule loadModule, Scope scope, String string2, int n, boolean bl) {
        Object object;
        YType[] yTypeArray;
        Map.Entry entry;
        Iterator iterator;
        if (string2 == null) {
            loadModule.checkUsed = true;
            if (loadModule.type.type == 11) {
                iterator = loadModule.type.allowedMembers.entrySet().iterator();
                block0: while (iterator.hasNext()) {
                    entry = iterator.next();
                    yTypeArray = ((String)entry.getKey()).intern();
                    if (bl) {
                        object = ROOT_SCOPE;
                        while (object != null) {
                            if (((Scope)object).name == yTypeArray) continue block0;
                            object = ((Scope)object).outer;
                        }
                    }
                    object = (YType)entry.getValue();
                    scope = YetiAnalyzer.bind((String)yTypeArray, (YType)object, loadModule.bindField((String)yTypeArray, (YType)object), 8, n, scope);
                }
            } else if (loadModule.type.type != 1) {
                throw new CompileException(node, "Expected module with struct or unit type here (" + loadModule.moduleName.replace('/', '.') + " has type " + loadModule.type.toString(scope, null) + ", but only structs can be exploded)");
            }
        }
        iterator = loadModule.moduleType.typeDefs.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            yTypeArray = (YType[])entry.getValue();
            object = (String)entry.getKey();
            if (string2 != null) {
                object = string2.concat((String)object).intern();
            }
            ArrayList arrayList = new ArrayList();
            YetiAnalyzer.getAllTypeVar(arrayList, null, yTypeArray[yTypeArray.length - 1], false);
            scope = new TypeScope(scope, (String)object, yTypeArray, loadModule);
            scope.free = arrayList.toArray(new YType[arrayList.size()]);
        }
        return scope;
    }

    static void registerVar(BindExpr bindExpr, Scope scope) {
        while (scope != null) {
            if (scope.closure != null) {
                scope.closure.addVar(bindExpr);
                return;
            }
            scope = scope.outer;
        }
    }

    static Scope genericBind(YetiParser.Bind bind, BindExpr bindExpr, boolean bl, Scope scope, int n) {
        YetiAnalyzer.limitDepth(bindExpr.st.type, bind.var ? n : n + 1, 0);
        switch (bindExpr.st.type.deref().type) {
            case 0: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                scope = YetiAnalyzer.bind(bind.name, bindExpr.st.type, bindExpr, bind.var ? 4 : (bindExpr.st.polymorph ? 8 : 0), n, scope);
                break;
            }
            default: {
                scope = new Scope(scope, bind.name, bindExpr);
            }
        }
        if (bind.var) {
            YetiAnalyzer.registerVar(bindExpr, scope.outer);
        }
        if (bl) {
            bindExpr.evalId = YetiEval.registerBind(bind.name, bindExpr.st.type, bind.var, bindExpr.st.polymorph);
        }
        return scope;
    }

    static void addSeq(SeqExpr[] seqExprArray, SeqExpr seqExpr) {
        if (seqExprArray[0] == null) {
            seqExprArray[1] = seqExpr;
        } else {
            seqExprArray[0].result = seqExpr;
        }
        seqExprArray[0] = seqExpr;
    }

    static Scope bindStruct(Binder binder, YetiParser.XNode xNode, boolean bl, Scope scope, int n, SeqExpr[] seqExprArray) {
        YetiParser.Node[] nodeArray = xNode.expr;
        if (nodeArray.length == 0) {
            throw new CompileException((YetiParser.Node)xNode, NONSENSE_STRUCT);
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            YetiParser.Bind bind = new YetiParser.Bind();
            if (!(nodeArray[i] instanceof YetiParser.Bind)) {
                throw new CompileException(nodeArray[i], "Expected field pattern, not a " + nodeArray[i]);
            }
            YetiParser.Bind bind2 = (YetiParser.Bind)nodeArray[i];
            if (bind2.var || bind2.property) {
                throw new CompileException((YetiParser.Node)bind2, "Structure field pattern may not have modifiers");
            }
            bind.expr = new YetiParser.Sym(bind2.name);
            bind.expr.pos(bind2.line, bind2.col);
            YetiParser.Node node = bind2.expr;
            if (!(node instanceof YetiParser.Sym) || (bind.name = node.sym()) == "_") {
                throw new CompileException(node, "Binding name expected, not a " + node);
            }
            Code code = YetiAnalyzer.selectMember(nodeArray[i], (YetiParser.Sym)bind.expr, binder.getRef(nodeArray[i].line), scope, n + 1);
            if (bind2.type != null) {
                YetiAnalyzer.isOp(bind2, null, code, scope, n);
            }
            BindExpr bindExpr = new BindExpr(code, false);
            scope = YetiAnalyzer.genericBind(bind, bindExpr, bl, scope, n);
            YetiAnalyzer.addSeq(seqExprArray, bindExpr);
        }
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Scope bindTypeDef(YetiParser.TypeDef typeDef, Object object, Scope scope) {
        ArrayList arrayList;
        YType yType;
        YType yType2 = new YType(0);
        Scope scope2 = scope;
        if (typeDef.kind != 3) {
            scope2 = new TypeScope(scope, typeDef.name, new YType[]{yType2}, null);
        }
        YType[] yTypeArray = new YType[typeDef.param.length + 1];
        boolean bl = typeDef.param.length;
        while ((bl -= 1) >= false) {
            yType = new YType(0);
            yType.doc = scope2.name;
            yTypeArray[bl] = yType;
            scope2 = new TypeScope(scope2, typeDef.param[bl], new YType[]{yType}, null);
        }
        bl = typeDef.kind == 2;
        yType = YetiAnalyzer.nodeToType(typeDef.type, new HashMap(), scope2, 1, typeDef.kind).deref();
        YetiAnalyzer.unify(yType2, yType, typeDef, scope, yType, yType2, "Type #~ (type self-binding)\n    #0");
        scope = new TypeScope(scope, typeDef.name, yTypeArray, null);
        ArrayList arrayList2 = arrayList = bl ? new ArrayList() : null;
        if (typeDef.kind != 1) {
            ArrayList arrayList3 = new ArrayList();
            if (typeDef.kind == 3) {
                YetiAnalyzer.getAllTypeVar(arrayList3, null, yType, false);
                yType = YetiAnalyzer.copyType(yType, YetiAnalyzer.createFreeVars(arrayList3.toArray(NO_PARAM), 1), new IdentityHashMap());
                arrayList3.clear();
                YetiAnalyzer.stripFlexTypes(yType, false);
            }
            YetiAnalyzer.getAllTypeVar(arrayList3, arrayList, yType, bl);
            scope.free = arrayList3.toArray(new YType[arrayList3.size()]);
        } else {
            scope.free = null;
        }
        boolean bl2 = false;
        if (bl) {
            yType2 = yType;
            int n = scope.free.length;
            while (--n >= 0) {
                int n2 = yTypeArray.length - 1;
                while (--n2 >= 0 && scope.free[n] != yTypeArray[n2]) {
                }
                if (n2 >= 0) continue;
                scope.free[n].flags |= 0x100;
                throw new CompileException(typeDef, scope, yType2, null, "typedef opaque " + typeDef.name + " contains free type variable in #1", null);
            }
            Map map3 = scope.ctx.opaqueTypes;
            synchronized (map3) {
                yType = new YType(scope.ctx.opaqueTypes.size() + 65536, new YType[yTypeArray.length - 1]);
                System.arraycopy(yTypeArray, 0, yType.param, 0, yType.param.length);
                String string2 = scope.ctx.className + ':' + typeDef.name;
                if (!(object instanceof TopLevel)) {
                    string2 = string2 + '#' + (yType.type - 65536);
                }
                yType.allowedMembers = Collections.singletonMap("", yType2);
                yType.requiredMembers = Collections.singletonMap(string2, NO_TYPE);
                bl2 = scope.ctx.opaqueTypes.put(string2, yType) != null;
            }
            if (arrayList.size() == 0) {
                scope.free = yType.param;
            } else {
                scope.free = new YType[arrayList.size() + yType.param.length];
                System.arraycopy(yTypeArray, 0, arrayList.toArray(scope.free), arrayList.size(), yType.param.length);
            }
        }
        yTypeArray[yTypeArray.length - 1] = yType;
        if (typeDef.name.charAt(0) != '_' && typeDef.kind != 1 && object instanceof TopLevel) {
            if (((TopLevel)object).typeDefs.put(typeDef.name, yTypeArray) != null && bl2) {
                throw new CompileException((YetiParser.Node)typeDef, "Overriding typedef opaque " + typeDef.name + "<> at module scope is not allowed");
            }
            ((TopLevel)object).typeScope = scope;
        }
        return scope;
    }

    static void expectUnit(Code code, YetiParser.Node node, Scope scope, String string2, String string3) {
        if (code.type.type == 13 || code.type.type == 14) {
            return;
        }
        try {
            YetiAnalyzer.unify(code.type, UNIT_TYPE);
        }
        catch (TypeException typeException) {
            int n;
            String string4 = string2 + ", not a #1";
            YType yType = code.type.deref();
            if (!(yType.type != 9 || (n = yType.param[1].deref().type) != 0 && n != 1 && n != 9 || code instanceof BindRef || code instanceof Function)) {
                string4 = string4 + "\n    Maybe you should give more arguments to the function?";
            } else if (string3 != null) {
                string4 = string4 + string3;
            }
            throw new CompileException(node, scope, code.type, null, string4, typeException);
        }
    }

    static Code analSeq(YetiParser.Seq seq, Scope object, int n) {
        Object object2;
        YetiParser.Node[] nodeArray = seq.st;
        BindExpr[] bindExprArray = new BindExpr[nodeArray.length];
        SeqExpr[] seqExprArray = new SeqExpr[]{null, null};
        for (int i = 0; i < nodeArray.length - 1; ++i) {
            Object object3;
            if (nodeArray[i] instanceof YetiParser.Bind) {
                BindExpr bindExpr;
                object2 = (YetiParser.Bind)nodeArray[i];
                object3 = YetiAnalyzer.asLambda(object2.expr);
                if (object3 != null) {
                    object2.expr = object3;
                    bindExpr = (BindExpr)YetiAnalyzer.singleBind((YetiParser.Bind)object2, (Scope)object, (int)n).selfBind;
                } else {
                    Code code = YetiAnalyzer.analyze(object2.expr, (Scope)object, n);
                    bindExpr = new BindExpr(code, object2.var);
                    if (code instanceof LoadModule) {
                        object = YetiAnalyzer.explodeStruct((YetiParser.Node)object2, (LoadModule)code, (Scope)object, object2.name.concat("."), n - 1, false);
                    }
                    if (object2.type != null) {
                        YetiAnalyzer.isOp((YetiParser.Node)object2, null, bindExpr.st, (Scope)object, n);
                    }
                }
                if (object2.doc != null) {
                    bindExpr.st.type = YetiAnalyzer.withDoc(bindExpr.st.type, object2.doc);
                }
                object = YetiAnalyzer.genericBind((YetiParser.Bind)object2, bindExpr, seq.seqKind == YetiParser.Seq.EVAL, (Scope)object, n);
                bindExprArray[i] = bindExpr;
                YetiAnalyzer.addSeq(seqExprArray, bindExpr);
                continue;
            }
            if (nodeArray[i].kind == "struct-bind") {
                object2 = (YetiParser.XNode)nodeArray[i];
                Code code = YetiAnalyzer.analyze(object2.expr[1], (Scope)object, n + 1);
                object3 = new BindExpr(code, false);
                YetiAnalyzer.addSeq(seqExprArray, (SeqExpr)object3);
                object = YetiAnalyzer.bindStruct((Binder)object3, (YetiParser.XNode)object2.expr[0], seq.seqKind == YetiParser.Seq.EVAL, (Scope)object, n, seqExprArray);
                continue;
            }
            if (nodeArray[i].kind == "load") {
                object2 = (LoadModule)YetiAnalyzer.analyze(nodeArray[i], (Scope)object, n);
                object = YetiAnalyzer.explodeStruct(nodeArray[i], (LoadModule)object2, (Scope)object, null, n - 1, false);
                YetiAnalyzer.addSeq(seqExprArray, new SeqExpr((Code)object2));
                if (!(seq.seqKind instanceof TopLevel)) continue;
                ((TopLevel)seq.seqKind).typeScope = object;
                continue;
            }
            if (nodeArray[i].kind == "import") {
                if ((((Scope)object).ctx.compiler.globalFlags & 0x10) != 0) {
                    throw new CompileException(nodeArray[i], "import is disabled");
                }
                object2 = ((YetiParser.XNode)nodeArray[i]).expr;
                for (int k = 0; k < ((YetiParser.Node[])object2).length; ++k) {
                    object3 = ((YetiParser.Node)object2[k]).sym();
                    int n2 = ((String)object3).lastIndexOf(47);
                    object = new Scope((Scope)object, ((String)(n2 < 0 ? object3 : ((String)object3).substring(n2 + 1))).intern(), null);
                    YType yType = new YType("L" + (String)object3 + ';');
                    ((Scope)object).importClass = new YetiType.ClassBinding(yType);
                    if (seq.seqKind != YetiParser.Seq.EVAL) continue;
                    YetiEval.registerImport(((Scope)object).name, yType);
                }
                continue;
            }
            if (nodeArray[i] instanceof YetiParser.TypeDef) {
                object = YetiAnalyzer.bindTypeDef((YetiParser.TypeDef)nodeArray[i], seq.seqKind, (Scope)object);
                continue;
            }
            if (nodeArray[i].kind == "class") {
                object2 = new Scope[]{object};
                YetiAnalyzer.addSeq(seqExprArray, new SeqExpr(MethodDesc.defineClass((YetiParser.XNode)nodeArray[i], seq.seqKind instanceof TopLevel && ((TopLevel)seq.seqKind).isModule, (Scope[])object2, n)));
                object = object2[0];
                continue;
            }
            object2 = YetiAnalyzer.analyze(nodeArray[i], (Scope)object, n);
            YetiAnalyzer.expectUnit((Code)object2, nodeArray[i], (Scope)object, "Unit type expected here", seq.seqKind != "{}" ? null : "\n    (use , instead of ; to separate structure fields)");
            YetiAnalyzer.addSeq(seqExprArray, new SeqExpr((Code)object2));
        }
        YetiParser.Node node = nodeArray[nodeArray.length - 1];
        object2 = node.kind == "class" && seq.seqKind instanceof TopLevel && ((TopLevel)seq.seqKind).isModule ? MethodDesc.defineClass((YetiParser.XNode)node, true, new Scope[]{object}, n) : YetiAnalyzer.analyze(node, (Scope)object, n);
        int n3 = bindExprArray.length;
        while (--n3 >= 0) {
            if (bindExprArray[n3] == null || bindExprArray[n3].refs != null || seq.seqKind == YetiParser.Seq.EVAL || bindExprArray[n3].st instanceof LoadModule && ((LoadModule)bindExprArray[n3].st).typedefUsed) continue;
            YetiAnalyzer.unusedBinding((Scope)object, (YetiParser.Bind)nodeArray[n3]);
        }
        return YetiAnalyzer.wrapSeq((Code)object2, seqExprArray);
    }

    static Code wrapSeq(Code code, SeqExpr[] seqExprArray) {
        if (seqExprArray == null || seqExprArray[0] == null) {
            return code;
        }
        SeqExpr seqExpr = seqExprArray[1];
        while (seqExpr != null) {
            seqExpr.type = code.type;
            seqExpr = (SeqExpr)seqExpr.result;
        }
        seqExprArray[0].result = code;
        seqExprArray[1].polymorph = code.polymorph;
        return seqExprArray[1];
    }

    static Code lambdaBind(Function function, YetiParser.Bind bind, Scope scope, int n) {
        if (bind.type != null) {
            YetiAnalyzer.isOp(bind, null, function, scope, n);
        }
        return YetiAnalyzer.lambda(function, (YetiParser.XNode)bind.expr, scope, n);
    }

    static Code lambda(Function function, YetiParser.XNode xNode, Scope scope, int n) {
        Object object;
        Object object2;
        ++n;
        YType yType = function.type == null ? null : function.type.deref();
        function.polymorph = true;
        Scope scope2 = null;
        SeqExpr[] seqExprArray = null;
        YetiParser.Node node = xNode.expr[0];
        if (node.kind == "()") {
            function.arg.type = UNIT_TYPE;
        } else {
            YType yType2 = function.arg.type = yType != null && yType.type == 9 ? yType.param[0] : new YType(n);
            if (node instanceof YetiParser.Sym) {
                object2 = node.sym();
                if (object2 != "_") {
                    scope2 = new Scope(scope, (String)object2, function);
                }
            } else if (node.kind == "struct") {
                seqExprArray = new SeqExpr[]{null, null};
                scope2 = YetiAnalyzer.bindStruct(function, (YetiParser.XNode)node, false, scope, n, seqExprArray);
            } else {
                throw new CompileException(node, "Bad argument: " + node);
            }
        }
        if (scope2 == null) {
            scope2 = new Scope(scope, null, function);
        }
        object2 = scope2;
        while (((Scope)object2).outer != scope) {
            object2 = ((Scope)object2).outer;
        }
        ((Scope)object2).closure = function;
        YetiParser.XNode xNode2 = YetiAnalyzer.asLambda(xNode.expr[1]);
        if (xNode2 != null) {
            object = new Function(yType != null && yType.type == 9 ? yType.param[1] : null);
            function.setBody((Code)(seqExprArray == null || seqExprArray[0] == null ? object : seqExprArray[1]));
            YetiAnalyzer.lambda((Function)object, xNode2, scope2, n);
            YetiAnalyzer.wrapSeq((Code)object, seqExprArray);
        } else {
            YType yType3;
            object = YetiAnalyzer.analyze(xNode.expr[1], scope2, n);
            if (yType != null && yType.type == 9 && JavaType.isSafeCast(scope, xNode, yType3 = yType.param[1].deref(), ((Code)object).type, false)) {
                object = new Cast((Code)object, yType3, true, xNode.expr[1].line);
            }
            function.setBody(YetiAnalyzer.wrapSeq((Code)object, seqExprArray));
        }
        object = new YType(9, new YType[]{function.arg.type, function.body.type});
        if (yType != null) {
            YetiAnalyzer.unify((YType)object, yType, xNode, scope, "Function type #~ (self-binding)\n    #0");
        }
        YetiAnalyzer.restrictArg(function.arg.type, n, false);
        function.type = object;
        function.bindName = xNode.expr.length > 2 ? xNode.expr[2].sym() : null;
        function.body.markTail();
        return function;
    }

    private static YetiParser.Bind getField(YetiParser.Node node) {
        if (!(node instanceof YetiParser.Bind)) {
            throw new CompileException(node, "Unexpected beast in the structure (" + node + "), please give me some field binding.");
        }
        return (YetiParser.Bind)node;
    }

    private static void duplicateField(YetiParser.Bind bind) {
        throw new CompileException((YetiParser.Node)bind, "Duplicate field " + bind.name + " in the structure");
    }

    static void propertyField(YetiParser.Bind bind, Code code, StructField structField, Map map3, YetiParser.Node node, Scope scope, Scope scope2, int n) {
        YType[] yTypeArray;
        YType yType;
        Object object;
        if (code == null) {
            code = YetiAnalyzer.analyze(bind.expr, scope2, n);
        } else if (!bind.var) {
            object = (YetiParser.XNode)bind.expr;
            if (((YetiParser.XNode)object).expr[1].kind == "lambda") {
                ((YetiParser.XNode)object).expr[1] = new YetiParser.Seq(new YetiParser.Node[]{new YetiParser.XNode("()"), ((YetiParser.XNode)object).expr[1]}, null).pos(((YetiParser.XNode)object).line, ((YetiParser.XNode)object).col);
            }
        }
        object = (YType)map3.get(bind.name);
        if (object == null) {
            object = new YType(n);
            ((YType)object).field = 1;
            map3.put(bind.name, object);
        }
        if (bind.type != null) {
            yType = YetiAnalyzer.nodeToType(bind.type, new HashMap(), scope, n, -1);
            YetiAnalyzer.normalizeFlexType(yType, true);
            YetiAnalyzer.unify((YType)object, yType, bind, scope, "#0 (when checking #1 is #2)");
        }
        if (bind.var) {
            ((YType)object).field = 2;
        }
        if (bind.doc != null) {
            if (((YType)object).doc == null) {
                object = YetiAnalyzer.withDoc((YType)object, bind.doc);
            } else {
                ((YType)object).doc = bind.doc + '\n' + ((YType)object).doc;
            }
        }
        if (bind.var) {
            YType[] yTypeArray2 = new YType[2];
            yTypeArray2[0] = object;
            yTypeArray = yTypeArray2;
            yTypeArray2[1] = UNIT_TYPE;
        } else {
            YType[] yTypeArray3 = new YType[2];
            yTypeArray3[0] = UNIT_TYPE;
            yTypeArray = yTypeArray3;
            yTypeArray3[1] = object;
        }
        yType = new YType(9, yTypeArray);
        try {
            YetiAnalyzer.unify(code.type, yType);
        }
        catch (TypeException typeException) {
            throw new CompileException(node, scope, code.type, yType, (bind.var ? "Setter " : "Getter ") + bind.name + " type #~", typeException);
        }
        if (bind.var) {
            structField.setter = code;
            structField.mutable = true;
        } else {
            structField.value = code;
        }
    }

    static Code structType(YetiParser.XNode xNode, Scope scope, int n) {
        YetiParser.Bind bind;
        int n2;
        YetiParser.Node[] nodeArray = xNode.expr;
        if (nodeArray.length == 0) {
            throw new CompileException((YetiParser.Node)xNode, NONSENSE_STRUCT);
        }
        Scope scope2 = scope;
        Scope scope3 = null;
        IdentityHashMap<String, YType> identityHashMap = new IdentityHashMap<String, YType>(nodeArray.length);
        IdentityHashMap<String, StructField> identityHashMap2 = new IdentityHashMap<String, StructField>(nodeArray.length);
        Function[] functionArray = new Function[nodeArray.length];
        StructConstructor structConstructor = new StructConstructor(nodeArray.length);
        structConstructor.polymorph = true;
        for (n2 = 0; n2 < nodeArray.length; ++n2) {
            Object object;
            Function function;
            bind = YetiAnalyzer.getField(nodeArray[n2]);
            Code code = function = !bind.noRec && bind.expr.kind == "lambda" ? new Function(new YType(n + 1)) : null;
            StructField structField = (StructField)identityHashMap2.get(bind.name);
            if (bind.property) {
                if (structField == null) {
                    structField = new StructField();
                    structField.property = 1;
                    structField.name = bind.name;
                    structField.line = bind.line;
                    identityHashMap2.put(structField.name, structField);
                    structConstructor.add(structField);
                } else if (structField.property == 0 || (bind.var ? structField.setter : structField.value) != null) {
                    YetiAnalyzer.duplicateField(bind);
                }
                if (code == null && scope3 == null) {
                    scope3 = new Scope(scope, null, null);
                    scope3.closure = structConstructor;
                }
                YetiAnalyzer.propertyField(bind, code, structField, identityHashMap, nodeArray[n2], scope, scope3, n);
                continue;
            }
            if (structField != null) {
                YetiAnalyzer.duplicateField(bind);
            }
            if (code == null) {
                code = YetiAnalyzer.analyze(bind.expr, scope, n);
                if (bind.type != null) {
                    YetiAnalyzer.isOp(bind, null, code, scope, n);
                }
            }
            structField = new StructField();
            structField.name = bind.name;
            structField.value = code;
            structField.mutable = bind.var;
            identityHashMap2.put(bind.name, structField);
            structConstructor.add(structField);
            boolean bl = code.polymorph || function != null;
            YType yType = code.type;
            if (!bl && !bind.var) {
                switch (yType.deref().type) {
                    case 0: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        object = new IdentityHashMap();
                        YType[] yTypeArray = YetiAnalyzer.getFreeVar(object, yType, 0, n);
                        if (yTypeArray.length == 0 || (bl = yTypeArray.length == object.size())) break;
                        YetiAnalyzer.removeStructs(yType, object.keySet());
                        boolean bl2 = bl = yTypeArray.length >= object.size();
                    }
                }
            }
            if (bind.var) {
                yType = YetiAnalyzer.fieldRef(n, yType, 2);
            } else if (!bl) {
                yType = YetiAnalyzer.fieldRef(n, yType, 1);
            }
            identityHashMap.put(bind.name, YetiAnalyzer.withDoc(yType, bind.doc));
            if (bind.noRec) continue;
            object = structConstructor.bind(structField);
            if (function != null) {
                function.selfBind = object;
            }
            scope2 = new Scope(scope2, bind.name, (Binder)object);
        }
        if (structConstructor.properties != null) {
            scope3 = new Scope(scope2, null, null);
            scope3.closure = structConstructor;
        }
        for (n2 = 0; n2 < nodeArray.length; ++n2) {
            bind = (YetiParser.Bind)nodeArray[n2];
            if (functionArray[n2] == null) continue;
            YetiAnalyzer.lambdaBind(functionArray[n2], bind, ((YetiParser.Bind)nodeArray[n2]).property ? scope3 : scope2, n);
        }
        structConstructor.type = new YType(11, null);
        StructField structField = structConstructor.properties;
        while (structField != null) {
            if (structField.value == null) {
                throw new CompileException((YetiParser.Node)xNode, "Property " + structField.name + " has no getter");
            }
            structField = structField.nextProperty;
        }
        YetiAnalyzer.structParam(structConstructor.type, identityHashMap, new YType(n + 1));
        structConstructor.type.allowedMembers = identityHashMap;
        structConstructor.close();
        return structConstructor;
    }

    static String checkPartialMatch(YType yType) {
        if (yType.seen || (yType.flags & 0x4000) != 0) {
            return null;
        }
        if ((yType.flags & 0x8000) != 0) {
            return yType.type == 10 ? "[]" : yType.toString();
        }
        if (yType.type != 0) {
            yType.seen = true;
            int n = yType.param.length;
            while (--n >= 0) {
                String string2 = YetiAnalyzer.checkPartialMatch(yType.param[n]);
                if (string2 == null) continue;
                yType.seen = false;
                if (yType.type == 10) {
                    return "(" + string2 + ")::_";
                }
                if (yType.type == 12 || yType.type == 11) {
                    Iterator iterator = yType.requiredMembers.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (entry.getValue() != yType.param[n]) continue;
                        return (yType.type == 11 ? "." : "") + entry.getKey() + " (" + string2 + ")";
                    }
                }
                return string2;
            }
            yType.seen = false;
        } else if (yType.ref != null) {
            return YetiAnalyzer.checkPartialMatch(yType.ref);
        }
        return null;
    }

    static Code caseType(YetiParser.XNode xNode, Scope scope, int n) {
        YetiParser.Node[] nodeArray = xNode.expr;
        if (nodeArray.length <= 1) {
            throw new CompileException((YetiParser.Node)xNode, "case expects some option!");
        }
        Code code = YetiAnalyzer.analyze(nodeArray[0], scope, n);
        CaseCompiler caseCompiler = new CaseCompiler(code, n);
        CasePattern[] casePatternArray = new CasePattern[nodeArray.length];
        Scope[] scopeArray = new Scope[nodeArray.length];
        YType yType = new YType(n);
        for (int i = 1; i < nodeArray.length; ++i) {
            caseCompiler.scope = scope;
            YetiParser.XNode xNode2 = (YetiParser.XNode)nodeArray[i];
            casePatternArray[i] = caseCompiler.toPattern(xNode2.expr[0], yType, xNode2.doc);
            scopeArray[i] = caseCompiler.scope;
            caseCompiler.exp.resetParams();
        }
        String string2 = YetiAnalyzer.checkPartialMatch(yType);
        if (string2 != null) {
            throw new CompileException((YetiParser.Node)xNode, "Partial match: " + string2);
        }
        caseCompiler.finalizeVariants();
        for (int i = 1; i < nodeArray.length; ++i) {
            if (nodeArray[i].kind == "...") continue;
            caseCompiler.mergeChoice(casePatternArray[i], ((YetiParser.XNode)nodeArray[i]).expr[1], scopeArray[i]);
        }
        YetiAnalyzer.unify(code.type, yType, nodeArray[0], scope, "Inferred type for case argument is #2, but a #1 is given\n    (#0)");
        return caseCompiler.exp;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static Code list(YetiParser.Node var0, YetiParser.Node[] var1_1, Scope var2_2, int var3_3) {
        v0 = var4_4 = var1_1 == null;
        if (var4_4) {
            var1_1 = new YetiParser.Node[]{};
        }
        var5_5 = null;
        var6_6 = new Code[var1_1.length];
        var7_7 = null;
        var8_8 = YetiAnalyzer.NO_TYPE;
        var9_9 = null;
        var11_10 = null;
        var12_11 = 0;
        var13_12 = 0;
        while (var13_12 < var1_1.length) {
            block17: {
                block19: {
                    block18: {
                        block16: {
                            if (var1_1[var13_12].kind != ":") break block16;
                            if (var11_10 != null) {
                                throw new CompileException(var1_1[var13_12], "Expecting , here, not :");
                            }
                            var11_10 = (YetiParser.XNode)var1_1[var13_12];
                            if (var9_9 == YetiAnalyzer.LIST_TYPE) {
                                throw new CompileException((YetiParser.Node)var11_10, "Unexpected : in list" + (var13_12 != 1 ? "" : " (or the key is missing on the first item?)"));
                            }
                            --var12_11;
                            break block17;
                        }
                        if (var11_10 == null) break block18;
                        var14_15 = YetiAnalyzer.analyze(var11_10.expr[0], var2_2, var3_3);
                        if (var9_9 != YetiAnalyzer.MAP_TYPE) {
                            var8_8 = var14_15.type;
                            var9_9 = YetiAnalyzer.MAP_TYPE;
                            var5_5 = new Code[var1_1.length / 2];
                        } else {
                            YetiAnalyzer.unify(var8_8, var14_15.type, var1_1[var13_12], var2_2, "This map element has #2 key, but others have had #1");
                        }
                        var5_5[var12_11] = var14_15;
                        var6_6[var12_11] = YetiAnalyzer.analyze(var1_1[var13_12], var2_2, var3_3);
                        var11_10 = null;
                        break block19;
                    }
                    if (var9_9 == YetiAnalyzer.MAP_TYPE) {
                        throw new CompileException(var1_1[var13_12], "Map item is missing a key");
                    }
                    var9_9 = YetiAnalyzer.LIST_TYPE;
                    if (!(var1_1[var13_12] instanceof YetiParser.BinOp)) ** GOTO lbl-1000
                    var10_14 = (YetiParser.BinOp)var1_1[var13_12];
                    if (var10_14.op == "..") {
                        var14_15 = YetiAnalyzer.analyze(var10_14.left, var2_2, var3_3);
                        var15_17 = YetiAnalyzer.analyze(var10_14.right, var2_2, var3_3);
                        YetiAnalyzer.unify(var14_15.type, YetiAnalyzer.NUM_TYPE, var10_14.left, var2_2, ".. range expects limit to be number, not a #1");
                        YetiAnalyzer.unify(var15_17.type, YetiAnalyzer.NUM_TYPE, var10_14.right, var2_2, ".. range expects limit to be number, not a #1");
                        var6_6[var12_11] = new Range(var14_15, var15_17);
                    } else lbl-1000:
                    // 2 sources

                    {
                        var6_6[var12_11] = YetiAnalyzer.analyze(var1_1[var13_12], var2_2, var3_3);
                    }
                }
                if (var7_7 == null) {
                    var7_7 = var6_6[var12_11].type;
                } else {
                    try {
                        var7_7 = YetiAnalyzer.mergeOrUnify(var7_7, var6_6[var12_11].type);
                    }
                    catch (TypeException var14_16) {
                        throw new CompileException(var1_1[var13_12], var2_2, var6_6[var12_11].type, var7_7, (var9_9 == YetiAnalyzer.LIST_TYPE ? "This list element is " : "This map element is ") + "#1, but others have been #2", var14_16);
                    }
                }
            }
            ++var13_12;
            ++var12_11;
        }
        if (var7_7 == null) {
            var7_7 = new YType(var3_3);
        }
        if (var9_9 == null) {
            var9_9 = YetiAnalyzer.LIST_TYPE;
        }
        if (var4_4) {
            var8_8 = new YType(var3_3);
            var5_5 = new Code[]{};
            var9_9 = YetiAnalyzer.MAP_TYPE;
        }
        var13_13 /* !! */  = var9_9 == YetiAnalyzer.LIST_TYPE ? new ListConstructor(var6_6) : new MapConstructor(var5_5, var6_6);
        var13_13 /* !! */ .type = new YType(10, new YType[]{var7_7, var8_8, var9_9});
        var13_13 /* !! */ .polymorph = var9_9 == YetiAnalyzer.LIST_TYPE;
        return var13_13 /* !! */ ;
    }

    void checkModuleFree(YetiParser.Node node, RootClosure rootClosure) {
        YetiParser.Seq seq;
        YType yType = rootClosure.type.deref();
        YType[] yTypeArray = YetiAnalyzer.getFreeVar(new IdentityHashMap(), yType, rootClosure.body.polymorph ? 8 : 0, 0);
        Map map3 = null;
        while (node instanceof YetiParser.Seq) {
            seq = (YetiParser.Seq)node;
            node = seq.st[seq.st.length - 1];
        }
        Object object = seq = node.kind == "struct" ? ((YetiParser.XNode)node).expr : null;
        map3 = seq == null || yType.type != 11 ? Collections.singletonMap(null, yType) : (yType.requiredMembers != null ? yType.requiredMembers : yType.allowedMembers);
        Object var7_7 = null;
        boolean bl = false;
        Iterator iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            int n;
            Map.Entry entry = iterator.next();
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            yType = (YType)entry.getValue();
            YetiAnalyzer.getAllTypeVar(arrayList, arrayList2, yType, false);
            for (n = 0; n < yTypeArray.length; ++n) {
                arrayList.remove(yTypeArray[n]);
            }
            if (arrayList.isEmpty()) continue;
            YetiAnalyzer.removeStructs(yType, arrayList);
            if (arrayList.isEmpty()) continue;
            bl = true;
            n = arrayList.size();
            while (--n >= 0) {
                ((YType)arrayList.get((int)n)).deref().flags |= 0x100;
            }
            if (entry.getKey() == null) continue;
            for (n = 0; n < ((YetiParser.Seq)seq).length; ++n) {
                if (!(seq[n] instanceof YetiParser.Bind) || !entry.getKey().equals(((YetiParser.Bind)((Object)seq[n])).name)) continue;
                throw new CompileException((YetiParser.Node)seq[n], "Module type is not fully defined in field " + entry.getKey() + ":\n    " + yType + "\n    (offending type variables are marked with *)");
            }
        }
        if (bl) {
            throw new CompileException(node, rootClosure.body.type + "\nModule type is not fully defined " + "(offending type variables are marked with *)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RootClosure toCode(char[] cArray) {
        TopLevel topLevel = new TopLevel();
        Object t = currentSrc.get();
        currentSrc.set(cArray);
        try {
            Object object;
            Object object2;
            YetiParser.Node node;
            YetiParser.Parser parser = new YetiParser.Parser(this.sourceName, cArray, this.flags | this.compiler.globalFlags);
            try {
                node = parser.parse(topLevel);
            }
            catch (CompileException compileException) {
                if (compileException.line == 0) {
                    compileException.line = parser.currentLine();
                }
                throw compileException;
            }
            finally {
                if (parser.sourceName != null && !parser.sourceName.equals(this.sourceName)) {
                    this.sourceName = parser.sourceName;
                    this.sourceFile = null;
                }
            }
            if ((this.flags & 2) != 0) {
                System.err.println(node.str());
            }
            if ((this.flags & 0x180) != 0 && (this.flags & 0x80) != 0 != parser.isModule) {
                throw new CompileException(parser.moduleNameLine, 0, (this.flags & 0x80) != 0 ? "Expected module" : "Expected program");
            }
            this.compiler.deriveName(parser, this);
            String string2 = parser.moduleName;
            this.compiler.addClass(string2, null, parser.moduleNameLine);
            while (parser.loads != null) {
                object2 = parser.loads;
                if ((this.compiler.globalFlags & 0x10) != 0) {
                    throw new CompileException((YetiParser.Node)object2, "load is disabled");
                }
                parser.loads = (YetiParser.XNode)((YetiParser.XNode)object2).expr[1];
                ((YetiParser.XNode)object2).expr[1] = object = YetiTypeVisitor.getType(this.compiler, (YetiParser.Node)object2, ((YetiParser.XNode)object2).expr[0].sym(), false);
                if (this.depsModifiedTime >= ((ModuleType)object).lastModified) continue;
                this.depsModifiedTime = ((ModuleType)object).lastModified;
            }
            object2 = new RootClosure();
            object = new Scope((this.compiler.globalFlags & 0x10) == 0 ? ROOT_SCOPE_SYS : ROOT_SCOPE, null, null);
            LoadModule[] loadModuleArray = new LoadModule[this.preload.length];
            for (int i = 0; i < this.preload.length; ++i) {
                if (this.preload[i].equals(string2)) continue;
                ModuleType moduleType = YetiTypeVisitor.getType(this.compiler, null, this.preload[i], false);
                loadModuleArray[i] = new LoadModule(this.preload[i], moduleType, -1);
                object = YetiAnalyzer.explodeStruct(null, loadModuleArray[i], (Scope)object, null, 0, "yeti/lang/std".equals(this.preload[i]));
                if (this.depsModifiedTime < moduleType.lastModified) {
                    this.depsModifiedTime = moduleType.lastModified;
                    continue;
                }
                if (moduleType.lastModified != 0L) continue;
                this.depsModifiedTime = Long.MAX_VALUE;
            }
            if (this.targetTime > this.sourceTime && this.sourceTime != 0L && this.targetTime >= this.depsModifiedTime && this.targetFile != null) {
                this.topDoc = parser.topDoc;
                if (!parser.isModule) {
                    this.resolvedType = new ModuleType(UNIT_TYPE, null, true, -1);
                    this.resolvedType.name = string2;
                }
                RootClosure rootClosure = null;
                return rootClosure;
            }
            if (parser.isModule) {
                object = YetiAnalyzer.bindImport("module", string2, (Scope)object);
            }
            if ((this.flags & 8) != 0) {
                List list2 = YetiEval.get().bindings;
                int n = list2.size();
                for (int i = 0; i < n; ++i) {
                    YetiEval.Binding binding = (YetiEval.Binding)list2.get(i);
                    if (binding.isImport) {
                        object = new Scope((Scope)object, binding.name, null);
                        ((Scope)object).importClass = new YetiType.ClassBinding(binding.type);
                        continue;
                    }
                    object = YetiAnalyzer.bind(binding.name, binding.type, new EvalBind(binding), binding.mutable ? 4 : (binding.polymorph ? 8 : 0), 0, (Scope)object);
                }
            }
            topLevel.isModule = parser.isModule;
            topLevel.typeScope = object;
            ((RootClosure)object2).preload = loadModuleArray;
            ((RootClosure)object2).line = parser.moduleNameLine;
            ((Scope)object).closure = object2;
            ((Scope)object).ctx = new YetiType.ScopeCtx(string2, this.compiler);
            ((RootClosure)object2).body = YetiAnalyzer.analyze(node, (Scope)object, 0);
            ((RootClosure)object2).type = ((RootClosure)object2).body.type.deref();
            ModuleType moduleType = new ModuleType(((RootClosure)object2).type, topLevel.typeDefs, true, parser.isModule ? 1 : -1);
            Object object3 = moduleType.typeDefs.values().iterator();
            while (object3.hasNext()) {
                YType[] yTypeArray = (YType[])object3.next();
                if (yTypeArray[yTypeArray.length - 1].type < 65536) continue;
                yTypeArray[yTypeArray.length - 1].allowedMembers = null;
            }
            ((RootClosure)object2).moduleType = moduleType;
            moduleType.topDoc = parser.topDoc;
            moduleType.deprecated = parser.deprecated;
            moduleType.name = string2;
            moduleType.typeScope = topLevel.typeScope;
            moduleType.lastModified = this.sourceTime;
            moduleType.hasSource = true;
            if (moduleType.lastModified < this.depsModifiedTime) {
                moduleType.lastModified = this.depsModifiedTime;
            }
            ((RootClosure)object2).isModule = parser.isModule;
            if (parser.isModule) {
                this.checkModuleFree(node, (RootClosure)object2);
            } else if ((this.flags & 4) == 0) {
                YetiAnalyzer.expectUnit((Code)object2, node, topLevel.typeScope, "Program body must have a unit type", null);
            }
            object3 = object2;
            return object3;
        }
        finally {
            currentSrc.set(t);
        }
    }

    static final class CaseCompiler {
        CaseExpr exp;
        Scope scope;
        int depth;
        List variants = new ArrayList();
        List listVars;
        int submatch;

        CaseCompiler(Code code, int n) {
            this.exp = new CaseExpr(code);
            this.exp.polymorph = true;
            this.depth = n;
        }

        CasePattern toPattern(YetiParser.Node node, YType yType, String string2) {
            YetiParser.Node[] nodeArray;
            if ((yType.flags & 0x4000) != 0) {
                throw new CompileException(node, "Useless case " + node + " (any value already matched)");
            }
            if (yType.type == 0 && yType.ref == null && this.listVars != null && !this.listVars.contains(yType)) {
                this.listVars.add(yType);
            }
            if (node instanceof YetiParser.Sym) {
                yType.flags |= 0x4000;
                String string3 = node.sym();
                if (string3 == "_" || string3 == "...") {
                    return CasePattern.ANY_PATTERN;
                }
                BindPattern bindPattern = new BindPattern(this.exp, yType);
                this.scope = new Scope(this.scope, string3, bindPattern);
                yType = yType.deref();
                if (yType.type == 12) {
                    yType.flags |= 0x4000;
                }
                return bindPattern;
            }
            if (node.kind == "()") {
                YetiType.unify(yType, YetiType.UNIT_TYPE, node, this.scope, "#0");
                return CasePattern.ANY_PATTERN;
            }
            if (node instanceof YetiParser.NumLit || node instanceof YetiParser.Str || node instanceof YetiParser.ObjectRefOp) {
                nodeArray = YetiAnalyzer.analyze(node, this.scope, this.depth);
                if (!(node instanceof YetiParser.ObjectRefOp) || nodeArray.flagop(1)) {
                    yType = yType.deref();
                    if (yType.type == 0) {
                        yType.type = nodeArray.type.type;
                        yType.param = YetiType.NO_PARAM;
                        yType.flags = 32768;
                    } else if (yType.type != nodeArray.type.type) {
                        throw new CompileException(node, this.scope, nodeArray.type, yType, "Pattern type mismatch: #~", null);
                    }
                    return new ConstPattern((Code)nodeArray);
                }
            }
            if (node.kind == "list") {
                nodeArray = (YetiParser.XNode)node;
                YType yType2 = new YType(this.depth);
                YType yType3 = new YType(10, new YType[]{yType2, new YType(this.depth), YetiType.LIST_TYPE});
                yType3.flags |= 0x8000;
                if (nodeArray.expr == null || nodeArray.expr.length == 0) {
                    YetiType.unify(yType, yType3, node, this.scope, "#0");
                    return AListPattern.EMPTY_PATTERN;
                }
                CasePattern[] casePatternArray = new CasePattern[nodeArray.expr.length];
                int n = 16384;
                ++this.submatch;
                List list2 = this.listVars;
                this.listVars = new ArrayList();
                for (int i = 0; i < casePatternArray.length; ++i) {
                    yType2.flags &= 0xFFFFBFFF;
                    int n2 = this.listVars.size();
                    while (--n2 >= 0) {
                        ((YType)this.listVars.get((int)n2)).flags &= 0xFFFFBFFF;
                    }
                    this.listVars.clear();
                    casePatternArray[i] = this.toPattern(nodeArray.expr[i], yType2, null);
                    n &= yType2.flags;
                }
                this.listVars = list2;
                --this.submatch;
                yType2.flags &= n;
                YetiType.unify(yType, yType3, node, this.scope, "#0");
                return new ListPattern(casePatternArray);
            }
            if (node instanceof YetiParser.BinOp) {
                nodeArray = (YetiParser.BinOp)node;
                if (nodeArray.op == "" && nodeArray.left instanceof YetiParser.Sym) {
                    String string4 = nodeArray.left.sym();
                    if (!Character.isUpperCase(string4.charAt(0))) {
                        throw new CompileException(nodeArray.left, string4 + ": Variant constructor must start with upper case");
                    }
                    yType = yType.deref();
                    if (yType.type != 0 && yType.type != 12) {
                        throw new CompileException(node, "Variant " + string4 + " ... is not " + yType.toString(this.scope, null));
                    }
                    yType.type = 12;
                    if (yType.requiredMembers == null) {
                        yType.requiredMembers = new IdentityHashMap();
                        yType.flags |= 8;
                        if (this.submatch == 0) {
                            this.variants.add(yType);
                        }
                    }
                    YType yType4 = new YType(this.depth);
                    yType4.doc = string2;
                    YType yType5 = yType.requiredMembers.put(string4, yType4);
                    if (yType5 != null) {
                        yType4 = YetiType.withDoc(yType5, string2);
                        yType.requiredMembers.put(string4, yType4);
                    }
                    CasePattern casePattern = this.toPattern(nodeArray.right, yType4, null);
                    YetiType.structParam(yType, yType.requiredMembers, new YType(this.depth));
                    return new VariantPattern(string4, casePattern);
                }
                if (nodeArray.op == "::") {
                    YType yType6 = new YType(this.depth);
                    YType yType7 = new YType(10, new YType[]{yType6, YetiType.NO_TYPE, YetiType.LIST_TYPE});
                    int n = yType.flags;
                    YetiType.unify(yType, yType7, node, this.scope, "#0");
                    ++this.submatch;
                    CasePattern casePattern = this.toPattern(nodeArray.left, yType6, null);
                    CasePattern casePattern2 = this.toPattern(nodeArray.right, yType, null);
                    --this.submatch;
                    yType7.flags = 32768;
                    yType.flags = n;
                    return new ConsPattern(casePattern, casePattern2);
                }
            }
            if (node.kind == "struct") {
                YType yType8;
                Object object;
                nodeArray = ((YetiParser.XNode)node).expr;
                if (nodeArray.length == 0) {
                    throw new CompileException(node, YetiAnalyzer.NONSENSE_STRUCT);
                }
                String[] stringArray = new String[nodeArray.length];
                CasePattern[] casePatternArray = new CasePattern[nodeArray.length];
                HashMap hashMap = new HashMap(nodeArray.length);
                int n = 16384;
                for (int i = 0; i < nodeArray.length; ++i) {
                    object = YetiAnalyzer.getField(nodeArray[i]);
                    if (hashMap.containsKey(((YetiParser.Bind)object).name)) {
                        YetiAnalyzer.duplicateField((YetiParser.Bind)object);
                    }
                    hashMap.put(((YetiParser.Bind)object).name, null);
                    yType8 = new YType(this.depth);
                    YType yType9 = new YType(11, new YType[]{new YType(this.depth), yType8});
                    IdentityHashMap<String, YType> identityHashMap = new IdentityHashMap<String, YType>();
                    identityHashMap.put(((YetiParser.Bind)object).name, yType8);
                    yType9.requiredMembers = identityHashMap;
                    YetiType.unify(yType, yType9, (YetiParser.Node)object, this.scope, "#0");
                    stringArray[i] = ((YetiParser.Bind)object).name;
                    yType8.flags &= 0xFFFFBFFF;
                    casePatternArray[i] = this.toPattern(((YetiParser.Bind)object).expr, yType8, null);
                    n &= yType8.flags;
                }
                Map map3 = yType.deref().requiredMembers;
                if (map3 != null) {
                    object = map3.values().iterator();
                    while (object.hasNext()) {
                        yType8 = ((YType)object.next()).deref();
                        if (n == 0) {
                            yType8.flags &= 0xFFFFBFFF;
                            continue;
                        }
                        yType8.flags |= 0x4000;
                    }
                }
                return new StructPattern(stringArray, casePatternArray);
            }
            throw new CompileException(node, "Bad case pattern: " + node);
        }

        void finalizeVariants() {
            int n = this.variants.size();
            while (--n >= 0) {
                YType yType = (YType)this.variants.get(n);
                if (yType.type != 12 || yType.allowedMembers != null || (yType.flags & 0x4000) != 0) continue;
                yType.allowedMembers = yType.requiredMembers;
                yType.requiredMembers = null;
                yType.flags &= 0xFFFFFFF7;
            }
        }

        void mergeChoice(CasePattern casePattern, YetiParser.Node node, Scope scope) {
            Code code = YetiAnalyzer.analyze(node, scope, this.depth);
            this.exp.polymorph &= code.polymorph;
            if (this.exp.type == null) {
                this.exp.type = code.type;
            } else {
                try {
                    this.exp.type = YetiType.mergeOrUnify(this.exp.type, code.type);
                }
                catch (TypeException typeException) {
                    throw new CompileException(node, scope, code.type, this.exp.type, "This choice has a #1 type, while another was a #2", typeException);
                }
            }
            this.exp.addChoice(casePattern, code);
        }
    }

    static final class TopLevel {
        Map typeDefs = new HashMap();
        Scope typeScope;
        boolean isModule;

        TopLevel() {
        }
    }
}

