/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import yeti.lang.compiler.CompileException;
import yeti.lang.compiler.Compiler;
import yeti.lang.compiler.JavaType;
import yeti.lang.compiler.ModuleType;
import yeti.lang.compiler.YType;
import yeti.lang.compiler.YetiType;
import yeti.renamed.asm3.Attribute;
import yeti.renamed.asm3.ByteVector;
import yeti.renamed.asm3.ClassReader;
import yeti.renamed.asm3.ClassWriter;
import yeti.renamed.asm3.Label;

class TypeAttr
extends Attribute {
    static final byte END = -1;
    static final byte REF = -2;
    static final byte ORDERED = -3;
    static final byte MUTABLE = -4;
    static final byte TAINTED = -5;
    static final byte OPAQUE = -6;
    static final byte ANYCASE = -7;
    static final byte SMART = -8;
    final ModuleType moduleType;
    private ByteVector encoded;
    final Compiler compiler;

    TypeAttr(ModuleType moduleType, Compiler compiler) {
        super("YetiModuleType");
        this.moduleType = moduleType;
        this.compiler = compiler;
    }

    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        int n4 = 3;
        switch (classReader.b[n]) {
            case 0: {
                n4 = 1;
            }
            case 1: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown type encoding: " + classReader.b[n]);
            }
        }
        DecodeType decodeType = new DecodeType(classReader, n + n4, n2 - n4, cArray, this.compiler.opaqueTypes);
        YType yType = decodeType.read();
        Map map3 = decodeType.readTypeDefs();
        return new TypeAttr(new ModuleType(yType, map3, n4 != 1, -1), this.compiler);
    }

    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n, int n2, int n3) {
        if (this.encoded != null) {
            return this.encoded;
        }
        EncodeType encodeType = new EncodeType();
        Iterator iterator = this.moduleType.typeDefs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            YType[] yTypeArray = (YType[])entry.getValue();
            YType yType = yTypeArray[yTypeArray.length - 1];
            if (yType.type < 65536 || yType.requiredMembers != null) continue;
            encodeType.opaque.put(new Integer(yType.type), this.moduleType.name + ':' + entry.getKey());
        }
        encodeType.cw = classWriter;
        encodeType.buf.putByte(1);
        encodeType.buf.putShort(0);
        encodeType.write(this.moduleType.type);
        encodeType.writeTypeDefs(this.moduleType.typeDefs);
        this.encoded = encodeType.buf;
        return this.encoded;
    }

    private static final class DecodeType {
        private static final int VAR_DEPTH = 1;
        final ClassReader cr;
        final byte[] in;
        final char[] buf;
        int p;
        final int end;
        final Map vars = new HashMap();
        final List refs = new ArrayList();
        final Map opaqueTypes;

        DecodeType(ClassReader classReader, int n, int n2, char[] cArray, Map map3) {
            this.cr = classReader;
            this.in = classReader.b;
            this.p = n;
            this.end = this.p + n2;
            this.buf = cArray;
            this.opaqueTypes = map3;
        }

        Map readMap() {
            if (this.in[this.p] == -1) {
                ++this.p;
                return null;
            }
            IdentityHashMap<String, YType> identityHashMap = new IdentityHashMap<String, YType>();
            while (this.in[this.p] != -1) {
                YType yType = this.read();
                identityHashMap.put(this.cr.readUTF8(this.p, this.buf).intern(), yType);
                this.p += 2;
            }
            ++this.p;
            return identityHashMap;
        }

        YType[] readArray() {
            ArrayList<YType> arrayList = new ArrayList<YType>();
            while (this.in[this.p] != -1) {
                arrayList.add(this.read());
            }
            ++this.p;
            return arrayList.toArray(new YType[arrayList.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        YType read() {
            if (this.p >= this.end) {
                throw new RuntimeException("Invalid type description");
            }
            byte by = this.in[this.p++];
            switch (by) {
                case -5: 
                case 0: {
                    Integer n = new Integer(this.cr.readUnsignedShort(this.p));
                    this.p += 2;
                    YType yType = (YType)this.vars.get(n);
                    if (yType == null) {
                        yType = new YType(1);
                        this.vars.put(n, yType);
                    }
                    if (by == -5) {
                        yType.flags |= 2;
                    }
                    return yType;
                }
                case -3: {
                    YType yType = this.read();
                    yType.flags |= 1;
                    return yType;
                }
                case -2: {
                    int n = this.cr.readUnsignedShort(this.p);
                    this.p += 2;
                    if (this.refs.size() <= n) {
                        throw new RuntimeException("Illegal type reference");
                    }
                    return (YType)this.refs.get(n);
                }
                case -4: {
                    return YetiType.fieldRef(1, this.read(), 2);
                }
            }
            if (by < YetiType.PRIMITIVES.length && by > 0) {
                return YetiType.PRIMITIVES[by];
            }
            YType yType = new YType(by, null);
            this.refs.add(yType);
            if (yType.type == 9) {
                yType.param = new YType[2];
                yType.param[0] = this.read();
                yType.param[1] = this.read();
            } else if (by == 10) {
                yType.param = this.readArray();
            } else if (by == 11 || by == 12) {
                IdentityHashMap identityHashMap;
                if (this.in[this.p] == -7) {
                    yType.flags |= 8;
                    ++this.p;
                }
                if (this.in[this.p] == -8) {
                    yType.flags |= 0x10;
                    ++this.p;
                }
                yType.allowedMembers = this.readMap();
                yType.requiredMembers = this.readMap();
                if (yType.allowedMembers == null) {
                    identityHashMap = yType.requiredMembers;
                    if (identityHashMap == null) {
                        identityHashMap = new IdentityHashMap();
                    }
                } else if (yType.requiredMembers == null) {
                    identityHashMap = yType.allowedMembers;
                } else {
                    identityHashMap = new IdentityHashMap(yType.allowedMembers);
                    identityHashMap.putAll(yType.requiredMembers);
                }
                yType.param = new YType[identityHashMap.size() + 1];
                yType.param[0] = new YType(1);
                Iterator iterator = identityHashMap.values().iterator();
                int n = 1;
                while (iterator.hasNext()) {
                    yType.param[n] = (YType)iterator.next();
                    ++n;
                }
            } else if (by == 13) {
                yType.javaType = JavaType.fromDescription(this.cr.readUTF8(this.p, this.buf));
                this.p += 2;
                yType.param = this.readArray();
            } else if (by == 14) {
                yType.param = new YType[]{this.read()};
            } else if (by == -6) {
                String string2 = this.cr.readUTF8(this.p, this.buf);
                this.p += 2;
                Map map3 = this.opaqueTypes;
                synchronized (map3) {
                    YType yType2 = (YType)this.opaqueTypes.get(string2);
                    if (yType2 != null) {
                        yType.type = yType2.type;
                    } else {
                        yType.type = this.opaqueTypes.size() + 65536;
                        this.opaqueTypes.put(string2, yType);
                    }
                }
                yType.requiredMembers = Collections.singletonMap(string2, YetiType.NO_TYPE);
                yType.param = this.readArray();
            } else {
                throw new RuntimeException("Unknown type id: " + by);
            }
            return yType;
        }

        Map readTypeDefs() {
            HashMap<String, YType[]> hashMap = new HashMap<String, YType[]>();
            while (this.in[this.p] != -1) {
                String string2 = this.cr.readUTF8(this.p, this.buf);
                this.p += 2;
                hashMap.put(string2.intern(), this.readArray());
            }
            ++this.p;
            return hashMap;
        }
    }

    private static final class EncodeType {
        ClassWriter cw;
        ByteVector buf = new ByteVector();
        Map refs = new IdentityHashMap();
        Map vars = new IdentityHashMap();
        Map opaque = new HashMap();

        private EncodeType() {
        }

        void writeMap(Map map3) {
            if (map3 != null) {
                Iterator iterator = map3.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    YType yType = (YType)entry.getValue();
                    if (yType.field == 2) {
                        this.buf.putByte(-4);
                    }
                    this.write(yType);
                    int n = this.cw.newUTF8((String)entry.getKey());
                    this.buf.putShort(n);
                }
            }
            this.buf.putByte(-1);
        }

        void writeArray(YType[] yTypeArray) {
            for (int i = 0; i < yTypeArray.length; ++i) {
                this.write(yTypeArray[i]);
            }
            this.buf.putByte(-1);
        }

        void write(YType yType) {
            yType = yType.deref();
            if (yType.type == 0) {
                Integer n = (Integer)this.vars.get(yType);
                if (n == null) {
                    n = new Integer(this.vars.size());
                    this.vars.put(yType, n);
                    if (n > Short.MAX_VALUE) {
                        throw new RuntimeException("Too many type parameters");
                    }
                    if ((yType.flags & 1) != 0) {
                        this.buf.putByte(-3);
                    }
                }
                this.buf.putByte((yType.flags & 2) == 0 ? 0 : -5);
                this.buf.putShort(n);
                return;
            }
            if (yType.type < YetiType.PRIMITIVES.length && YetiType.PRIMITIVES[yType.type] != null) {
                this.buf.putByte(yType.type);
                return;
            }
            Integer n = (Integer)this.refs.get(yType);
            if (n != null) {
                if (n > Short.MAX_VALUE) {
                    throw new RuntimeException("Too many type parts");
                }
                this.buf.putByte(-2);
                this.buf.putShort(n);
                return;
            }
            this.refs.put(yType, new Integer(this.refs.size()));
            if (yType.type >= 65536) {
                Object object = this.opaque.get(new Integer(yType.type));
                if (object == null) {
                    object = yType.requiredMembers.keySet().toArray()[0];
                }
                this.buf.putByte(-6);
                this.buf.putShort(this.cw.newUTF8(object.toString()));
                this.writeArray(yType.param);
                return;
            }
            this.buf.putByte(yType.type);
            if (yType.type == 9) {
                this.write(yType.param[0]);
                this.write(yType.param[1]);
            } else if (yType.type == 10) {
                this.writeArray(yType.param);
            } else if (yType.type == 11 || yType.type == 12) {
                if ((yType.allowedMembers == null || yType.allowedMembers.isEmpty()) && (yType.requiredMembers == null || yType.requiredMembers.isEmpty())) {
                    throw new CompileException(0, 0, yType.type == 11 ? "Internal error: empty struct" : "Internal error: empty variant");
                }
                if ((yType.flags & 8) != 0) {
                    this.buf.putByte(-7);
                }
                if ((yType.flags & 0x10) != 0) {
                    this.buf.putByte(-8);
                }
                this.writeMap(yType.allowedMembers);
                this.writeMap(yType.requiredMembers);
            } else if (yType.type == 13) {
                this.buf.putShort(this.cw.newUTF8(yType.javaType.description));
                this.writeArray(yType.param);
            } else if (yType.type == 14) {
                this.write(yType.param[0]);
            } else {
                throw new RuntimeException("Unknown type: " + yType.type);
            }
        }

        void writeTypeDefs(Map map3) {
            Iterator iterator = map3.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.buf.putShort(this.cw.newUTF8((String)entry.getKey()));
                this.writeArray((YType[])entry.getValue());
            }
            this.buf.putByte(-1);
        }
    }
}

