/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.Arrays;
import java.util.List;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.CodeGen;
import yeti.lang.compiler.Ctx;
import yeti.lang.compiler.Range;
import yeti.lang.compiler.SimpleCode;

final class ListConstructor
extends Code
implements CodeGen {
    private Code[] items;
    private List key;

    ListConstructor(Code[] codeArray) {
        int n;
        this.items = codeArray;
        for (n = 0; n < codeArray.length; ++n) {
            if (codeArray[n].flagop(1)) continue;
            return;
        }
        Object[] objectArray = new Object[codeArray.length + 1];
        objectArray[0] = "LIST";
        for (n = 0; n < codeArray.length; ++n) {
            objectArray[n + 1] = codeArray[n].valueKey();
        }
        this.key = Arrays.asList(objectArray);
    }

    public void gen2(Ctx ctx, Code code, int n) {
        int n2;
        for (n2 = 0; n2 < this.items.length; ++n2) {
            if (!(this.items[n2] instanceof Range)) {
                ctx.typeInsn(187, "yeti/lang/LList");
                ctx.insn(89);
            }
            this.items[n2].gen(ctx);
        }
        ctx.insn(1);
        n2 = this.items.length;
        while (--n2 >= 0) {
            if (this.items[n2] instanceof Range) {
                ctx.methodInsn(184, "yeti/lang/ListRange", "range", "(Ljava/lang/Object;Ljava/lang/Object;Lyeti/lang/AList;)Lyeti/lang/AList;");
                continue;
            }
            ctx.visitInit("yeti/lang/LList", "(Ljava/lang/Object;Lyeti/lang/AList;)V");
        }
    }

    void gen(Ctx ctx) {
        if (this.items.length == 0) {
            ctx.insn(1);
            return;
        }
        if (this.key == null) {
            this.gen2(ctx, null, 0);
        } else {
            ctx.constant(this.key, new SimpleCode(this, null, this.type, 0));
        }
        ctx.forceType("yeti/lang/AList");
    }

    Object valueKey() {
        return this.key;
    }

    boolean flagop(int n) {
        return (n & 0x23) != 0 && (this.key != null || this.items.length == 0) || (n & 0x10) != 0 && this.items.length == 0 || (n & 0x100) != 0 && this.items.length != 0 && this.items[0] instanceof Range;
    }
}

