/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import yeti.lang.compiler.BindRef;
import yeti.lang.compiler.CaptureWrapper;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.ConcatStrings;
import yeti.lang.compiler.Ctx;
import yeti.lang.compiler.JavaType;
import yeti.lang.compiler.NewArrayExpr;
import yeti.lang.compiler.StringConstant;
import yeti.lang.compiler.UnitConstant;
import yeti.lang.compiler.YType;
import yeti.renamed.asm3.Label;

class JavaExpr
extends Code {
    Code object;
    JavaType.Method method;
    Code[] args;
    int line;

    JavaExpr(Code code, JavaType.Method method, Code[] codeArray, int n) {
        this.object = code;
        this.method = method;
        this.args = codeArray;
        this.line = n;
    }

    private static void convert(Ctx ctx, YType yType, YType yType2) {
        String string2;
        yType = yType.deref();
        yType2 = yType2.deref();
        String string3 = string2 = yType2.javaType == null ? "" : yType2.javaType.description;
        if (yType2.type == 14 && yType.type == 14) {
            ctx.typeInsn(192, JavaType.descriptionOf(yType2));
            return;
        }
        if (yType.type != 13 && (yType2.type == 14 || yType2.type == 13 && yType2.javaType.isCollection())) {
            YType yType3;
            YType yType4 = yType3 = yType2.param.length != 0 ? yType2.param[0].deref() : null;
            if (yType2.type == 14 && yType3.javaType != null) {
                if (yType3.javaType.description == "B") {
                    ctx.typeInsn(192, "yeti/lang/AList");
                    ctx.methodInsn(184, "yeti/lang/Core", "bytes", "(Lyeti/lang/AList;)[B");
                    return;
                }
                if (yType3.javaType.description.charAt(0) == 'L') {
                    ctx.typeInsn(192, "yeti/lang/AList");
                    ctx.methodInsn(184, "yeti/lang/MList", "ofList", "(Lyeti/lang/AList;)Lyeti/lang/MList;");
                    ctx.insn(89);
                    ctx.methodInsn(182, "yeti/lang/MList", "length", "()J");
                    ctx.insn(136);
                    new NewArrayExpr(yType2, null, 0).gen(ctx);
                    ctx.methodInsn(182, "yeti/lang/MList", "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;");
                    string2 = JavaType.descriptionOf(yType2);
                    ctx.typeInsn(192, string2);
                    ctx.forceType(string2);
                    return;
                }
            }
            Label label = new Label();
            Label label2 = new Label();
            ctx.typeInsn(192, "yeti/lang/AIter");
            String string4 = string2 != "Ljava/lang/Set;" ? "java/util/ArrayList" : "java/util/HashSet";
            ctx.typeInsn(187, string4);
            ctx.insn(89);
            ctx.visitInit(string4, "()V");
            ctx.insn(95);
            ctx.insn(89);
            ctx.jumpInsn(198, label2);
            ctx.insn(89);
            ctx.methodInsn(182, "yeti/lang/AIter", "isEmpty", "()Z");
            ctx.jumpInsn(154, label2);
            ctx.visitLabel(label);
            ctx.insn(92);
            ctx.methodInsn(182, "yeti/lang/AIter", "first", "()Ljava/lang/Object;");
            if (yType3 != null && (yType3.type != 13 || yType3.javaType.description.length() > 1)) {
                JavaExpr.convert(ctx, yType.param[0], yType2.param[0]);
            }
            ctx.methodInsn(182, string4, "add", "(Ljava/lang/Object;)Z");
            ctx.insn(87);
            ctx.methodInsn(182, "yeti/lang/AIter", "next", "()Lyeti/lang/AIter;");
            ctx.insn(89);
            ctx.jumpInsn(199, label);
            ctx.visitLabel(label2);
            ctx.insn(87);
            if (yType2.type != 14) {
                return;
            }
            String string5 = "";
            YType yType5 = yType2;
            while (true) {
                yType2 = yType2.param[0];
                if (yType2.type != 14) break;
                string5 = string5 + "[";
                yType5 = yType2;
            }
            String string6 = string5;
            string5 = string5 == "" && yType2.javaType.description.length() != 1 ? yType2.javaType.className() : string5 + yType2.javaType.description;
            ctx.insn(89);
            ctx.methodInsn(182, string4, "size", "()I");
            if (yType3.type != 13 || (string2 = yType3.javaType.description).length() != 1) {
                ctx.typeInsn(189, string5);
                ctx.methodInsn(182, string4, "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;");
                if (!string5.equals("java/lang/Object")) {
                    ctx.typeInsn(192, string6 + "[" + yType2.javaType.description);
                }
                return;
            }
            int n = ctx.localVarCount++;
            Label label3 = new Label();
            Label label4 = new Label();
            ctx.insn(89);
            ctx.varInsn(54, n);
            new NewArrayExpr(yType5, null, 0).gen(ctx);
            ctx.insn(95);
            ctx.visitLabel(label3);
            ctx.varInsn(21, n);
            ctx.jumpInsn(153, label4);
            ctx.visitIntInsn(132, n);
            ctx.insn(92);
            ctx.varInsn(21, n);
            ctx.methodInsn(182, string4, "get", "(I)Ljava/lang/Object;");
            if (string2 == "Z") {
                ctx.typeInsn(192, "java/lang/Boolean");
                ctx.methodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
            } else {
                ctx.typeInsn(192, "yeti/lang/Num");
                JavaExpr.convertNum(ctx, string2);
            }
            ctx.varInsn(21, n);
            int n2 = 84;
            switch (yType2.javaType.description.charAt(0)) {
                case 'D': {
                    n2 = 82;
                    break;
                }
                case 'F': {
                    n2 = 81;
                    break;
                }
                case 'I': {
                    n2 = 79;
                    break;
                }
                case 'J': {
                    n2 = 80;
                    break;
                }
                case 'S': {
                    n2 = 86;
                }
            }
            if (n2 == 82 || n2 == 80) {
                ctx.insn(91);
                ctx.insn(87);
            } else {
                ctx.insn(95);
            }
            ctx.insn(n2);
            ctx.jumpInsn(167, label3);
            ctx.visitLabel(label4);
            ctx.insn(87);
            return;
        }
        if (yType.type == 2) {
            ctx.typeInsn(192, "java/lang/String");
            ctx.insn(89);
            ctx.fieldInsn(178, "yeti/lang/Core", "UNDEF_STR", "Ljava/lang/String;");
            Label label = new Label();
            ctx.jumpInsn(166, label);
            ctx.insn(87);
            ctx.insn(1);
            ctx.visitLabel(label);
            return;
        }
        if (yType.type != 3 || string2 == "Ljava/lang/Object;" || string2 == "Ljava/lang/Number;") {
            if (string2 != "Ljava/lang/Object;") {
                ctx.typeInsn(192, yType2.javaType.className());
            }
            return;
        }
        ctx.typeInsn(192, "yeti/lang/Num");
        if (string2 == "Ljava/math/BigInteger;") {
            ctx.methodInsn(182, "yeti/lang/Num", "toBigInteger", "()Ljava/math/BigInteger;");
            return;
        }
        if (string2 == "Ljava/math/BigDecimal;") {
            ctx.methodInsn(182, "yeti/lang/Num", "toBigDecimal", "()Ljava/math/BigDecimal;");
            return;
        }
        String string7 = null;
        if (string2.startsWith("Ljava/lang/")) {
            string7 = yType2.javaType.className();
            ctx.typeInsn(187, string7);
            ctx.insn(90);
            ctx.insn(95);
            string2 = string2.substring(11, 12);
        }
        JavaExpr.convertNum(ctx, string2);
        if (string7 != null) {
            ctx.visitInit(string7, "(" + string2 + ")V");
        }
    }

    private static void convertNum(Ctx ctx, String string2) {
        String string3 = null;
        switch (string2.charAt(0)) {
            case 'B': {
                string3 = "byteValue";
                break;
            }
            case 'D': {
                string3 = "doubleValue";
                break;
            }
            case 'F': {
                string3 = "floatValue";
                break;
            }
            case 'I': {
                string3 = "intValue";
                break;
            }
            case 'L': {
                if (string2 == "Lyeti/lang/Num;") {
                    return;
                }
            }
            case 'J': {
                string3 = "longValue";
                break;
            }
            case 'S': {
                string3 = "shortValue";
            }
        }
        ctx.methodInsn(182, "yeti/lang/Num", string3, "()" + string2);
    }

    void visitInvoke(Ctx ctx, int n) {
        ctx.methodInsn(n, this.method.classType.javaType.className(), this.method.name, this.method.descr(null));
    }

    void genCall(Ctx ctx, BindRef[] bindRefArray, int n) {
        int n2;
        for (n2 = 0; n2 < this.args.length; ++n2) {
            JavaExpr.convertedArg(ctx, this.args[n2], this.method.arguments[n2], this.line);
        }
        if (bindRefArray != null) {
            for (n2 = 0; n2 < bindRefArray.length; ++n2) {
                BindRef bindRef = bindRefArray[n2];
                CaptureWrapper captureWrapper = bindRef.capture();
                if (captureWrapper == null) {
                    bindRef.gen(ctx);
                    ctx.captureCast(bindRef.captureType());
                    continue;
                }
                captureWrapper.genPreGet(ctx);
            }
        }
        ctx.visitLine(this.line);
        this.visitInvoke(ctx, n);
        JavaType javaType = this.method.returnType.javaType;
        if (javaType != null && javaType.description.charAt(0) == 'L') {
            ctx.forceType(javaType.className());
        }
    }

    static void convertedArg(Ctx ctx, Code code, YType yType, int n) {
        yType = yType.deref();
        if (yType.type == 13) {
            String string2 = yType.javaType.description;
            if (string2 == "I" || string2 == "J") {
                code.genInt(ctx, n, string2 == "J");
                return;
            }
        }
        if (JavaExpr.genRawArg(ctx, code, yType, n)) {
            JavaExpr.convert(ctx, code.type, yType);
        } else if (yType.type == 2) {
            JavaExpr.convertValue(ctx, code.type.deref());
        }
    }

    private static boolean genRawArg(Ctx ctx, Code code, YType yType, int n) {
        String string2;
        YType yType2 = code.type.deref();
        String string3 = string2 = yType.javaType == null ? null : yType.javaType.description;
        if (string2 == "Z") {
            Label label = new Label();
            Label label2 = new Label();
            code.genIf(ctx, label2, false);
            ctx.intConst(1);
            ctx.jumpInsn(167, label);
            ctx.visitLabel(label2);
            ctx.intConst(0);
            ctx.visitLabel(label);
            return false;
        }
        code.gen(ctx);
        if (yType2.type == 1) {
            if (!(code instanceof UnitConstant)) {
                ctx.insn(87);
                ctx.insn(1);
            }
            return false;
        }
        ctx.visitLine(n);
        if (string2 == "C") {
            ctx.typeInsn(192, "java/lang/String");
            ctx.intConst(0);
            ctx.methodInsn(182, "java/lang/String", "charAt", "(I)C");
            return false;
        }
        if (yType.type == 14 && yType2.type == 2) {
            ctx.typeInsn(192, "java/lang/String");
            ctx.methodInsn(182, "java/lang/String", "toCharArray", "()[C");
            return false;
        }
        if (code instanceof StringConstant || code instanceof ConcatStrings) {
            return false;
        }
        if (yType.type == 10 && yType2.type == 14) {
            boolean bl;
            String string4 = yType2.param[0].javaType.description;
            if (string4.length() == 1) {
                String string5 = "[".concat(string4);
                ctx.typeInsn(192, string5);
                ctx.methodInsn(184, "yeti/lang/PArray", "wrap", "(" + string5 + ")Lyeti/lang/AList;");
                return false;
            }
            Label label = new Label();
            Label label3 = new Label();
            ctx.typeInsn(192, "[Ljava/lang/Object;");
            ctx.insn(89);
            ctx.jumpInsn(198, label);
            boolean bl2 = bl = yType.param[1].deref().type == 6;
            if (bl) {
                ctx.insn(89);
                ctx.insn(190);
                ctx.jumpInsn(153, label);
            }
            if (bl && yType.param[0].deref().type == 2) {
                ctx.methodInsn(184, "yeti/lang/MList", "ofStrArray", "([Ljava/lang/Object;)Lyeti/lang/MList;");
            } else {
                ctx.typeInsn(187, "yeti/lang/MList");
                ctx.insn(90);
                ctx.insn(95);
                ctx.visitInit("yeti/lang/MList", "([Ljava/lang/Object;)V");
            }
            ctx.jumpInsn(167, label3);
            ctx.visitLabel(label);
            ctx.insn(87);
            if (bl) {
                ctx.insn(1);
            } else {
                ctx.typeInsn(187, "yeti/lang/MList");
                ctx.insn(89);
                ctx.visitInit("yeti/lang/MList", "()V");
            }
            ctx.visitLabel(label3);
            return false;
        }
        return yType.type == 13 || yType.type == 14;
    }

    static void genValue(Ctx ctx, Code code, YType yType, int n) {
        JavaExpr.genRawArg(ctx, code, yType, n);
        if (code.type.deref().type == 3 && yType.javaType.description.length() == 1) {
            ctx.typeInsn(192, "yeti/lang/Num");
            JavaExpr.convertNum(ctx, yType.javaType.description);
        }
    }

    static void convertValue(Ctx ctx, YType yType) {
        if (yType.type != 13) {
            return;
        }
        String string2 = yType.javaType.description;
        if (string2 == "V") {
            ctx.insn(1);
        } else if (string2 == "Ljava/lang/String;") {
            Label label = new Label();
            ctx.typeInsn(192, "java/lang/String");
            ctx.insn(89);
            ctx.jumpInsn(199, label);
            ctx.insn(87);
            ctx.fieldInsn(178, "yeti/lang/Core", "UNDEF_STR", "Ljava/lang/String;");
            ctx.visitLabel(label);
        } else if (string2 == "Z") {
            Label label = new Label();
            Label label2 = new Label();
            ctx.jumpInsn(153, label);
            ctx.fieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            ctx.jumpInsn(167, label2);
            ctx.visitLabel(label);
            ctx.fieldInsn(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            ctx.visitLabel(label2);
        } else if (string2 == "B" || string2 == "S" || string2 == "I" || string2 == "J") {
            if (string2 == "B") {
                ctx.intConst(255);
                ctx.insn(126);
            }
            ctx.typeInsn(187, "yeti/lang/IntNum");
            if (string2 == "J") {
                ctx.insn(91);
                ctx.insn(91);
                ctx.insn(87);
            } else {
                ctx.insn(90);
                ctx.insn(95);
            }
            ctx.visitInit("yeti/lang/IntNum", string2 == "J" ? "(J)V" : "(I)V");
            ctx.forceType("yeti/lang/Num");
        } else if (string2 == "D" || string2 == "F") {
            ctx.typeInsn(187, "yeti/lang/FloatNum");
            if (string2 == "F") {
                ctx.insn(90);
                ctx.insn(95);
                ctx.insn(141);
            } else {
                ctx.insn(91);
                ctx.insn(91);
                ctx.insn(87);
            }
            ctx.visitInit("yeti/lang/FloatNum", "(D)V");
            ctx.forceType("yeti/lang/Num");
        } else if (string2 == "C") {
            ctx.methodInsn(184, "java/lang/String", "valueOf", "(C)Ljava/lang/String;");
            ctx.forceType("java/lang/String");
        }
    }

    void gen(Ctx ctx) {
        throw new UnsupportedOperationException();
    }
}

