/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import yeti.lang.compiler.AClosure;
import yeti.lang.compiler.BindExpr;
import yeti.lang.compiler.BindRef;
import yeti.lang.compiler.Binder;
import yeti.lang.compiler.Capture;
import yeti.lang.compiler.CaptureWrapper;
import yeti.lang.compiler.CapturingClosure;
import yeti.lang.compiler.Closure;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.CodeGen;
import yeti.lang.compiler.CompileException;
import yeti.lang.compiler.Ctx;
import yeti.lang.compiler.JavaClassNotFoundException;
import yeti.lang.compiler.JavaExpr;
import yeti.lang.compiler.JavaType;
import yeti.lang.compiler.JavaTypeReader;
import yeti.lang.compiler.LoopExpr;
import yeti.lang.compiler.NumericConstant;
import yeti.lang.compiler.SimpleCode;
import yeti.lang.compiler.YType;
import yeti.lang.compiler.YetiType;
import yeti.renamed.asm3.Opcodes;

final class JavaClass
extends CapturingClosure
implements Runnable {
    private String className;
    private String[] implement;
    private YetiType.ClassBinding parentClass;
    private List fields = new ArrayList();
    private List methods = new ArrayList();
    private Field serialVersion;
    private JavaExpr superInit;
    private final boolean isPublic;
    private boolean hasStatic;
    private int captureCount;
    private Map accessors;
    private Ctx classCtx;
    private final int cline;
    YType classType;
    final Meth constr = new Meth();
    final Binder self;
    Binder superRef;

    JavaClass(String string2, boolean bl, int n) {
        this.type = YetiType.UNIT_TYPE;
        this.className = string2;
        this.classType = new YType(13, YetiType.NO_PARAM);
        this.classType.javaType = JavaType.createNewClass(string2, this);
        this.self = new Arg(this.classType, false);
        this.constr.name = "<init>";
        this.constr.returnType = YetiType.UNIT_TYPE;
        this.constr.className = string2;
        this.constr.access = bl ? 1 : 0;
        this.isPublic = bl;
        this.cline = n;
    }

    private static int loadArg(Ctx ctx, YType yType, int n) {
        int n2 = 25;
        if (yType.type == 13) {
            switch (yType.javaType.description.charAt(0)) {
                case 'D': {
                    n2 = 24;
                    break;
                }
                case 'F': {
                    n2 = 23;
                    break;
                }
                case 'J': {
                    n2 = 22;
                    break;
                }
                case 'L': {
                    break;
                }
                default: {
                    n2 = 21;
                }
            }
        }
        ctx.varInsn(n2, n);
        return n2 == 24 ? 2 : 1;
    }

    static void genRet(Ctx ctx, YType yType) {
        int n = 176;
        if (yType.type == 13) {
            switch (yType.javaType.description.charAt(0)) {
                case 'D': {
                    n = 175;
                    break;
                }
                case 'F': {
                    n = 174;
                    break;
                }
                case 'J': {
                    n = 173;
                    break;
                }
                case 'L': {
                    break;
                }
                case 'V': {
                    n = 177;
                    break;
                }
                default: {
                    n = 172;
                }
            }
        }
        ctx.insn(n);
    }

    void init(YetiType.ClassBinding classBinding, String[] stringArray) {
        this.implement = stringArray;
        this.parentClass = classBinding;
        YType yType = new YType(13, YetiType.NO_PARAM);
        yType.javaType = classBinding.type.javaType.dup();
        yType.javaType.implementation = this;
        yType.javaType.publicMask = 5;
        this.superRef = new Arg(yType, true);
    }

    Meth addMethod(String string2, YType yType, String string3, int n) {
        Meth meth = new Meth();
        meth.name = string2;
        meth.returnType = yType;
        meth.className = this.className;
        int n2 = string3 == "static-method" ? 9 : (meth.access = string3 == "abstract-method" ? 1025 : 1);
        if ((meth.access & 8) != 0) {
            this.hasStatic = true;
        }
        meth.line = n;
        this.methods.add(meth);
        return meth;
    }

    Binder addField(Code code, boolean bl, String string2) {
        Field field;
        if (string2 == "serialVersionUID" && !bl && this.serialVersion == null && code instanceof NumericConstant) {
            this.serialVersion = field = new Field(string2, code, false);
        } else {
            field = new Field("$" + this.fields.size(), code, bl);
        }
        this.fields.add(field);
        return field;
    }

    public BindRef refProxy(BindRef bindRef) {
        if (bindRef.flagop(32)) {
            return bindRef;
        }
        if (!this.isPublic) {
            return this.captureRef(bindRef);
        }
        bindRef.forceDirect();
        return bindRef;
    }

    void superInit(JavaType.Method method, Code[] codeArray, int n) {
        this.superInit = new JavaExpr(null, method, codeArray, n);
    }

    void close() throws JavaClassNotFoundException {
        this.constr.init();
        JavaTypeReader javaTypeReader = new JavaTypeReader();
        javaTypeReader.constructors.add(this.constr);
        int n = this.methods.size();
        for (int i = 0; i < n; ++i) {
            Meth meth = (Meth)this.methods.get(i);
            meth.init();
            ((meth.access & 8) != 0 ? javaTypeReader.staticMethods : javaTypeReader.methods).add(meth);
        }
        javaTypeReader.parent = this.parentClass.type.javaType;
        javaTypeReader.className = this.className;
        javaTypeReader.interfaces = this.implement;
        javaTypeReader.access = this.isPublic ? 1 : 0;
        this.classType.javaType.publicMask = 5;
        this.classType.javaType.resolve(javaTypeReader);
    }

    BindRef[] getCaptures() {
        this.captureCount = this.mergeCaptures(null, true);
        BindRef[] bindRefArray = new BindRef[this.captureCount];
        int n = 0;
        Capture capture = this.captures;
        while (capture != null) {
            bindRefArray[n++] = capture.ref;
            capture = capture.next;
        }
        return bindRefArray;
    }

    void captureInit(Ctx ctx, Capture capture, int n) {
        capture.id = "_" + n;
        capture.localVar = n + this.constr.args.size() + 1;
    }

    String getAccessor(JavaType.Method method, String string2, boolean bl) {
        Object[] objectArray;
        if (this.accessors == null) {
            this.accessors = new HashMap();
        }
        String string3 = method.sig;
        if (bl) {
            string3 = "*".concat(method.sig);
        }
        if ((objectArray = (Object[])this.accessors.get(string3)) == null) {
            objectArray = new Object[]{"access$" + this.accessors.size(), method, string2, bl ? "" : null};
            this.accessors.put(method.sig, objectArray);
        }
        return (String)objectArray[0];
    }

    String getAccessor(JavaType.Field field, String string2, boolean bl) {
        Object[] objectArray;
        String string3 = (bl ? "{" : "}").concat(field.name);
        if (this.accessors == null) {
            this.accessors = new HashMap();
        }
        if ((objectArray = (Object[])this.accessors.get(string3)) == null) {
            objectArray = new Object[]{"access$" + this.accessors.size(), field, string2, bl ? "" : null, null};
            this.accessors.put(string3, objectArray);
        }
        return (String)objectArray[0];
    }

    void gen(Ctx ctx) {
        int n;
        this.constr.captures = this.captures;
        ctx.insn(1);
        Ctx ctx2 = ctx.newClass(this.classType.javaType.access | 0x20, this.className, this.parentClass.type.javaType.className(), this.implement, this.cline);
        ctx2.fieldCounter = this.captureCount;
        int n2 = this.methods.size();
        for (n = 0; n < n2; ++n) {
            ctx2.usedMethodNames.put(((Meth)this.methods.get((int)n)).name, null);
        }
        if (!this.isPublic) {
            ctx2.markInnerClass(ctx.constants.ctx, 8);
        }
        Ctx ctx3 = ctx2.newMethod(this.constr.access, "<init>", this.constr.descr(null));
        if (this.isPublic && !this.hasStatic) {
            ctx3.methodInsn(184, ctx.className, "init", "()V");
        }
        this.constr.convertArgs(ctx3);
        this.genClosureInit(ctx3);
        this.superInit.genCall(ctx3.load(0), this.parentClass.getCaptures(), 183);
        int n3 = this.constr.arguments.length;
        Opcodes opcodes = this.captures;
        while (opcodes != null) {
            ((Capture)opcodes).localVar = -1;
            ctx2.cw.visitField(18, ((Capture)opcodes).id, ((Capture)opcodes).captureType(), null, null).visitEnd();
            ctx3.load(0).load(++n3).fieldInsn(181, this.className, ((Capture)opcodes).id, ((Capture)opcodes).captureType());
            opcodes = ((Capture)opcodes).next;
        }
        n2 = this.fields.size();
        for (n = 0; n < n2; ++n) {
            ((Code)this.fields.get(n)).gen(ctx3);
        }
        ctx3.insn(177);
        ctx3.closeMethod();
        n2 = this.methods.size();
        for (n = 0; n < n2; ++n) {
            ((Meth)this.methods.get(n)).gen(ctx2);
        }
        if (this.isPublic && this.hasStatic) {
            opcodes = ctx2.newMethod(8, "<clinit>", "()V");
            ((Ctx)opcodes).methodInsn(184, ctx.className, "init", "()V");
            ((Ctx)opcodes).insn(177);
            ((Ctx)opcodes).closeMethod();
        }
        this.classCtx = ctx2;
        ctx.compilation.postGen.add(this);
    }

    public void run() {
        if (this.accessors == null) {
            return;
        }
        Iterator iterator = this.accessors.values().iterator();
        while (iterator.hasNext()) {
            int n;
            int n2;
            Object[] objectArray = (Object[])iterator.next();
            int n3 = 8;
            JavaType.Method method = null;
            if (objectArray.length == 4) {
                method = (JavaType.Method)objectArray[1];
                n3 = method.access & 8;
            }
            Ctx ctx = this.classCtx.newMethod(n3 | 0x1000, (String)objectArray[0], (String)objectArray[2]);
            if (method != null) {
                int n4 = 0;
                n2 = 184;
                if ((n3 & 8) == 0) {
                    n2 = objectArray[3] == null ? 182 : 183;
                    n4 = 1;
                    ctx.load(0);
                }
                for (n = 0; n < method.arguments.length; n += JavaClass.loadArg(ctx, method.arguments[n], n + n4)) {
                }
                ctx.methodInsn(n2, objectArray[3] == null ? this.className : this.parentClass.type.javaType.className(), method.name, method.descr(null));
                JavaClass.genRet(ctx, method.returnType);
            } else {
                JavaType.Field field = (JavaType.Field)objectArray[1];
                n2 = 178;
                n = 0;
                if ((field.access & 8) == 0) {
                    ctx.load(n++);
                    n2 = 180;
                }
                if (objectArray[3] != null) {
                    ctx.load(n);
                    n2 = n2 == 180 ? 181 : 179;
                }
                ctx.fieldInsn(n2, this.className, field.name, JavaType.descriptionOf(field.type));
                if (objectArray[3] != null) {
                    ctx.insn(177);
                } else {
                    JavaClass.genRet(ctx, field.type);
                }
            }
            ctx.closeMethod();
        }
    }

    final class Field
    extends Code
    implements Binder,
    CaptureWrapper,
    CodeGen {
        private String name;
        private String javaType;
        private String descr;
        Code value;
        private final boolean var;
        private int access = 2;
        private boolean directConst;

        Field(String string2, Code code, boolean bl) {
            this.name = string2;
            this.value = code;
            this.var = bl;
        }

        public void genPreGet(Ctx ctx) {
            if (!this.directConst) {
                ctx.load(0);
            }
        }

        public void genGet(Ctx ctx) {
            if (this.directConst) {
                this.value.gen(ctx);
            } else {
                ctx.fieldInsn(180, JavaClass.this.className, this.name, this.descr);
            }
        }

        public void genSet(Ctx ctx, Code code) {
            code.gen(ctx);
            ctx.typeInsn(192, this.javaType);
            ctx.fieldInsn(181, JavaClass.this.className, this.name, this.descr);
        }

        public Object captureIdentity() {
            return JavaClass.this;
        }

        public String captureType() {
            return JavaClass.this.classType.javaType.description;
        }

        public void gen2(Ctx ctx, Code code, int n) {
            this.genPreGet(ctx);
            this.genSet(ctx, code);
            ctx.insn(1);
        }

        public BindRef getRef(int n) {
            if (this.javaType == null) {
                if (this.name == "_") {
                    throw new IllegalStateException("NO _ REF");
                }
                this.javaType = Code.javaType(this.value.type);
                this.descr = 'L' + this.javaType + ';';
            }
            BindRef bindRef = new BindRef(){

                void gen(Ctx ctx) {
                    Field.this.genPreGet(ctx);
                    Field.this.genGet(ctx);
                }

                Code assign(Code code) {
                    return Field.this.var ? new SimpleCode(Field.this, code, null, 0) : null;
                }

                boolean flagop(int n) {
                    return (n & 4) != 0 && Field.this.var || (n & 0x21) != 0 && Field.this.directConst || (n & 2) != 0 && !Field.this.var;
                }

                CaptureWrapper capture() {
                    if (!Field.this.var) {
                        return null;
                    }
                    Field.this.access = 4096;
                    return Field.this;
                }
            };
            bindRef.type = this.value.type;
            bindRef.binder = this;
            return bindRef;
        }

        void gen(Ctx ctx) {
            if (this == JavaClass.this.serialVersion) {
                Long l2 = new Long(((NumericConstant)this.value).num.longValue());
                ctx.cw.visitField(26, this.name, "J", null, l2);
                this.directConst = true;
            } else if (this.javaType == null) {
                this.value.gen(ctx);
                ctx.insn(87);
            } else if (!this.var && this.value.prepareConst(ctx)) {
                this.directConst = true;
            } else {
                ctx.cw.visitField(this.var ? this.access : this.access | 0x10, this.name, this.descr, null, null).visitEnd();
                this.genPreGet(ctx);
                this.genSet(ctx, this.value);
            }
        }
    }

    static class Meth
    extends JavaType.Method
    implements Closure {
        private List args = new ArrayList();
        private AClosure closure = new LoopExpr();
        private int line;
        Capture captures;
        Code code;

        Meth() {
        }

        Binder addArg(YType yType) {
            Arg arg = new Arg(yType, false);
            this.args.add(arg);
            arg.argn = (this.access & 8) == 0 ? this.args.size() : this.args.size() - 1;
            return arg;
        }

        public BindRef refProxy(BindRef bindRef) {
            return bindRef;
        }

        public void addVar(BindExpr bindExpr) {
            this.closure.addVar(bindExpr);
        }

        void init() {
            this.arguments = new YType[this.args.size()];
            for (int i = 0; i < this.arguments.length; ++i) {
                Arg arg = (Arg)this.args.get(i);
                this.arguments[i] = arg.javaType;
            }
            this.sig = this.name.concat(super.descr(null));
            this.descr = null;
        }

        String descr(String string2) {
            if (this.descr != null) {
                return this.descr;
            }
            StringBuffer stringBuffer = new StringBuffer();
            Capture capture = this.captures;
            while (capture != null) {
                stringBuffer.append(capture.captureType());
                capture = capture.next;
            }
            return super.descr(stringBuffer.toString());
        }

        void convertArgs(Ctx ctx) {
            int n;
            int n2 = n = (this.access & 8) == 0 ? 1 : 0;
            for (int i = 0; i < this.arguments.length; ++i) {
                String string2;
                ++n2;
                if (this.arguments[i].type != 13 || (string2 = this.arguments[i].javaType.description) != "Ljava/lang/String;" && string2.charAt(0) == 'L') continue;
                --n2;
                n2 += JavaClass.loadArg(ctx, this.arguments[i], n2);
                JavaExpr.convertValue(ctx, this.arguments[i]);
                ctx.varInsn(58, i + n);
            }
            ctx.localVarCount = n2;
        }

        void gen(Ctx ctx) {
            ctx = ctx.newMethod(this.access, this.name, this.descr(null));
            if ((this.access & 0x400) != 0) {
                ctx.closeMethod();
                return;
            }
            this.convertArgs(ctx);
            this.closure.genClosureInit(ctx);
            JavaExpr.convertedArg(ctx, this.code, this.returnType, this.line);
            if (this.returnType.type == 1) {
                ctx.insn(87);
                ctx.insn(177);
            } else {
                JavaClass.genRet(ctx, this.returnType);
            }
            ctx.closeMethod();
        }
    }

    static class Arg
    extends BindRef
    implements Binder {
        int argn;
        final YType javaType;
        private boolean isSuper;

        Arg(YType yType, boolean bl) {
            this.javaType = yType;
            this.type = JavaType.convertValueType(yType);
            this.isSuper = bl;
            this.binder = this;
        }

        public BindRef getRef(int n) {
            if (this.isSuper && n >= 0) {
                throw new CompileException(n, 0, "super cannot be used as a value");
            }
            return this;
        }

        void gen(Ctx ctx) {
            ctx.load(this.argn);
            if (this.javaType.type == 14) {
                ctx.forceType(JavaType.descriptionOf(this.javaType));
            } else if (this.javaType.javaType.description.charAt(0) == 'L') {
                ctx.forceType(this.javaType.javaType.className());
            }
        }

        boolean flagop(int n) {
            return (n & 0x40) != 0 && this.argn == 0;
        }
    }
}

