/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import yeti.lang.compiler.ClassDir;
import yeti.lang.compiler.ClassJar;
import yeti.lang.compiler.ClassPathItem;
import yeti.lang.compiler.JavaNode;
import yeti.lang.compiler.JavaSource;
import yeti.lang.compiler.JavaTypeReader;
import yeti.renamed.asm3.ClassReader;

class ClassFinder {
    private final ClassPathItem[] classPath;
    private final ClassPathItem destDir;
    private Map defined = new HashMap();
    final Map parsed = new HashMap();
    final Map existsCache = new HashMap();
    final String pathStr;

    ClassFinder(String string2) {
        this(string2.split(File.pathSeparator), null);
    }

    ClassFinder(String[] stringArray, String string2) {
        this.classPath = new ClassPathItem[stringArray.length];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            ClassPathItem classPathItem = this.classPath[i] = stringArray[i].endsWith(".jar") ? new ClassJar(stringArray[i]) : new ClassDir(stringArray[i]);
            if (i != 0) {
                stringBuffer.append(File.pathSeparator);
            }
            stringBuffer.append(stringArray[i]);
        }
        this.pathStr = stringBuffer.toString();
        this.destDir = string2 == null ? null : new ClassDir(string2);
    }

    public InputStream findClass(String string2, long[] lArray) {
        InputStream inputStream;
        Object v2 = this.defined.get(string2);
        if (v2 != null && lArray != null) {
            lArray[0] = 0L;
            return new ByteArrayInputStream((byte[])v2);
        }
        for (int i = 0; i < this.classPath.length; ++i) {
            try {
                inputStream = this.classPath[i].getStream(string2, lArray);
                if (inputStream == null) continue;
                return inputStream;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        inputStream = classLoader != null ? classLoader.getResourceAsStream(string2) : null;
        return inputStream != null ? inputStream : this.getClass().getClassLoader().getResourceAsStream(string2);
    }

    public void define(String string2, byte[] byArray) {
        this.defined.put(string2, byArray);
    }

    boolean exists(String string2) {
        InputStream inputStream;
        if (this.parsed.containsKey(string2)) {
            return true;
        }
        Boolean bl = (Boolean)this.existsCache.get(string2);
        if (bl != null) {
            return bl;
        }
        String string3 = string2.concat(".class");
        boolean bl2 = false;
        for (int i = 0; i < this.classPath.length; ++i) {
            if (!this.classPath[i].exists(string3)) continue;
            bl2 = true;
            break;
        }
        ClassLoader classLoader = null;
        if (!bl2 && (classLoader = Thread.currentThread().getContextClassLoader()) == null && string2.startsWith("java")) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(string3)) != null) {
            bl2 = true;
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.existsCache.put(string2, bl2);
        return bl2;
    }

    JavaTypeReader readClass(String string2) {
        JavaTypeReader javaTypeReader = new JavaTypeReader();
        javaTypeReader.className = string2;
        Object v2 = this.parsed.get(string2);
        if (v2 != null) {
            JavaSource.loadClass(this, javaTypeReader, (JavaNode)v2);
            return javaTypeReader;
        }
        String string3 = string2.concat(".class");
        InputStream inputStream = this.findClass(string3, null);
        if (inputStream == null) {
            try {
                if (this.destDir == null) {
                    return null;
                }
                inputStream = this.destDir.getStream(string3, null);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        try {
            new ClassReader(inputStream).accept(javaTypeReader, null, 5);
        }
        catch (IOException iOException) {
            return null;
        }
        return javaTypeReader;
    }
}

