/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import yeti.lang.compiler.BindExpr;
import yeti.lang.compiler.BindRef;
import yeti.lang.compiler.BindWrapper;
import yeti.lang.compiler.CaptureRef;
import yeti.lang.compiler.CaptureWrapper;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.CodeGen;
import yeti.lang.compiler.Ctx;
import yeti.lang.compiler.SimpleCode;

final class Capture
extends CaptureRef
implements CaptureWrapper,
CodeGen {
    String id;
    Capture next;
    CaptureWrapper wrapper;
    Object identity;
    int localVar = -1;
    boolean uncaptured;
    boolean ignoreGet;
    private String refType;

    Capture() {
    }

    void gen(Ctx ctx) {
        if (this.uncaptured) {
            this.ref.gen(ctx);
            return;
        }
        this.genPreGet(ctx);
        this.genGet(ctx);
    }

    String getId(Ctx ctx) {
        if (this.id == null) {
            this.id = "_".concat(Integer.toString(ctx.fieldCounter++));
        }
        return this.id;
    }

    boolean flagop(int n) {
        if (n == 32 && !this.uncaptured) {
            this.uncaptured = this.ref.flagop(n);
            return this.uncaptured;
        }
        return (n & 0x26) != 0 && this.ref.flagop(n);
    }

    public void gen2(Ctx ctx, Code code, int n) {
        if (this.uncaptured) {
            this.ref.assign(code).gen(ctx);
        } else {
            this.genPreGet(ctx);
            this.wrapper.genSet(ctx, code);
            ctx.insn(1);
        }
    }

    Code assign(Code code) {
        if (!this.ref.flagop(4)) {
            return null;
        }
        return new SimpleCode(this, code, null, 0);
    }

    public void genPreGet(Ctx ctx) {
        if (this.uncaptured) {
            this.wrapper.genPreGet(ctx);
        } else if (this.localVar < 0) {
            ctx.load(0);
            if (this.localVar < -1) {
                String string2;
                ctx.intConst(-2 - this.localVar);
                ctx.insn(50);
                if (this.wrapper != null && (string2 = this.wrapper.captureType()) != null) {
                    ctx.captureCast(string2);
                }
            } else {
                ctx.fieldInsn(180, ctx.className, this.id, this.captureType());
            }
        } else {
            ctx.load(this.localVar);
            if (!this.ignoreGet) {
                ctx.forceType(this.captureType().charAt(0) == '[' ? this.refType : this.refType.substring(1, this.refType.length() - 1));
            }
        }
    }

    public void genGet(Ctx ctx) {
        if (this.wrapper != null && !this.ignoreGet) {
            this.wrapper.genGet(ctx);
        }
    }

    public void genSet(Ctx ctx, Code code) {
        this.wrapper.genSet(ctx, code);
    }

    public CaptureWrapper capture() {
        if (this.uncaptured) {
            return this.ref.capture();
        }
        return this.wrapper == null ? null : this;
    }

    public Object captureIdentity() {
        return this.wrapper == null ? this : this.wrapper.captureIdentity();
    }

    public String captureType() {
        if (this.refType == null) {
            if (this.wrapper != null) {
                this.refType = this.wrapper.captureType();
                if (this.refType == null) {
                    throw new IllegalStateException("captureType:" + this.wrapper);
                }
            } else {
                this.refType = this.origin != null ? ((BindExpr)this.binder).captureType() : 'L' + Capture.javaType(this.ref.type) + ';';
            }
        }
        return this.refType;
    }

    void captureGen(Ctx ctx) {
        if (this.wrapper == null) {
            this.ref.gen(ctx);
        } else {
            this.wrapper.genPreGet(ctx);
        }
        ctx.captureCast(this.captureType());
    }

    BindRef unshare() {
        return new BindWrapper(this);
    }
}

