/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import yeti.lang.compiler.Argv;
import yeti.lang.compiler.BindRef;
import yeti.lang.compiler.Binder;
import yeti.lang.compiler.BooleanConstant;
import yeti.lang.compiler.Compose;
import yeti.lang.compiler.Cons;
import yeti.lang.compiler.Escape;
import yeti.lang.compiler.For;
import yeti.lang.compiler.Head;
import yeti.lang.compiler.InOpFun;
import yeti.lang.compiler.IsDefined;
import yeti.lang.compiler.IsEmpty;
import yeti.lang.compiler.IsNullPtr;
import yeti.lang.compiler.LazyCons;
import yeti.lang.compiler.Length;
import yeti.lang.compiler.MatchOpFun;
import yeti.lang.compiler.Negate;
import yeti.lang.compiler.NotOp;
import yeti.lang.compiler.Same;
import yeti.lang.compiler.StaticRef;
import yeti.lang.compiler.StrChar;
import yeti.lang.compiler.Synchronized;
import yeti.lang.compiler.Tail;
import yeti.lang.compiler.Throw;
import yeti.lang.compiler.UnitConstant;
import yeti.lang.compiler.YetiType;

final class BuiltIn
implements Binder {
    int op;

    public BuiltIn(int n) {
        this.op = n;
    }

    static BindRef undef_str(Binder binder, int n) {
        return new StaticRef("yeti/lang/Core", "UNDEF_STR", YetiType.STR_TYPE, binder, true, n);
    }

    public BindRef getRef(int n) {
        BindRef bindRef = null;
        switch (this.op) {
            case 1: {
                bindRef = new Argv();
                bindRef.type = YetiType.STRING_ARRAY;
                break;
            }
            case 2: {
                bindRef = new InOpFun(n);
                break;
            }
            case 3: {
                bindRef = new Cons(n);
                break;
            }
            case 4: {
                bindRef = new LazyCons(n);
                break;
            }
            case 5: {
                bindRef = new For(n);
                break;
            }
            case 6: {
                bindRef = new Compose(n);
                break;
            }
            case 7: {
                bindRef = new Synchronized(n);
                break;
            }
            case 8: {
                bindRef = new IsNullPtr(YetiType.A_TO_BOOL, "nullptr$q", n);
                break;
            }
            case 9: {
                bindRef = new IsDefined(n);
                break;
            }
            case 10: {
                bindRef = new IsEmpty(n);
                break;
            }
            case 11: {
                bindRef = new Head(n);
                break;
            }
            case 12: {
                bindRef = new Tail(n);
                break;
            }
            case 13: {
                bindRef = new MatchOpFun(n, true);
                break;
            }
            case 14: {
                bindRef = new MatchOpFun(n, false);
                break;
            }
            case 15: {
                bindRef = new NotOp(n);
                break;
            }
            case 16: {
                bindRef = new StrChar(n);
                break;
            }
            case 17: {
                bindRef = new UnitConstant(YetiType.BOOL_TYPE);
                break;
            }
            case 18: {
                bindRef = new BooleanConstant(false);
                break;
            }
            case 19: {
                bindRef = new BooleanConstant(true);
                break;
            }
            case 20: {
                bindRef = new Negate();
                break;
            }
            case 21: {
                bindRef = new Same();
                break;
            }
            case 22: {
                bindRef = new StaticRef("yeti/lang/Core", "RANDINT", YetiType.NUM_TO_NUM, this, true, n);
                break;
            }
            case 23: {
                bindRef = BuiltIn.undef_str(this, n);
                break;
            }
            case 24: {
                bindRef = new Escape(n);
                break;
            }
            case 25: {
                bindRef = new Length();
                break;
            }
            case 26: {
                bindRef = new Throw(n);
            }
        }
        bindRef.binder = this;
        return bindRef;
    }
}

