/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.math.BigInteger;
import yeti.lang.IntNum;
import yeti.lang.Num;
import yeti.lang.RatNum;

public final class FloatNum
extends Num {
    private final double v;

    public FloatNum(double d2) {
        this.v = d2;
    }

    public Num add(Num num) {
        return new FloatNum(this.v + num.doubleValue());
    }

    public Num add(long l2) {
        return new FloatNum(this.v + (double)l2);
    }

    public Num add(RatNum ratNum) {
        return new FloatNum(this.v + ratNum.doubleValue());
    }

    public Num add(BigInteger bigInteger) {
        return new FloatNum(this.v + bigInteger.doubleValue());
    }

    public Num mul(Num num) {
        return new FloatNum(this.v * num.doubleValue());
    }

    public Num mul(long l2) {
        return new FloatNum(this.v * (double)l2);
    }

    public Num mul(RatNum ratNum) {
        return new FloatNum(this.v * ratNum.doubleValue());
    }

    public Num mul(BigInteger bigInteger) {
        return new FloatNum(this.v * bigInteger.doubleValue());
    }

    public Num div(Num num) {
        return new FloatNum(this.v / num.doubleValue());
    }

    public Num div(long l2) {
        return new FloatNum(this.v / (double)l2);
    }

    public Num divFrom(long l2) {
        return new FloatNum((double)l2 / this.v);
    }

    public Num divFrom(RatNum ratNum) {
        return new FloatNum(ratNum.doubleValue() / this.v);
    }

    public Num intDiv(Num num) {
        double d2 = (this.v >= 0.0 ? Math.floor(this.v) : Math.ceil(this.v)) / num.doubleValue();
        return d2 > 2.147483647E9 || d2 < -2.147483647E9 ? new FloatNum(d2 >= 0.0 ? Math.floor(d2) : Math.ceil(d2)) : new IntNum((long)d2);
    }

    public Num intDiv(int n) {
        double d2 = (this.v >= 0.0 ? Math.floor(this.v) : Math.ceil(this.v)) / (double)n;
        return d2 > 2.147483647E9 || d2 < -2.147483647E9 ? new FloatNum(d2 >= 0.0 ? Math.floor(d2) : Math.ceil(d2)) : new IntNum((long)d2);
    }

    public Num intDivFrom(long l2) {
        return new IntNum((long)((double)l2 / (this.v >= 0.0 ? Math.floor(this.v) : Math.ceil(this.v))));
    }

    public Num intDivFrom(BigInteger bigInteger) {
        double d2 = bigInteger.doubleValue() / (this.v >= 0.0 ? Math.floor(this.v) : Math.ceil(this.v));
        return d2 > 2.147483647E9 || d2 < -2.147483647E9 ? new FloatNum(d2 >= 0.0 ? Math.floor(d2) : Math.ceil(d2)) : new IntNum((long)d2);
    }

    public Num rem(Num num) {
        return new IntNum((long)this.v % num.longValue());
    }

    public Num rem(int n) {
        return new IntNum((long)this.v % (long)n);
    }

    public Num remFrom(long l2) {
        return new IntNum(l2 % (long)this.v);
    }

    public Num remFrom(BigInteger bigInteger) {
        double d2 = bigInteger.doubleValue() % (this.v >= 0.0 ? Math.floor(this.v) : Math.ceil(this.v));
        return d2 > 2.147483647E9 || d2 < -2.147483647E9 ? new FloatNum(d2 >= 0.0 ? Math.floor(d2) : Math.ceil(d2)) : new IntNum((long)d2);
    }

    public Num sub(Num num) {
        return new FloatNum(this.v - num.doubleValue());
    }

    public Num sub(long l2) {
        return new FloatNum(this.v - (double)l2);
    }

    public Num subFrom(long l2) {
        return new FloatNum((double)l2 - this.v);
    }

    public Num subFrom(RatNum ratNum) {
        return new FloatNum(ratNum.doubleValue() - this.v);
    }

    public Num subFrom(BigInteger bigInteger) {
        return new FloatNum(bigInteger.doubleValue() - this.v);
    }

    public Num and(Num num) {
        return new IntNum(num.longValue() & (long)this.v);
    }

    public Num and(BigInteger bigInteger) {
        return new IntNum(bigInteger.longValue() & (long)this.v);
    }

    public Num or(Num num) {
        return num.or((long)this.v);
    }

    public Num or(long l2) {
        return new IntNum(l2 | (long)this.v);
    }

    public Num xor(Num num) {
        return num.xor((long)this.v);
    }

    public Num xor(long l2) {
        return new IntNum(l2 ^ (long)this.v);
    }

    public byte byteValue() {
        return (byte)this.v;
    }

    public short shortValue() {
        return (short)this.v;
    }

    public int intValue() {
        return (int)this.v;
    }

    public long longValue() {
        return (long)this.v;
    }

    public float floatValue() {
        return (float)this.v;
    }

    public double doubleValue() {
        return this.v;
    }

    public int compareTo(Object object) {
        double d2 = ((Number)object).doubleValue();
        return this.v < d2 ? -1 : (this.v > d2 ? 1 : 0);
    }

    public int rCompare(long l2) {
        return this.v < (double)l2 ? 1 : (this.v > (double)l2 ? -1 : 0);
    }

    public int rCompare(RatNum ratNum) {
        double d2 = ratNum.doubleValue();
        return this.v < d2 ? 1 : (this.v > d2 ? -1 : 0);
    }

    public int rCompare(BigInteger bigInteger) {
        double d2 = bigInteger.doubleValue();
        return this.v < d2 ? 1 : (this.v > d2 ? -1 : 0);
    }

    public String toString() {
        return Double.toString(this.v);
    }

    public int hashCode() {
        long l2 = (long)this.v;
        long l3 = Double.doubleToLongBits(this.v - (double)l2);
        if (l3 != Long.MIN_VALUE) {
            l2 ^= l3;
        }
        return (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(Object object) {
        return object instanceof Num && this.v == ((Num)object).doubleValue();
    }
}

