/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import yeti.lang.compiler.BinOpRef;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.CodeGen;
import yeti.lang.compiler.CompileException;
import yeti.lang.compiler.Ctx;
import yeti.lang.compiler.SimpleCode;
import yeti.lang.compiler.StringConstant;
import yeti.lang.compiler.YType;
import yeti.lang.compiler.YetiType;
import yeti.renamed.asmx.Label;

final class MatchOpFun
extends BinOpRef
implements CodeGen {
    private int line;
    private boolean yes;

    MatchOpFun(int n, boolean bl) {
        this.type = YetiType.STR2_PRED_TYPE;
        this.coreFun = MatchOpFun.mangle(bl ? "=~" : "!~");
        this.line = n;
        this.yes = bl;
    }

    void binGen(Ctx ctx, Code code, Code code2) {
        this.apply2nd(code2, YetiType.STR2_PRED_TYPE, this.line).gen(ctx);
        ctx.visitApply(code, this.line);
    }

    public void gen2(Ctx ctx, Code code, int n) {
        ctx.typeInsn(187, "yeti/lang/Match");
        ctx.insn(89);
        code.gen(ctx);
        ctx.intConst(this.yes ? 1 : 0);
        ctx.visitLine(n);
        ctx.visitInit("yeti/lang/Match", "(Ljava/lang/Object;Z)V");
    }

    Code apply2nd(final Code code, final YType yType, int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        final SimpleCode simpleCode = new SimpleCode(this, code, yType, n);
        if (!(code instanceof StringConstant)) {
            return simpleCode;
        }
        try {
            Pattern.compile(((StringConstant)code).str, 32);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new CompileException(n, 0, "Bad pattern syntax: " + patternSyntaxException.getMessage());
        }
        return new Code(){
            {
                this.type = yType;
            }

            void gen(Ctx ctx) {
                ctx.constant((MatchOpFun.this.yes ? "MATCH-FUN:" : "MATCH!FUN:").concat(((StringConstant)code).str), simpleCode);
            }
        };
    }

    void binGenIf(Ctx ctx, Code code, Code code2, Label label, boolean bl) {
        this.binGen(ctx, code, code2);
        ctx.fieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
        ctx.jumpInsn(bl ? 165 : 166, label);
    }
}

