/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import yeti.lang.compiler.ClassFinder;
import yeti.lang.compiler.CompileException;
import yeti.lang.compiler.JavaNode;
import yeti.lang.compiler.JavaType;
import yeti.lang.compiler.JavaTypeReader;
import yeti.lang.compiler.YType;
import yeti.renamed.asmx.Opcodes;

class JavaSource
implements Opcodes {
    private static final String[] CHAR_SPOOL = new String[128];
    private static final Map MODS = new HashMap();
    private int p;
    private int e;
    private char[] s;
    private String lookahead;
    private String fn;
    private Map classes;
    private int line = 1;
    private final String packageName;
    private List imports = new ArrayList();
    private String[] importPackages;

    private String get(int n) {
        char c2;
        if (this.lookahead != null) {
            String string2 = this.lookahead;
            this.lookahead = null;
            return string2;
        }
        char[] cArray = this.s;
        int n2 = this.p - 1;
        int n3 = this.e;
        block0: while (true) {
            if (++n2 < n3 && (c2 = cArray[n2]) >= '\u0000' && c2 <= ' ') {
                if (c2 != '\n' && (c2 != '\r' || n2 + 1 >= n3 || cArray[n2 + 1] == '\n')) continue;
                ++this.line;
                continue;
            }
            if (n2 + 1 < n3 && cArray[n2] == '/') {
                if ((c2 = cArray[++n2]) == '/') {
                    while (++n2 < n3 && (c2 = cArray[n2]) != '\r' && c2 != '\n') {
                    }
                    --n2;
                    continue;
                }
                if (c2 == '*') {
                    ++n2;
                    while (true) {
                        if (++n2 >= n3 || (c2 = cArray[n2 - 1]) == '*' && cArray[n2] == '/') continue block0;
                        if (c2 != '\n' && (c2 != '\r' || cArray[n2] == '\n')) continue;
                        ++this.line;
                    }
                }
                --n2;
            }
            if (n2 >= n3) {
                this.p = n2;
                return null;
            }
            c2 = cArray[n2];
            if (c2 == '\"' || c2 == '\'') {
                while (++n2 < n3 && cArray[n2] != c2 && cArray[n2] != '\n') {
                    if (cArray[n2] != '\\') continue;
                    ++n2;
                }
            }
            if (n > 0 && (c2 != '}' || --n > 0)) {
                if (c2 != '{') continue;
                ++n;
                continue;
            }
            if (n == 0 || n == -1 && c2 != '(') {
                if (c2 != '@') break;
                while (++n2 < n3 && cArray[n2] >= '0') {
                }
                n = -1;
                continue;
            }
            if (c2 == '(') {
                --n;
                continue;
            }
            if (c2 != ')') continue;
            ++n;
        }
        int n4 = n2;
        while (n2 < n3 && ((c2 = cArray[n2]) == '_' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 > '~')) {
            ++n2;
        }
        if (n4 == n2) {
            c2 = cArray[n2];
            while (++n2 < n3 && c2 == '.' && cArray[n2] == c2) {
            }
        }
        this.p = n2;
        int n5 = n2 - n4;
        if (n5 == 1 && (c2 = cArray[n4]) >= '\u0000' && c2 < CHAR_SPOOL.length) {
            return CHAR_SPOOL[c2];
        }
        return new String(cArray, n4, n2 - n4);
    }

    void expect(String string2, String string3) {
        if (!string2.equals(string3)) {
            CompileException compileException = new CompileException(this.line, 0, "Expected `" + string2 + (string3 == null ? "EOF" : "', not `" + string3 + '\''));
            compileException.fn = this.fn;
            throw compileException;
        }
    }

    private int modifiers() {
        String string2;
        Object v2;
        int n = 0;
        while ((v2 = MODS.get(string2 = this.get(0))) != null) {
            n |= ((Integer)v2).intValue();
        }
        this.lookahead = string2;
        return n;
    }

    private String type(int n) {
        String string2;
        StringBuffer stringBuffer = null;
        String string3 = this.get(0);
        String string4 = null;
        if (string3 == "{") {
            return string3;
        }
        while (string3 != null) {
            string4 = this.get(0);
            if (string4 == "<" && n > 1) {
                String string5;
                int n2 = 1;
                while ((string5 = this.get(0)) != null && (string5 != ">" || --n2 > 0)) {
                    if (string5 != "<") continue;
                    ++n2;
                }
                string4 = this.get(0);
            }
            if (string4 != "." || n == 1) break;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string3);
            }
            stringBuffer.append('/');
            string3 = this.get(0);
            if (string3 == null) continue;
            stringBuffer.append(string3);
        }
        String string6 = string2 = stringBuffer == null ? string3 : stringBuffer.toString();
        if (n != 0) {
            while (string4 == "[" && n != 2) {
                this.expect("]", this.get(0));
                string2 = "[".concat(string2);
                string4 = this.get(0);
            }
        }
        this.lookahead = string4;
        return string2;
    }

    private String field(int n, String string2, JavaNode javaNode) {
        JavaNode javaNode2 = null;
        String string3 = this.type(1);
        if (string3 != null && ((n & 2) == 0 || string3 == "(")) {
            if ("...".equals(string3)) {
                string2 = "[".concat(string2);
                string3 = this.type(1);
                if (string3 == null) {
                    return null;
                }
            }
            while (string3.startsWith("[")) {
                string2 = "[".concat(string2);
                string3 = string3.substring(1);
            }
            string2 = string2.intern();
            if (javaNode == null) {
                return string2;
            }
            javaNode2 = new JavaNode();
            javaNode2.modifier = n;
            if (string3 == "(") {
                string2 = "void";
                javaNode2.name = "<init>";
            } else {
                javaNode2.name = string3.intern();
            }
            javaNode2.type = string2;
            javaNode2.field = javaNode.field;
            javaNode.field = javaNode2;
        }
        int n2 = 0;
        if (string3 == "(" || (string3 = this.get(0)) == "(") {
            ArrayList<String> arrayList = new ArrayList<String>();
            do {
                this.modifiers();
                string3 = this.type(3);
                if (string3 == ")") break;
                string2 = this.field(0, string3, null);
                string3 = this.get(0);
                if (string3 == null) continue;
                arrayList.add(string2);
            } while (string3 == ",");
            this.expect(")", string3);
            if (javaNode2 != null) {
                javaNode2.argv = arrayList.toArray(new String[arrayList.size()]);
            }
            ++n2;
        } else if (string3 != "=") {
            return string3;
        }
        int n3 = n2;
        while ((string3 = this.get(0)) != null && string3 != ";" && (n3 > 0 || string3 != ",")) {
            if (string3 == "{") {
                this.get(1);
                if (n2 == 0) continue;
                return ";";
            }
            if (string3 == "(") {
                ++n3;
                continue;
            }
            if (string3 != ")") continue;
            --n3;
        }
        return string3;
    }

    private String readClass(String string2, int n) {
        String string3 = this.type(3);
        if ("interface".equals(string3)) {
            n |= 0x600;
        } else if (!"class".equals(string3)) {
            return string3;
        }
        JavaNode javaNode = new JavaNode();
        javaNode.source = this;
        javaNode.modifier = n;
        string3 = this.type(2);
        javaNode.name = string2 != null ? string2 + '$' + string3 : (this.packageName.length() != 0 ? this.packageName + '/' + string3 : string3);
        string3 = this.get(0);
        boolean bl = false;
        if ("extends".equals(string3)) {
            if ((n & 0x200) == 0) {
                javaNode.type = this.type(2);
                string3 = this.get(0);
            } else {
                bl = true;
            }
        }
        if (bl || "implements".equals(string3)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            do {
                arrayList.add(this.type(2));
            } while ((string3 = this.get(0)) == ",");
            javaNode.argv = arrayList.toArray(new String[arrayList.size()]);
        }
        this.expect("{", string3);
        while ((string3 = this.readClass(javaNode.name, n = this.modifiers())) != "}") {
            if (string3 == null) {
                return null;
            }
            if (string3 == "{") {
                this.get(1);
                continue;
            }
            while (string3 != "" && this.field(n, string3, javaNode) == ",") {
            }
        }
        this.classes.put(javaNode.name, javaNode);
        return "";
    }

    JavaSource(String string2, char[] cArray, Map map3) {
        this.fn = string2;
        this.s = cArray;
        this.e = cArray.length;
        this.classes = map3;
        String string3 = this.get(0);
        if ("package".equals(string3)) {
            this.packageName = this.type(0);
            string3 = this.get(0);
        } else {
            this.packageName = "";
        }
        while (string3 != null) {
            if (string3 != ";") {
                if (!"import".equals(string3)) break;
                string3 = this.type(0);
                if ("static".equals(string3)) {
                    this.type(0);
                } else if (string3 != null) {
                    this.imports.add(string3);
                }
            }
            string3 = this.get(0);
        }
        this.lookahead = string3;
        while (this.readClass(null, this.modifiers()) != null) {
        }
        this.s = null;
        map3 = null;
        this.fn = null;
    }

    private static String resolveFull(ClassFinder classFinder, String string2, Map map3) {
        String string3 = null;
        String string4 = string2;
        char[] cArray = string2.toCharArray();
        int n = cArray.length;
        while (--n >= 0) {
            if (cArray[n] != '/') continue;
            if (string3 == null) {
                string3 = string2.substring(n + 1, cArray.length);
            } else {
                string4 = new String(cArray);
            }
            if (classFinder.exists(string4)) {
                String string5;
                string4 = 'L' + string4 + ';';
                if (map3 != null && (string5 = map3.put(string3, string4)) != null) {
                    map3.put(string3, string5);
                }
                return string4;
            }
            cArray[n] = 36;
        }
        return null;
    }

    private synchronized void prepareResolve(ClassFinder classFinder) {
        if (this.importPackages != null) {
            return;
        }
        this.classes = new HashMap(JavaType.JAVA_PRIM);
        this.classes.remove("number");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.packageName.concat("/"));
        arrayList.add("java/lang/");
        for (int i = 0; i < this.imports.size(); ++i) {
            String string2 = (String)this.imports.get(i);
            if (string2.endsWith("/*")) {
                arrayList.add(string2.substring(0, string2.length() - 1));
                continue;
            }
            JavaSource.resolveFull(classFinder, string2, this.classes);
        }
        this.classes.put("void", "V");
        this.importPackages = arrayList.toArray(new String[arrayList.size()]);
        this.imports = null;
    }

    private YType resolve(ClassFinder classFinder, String string2, String[] stringArray, int n) {
        String string3;
        int n2;
        int n3 = string2.length();
        for (n2 = 0; n2 < n3 && string2.charAt(n2) == '['; ++n2) {
        }
        string2 = string2.substring(n2);
        int n4 = string2.indexOf(47);
        String string4 = string2;
        String string5 = string2;
        if (n4 > 0) {
            string4 = string2.replace('/', '$');
            string5 = string2.substring(0, n4);
        }
        if ((string3 = (String)this.classes.get(string5)) == null && (n4 <= 0 || (string3 = JavaSource.resolveFull(classFinder, string2, null)) == null)) {
            for (int i = 0; string3 == null && i < this.importPackages.length; ++i) {
                if (!classFinder.exists(this.importPackages[i].concat(string5))) continue;
                string3 = this.importPackages[i].concat(string4);
            }
            if (string3 == null) {
                string3 = n4 > 0 ? string2 : this.importPackages[0].concat(string2);
            }
            string3 = 'L' + string3 + ';';
        }
        if (stringArray != null) {
            stringArray[n] = n2 != 0 || string3.length() <= 1 ? string2 : string3.substring(1, string3.length() - 1);
            return null;
        }
        YType yType = new YType(string3);
        while (--n2 >= 0) {
            yType = new YType(14, new YType[]{yType});
        }
        return yType;
    }

    static void loadClass(ClassFinder classFinder, JavaTypeReader javaTypeReader, JavaNode javaNode) {
        JavaSource javaSource = javaNode.source;
        javaSource.prepareResolve(classFinder);
        String string2 = javaNode.name;
        String[] stringArray = new String[]{"java/lang/Object"};
        if (javaNode.type != null) {
            javaSource.resolve(classFinder, javaNode.type, stringArray, 0);
        }
        String[] stringArray2 = new String[javaNode.argv == null ? 0 : javaNode.argv.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            javaSource.resolve(classFinder, javaNode.argv[i], stringArray2, i);
        }
        javaTypeReader.visit(0, javaNode.modifier, string2, null, stringArray[0], stringArray2);
        JavaNode javaNode2 = javaNode.field;
        while (javaNode2 != null) {
            int n = javaNode2.modifier;
            if ((javaNode.modifier & 0x200) != 0) {
                n |= javaNode2.argv == null ? 25 : 1025;
            }
            String string3 = javaNode2.name;
            YType yType = javaSource.resolve(classFinder, javaNode2.type, null, 0);
            if (javaNode2.argv == null) {
                ((n & 8) == 0 ? javaTypeReader.fields : javaTypeReader.staticFields).put(string3, new JavaType.Field(string3, n, string2, yType));
            } else {
                YType[] yTypeArray = new YType[javaNode2.argv.length];
                for (int i = 0; i < yTypeArray.length; ++i) {
                    yTypeArray[i] = javaSource.resolve(classFinder, javaNode2.argv[i], null, 0);
                }
                JavaType.Method method = new JavaType.Method();
                method.name = string3;
                method.access = n;
                method.returnType = yType;
                method.arguments = yTypeArray;
                method.className = string2;
                method.sig = string3 + method.descr(null);
                if (string3 == "<init>") {
                    javaTypeReader.constructors.add(method);
                } else {
                    ((n & 8) == 0 ? javaTypeReader.methods : javaTypeReader.staticMethods).add(method);
                }
            }
            javaNode2 = javaNode2.field;
        }
        if (javaTypeReader.constructors.size() == 0) {
            javaTypeReader.visitMethod(1, "<init>", "()V", null, null);
        }
    }

    private static void mod(String string2, int n) {
        MODS.put(string2, new Integer(n));
    }

    static {
        char[] cArray = new char[]{' '};
        for (int n = 0; n < CHAR_SPOOL.length; n = (int)((short)(n + 1))) {
            cArray[0] = (char)n;
            JavaSource.CHAR_SPOOL[n] = new String(cArray).intern();
        }
        JavaSource.mod("abstract", 1024);
        JavaSource.mod("final", 16);
        JavaSource.mod("native", 256);
        JavaSource.mod("private", 2);
        JavaSource.mod("protected", 4);
        JavaSource.mod("public", 1);
        JavaSource.mod("static", 8);
        JavaSource.mod("strictfp", 2048);
        JavaSource.mod("synchronized", 32);
        JavaSource.mod("transient", 128);
        JavaSource.mod("volatile", 64);
    }
}

