/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang.compiler;

import java.util.HashMap;
import java.util.Map;
import yeti.lang.compiler.Code;
import yeti.lang.compiler.Compiler;
import yeti.lang.compiler.Constants;
import yeti.lang.compiler.YClassWriter;
import yeti.renamed.asmx.ClassWriter;
import yeti.renamed.asmx.Label;
import yeti.renamed.asmx.MethodVisitor;
import yeti.renamed.asmx.Opcodes;

final class Ctx
implements Opcodes {
    Compiler compilation;
    String className;
    ClassWriter cw;
    private MethodVisitor m;
    private int lastInsn = -1;
    private String lastType;
    Constants constants;
    Map usedMethodNames;
    int localVarCount;
    int fieldCounter;
    int lastLine;
    int tainted;

    Ctx(Compiler compiler, Constants constants, ClassWriter classWriter, String string2) {
        this.compilation = compiler;
        this.constants = constants;
        this.cw = classWriter;
        this.className = string2;
    }

    Ctx newClass(int n, String string2, String string3, String[] stringArray, int n2) {
        Ctx ctx = new Ctx(this.compilation, this.constants, new YClassWriter(this.compilation.classWriterFlags), string2);
        ctx.usedMethodNames = new HashMap();
        ctx.cw.visit(48, n, string2, null, string3 == null ? "java/lang/Object" : string3, stringArray);
        ctx.cw.visitSource(this.constants.sourceName, null);
        this.compilation.addClass(string2, ctx, n2);
        return ctx;
    }

    String methodName(String string2) {
        Map map3 = this.usedMethodNames;
        if (string2 == null) {
            string2 = "_" + map3.size();
        } else if (map3.containsKey(string2) || string2.startsWith("_")) {
            string2 = string2 + map3.size();
        }
        map3.put(string2, null);
        return string2;
    }

    Ctx newMethod(int n, String string2, String string3) {
        Ctx ctx = new Ctx(this.compilation, this.constants, this.cw, this.className);
        ctx.usedMethodNames = this.usedMethodNames;
        ctx.m = this.cw.visitMethod(n, string2, string3, null, null);
        ctx.m.visitCode();
        return ctx;
    }

    void markInnerClass(Ctx ctx, int n) {
        String string2 = this.className.substring(ctx.className.length() + 1);
        ctx.cw.visitInnerClass(this.className, ctx.className, string2, n);
        this.cw.visitInnerClass(this.className, ctx.className, string2, n);
    }

    void closeMethod() {
        this.insn(-1);
        this.m.visitMaxs(0, 0);
        this.m.visitEnd();
    }

    void createInit(int n, String string2) {
        MethodVisitor methodVisitor = this.cw.visitMethod(n, "<init>", "()V", null, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, string2, "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    void intConst(int n) {
        if (n >= -1 && n <= 5) {
            this.insn(n + 3);
        } else {
            this.insn(-1);
            if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
                this.m.visitIntInsn(n >= -128 && n <= 127 ? 16 : 17, n);
            } else {
                this.m.visitLdcInsn(new Integer(n));
            }
        }
    }

    void visitLine(int n) {
        if (n != 0 && this.lastLine != n) {
            Label label = new Label();
            this.m.visitLabel(label);
            this.m.visitLineNumber(n, label);
            this.lastLine = n;
        }
    }

    void genBoolean(Label label) {
        this.fieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
        Label label2 = new Label();
        this.m.visitJumpInsn(167, label2);
        this.m.visitLabel(label);
        this.m.visitFieldInsn(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
        this.m.visitLabel(label2);
    }

    void insn(int n) {
        if (this.lastInsn != -1 && this.lastInsn != -2) {
            if (this.lastInsn == 1 && n == 87) {
                this.lastInsn = -1;
                return;
            }
            this.m.visitInsn(this.lastInsn);
        }
        this.lastInsn = n;
    }

    void varInsn(int n, int n2) {
        this.insn(-1);
        this.m.visitVarInsn(n, n2);
    }

    Ctx load(int n) {
        this.insn(-1);
        this.m.visitVarInsn(25, n);
        return this;
    }

    void visitIntInsn(int n, int n2) {
        this.insn(-1);
        if (n != 132) {
            this.m.visitIntInsn(n, n2);
        } else {
            this.m.visitIincInsn(n2, -1);
        }
    }

    void typeInsn(int n, String string2) {
        if (n == 192) {
            if (this.lastInsn == -2 && string2.equals(this.lastType) || this.lastInsn == 1) {
                return;
            }
            this.insn(-2);
            this.lastType = string2;
        } else {
            this.insn(-1);
        }
        this.m.visitTypeInsn(n, string2);
    }

    void captureCast(String string2) {
        if (string2.charAt(0) == 'L') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (!string2.equals("java/lang/Object")) {
            this.typeInsn(192, string2);
        }
    }

    void visitInit(String string2, String string3) {
        this.insn(-2);
        this.m.visitMethodInsn(183, string2, "<init>", string3, false);
        this.lastType = string2;
    }

    void forceType(String string2) {
        this.insn(-2);
        this.lastType = string2;
    }

    void fieldInsn(int n, String string2, String string3, String string4) {
        if (string2 == null || string3 == null || string4 == null) {
            throw new IllegalArgumentException("fieldInsn(" + n + ", " + string2 + ", " + string3 + ", " + string4 + ")");
        }
        this.insn(-1);
        this.m.visitFieldInsn(n, string2, string3, string4);
        if ((n == 178 || n == 180) && string4.charAt(0) == 'L') {
            this.lastInsn = -2;
            this.lastType = string4.substring(1, string4.length() - 1);
        }
    }

    void methodInsn(int n, String string2, String string3, String string4) {
        this.insn(-1);
        this.m.visitMethodInsn(n, string2, string3, string4, n == 185);
    }

    void visitApply(Code code, int n) {
        code.gen(this);
        this.insn(-1);
        this.visitLine(n);
        this.m.visitMethodInsn(182, "yeti/lang/Fun", "apply", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
    }

    void jumpInsn(int n, Label label) {
        this.insn(-1);
        this.m.visitJumpInsn(n, label);
    }

    void visitLabel(Label label) {
        if (this.lastInsn != -2) {
            this.insn(-1);
        }
        this.m.visitLabel(label);
    }

    void ldcInsn(Object object) {
        this.insn(-1);
        this.m.visitLdcInsn(object);
        if (object instanceof String) {
            this.lastInsn = -2;
            this.lastType = "java/lang/String";
        }
    }

    void tryCatchBlock(Label label, Label label2, Label label3, String string2) {
        this.insn(-1);
        this.m.visitTryCatchBlock(label, label2, label3, string2);
    }

    void switchInsn(int n, int n2, Label label, int[] nArray, Label[] labelArray) {
        this.insn(-1);
        if (nArray == null) {
            this.m.visitTableSwitchInsn(n, n2, label, labelArray);
        } else {
            this.m.visitLookupSwitchInsn(label, nArray, labelArray);
        }
    }

    void constant(Object object, Code code) {
        this.constants.registerConstant(object, code, this);
    }

    void popn(int n) {
        if ((n & 1) != 0) {
            this.insn(87);
        }
        while (n >= 2) {
            this.insn(88);
            n -= 2;
        }
    }
}

