/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import yeti.lang.AIter;
import yeti.lang.AList;
import yeti.lang.Fun;
import yeti.lang.IntNum;
import yeti.lang.MList;
import yeti.lang.Num;
import yeti.lang.PArray;

final class ByteArray
extends PArray {
    private final byte[] a;

    ByteArray(int n, int n2, byte[] byArray) {
        super(n, n2, byArray);
        this.a = byArray;
    }

    public Object first() {
        return new IntNum(this.a[this.start] & 0xFF);
    }

    PArray slice(int n, int n2) {
        return new ByteArray(n, n2, this.a);
    }

    public void forEach(Object object) {
        Fun fun = (Fun)object;
        int n = this.length;
        for (int i = this.start; i < n; ++i) {
            fun.apply(new IntNum(this.a[i]));
        }
    }

    public Object fold(Fun fun, Object object) {
        Fun fun2 = fun;
        int n = this.length;
        for (int i = this.start; i < n; ++i) {
            object = fun2.apply(object, new IntNum(this.a[i]));
        }
        return object;
    }

    public AList reverse() {
        byte[] byArray = new byte[this.length - this.start];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[byArray.length - i] = this.a[i + this.start];
        }
        return new ByteArray(0, byArray.length, byArray);
    }

    public Num index(Object object) {
        int n = ((IntNum)object).intValue();
        int n2 = this.length;
        for (int i = this.start; i < n2; ++i) {
            if (this.a[i] != n) continue;
            return new IntNum(i - this.start);
        }
        return null;
    }

    public AList find(Fun fun) {
        int n = this.length;
        for (int i = this.start; i < n; ++i) {
            if (fun.apply(new IntNum(this.a[i])) != Boolean.TRUE) continue;
            return new ByteArray(i, n - i, this.a);
        }
        return null;
    }

    public AList sort() {
        byte[] byArray = new byte[this.length - this.start];
        System.arraycopy(this.a, this.start, byArray, 0, byArray.length);
        Arrays.sort(byArray);
        return new ByteArray(0, byArray.length, byArray);
    }

    public long length() {
        return this.length - this.start;
    }

    public Object copy() {
        byte[] byArray = new byte[this.length - this.start];
        System.arraycopy(this.a, this.start, byArray, 0, byArray.length);
        return new ByteArray(0, byArray.length, byArray);
    }

    AIter write(OutputStream outputStream) throws IOException {
        outputStream.write(this.a, this.start, this.length - this.start);
        return null;
    }

    public AList map(Fun fun) {
        return this.smap(fun);
    }

    public AList sort(Fun fun) {
        return new MList(this).asort(fun);
    }
}

