/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.temptable.column;

import com.amazon.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.amazon.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.amazon.sqlengine.executor.etree.temptable.column.IColumnSlice;
import java.sql.Date;

public final class DateColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = 6449117822981500182L;
    private Date[] m_data;
    private final int m_columnNumber;

    public DateColumnSlice(int n, int n2) {
        this.m_data = new Date[n];
        this.m_columnNumber = n2;
    }

    public int columnNumber() {
        return this.m_columnNumber;
    }

    public boolean isNull(int n) {
        return null == this.m_data[n];
    }

    public void setNull(int n) {
        this.m_data[n] = null;
    }

    public Date getDate(int n) {
        return this.m_data[n];
    }

    public void setDate(int n, Date date) {
        this.m_data[n] = date;
    }

    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.DATE;
    }

    public int size() {
        return this.m_data.length;
    }

    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        DateColumnSlice dateColumnSlice = (DateColumnSlice)iColumnSlice;
        System.arraycopy(dateColumnSlice.m_data, n, this.m_data, n3, n2);
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize) {
        return javaSize.getObjectShellSize() + javaSize.getLongSize() + javaSize.getObjectRefSize();
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return javaSize.getObjectRefSize();
    }
}

