/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.utilities.ExecutionContext;
import com.amazon.dsi.dataengine.utilities.ExecutionContexts;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.dataengine.utilities.ParameterType;
import com.amazon.jdbc.utils.ParseQueryUtils;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGAbstractQueryExecutor;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;

public class PGIQueryExecutor
extends PGAbstractQueryExecutor {
    private PGMessagingContext m_messagingContext;
    private String m_query;

    public PGIQueryExecutor(String string, PGClient pGClient, ILogger iLogger, boolean bl, PGJDBCStatement pGJDBCStatement, int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, string, pGClient);
        this.m_query = string;
        this.m_log = iLogger;
        this.m_client = pGClient;
        this.m_isDirectExecute = bl;
        this.m_statement = pGJDBCStatement;
        this.m_socketTimeoutMS = n;
        if (!bl) {
            string = ParseQueryUtils.parseCommentsOnSingleQuery(string);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            string = PGCoreUtils.parameterQueryFormatter(string, arrayList);
            this.m_messagingContext = this.m_client.prepareStatement(string, arrayList, pGJDBCStatement.getWarningListener());
            this.m_messagingContext.addSocketCloseListener(this);
            this.m_contexts.add(this.m_messagingContext);
            this.m_statement.pushContexts(this.m_contexts);
        }
    }

    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws ErrorException {
        int n;
        LogUtilities.logFunctionEntrance(this.m_log, executionContexts, iWarningListener);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            n = this.m_statement.getProperty(6).getInt();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Fetch size retrieval failed", this.m_query}, (Throwable)exception);
            throw errorException;
        }
        ++this.m_currentExecuteIndex;
        if (this.m_isDirectExecute) {
            this.m_contexts = this.m_client.directExecute(this.m_query, n, this.m_statement.getWarningListener());
            this.m_statement.pushContexts(this.m_contexts);
            for (PGMessagingContext pGMessagingContext : this.m_contexts) {
                pGMessagingContext.addSocketCloseListener(this);
            }
        } else {
            try {
                int n2 = executionContexts.getMetadata().size();
                if (this.m_statement.isCallableStatement() && this.m_statement.hasReturnQuestionMark()) {
                    --n2;
                }
                if (n > 5) {
                    this.m_messagingContext.setNRowMode(n);
                }
                if (n2 != 0) {
                    Object object;
                    ArrayList<byte[][]> arrayList = new ArrayList<byte[][]>();
                    Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
                    while (iterator.hasNext()) {
                        object = new byte[n2][];
                        ExecutionContext executionContext = iterator.next();
                        for (int i = 0; i < executionContext.getInputs().size(); ++i) {
                            ParameterInputValue parameterInputValue = executionContext.getInputs().get(i);
                            object[i] = PGDataTypeUtilities.toUTF8ByteArray(parameterInputValue.getData());
                        }
                        arrayList.add((byte[][])object);
                    }
                    if (1 == arrayList.size()) {
                        this.m_client.executePreparedStatement(this.m_messagingContext, (byte[][])arrayList.get(0), false, false);
                    }
                    object = new byte[arrayList.size()][][];
                    for (int i = 0; i < ((byte[][])object).length; ++i) {
                        object[i] = (byte[])((byte[][])arrayList.get(i));
                    }
                    this.m_client.executePreparedStatementBatch(this.m_messagingContext, this.m_currentExecuteIndex, (byte[][][])object, false);
                }
                this.m_client.executePreparedStatement(this.m_messagingContext, null, false, false);
            }
            catch (Exception exception) {
                --this.m_currentExecuteIndex;
                if (!(exception instanceof ErrorException)) {
                    ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PREPARE_EXECUTE_ERR.name(), exception.getMessage());
                    errorException.initCause(exception);
                    throw errorException;
                }
                throw (ErrorException)exception;
            }
        }
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        if (null != this.m_parameterMetadata) {
            return this.m_parameterMetadata;
        }
        ArrayList<ParameterMetadata> arrayList = new ArrayList();
        if (this.m_statement.isCallableStatement()) {
            int n = PGDataTypeUtilities.oidToSQLType(this.m_messagingContext.getRowDescription(0).getFieldDescriptions()[0].getDataTypeObjectID());
            if (this.m_statement.hasReturnQuestionMark()) {
                ParameterMetadata parameterMetadata = new ParameterMetadata(1, ParameterType.OUTPUT, n);
                arrayList.add(parameterMetadata);
                for (ParameterMetadata parameterMetadata2 : this.m_messagingContext.m_parameterMetadata) {
                    arrayList.add(new ParameterMetadata(parameterMetadata2.getParameterNumber() + 1, parameterMetadata2.getParameterType(), parameterMetadata2.getTypeMetadata().getType()));
                }
            } else {
                for (int i = 0; i < this.m_messagingContext.m_parameterMetadata.size(); ++i) {
                    ParameterMetadata parameterMetadata = this.m_messagingContext.m_parameterMetadata.get(i);
                    if (i == 0) {
                        arrayList.add(new ParameterMetadata(parameterMetadata.getParameterNumber() + 1, ParameterType.INPUT_OUTPUT, parameterMetadata.getTypeMetadata().getType()));
                        continue;
                    }
                    arrayList.add(new ParameterMetadata(parameterMetadata.getParameterNumber() + 1, parameterMetadata.getParameterType(), parameterMetadata.getTypeMetadata().getType()));
                }
                if (arrayList.isEmpty()) {
                    ParameterMetadata parameterMetadata = new ParameterMetadata(1, ParameterType.OUTPUT, n);
                    arrayList.add(parameterMetadata);
                }
            }
        } else {
            arrayList = this.m_messagingContext.m_parameterMetadata;
        }
        this.m_parameterMetadata = arrayList;
        return arrayList;
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return PGCoreUtils.parameterCounter(this.m_query);
    }
}

