/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.impl.DSIErrorResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResults;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.OperationMetadataImpl;
import com.amazon.redshift.client.messages.inbound.ErrorResponse;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.dataengine.ExpectedResult;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.redshift.dataengine.PGRowCountResult;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.util.List;

public class PGExecutionResults
extends ExecutionResults {
    private final ILogger m_log;

    public PGExecutionResults(List<PGMessagingContext> list, int n, ILogger iLogger, ExpectedResult expectedResult, int n2) throws ErrorException {
        this.m_log = iLogger;
        for (PGMessagingContext pGMessagingContext : list) {
            try {
                int n3 = pGMessagingContext.getPortalCount();
                if (0 == n3) {
                    n3 = 1;
                }
                for (int i = 0; i < n3; ++i) {
                    boolean bl = false;
                    OperationMetadataImpl operationMetadataImpl = null;
                    int n4 = i + n * n3;
                    if (-1 == n4) {
                        n4 = 0;
                    }
                    while (!bl) {
                        try {
                            IInboundMessage iInboundMessage;
                            if (pGMessagingContext.m_totalMessageCount > pGMessagingContext.m_currentMessageIndex && (iInboundMessage = pGMessagingContext.peekNextMessage(n2)) instanceof ErrorResponse) {
                                pGMessagingContext.getErrorResponse(n4);
                            }
                            operationMetadataImpl = (OperationMetadataImpl)pGMessagingContext.getOperationMetadata(0);
                            if (pGMessagingContext.m_isPreparedStatement && null == operationMetadataImpl.m_readyForQueryFromPipelineForPrepare) {
                                pGMessagingContext.getReadyForQuery(0, true);
                            }
                            if (null != operationMetadataImpl.m_noData) {
                                pGMessagingContext.getCommandCompleteMessage(n4);
                                this.addExecutionResult(this.buildRowCount(expectedResult, pGMessagingContext, n4));
                                bl = true;
                                continue;
                            }
                            if (null != operationMetadataImpl.m_rowDescription && operationMetadataImpl.m_rowDescription.getNumberOfFields() > 0) {
                                this.addExecutionResult(this.buildResultSet(expectedResult, pGMessagingContext, n4));
                                bl = true;
                                continue;
                            }
                            pGMessagingContext.getCommandCompleteMessage(n4);
                            this.addExecutionResult(this.buildRowCount(expectedResult, pGMessagingContext, n4));
                            bl = true;
                        }
                        catch (ErrorException errorException) {
                            DSIErrorResult dSIErrorResult = new DSIErrorResult(errorException);
                            if (expectedResult == ExpectedResult.SingleRowCount || null != operationMetadataImpl && null != operationMetadataImpl.m_noData) {
                                this.addExecutionResult(new ExecutionResult(dSIErrorResult, false));
                                bl = true;
                            } else {
                                this.addExecutionResult(new ExecutionResult(dSIErrorResult, true));
                                bl = true;
                            }
                            throw errorException;
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ErrorException errorException = pGMessagingContext.receivedFatalExeption();
                if (null != pGMessagingContext.receivedFatalExeption()) {
                    throw errorException;
                }
                if (exception instanceof ErrorException) {
                    throw (ErrorException)exception;
                }
                errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
                errorException.initCause(exception);
                throw errorException;
            }
        }
    }

    private ExecutionResult buildResultSet(ExpectedResult expectedResult, PGMessagingContext pGMessagingContext, int n) {
        if (null != expectedResult && ExpectedResult.SingleRowCount == expectedResult) {
            return new ExecutionResult(new DSIErrorResult(PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(JDBCMessageKey.NO_ROWCOUNT_GENERATED.name(), pGMessagingContext.m_query, ExceptionType.DEFAULT)), false);
        }
        PGResultSet pGResultSet = new PGResultSet(pGMessagingContext, n, this.m_log);
        return new ExecutionResult(pGResultSet);
    }

    private ExecutionResult buildRowCount(ExpectedResult expectedResult, PGMessagingContext pGMessagingContext, int n) {
        if (null != expectedResult && ExpectedResult.SingleResult == expectedResult) {
            return new ExecutionResult(new DSIErrorResult(PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(JDBCMessageKey.NO_RESULTSET_GENERATED.name(), pGMessagingContext.m_query, ExceptionType.DEFAULT)), true);
        }
        PGRowCountResult pGRowCountResult = new PGRowCountResult(pGMessagingContext, n, this.m_log);
        return new ExecutionResult(pGRowCountResult);
    }
}

