/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.utilities.ExecutionContext;
import com.amazon.dsi.dataengine.utilities.ExecutionContexts;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.dataengine.utilities.ParameterType;
import com.amazon.jdbc.communications.InboundMessagesPipeline;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGAbstractQueryExecutor;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PGBatchQueryExecutor
extends PGAbstractQueryExecutor {
    private Map<PGMessagingContext, Integer> m_parameterCountPerQuery = new HashMap<PGMessagingContext, Integer>();
    private List<String> m_queries;

    public PGBatchQueryExecutor(List<String> list, PGClient pGClient, ILogger iLogger, boolean bl, PGJDBCStatement pGJDBCStatement, int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, list, pGClient);
        this.m_queries = list;
        this.m_log = iLogger;
        this.m_isDirectExecute = bl;
        this.m_client = pGClient;
        this.m_statement = pGJDBCStatement;
        this.m_socketTimeoutMS = n;
        this.m_contexts = new ArrayList();
        if (!bl) {
            for (String string : list) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                string = PGCoreUtils.parameterQueryFormatter(string, arrayList);
                PGMessagingContext pGMessagingContext = this.m_client.prepareStatement(string, arrayList, pGJDBCStatement.getWarningListener());
                pGMessagingContext.addSocketCloseListener(this);
                this.m_contexts.add(pGMessagingContext);
            }
            this.m_statement.pushContexts(this.m_contexts);
        }
    }

    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws ErrorException {
        int n;
        LogUtilities.logFunctionEntrance(this.m_log, executionContexts, iWarningListener);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            n = this.m_statement.getProperty(6).getInt();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.m_queries.size(); ++i) {
                stringBuilder.append(this.m_queries.get(i));
                if (i >= this.m_queries.size() - 1) continue;
                stringBuilder.append(", ");
            }
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Fetch size retrieval failed", stringBuilder.toString()}, (Throwable)exception);
            throw errorException;
        }
        ++this.m_currentExecuteIndex;
        if (this.m_isDirectExecute) {
            for (String string : this.m_queries) {
                this.m_contexts.addAll(this.m_client.directExecute(string, n, this.m_statement.getWarningListener()));
            }
        } else {
            try {
                int n2;
                int n3 = 0;
                int n4 = executionContexts.getMetadata().size();
                if (this.m_statement.isCallableStatement() && this.m_statement.hasReturnQuestionMark()) {
                    --n4;
                }
                ArrayList<byte[][]> arrayList = new ArrayList<byte[][]>();
                if (n4 != 0) {
                    Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        n2 = 0;
                        for (Integer object2 : this.m_parameterCountPerQuery.values()) {
                            byte[][] byArrayArray = new byte[object2.intValue()][];
                            for (int i = 0; i < object2 && n2 < ((ExecutionContext)object).getInputs().size(); ++i, ++n2) {
                                ParameterInputValue parameterInputValue = ((ExecutionContext)object).getInputs().get(n2);
                                byArrayArray[i] = PGDataTypeUtilities.toUTF8ByteArray(parameterInputValue.getData());
                            }
                            arrayList.add(byArrayArray);
                        }
                    }
                }
                for (Object object : this.m_contexts) {
                    n2 = this.m_parameterCountPerQuery.get(object);
                    ArrayList arrayList2 = new ArrayList();
                    arrayList2 = new ArrayList(arrayList.subList(n3, n3 + n2));
                    if (n > 5) {
                        ((InboundMessagesPipeline)object).setNRowMode(n);
                    }
                    if (n2 != 0) {
                        if (1 == arrayList2.size()) {
                            this.m_client.executePreparedStatement((PGMessagingContext)object, (byte[][])arrayList2.get(0), false, false);
                        } else {
                            byte[][][] byArrayArray = new byte[n2][][];
                            for (int i = 0; i < byArrayArray.length; ++i) {
                                byArrayArray[i] = (byte[][])arrayList2.get(i);
                            }
                            this.m_client.executePreparedStatementBatch((PGMessagingContext)object, this.m_currentExecuteIndex, byArrayArray, false);
                        }
                        n3 += n2;
                        continue;
                    }
                    this.m_client.executePreparedStatement((PGMessagingContext)object, null, false, false);
                }
            }
            catch (Exception exception) {
                --this.m_currentExecuteIndex;
                if (!(exception instanceof ErrorException)) {
                    ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PREPARE_EXECUTE_ERR.name(), exception.getMessage());
                    errorException.initCause(exception);
                    throw errorException;
                }
                throw (ErrorException)exception;
            }
        }
        this.m_statement.pushContexts(this.m_contexts);
        for (PGMessagingContext pGMessagingContext : this.m_contexts) {
            pGMessagingContext.addSocketCloseListener(this);
        }
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        ArrayList<ParameterMetadata> arrayList = new ArrayList<ParameterMetadata>();
        for (PGMessagingContext pGMessagingContext : this.m_contexts) {
            arrayList.addAll(this.getMetadataForParameters(pGMessagingContext));
        }
        return arrayList;
    }

    private ArrayList<ParameterMetadata> getMetadataForParameters(PGMessagingContext pGMessagingContext) throws ErrorException {
        ArrayList<Object> arrayList = new ArrayList();
        if (this.m_statement.isCallableStatement()) {
            int n = PGDataTypeUtilities.oidToSQLType(pGMessagingContext.getRowDescription(0).getFieldDescriptions()[0].getDataTypeObjectID());
            if (this.m_statement.hasReturnQuestionMark()) {
                ParameterMetadata parameterMetadata = new ParameterMetadata(1, ParameterType.OUTPUT, n);
                arrayList.add(parameterMetadata);
                for (ParameterMetadata parameterMetadata2 : pGMessagingContext.m_parameterMetadata) {
                    arrayList.add(new ParameterMetadata(parameterMetadata2.getParameterNumber() + 1, parameterMetadata2.getParameterType(), parameterMetadata2.getTypeMetadata().getType()));
                }
            } else {
                for (int i = 0; i < pGMessagingContext.m_parameterMetadata.size(); ++i) {
                    ParameterMetadata parameterMetadata = pGMessagingContext.m_parameterMetadata.get(i);
                    if (i == 0) {
                        arrayList.add(new ParameterMetadata(parameterMetadata.getParameterNumber() + 1, ParameterType.INPUT_OUTPUT, parameterMetadata.getTypeMetadata().getType()));
                        continue;
                    }
                    arrayList.add(new ParameterMetadata(parameterMetadata.getParameterNumber() + 1, parameterMetadata.getParameterType(), parameterMetadata.getTypeMetadata().getType()));
                }
                if (arrayList.isEmpty()) {
                    ParameterMetadata parameterMetadata = new ParameterMetadata(1, ParameterType.OUTPUT, n);
                    arrayList.add(parameterMetadata);
                }
            }
        } else {
            arrayList = pGMessagingContext.m_parameterMetadata;
        }
        this.m_parameterCountPerQuery.put(pGMessagingContext, arrayList.size());
        return arrayList;
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return PGCoreUtils.parameterCounter(this.m_queries.get(0));
    }
}

