/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.interfaces.IQueryExecutor;
import com.amazon.dsi.dataengine.utilities.ExecutionResults;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.exceptions.BadDefaultParamException;
import com.amazon.jdbc.communications.interfaces.SocketCloseListener;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGExecutionResults;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class PGAbstractQueryExecutor
implements IQueryExecutor,
SocketCloseListener {
    protected List<PGMessagingContext> m_contexts = new ArrayList<PGMessagingContext>();
    protected int m_currentExecuteIndex = -1;
    protected boolean m_isDirectExecute;
    protected PGExecutionResults m_results;
    protected PGClient m_client;
    protected ILogger m_log;
    protected PGJDBCStatement m_statement;
    protected ErrorException m_fatalException = null;
    protected int m_socketTimeoutMS;
    protected ArrayList<ParameterMetadata> m_parameterMetadata = null;

    @Override
    public void cancelExecute() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        this.m_client.cancelQuery();
    }

    @Override
    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
    }

    @Override
    public void clearPushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        for (PGMessagingContext pGMessagingContext : this.m_contexts) {
            int n = 0;
            if (0 <= this.m_currentExecuteIndex) {
                n = this.m_currentExecuteIndex;
            }
            for (int i = 0; i < pGMessagingContext.getPortalCount(); ++i) {
                int n2 = i + n * pGMessagingContext.getPortalCount();
                pGMessagingContext.closeBatch(n2);
            }
            pGMessagingContext.removeSocketCloseListener(this);
        }
        this.m_results = null;
    }

    private void createExecutionResults() throws ErrorException {
        this.m_results = new PGExecutionResults(this.m_contexts, this.m_currentExecuteIndex, this.m_log, this.m_statement.getExpectedResult(), this.m_socketTimeoutMS);
    }

    @Override
    public void finalizePushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
    }

    @Override
    public ExecutionResults getResults() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        if (null == this.m_contexts) {
            return null;
        }
        this.createExecutionResults();
        return this.m_results;
    }

    @Override
    public void pushMappedParamTypes(Map<Integer, TypeMetadata> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
    }

    @Override
    public void pushParamData(int n, ParameterInputValue parameterInputValue) throws BadDefaultParamException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, n, parameterInputValue);
    }

    @Override
    public void socketClosed(ErrorException errorException) {
        this.m_fatalException = errorException;
    }
}

