/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class Parse
extends AbstractOutboundMessage
implements PGConstants {
    private final byte[] m_preparedStatementName;
    private final byte[] m_query;
    private final List<Integer> m_parameterDataTypes;

    public Parse(byte[] byArray, String string, List<Integer> list, IPGLogger iPGLogger) {
        byte[] byArray2;
        this.m_preparedStatementName = byArray;
        try {
            byArray2 = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray2 = string.getBytes();
        }
        this.m_query = byArray2;
        this.m_parameterDataTypes = list;
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, byte[] byArray) {
        byteBuffer.put((byte)80);
        byteBuffer.put(byArray);
        if (null != this.m_preparedStatementName) {
            byteBuffer.put(this.m_preparedStatementName);
        }
        byteBuffer.put(TERMINATOR);
        byteBuffer.put(this.m_query);
        byteBuffer.put(TERMINATOR);
        if (null != this.m_parameterDataTypes && this.m_parameterDataTypes.size() > 0) {
            byteBuffer.putShort((short)this.m_parameterDataTypes.size());
            for (int n : this.m_parameterDataTypes) {
                byteBuffer.putInt(n);
            }
        } else {
            byteBuffer.putShort((short)0);
        }
    }

    @Override
    public int getSize() {
        int n = 4 + (this.m_preparedStatementName != null ? this.m_preparedStatementName.length : 0) + 1 + this.m_query.length + 1 + 2;
        if (null != this.m_parameterDataTypes) {
            n += this.m_parameterDataTypes.size() * 4;
        }
        return n;
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = new String(this.m_query);
        String string2 = null;
        if (null != this.m_preparedStatementName) {
            string2 = new String(this.m_preparedStatementName);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("=>FE Parse(stmt=");
        stringBuilder.append(string2);
        stringBuilder.append(",query=");
        stringBuilder.append(string);
        stringBuilder.append(",oids=");
        if (null != this.m_parameterDataTypes) {
            stringBuilder.append(Arrays.toString(this.m_parameterDataTypes.toArray()));
        }
        stringBuilder.append(")");
        iPGLogger.logDebugExternal(stringBuilder.toString());
    }
}

