/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client;

import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.jdbc.communications.InboundMessagesPipeline;
import com.amazon.jdbc.communications.InboundMessagesThread;
import com.amazon.jdbc.communications.channels.AbstractMessagesSocketChannel;
import com.amazon.jdbc.communications.channels.MessagesSocketChannel;
import com.amazon.jdbc.communications.channels.SSLMessagesSocketChannel;
import com.amazon.jdbc.communications.exceptions.MessagesFrameworkMessageKey;
import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.jdbc.communications.interfaces.SocketCloseListener;
import com.amazon.jdbc.utils.ParseQueryUtils;
import com.amazon.jdbc.utils.ParsingException;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.FilterUtilities;
import com.amazon.redshift.client.InboundDataHandler;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.OperationMetadataImpl;
import com.amazon.redshift.client.messages.inbound.Authentication;
import com.amazon.redshift.client.messages.inbound.ErrorResponse;
import com.amazon.redshift.client.messages.inbound.KeyData;
import com.amazon.redshift.client.messages.inbound.ParameterDescription;
import com.amazon.redshift.client.messages.outbound.Bind;
import com.amazon.redshift.client.messages.outbound.CancelRequest;
import com.amazon.redshift.client.messages.outbound.Close;
import com.amazon.redshift.client.messages.outbound.Describe;
import com.amazon.redshift.client.messages.outbound.Execute;
import com.amazon.redshift.client.messages.outbound.Flush;
import com.amazon.redshift.client.messages.outbound.Parse;
import com.amazon.redshift.client.messages.outbound.PasswordMessage;
import com.amazon.redshift.client.messages.outbound.Query;
import com.amazon.redshift.client.messages.outbound.SSLRequest;
import com.amazon.redshift.client.messages.outbound.Startup;
import com.amazon.redshift.client.messages.outbound.Sync;
import com.amazon.redshift.client.messages.outbound.Terminate;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.redshift.ssl.NonValidatingFactory;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class PGClient
implements SocketCloseListener,
PGConstants {
    private static final String SYNTHETIC_PREPARED_STATEMENT_NAME_SEED = "PGJDBCSTMT";
    private static final String SYNTHETIC_PORTAL_NAME_SEED = "PGJDBCPRTL";
    private static final String TRUSTSTORE_PROPERTY = "javax.net.ssl.trustStore";
    private static final String TRUSTSTORE_PWD_PROPERTY = "javax.net.ssl.trustStorePassword";
    Selector m_selector;
    private IPGLogger m_log;
    private InboundMessagesThread m_backgroundFetcher;
    private final PGJDBCSettings m_settings;
    private AbstractMessagesSocketChannel m_socketChannel;
    private IWarningListener m_connectionWarningListener;
    private InboundDataHandler m_handler;
    private final KeyData m_keyData;
    private AbstractOutboundMessage[] m_oneMessage = new AbstractOutboundMessage[1];
    private AbstractOutboundMessage[] m_twoMessages = new AbstractOutboundMessage[2];
    private AbstractOutboundMessage[] m_threeMessages = new AbstractOutboundMessage[3];
    private AbstractOutboundMessage[] m_fourMessages = new AbstractOutboundMessage[4];
    private AbstractOutboundMessage[] m_fiveMessages = new AbstractOutboundMessage[5];
    private AbstractOutboundMessage[] m_sixMessages = new AbstractOutboundMessage[6];
    public static final int MAX_CACHED_FORMAT_CODE_ARRAYS = 30;
    public short[][] m_cachedBinaryFormatCodes = new short[30][];
    public short[][] m_cachedTextFormatCodes = new short[30][];
    public ErrorException m_fatalException = null;

    public PGClient(PGJDBCSettings pGJDBCSettings, IPGLogger iPGLogger, IWarningListener iWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(iPGLogger, new Object[0]);
        try {
            this.m_settings = pGJDBCSettings;
            this.m_connectionWarningListener = iWarningListener;
            this.m_log = iPGLogger;
            this.m_socketChannel = this.connect();
            switch (pGJDBCSettings.m_authMech) {
                case DISABLE: {
                    try {
                        this.startSession();
                        break;
                    }
                    catch (ErrorException errorException) {
                        ErrorException errorException2;
                        errorException.printStackTrace();
                        if (null != this.m_fatalException) {
                            errorException2 = this.m_fatalException;
                        }
                        ErrorException errorException3 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), errorException2.getMessageParams());
                        throw errorException3;
                    }
                }
                case ALLOW: {
                    try {
                        this.startSession();
                        break;
                    }
                    catch (ErrorException errorException) {
                        this.closeSession();
                        try {
                            this.m_socketChannel = this.connect();
                            this.m_socketChannel = this.checkSSL(this.m_socketChannel);
                            this.startSession();
                            break;
                        }
                        catch (ErrorException errorException4) {
                            ErrorException errorException5;
                            if (null != this.m_fatalException) {
                                errorException5 = this.m_fatalException;
                            }
                            ErrorException errorException6 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), errorException5.getMessageParams());
                            throw errorException6;
                        }
                    }
                }
                case PREFER: {
                    try {
                        this.m_socketChannel = this.checkSSL(this.m_socketChannel);
                        this.startSession();
                        break;
                    }
                    catch (ErrorException errorException) {
                        this.closeSession();
                        try {
                            this.m_socketChannel = this.connect();
                            this.startSession();
                            break;
                        }
                        catch (ErrorException errorException7) {
                            ErrorException errorException8;
                            if (null != this.m_fatalException) {
                                errorException8 = this.m_fatalException;
                            }
                            ErrorException errorException9 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), errorException8.getMessageParams());
                            throw errorException9;
                        }
                    }
                }
                case REQUIRE: 
                case VERIFY_CA: 
                case VERIFY_FULL: {
                    try {
                        this.m_socketChannel = this.checkSSL(this.m_socketChannel);
                        this.startSession();
                        break;
                    }
                    catch (ErrorException errorException) {
                        ErrorException errorException10;
                        if (null != this.m_fatalException) {
                            errorException10 = this.m_fatalException;
                        }
                        ErrorException errorException11 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), errorException10.getMessageParams());
                        throw errorException11;
                    }
                }
            }
            this.m_keyData = this.m_handler.m_keyData;
        }
        catch (ErrorException errorException) {
            LogUtilities.logFatal(errorException, (ILogger)this.m_log);
            this.closeSession();
            throw errorException;
        }
    }

    protected AbstractMessagesSocketChannel connect() throws ErrorException {
        Object object;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (this.m_log.isExternalLoggerEnabled()) {
            object = "Trying to establish a protocol version 3 connection to " + this.m_settings.m_host + ":" + this.m_settings.m_port;
            this.m_log.logInfoExternal((String)object);
        }
        try {
            this.m_handler = new InboundDataHandler(this.m_log, this.m_settings.m_nRowMode, FilterUtilities.translateLevel(this.m_settings.m_filterLevel));
            if (null != this.m_keyData) {
                this.m_handler.m_keyData = this.m_keyData;
            }
            object = new MessagesSocketChannel(SocketChannel.open(), this.m_handler, this.m_log);
            this.m_selector = Selector.open();
            ((AbstractMessagesSocketChannel)object).getSocketChannel().configureBlocking(true);
            ((AbstractMessagesSocketChannel)object).getSocketChannel().socket().connect(new InetSocketAddress(this.m_settings.m_host, this.m_settings.m_port), this.m_settings.m_loginTimeoutMS);
            ((AbstractMessagesSocketChannel)object).getSocketChannel().socket().setKeepAlive(false);
            if (0 < this.m_settings.m_newTCPConnectionKeepAliveMinutes) {
                ((AbstractMessagesSocketChannel)object).getSocketChannel().socket().setKeepAlive(true);
            }
            return object;
        }
        catch (IOException iOException) {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug(iOException, (ILogger)this.m_log);
            }
            this.closeSession();
            String string = iOException.getLocalizedMessage();
            if (null == string) {
                string = iOException.getClass().getSimpleName();
            }
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), string);
            errorException.initCause(iOException);
            throw errorException;
        }
    }

    protected void startSession() throws ErrorException {
        ErrorException errorException;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            this.m_socketChannel.getSocketChannel().configureBlocking(false);
            this.m_socketChannel.getSocketChannel().register(this.m_selector, 1);
        }
        catch (IllegalSelectorException illegalSelectorException) {
            LogUtilities.logFatal(illegalSelectorException, (ILogger)this.m_log);
            errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), illegalSelectorException.getMessage());
            errorException.initCause(illegalSelectorException);
        }
        catch (ClosedChannelException closedChannelException) {
            LogUtilities.logFatal(closedChannelException, (ILogger)this.m_log);
            errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), closedChannelException.getMessage());
            errorException.initCause(closedChannelException);
        }
        catch (IOException iOException) {
            LogUtilities.logFatal(iOException, (ILogger)this.m_log);
            errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), iOException.getMessage());
            errorException.initCause(iOException);
        }
        this.m_oneMessage[0] = new Startup(this.m_settings.m_username, this.m_settings.m_Schema, this.m_log);
        PGMessagingContext pGMessagingContext = new PGMessagingContext(this.m_socketChannel, 0, this.m_log, null, null);
        pGMessagingContext.openCurrentOperation();
        this.m_socketChannel.write((InboundMessagesPipeline)pGMessagingContext, this.m_oneMessage);
        if (this.m_log.isExternalLoggerEnabled()) {
            this.m_log.logDebugExternal("Receive Buffer Size is " + this.m_socketChannel.getReadBufferCapacity());
            this.m_log.logDebugExternal("Send Buffer Size is " + this.m_socketChannel.getReadBufferCapacity());
        }
        this.m_backgroundFetcher = new InboundMessagesThread(this.m_selector, this.m_socketChannel, this.m_handler, this.m_settings.m_newTCPConnectionKeepAliveMinutes, this.m_settings.m_host, this.m_settings.m_port, this.m_settings.m_socketTimeoutMS, this.m_log);
        this.m_backgroundFetcher.start();
        this.m_backgroundFetcher.addSocketCloseListener(this);
        for (int i = 0; i < 2; ++i) {
            Object object;
            Authentication authentication = null;
            authentication = pGMessagingContext.getAuthentication(this.m_settings.m_loginTimeoutMS);
            if (null == authentication) {
                LogUtilities.logFatal("Timeout waiting for respons to startup message.", (ILogger)this.m_log);
                object = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_TIMEOUT_ERR.name());
                throw object;
            }
            if (authentication.isAuthenticationOK()) {
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("Authentication is OK", (ILogger)this.m_log);
                }
                pGMessagingContext.checkErrorResponse(this.m_settings.m_loginTimeoutMS);
                if (null == this.m_fatalException) break;
                throw this.m_fatalException;
            }
            if (authentication.isClearTextPasswordRequired()) {
                if (null != this.m_settings.m_password) {
                    if (this.m_log.isEnabled()) {
                        LogUtilities.logDebug("Sending cleartext password", (ILogger)this.m_log);
                    }
                    this.m_oneMessage[0] = new PasswordMessage(this.m_settings.m_password, this.m_log);
                    this.m_socketChannel.write(null, this.m_oneMessage);
                    continue;
                }
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("Password required", (ILogger)this.m_log);
                }
                this.closeSession(false, true);
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.INVALID_LOGIN.name(), "Password required");
            }
            if (authentication.isMD5PasswordRequired()) {
                if (null != this.m_settings.m_password) {
                    if (this.m_log.isEnabled()) {
                        LogUtilities.logDebug("Sending MD5 password", (ILogger)this.m_log);
                    }
                    try {
                        object = MessageDigest.getInstance("MD5");
                        ((MessageDigest)object).update(new String(this.m_settings.m_password + this.m_settings.m_username).getBytes());
                        byte[] byArray = PGDataTypeUtilities.toHexString(((MessageDigest)object).digest());
                        ((MessageDigest)object).update(byArray, 0, byArray.length);
                        ((MessageDigest)object).update(authentication.getMD5SaltKey());
                        String string = new String(PGDataTypeUtilities.toHexString(((MessageDigest)object).digest()));
                        this.m_oneMessage[0] = new PasswordMessage("md5" + string, this.m_log);
                        this.m_socketChannel.write(null, this.m_oneMessage);
                        continue;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        LogUtilities.logFatal(noSuchAlgorithmException, (ILogger)this.m_log);
                        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_AUTH_MECH_UNSUPPORTED.name(), authentication.toString());
                    }
                }
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("Password required", (ILogger)this.m_log);
                }
                this.closeSession(false, true);
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.INVALID_LOGIN.name(), "Password required");
            }
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Authentication mechanism not supported: " + authentication.toString(), (ILogger)this.m_log);
            }
            this.closeSession(false, true);
            object = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_AUTH_MECH_UNSUPPORTED.name(), authentication.toString());
            throw object;
        }
    }

    public void cancelQuery() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            CancelRequest cancelRequest = new CancelRequest(this.m_keyData, this.m_log);
            AbstractMessagesSocketChannel abstractMessagesSocketChannel = this.connect();
            if (this.m_socketChannel instanceof SSLMessagesSocketChannel) {
                abstractMessagesSocketChannel = this.checkSSL(abstractMessagesSocketChannel);
            }
            AbstractOutboundMessage[] abstractOutboundMessageArray = new AbstractOutboundMessage[]{cancelRequest};
            abstractMessagesSocketChannel.write(null, abstractOutboundMessageArray);
            try {
                abstractMessagesSocketChannel.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
            abstractMessagesSocketChannel.close();
        }
        catch (Exception exception) {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug(exception, (ILogger)this.m_log);
            }
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_GENERAL_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    public void closeSession() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.closeSession(true, true);
    }

    public void closeSession(boolean bl, boolean bl2) {
        LogUtilities.logFunctionEntrance(this.m_log, bl);
        if (null == this.m_socketChannel || !this.m_socketChannel.getSocketChannel().isConnected()) {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Channel is not connected.", (ILogger)this.m_log);
            }
        } else if (bl && null != this.m_socketChannel && this.m_socketChannel.getSocketChannel().isConnected()) {
            AbstractOutboundMessage[] abstractOutboundMessageArray = new AbstractOutboundMessage[]{new Terminate(this.m_log)};
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Sending terminate message", (ILogger)this.m_log);
            }
            try {
                this.m_socketChannel.write((InboundMessagesPipeline)new PGMessagingContext(this.m_socketChannel, this.m_settings.m_nRowMode, this.m_log, null, null), abstractOutboundMessageArray);
            }
            catch (ErrorException errorException) {
                // empty catch block
            }
        }
        if (bl2 && null != this.m_backgroundFetcher) {
            LogUtilities.logDebug("Closing background thread", (ILogger)this.m_log);
            this.m_backgroundFetcher.close(null);
        }
        if (null != this.m_socketChannel && this.m_socketChannel.getSocketChannel().isOpen()) {
            LogUtilities.logDebug("Closing socket channel", (ILogger)this.m_log);
            this.m_socketChannel.close();
            this.m_socketChannel = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<PGMessagingContext> directExecute(String string, int n, IWarningListener iWarningListener) throws ErrorException {
        int n2;
        LogUtilities.logFunctionEntrance(this.m_log, string);
        ArrayList<PGMessagingContext> arrayList = new ArrayList<PGMessagingContext>();
        int n3 = n2 = n >= 5 ? n : this.m_settings.m_nRowMode;
        if (this.isConnected()) {
            try {
                List<String> list;
                try {
                    list = ParseQueryUtils.splitQueries(string);
                }
                catch (ParsingException parsingException) {
                    ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Parsing failed", string}, (Throwable)parsingException);
                    throw errorException;
                }
                if (1 == list.size()) {
                    IInboundMessage iInboundMessage;
                    Object object;
                    PGMessagingContext pGMessagingContext = new PGMessagingContext(this.m_socketChannel, n2, this.m_log, this.m_connectionWarningListener, iWarningListener);
                    pGMessagingContext.openCurrentOperation();
                    pGMessagingContext.m_query = string;
                    pGMessagingContext.m_isPreparedStatement = false;
                    this.m_sixMessages[0] = new Parse(null, string, null, this.m_log);
                    this.m_sixMessages[1] = new Bind(null, null, null, null, null, this.m_log);
                    this.m_sixMessages[2] = new Describe(null, Describe.DescribeType.PORTAL, this.m_log);
                    this.m_sixMessages[3] = new Execute(null, 0, this.m_log);
                    this.m_sixMessages[4] = new Flush(this.m_log);
                    this.m_sixMessages[5] = new Sync(this.m_log);
                    if (pGMessagingContext.m_isCanceled) return arrayList;
                    this.m_socketChannel.write((InboundMessagesPipeline)pGMessagingContext, this.m_sixMessages);
                    arrayList.add(pGMessagingContext);
                    while (null == pGMessagingContext.getBindComplete(0) && null == this.m_fatalException) {
                        object = pGMessagingContext.peekNextMessage(this.m_settings.m_socketTimeoutMS);
                        if (!(object instanceof ErrorResponse)) continue;
                        pGMessagingContext.getErrorResponse(0);
                    }
                    object = (OperationMetadataImpl)pGMessagingContext.getOperationMetadata(0);
                    if (null != object && null == ((OperationMetadataImpl)object).m_readyForQueryFromPipelineForQuery && (iInboundMessage = pGMessagingContext.peekNextMessage(this.m_settings.m_socketTimeoutMS)) instanceof ErrorResponse) {
                        pGMessagingContext.getErrorResponse(0);
                    }
                    if (null == this.m_fatalException) return arrayList;
                    throw this.m_fatalException;
                }
                for (String string2 : list) {
                    IInboundMessage iInboundMessage;
                    Object object;
                    PGMessagingContext pGMessagingContext = new PGMessagingContext(this.m_socketChannel, n2, this.m_log, this.m_connectionWarningListener, iWarningListener);
                    try {
                        if (!pGMessagingContext.m_isCanceled) {
                            pGMessagingContext = this.prepareStatementForDirectExecute(pGMessagingContext, string2);
                            pGMessagingContext.getReadyForQuery(0, true);
                        }
                    }
                    catch (ErrorException errorException) {
                        // empty catch block
                    }
                    if (pGMessagingContext.m_isCanceled || null != this.m_fatalException) continue;
                    arrayList.add(pGMessagingContext);
                    this.executePreparedStatement(pGMessagingContext, null, false, true);
                    while (null == pGMessagingContext.getBindComplete(0) && null == this.m_fatalException) {
                        object = pGMessagingContext.peekNextMessage(this.m_settings.m_socketTimeoutMS);
                        if (!(object instanceof ErrorResponse)) continue;
                        pGMessagingContext.getErrorResponse(0);
                    }
                    object = (OperationMetadataImpl)pGMessagingContext.getOperationMetadata(0);
                    if (null != object && null == ((OperationMetadataImpl)object).m_readyForQueryFromPipelineForQuery && (iInboundMessage = pGMessagingContext.peekNextMessage(this.m_settings.m_socketTimeoutMS)) instanceof ErrorResponse) {
                        pGMessagingContext.getErrorResponse(0);
                    }
                    if (null == this.m_fatalException) continue;
                    throw this.m_fatalException;
                }
                return arrayList;
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        }
        LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public void directExecuteImmediately(String string, IWarningListener iWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        if (this.isConnected()) {
            try {
                PGMessagingContext pGMessagingContext = new PGMessagingContext(this.m_socketChannel, 0, this.m_log, this.m_connectionWarningListener, iWarningListener);
                pGMessagingContext.m_query = string;
                pGMessagingContext.openCurrentOperation();
                ++pGMessagingContext.m_operationsExecuted;
                this.m_oneMessage[0] = new Query(string, this.m_log);
                this.m_socketChannel.write((InboundMessagesPipeline)pGMessagingContext, this.m_oneMessage);
                this.checkTimeOut(pGMessagingContext);
                pGMessagingContext.closeBatch(0);
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        } else {
            LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        }
    }

    public void executePreparedStatement(PGMessagingContext pGMessagingContext, byte[][] byArray, boolean bl, boolean bl2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, pGMessagingContext.m_query);
        if (this.isConnected()) {
            try {
                short[] sArray = null;
                if (null != byArray) {
                    sArray = this.buildFormatCodes(byArray.length, bl);
                }
                pGMessagingContext.clearPortalNames();
                pGMessagingContext.addPortalName(this.generateSynthteticPortalName(0));
                pGMessagingContext.openCurrentOperation();
                pGMessagingContext.m_isCanceled = false;
                ++pGMessagingContext.m_operationsExecuted;
                if (!bl2) {
                    this.m_fiveMessages[0] = new Bind(pGMessagingContext.getPortalName(0), pGMessagingContext.m_preparedStatementName, sArray, byArray, null, this.m_log);
                    this.m_fiveMessages[1] = new Describe(pGMessagingContext.getPortalName(0), Describe.DescribeType.PORTAL, this.m_log);
                    this.m_fiveMessages[2] = new Execute(pGMessagingContext.getPortalName(0), 0, this.m_log);
                    this.m_fiveMessages[3] = new Flush(this.m_log);
                    this.m_fiveMessages[4] = new Sync(this.m_log);
                    this.m_socketChannel.write((InboundMessagesPipeline)pGMessagingContext, this.m_fiveMessages);
                } else {
                    this.m_sixMessages[0] = new Bind(pGMessagingContext.getPortalName(0), pGMessagingContext.m_preparedStatementName, sArray, byArray, null, this.m_log);
                    this.m_sixMessages[1] = new Describe(pGMessagingContext.getPortalName(0), Describe.DescribeType.PORTAL, this.m_log);
                    this.m_sixMessages[2] = new Execute(pGMessagingContext.getPortalName(0), 0, this.m_log);
                    this.m_sixMessages[3] = new Close(pGMessagingContext.m_preparedStatementName, Close.CloseType.PREPARED_STATEMENT, this.m_log);
                    this.m_sixMessages[4] = new Flush(this.m_log);
                    this.m_sixMessages[5] = new Sync(this.m_log);
                    pGMessagingContext.m_preparedStatementName = null;
                    this.m_socketChannel.write((InboundMessagesPipeline)pGMessagingContext, this.m_fiveMessages);
                }
                IInboundMessage iInboundMessage = pGMessagingContext.peekNextMessage(this.m_settings.m_socketTimeoutMS);
                if (iInboundMessage instanceof ErrorResponse) {
                    pGMessagingContext.getErrorResponse(0);
                }
                this.checkTimeOut(pGMessagingContext);
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        } else {
            LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        }
    }

    public void executePreparedStatementBatch(PGMessagingContext pGMessagingContext, int n, byte[][][] byArray, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, pGMessagingContext.m_query);
        if (this.isConnected()) {
            try {
                int n2;
                AbstractOutboundMessage[] abstractOutboundMessageArray = new AbstractOutboundMessage[byArray.length * 2 + 2];
                pGMessagingContext.openCurrentOperation();
                pGMessagingContext.m_isCanceled = false;
                pGMessagingContext.m_operationsExecuted += byArray.length;
                pGMessagingContext.clearPortalNames();
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    byte[] byArray2 = this.generateSynthteticPortalName(n2);
                    pGMessagingContext.addPortalName(byArray2);
                    abstractOutboundMessageArray[n2 * 2] = new Bind(byArray2, pGMessagingContext.m_preparedStatementName, this.buildFormatCodes(byArray[n2].length, bl), byArray[n2], null, this.m_log);
                    abstractOutboundMessageArray[n2 * 2 + 1] = new Execute(byArray2, 0, this.m_log);
                }
                abstractOutboundMessageArray[abstractOutboundMessageArray.length - 2] = new Flush(this.m_log);
                abstractOutboundMessageArray[abstractOutboundMessageArray.length - 1] = new Sync(this.m_log);
                this.m_socketChannel.write((InboundMessagesPipeline)pGMessagingContext, abstractOutboundMessageArray);
                this.checkTimeOut(pGMessagingContext);
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    int n3 = n2 + n * byArray.length;
                    while (null == pGMessagingContext.getBindComplete(n3) && null == this.m_fatalException) {
                    }
                    if (null == this.m_fatalException) continue;
                    throw this.m_fatalException;
                }
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        } else {
            LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        }
    }

    public PGMessagingContext prepareStatement(String string, List<Integer> list, IWarningListener iWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        int n = this.m_settings.m_nRowMode;
        PGMessagingContext pGMessagingContext = new PGMessagingContext(this.m_socketChannel, n, this.m_log, this.m_connectionWarningListener, iWarningListener);
        pGMessagingContext.openCurrentOperation();
        pGMessagingContext.m_query = string;
        pGMessagingContext.m_isPreparedStatement = true;
        pGMessagingContext.m_preparedStatementName = this.generateSynthteticPreparedStatementName();
        if (this.isConnected()) {
            try {
                this.m_fourMessages[0] = new Parse(pGMessagingContext.m_preparedStatementName, string, list, this.m_log);
                this.m_fourMessages[1] = new Describe(pGMessagingContext.m_preparedStatementName, Describe.DescribeType.PREPARED_STATEMENT, this.m_log);
                this.m_fourMessages[2] = new Flush(this.m_log);
                this.m_fourMessages[3] = new Sync(this.m_log);
                this.m_socketChannel.write((InboundMessagesPipeline)pGMessagingContext, this.m_fourMessages);
                ParameterDescription parameterDescription = null;
                OperationMetadataImpl operationMetadataImpl = (OperationMetadataImpl)pGMessagingContext.getOperationMetadata(0);
                if (null == operationMetadataImpl || null == operationMetadataImpl.m_readyForQueryFromPipelineForQuery) {
                    LogUtilities.logError("ReadyForQuery not received.", (ILogger)this.m_log);
                }
                if (null != (parameterDescription = pGMessagingContext.getParameterDescription())) {
                    for (int i = 0; i < parameterDescription.getParameterDataTypeOIDs().length; ++i) {
                        int n2 = parameterDescription.getParameterDataTypeOIDs()[i];
                        int n3 = i + 1;
                        try {
                            pGMessagingContext.m_parameterMetadata.add(PGDataTypeUtilities.createParameter(n2, n3));
                            continue;
                        }
                        catch (NumericOverflowException numericOverflowException) {
                            LogUtilities.logFatal(numericOverflowException, (ILogger)this.m_log);
                            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), numericOverflowException.getMessage());
                            errorException.initCause(numericOverflowException);
                        }
                    }
                }
                pGMessagingContext.getReadyForQuery(0, true);
                return pGMessagingContext;
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        }
        LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public void closePreparedStatement(PGMessagingContext pGMessagingContext, IWarningListener iWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, pGMessagingContext.m_query);
        if (this.isConnected()) {
            try {
                PGMessagingContext pGMessagingContext2 = new PGMessagingContext(this.m_socketChannel, 0, this.m_log, this.m_connectionWarningListener, iWarningListener);
                pGMessagingContext2.openCurrentOperation();
                this.m_threeMessages[0] = new Close(pGMessagingContext.m_preparedStatementName, Close.CloseType.PREPARED_STATEMENT, this.m_log);
                this.m_threeMessages[1] = new Flush(this.m_log);
                this.m_threeMessages[2] = new Sync(this.m_log);
                this.m_socketChannel.write((InboundMessagesPipeline)pGMessagingContext2, this.m_threeMessages);
                pGMessagingContext2.getReadyForQuery(0, false);
                this.checkTimeOut(pGMessagingContext);
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        } else {
            LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        }
    }

    public PGMessagingContext prepareStatementForDirectExecute(PGMessagingContext pGMessagingContext, String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        pGMessagingContext.openCurrentOperation();
        pGMessagingContext.m_query = string;
        pGMessagingContext.m_preparedStatementName = this.generateSynthteticPreparedStatementName();
        if (this.isConnected()) {
            try {
                this.m_fourMessages[0] = new Parse(pGMessagingContext.m_preparedStatementName, string, null, this.m_log);
                this.m_fourMessages[1] = new Describe(pGMessagingContext.m_preparedStatementName, Describe.DescribeType.PREPARED_STATEMENT, this.m_log);
                this.m_fourMessages[2] = new Flush(this.m_log);
                this.m_fourMessages[3] = new Sync(this.m_log);
                this.m_socketChannel.write((InboundMessagesPipeline)pGMessagingContext, this.m_fourMessages);
                ParameterDescription parameterDescription = null;
                OperationMetadataImpl operationMetadataImpl = (OperationMetadataImpl)pGMessagingContext.getOperationMetadata(0);
                if (null == operationMetadataImpl || null == operationMetadataImpl.m_readyForQueryFromPipelineForQuery) {
                    LogUtilities.logError("ReadyForQuery not received.", (ILogger)this.m_log);
                }
                if (null != (parameterDescription = pGMessagingContext.getParameterDescription())) {
                    for (int i = 0; i < parameterDescription.getParameterDataTypeOIDs().length; ++i) {
                        int n = parameterDescription.getParameterDataTypeOIDs()[i];
                        int n2 = i + 1;
                        try {
                            pGMessagingContext.m_parameterMetadata.add(PGDataTypeUtilities.createParameter(n, n2));
                            continue;
                        }
                        catch (NumericOverflowException numericOverflowException) {
                            LogUtilities.logFatal(numericOverflowException, (ILogger)this.m_log);
                            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), numericOverflowException.getMessage());
                            errorException.initCause(numericOverflowException);
                        }
                    }
                }
                return pGMessagingContext;
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        }
        LogUtilities.logFatal("Not Connected", (ILogger)this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public boolean isConnected() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null == this.m_socketChannel || !this.m_socketChannel.getSocketChannel().isConnected()) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), "Not Connected");
        }
        return true;
    }

    private SSLMessagesSocketChannel checkSSL(AbstractMessagesSocketChannel abstractMessagesSocketChannel) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        SSLMessagesSocketChannel sSLMessagesSocketChannel = null;
        try {
            this.m_oneMessage[0] = new SSLRequest(this.m_log);
            abstractMessagesSocketChannel.write(null, this.m_oneMessage);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
            int n = abstractMessagesSocketChannel.getSocketChannel().read(byteBuffer);
            byteBuffer.flip();
            if (n < 0) {
                LogUtilities.logDebug("createSSLSocketChannel:0 Bytes Read, Server closed socket.", (ILogger)this.m_log);
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), "The server closed the connection.");
            }
            char c = (char)byteBuffer.get();
            switch (c) {
                case 'S': {
                    LogUtilities.logDebug("createSSLSocketChannel:SSL Supported", (ILogger)this.m_log);
                    abstractMessagesSocketChannel.getSocketChannel().configureBlocking(false);
                    TrustManager[] trustManagerArray = null;
                    trustManagerArray = true == this.m_settings.m_validate ? this.getDefaultTrustManager() : new TrustManager[]{new NonValidatingFactory()};
                    sSLMessagesSocketChannel = new SSLMessagesSocketChannel(abstractMessagesSocketChannel.getSocketChannel(), this.m_handler, this.m_settings.m_host, this.m_settings.m_port, null, trustManagerArray, this.m_log);
                    break;
                }
                case 'N': {
                    LogUtilities.logFatal("createSSLSocketChannel:SSL Not Supported (Unwilling)", (ILogger)this.m_log);
                    break;
                }
                case 'E': {
                    ErrorResponse errorResponse = null;
                    try {
                        int n2 = byteBuffer.getInt();
                        errorResponse = new ErrorResponse(byteBuffer, n2, this.m_log);
                        LogUtilities.logFatal(errorResponse.getMessage(), (ILogger)this.m_log);
                    }
                    catch (Exception exception) {
                        LogUtilities.logFatal("Attempting to connect to very old Server version.", (ILogger)this.m_log);
                        LogUtilities.logFatal(exception, (ILogger)this.m_log);
                    }
                    break;
                }
            }
            return sSLMessagesSocketChannel;
        }
        catch (IOException iOException) {
            LogUtilities.logFatal(iOException, (ILogger)this.m_log);
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), iOException.getMessage());
            errorException.initCause(iOException);
            throw errorException;
        }
    }

    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_connectionWarningListener = iWarningListener;
        this.m_handler.registerWarningListener(iWarningListener);
    }

    @Override
    public void socketClosed(ErrorException errorException) {
        LogUtilities.logFunctionEntrance(this.m_log, errorException);
        if (null != errorException) {
            this.m_fatalException = errorException;
        }
        this.closeSession(false, false);
    }

    public short[] buildFormatCodes(int n, boolean bl) {
        short[][] sArray = bl ? this.m_cachedBinaryFormatCodes : this.m_cachedTextFormatCodes;
        if (n < 30 && null != sArray[n]) {
            return sArray[n];
        }
        short[] sArray2 = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray2[i] = bl ? (short)1 : 0;
        }
        if (n < 30) {
            sArray[n] = sArray2;
        }
        return sArray2;
    }

    private TrustManager[] getDefaultTrustManager() throws ErrorException {
        FileInputStream fileInputStream = null;
        String string = null;
        String string2 = System.getProperty(TRUSTSTORE_PROPERTY);
        string = System.getProperty(TRUSTSTORE_PWD_PROPERTY);
        if (null == string2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(System.getProperty("java.home"));
            stringBuilder.append(File.separatorChar);
            stringBuilder.append("lib");
            stringBuilder.append(File.separatorChar);
            stringBuilder.append("security");
            stringBuilder.append(File.separatorChar);
            stringBuilder.append("cacerts");
            string2 = stringBuilder.toString();
        }
        try {
            fileInputStream = new FileInputStream(new File(string2));
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), "Error loading the keystore ");
            LogUtilities.logError(errorException, (ILogger)this.m_log);
            throw errorException;
        }
        return this.getExternalKeystoreTrustManager(fileInputStream, string);
    }

    private TrustManager[] getExternalKeystoreTrustManager(InputStream inputStream, String string) throws ErrorException {
        Object object;
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            object = null;
            if (null != string) {
                object = string.toCharArray();
            }
            keyStore.load(inputStream, (char[])object);
            inputStream.close();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), "Error loading the provided keystore");
            LogUtilities.logError(errorException, (ILogger)this.m_log);
            throw errorException;
        }
        try {
            object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object).init(keyStore);
            return ((TrustManagerFactory)object).getTrustManagers();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), "Error retrieving the available trust managers");
            LogUtilities.logError(errorException, (ILogger)this.m_log);
            throw errorException;
        }
    }

    private byte[] generateSynthteticPortalName(int n) {
        return new String("PGJDBCPRTL-" + n + "-" + System.nanoTime()).getBytes();
    }

    private byte[] generateSynthteticPreparedStatementName() {
        return new String(SYNTHETIC_PREPARED_STATEMENT_NAME_SEED + System.nanoTime()).getBytes();
    }

    private void checkTimeOut(PGMessagingContext pGMessagingContext) throws ErrorException {
        if (this.m_settings.m_socketTimeoutMS > 0) {
            IInboundMessage iInboundMessage = null;
            iInboundMessage = pGMessagingContext.peekNextMessage(this.m_settings.m_socketTimeoutMS);
            if (null == iInboundMessage) {
                LogUtilities.logFatal("The Socket Has TimedOut.", (ILogger)this.m_log);
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_SOCKET_TIMEOUT_ERR.name());
                throw errorException;
            }
        }
    }

    private int getMaxExtraFloatDigits() throws ErrorException {
        ArrayList<String> arrayList = new ArrayList<String>();
        PGResultSet pGResultSet = new PGResultSet(this.directExecute("SELECT character_value, version() FROM INFORMATION_SCHEMA.SQL_IMPLEMENTATION_INFO WHERE implementation_info_id = '17' or implementation_info_id = '18'", 0, null).get(0), 0, this.m_log);
        while (pGResultSet.hasMoreRows()) {
            DataWrapper dataWrapper = new DataWrapper();
            pGResultSet.moveToNextRow();
            pGResultSet.getData(0, 0L, -1L, dataWrapper);
            try {
                String string = "";
                if (null != dataWrapper.getVarChar()) {
                    string = dataWrapper.getVarChar();
                }
                arrayList.add(string);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), incorrectTypeException);
            }
        }
        pGResultSet.close();
        PGCoreUtils.SERVER_NAME = (String)arrayList.get(0);
        PGCoreUtils.SERVER_VERSION = (String)arrayList.get(1);
        int n = Integer.parseInt(PGCoreUtils.SERVER_VERSION.split("\\.")[0]);
        if (n >= 9) {
            return 3;
        }
        return 2;
    }

    private ErrorException buildError(Exception exception) {
        if (null != this.m_fatalException) {
            return this.m_fatalException;
        }
        if (exception instanceof ErrorException) {
            return (ErrorException)exception;
        }
        ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        errorException.initCause(exception);
        return errorException;
    }
}

