/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.api;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.ColumnMetadata;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.Nullable;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.dataengine.utilities.ParameterType;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.dataengine.utilities.Updatable;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.jdbc.utils.DataTypeUtilities;
import com.amazon.redshift.api.PGArrayColumnMetaData;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.messages.inbound.FieldDescription;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.dataengine.metadata.PGColumnMetadata;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class PGDataTypeUtilities
extends DataTypeUtilities
implements PGConstants {
    private static final int utf8InvalidValue = -1;
    private static final byte asciiInvalidValue = 127;
    private static final int OCTAL_FORMAT_MASK_UPPER = 240;
    private static final int OCTAL_FORMAT_MASK_LOWER = 15;
    private static final byte HEX_ENCODE_BYTE = 120;
    private static final byte HEX_BINARY_ESCAPE = 92;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.");
    private static final NumberFormat NANOSECONDS_FORMAT = new DecimalFormat("000000000");
    public static final String INFINITY_KEYWORD = "infinity";
    public static final String MINUS_INFINITY_KEYWORD = "-infinity";
    public static final Timestamp INFINITY_DATE_VALUE = new Timestamp(Long.MAX_VALUE);
    public static final Timestamp MINUS_INFINITY_DATE_VALUE = new Timestamp(Long.MIN_VALUE);
    public static final int DEFAULT_PARAMETER_LENGTH = -1;

    public static ColumnMetadata createColumn(String string, String string2, String string3, String string4, FieldDescription fieldDescription) throws ErrorException {
        int n = fieldDescription.getDataTypeSize();
        boolean bl = false;
        ColumnMetadata columnMetadata = null;
        switch (fieldDescription.getDataTypeObjectID()) {
            case 2206: {
                n = 255;
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "regtype"));
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 24: {
                n = 255;
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "regproc"));
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 19: {
                n = 64;
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "name"));
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 25: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "text"));
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 1043: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "varchar"));
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 1033: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "aclitem"));
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 2211: {
                n = 255;
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 12, n, "_regtype");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 1008: {
                n = 255;
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 12, n, "_regproc");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 1003: {
                n = 64;
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 12, n, "_name");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 1009: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 12, n, "_text");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 1034: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 12, n, "aclitem");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 1015: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 12, n, "_varchar");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 18: {
                n = 1;
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(1, "char"));
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 1042: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(1, "bpchar"));
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 1002: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 1, n, "_char");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 1014: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 1, n, "_bpchar");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 21: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(5, "int2"));
                break;
            }
            case 1005: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 5, n, "_int2");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 28: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(4, "xid"));
                break;
            }
            case 23: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(4, "int4"));
                break;
            }
            case 1011: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 4, n, "_xid");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 1007: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 4, n, "_int4");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 20: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(-5, "int8"));
                break;
            }
            case 26: {
                bl = true;
                n = 10;
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(-5, "oid"));
                break;
            }
            case 1016: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, -5, n, "_int8");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 1028: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, -5, n, "_oid");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 700: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(7, "float4"));
                break;
            }
            case 1021: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 7, n, "_float4");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 701: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(8, "float8"));
                break;
            }
            case 1022: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 8, n, "_float8");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 1082: {
                columnMetadata = new PGColumnMetadata(PGDataTypeUtilities.createTypeMetadata(91, "date"));
                break;
            }
            case 1182: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 91, n, "_date");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 1083: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(92, "time"));
                break;
            }
            case 1183: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 92, n, "_time");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 1114: {
                columnMetadata = new PGColumnMetadata(PGDataTypeUtilities.createTypeMetadata(93, "timestamp"));
                break;
            }
            case 1115: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 93, n, "_timestamp");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 702: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "abstime"));
                break;
            }
            case 1023: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 12, n, "_abstime");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 1186: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "internal"));
                break;
            }
            case 703: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "reltime"));
                break;
            }
            case 1024: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 12, n, "_reltime");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 16: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(-7, "bool"));
                break;
            }
            case 1560: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(-7, "bit"));
                break;
            }
            case 1000: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, -7, n, "_bool");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 1561: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, -7, n, "_bit");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 1700: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(2, "numeric"));
                break;
            }
            case 1231: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 2, n, "_numeric");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 27: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "tid"));
                columnMetadata.setCaseSensitive(true);
                break;
            }
            case 1010: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, 12, n, "_tid");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 17: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(-4, "bytea"));
                break;
            }
            case 1001: {
                IColumn iColumn = PGDataTypeUtilities.createBaseArrayColumn(string, string2, string3, string4, -4, n, "_bytea");
                columnMetadata = new PGArrayColumnMetaData(iColumn);
                break;
            }
            case 22: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "int2vector"));
                break;
            }
            default: {
                columnMetadata = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, null));
                break;
            }
        }
        if (columnMetadata.getTypeMetadata().isIntervalType() || columnMetadata.getTypeMetadata().isCharacterType()) {
            columnMetadata.getTypeMetadata().setIntervalPrecision(n);
        }
        if (columnMetadata.getTypeMetadata().isCharacterType()) {
            try {
                columnMetadata.setColumnLength(n);
            }
            catch (NumericOverflowException numericOverflowException) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_METADATA_INITIALIZATION_ERR.name(), numericOverflowException);
            }
        }
        if (bl) {
            columnMetadata.getTypeMetadata().setPrecision((short)n);
        } else if (columnMetadata.getTypeMetadata().isExactNumericType()) {
            int n2 = n - 4 >> 16 & 0xFFFF;
            int n3 = n - 4 & 0xFFFF;
            columnMetadata.getTypeMetadata().setPrecision((short)n2);
            columnMetadata.getTypeMetadata().setScale((short)n3);
        }
        try {
            columnMetadata.setName(new String(fieldDescription.getFieldName(), "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            columnMetadata.setName(string4);
        }
        columnMetadata.setLabel(columnMetadata.getName());
        columnMetadata.setCatalogName(string);
        columnMetadata.setTableName(string3);
        columnMetadata.setUpdatable(Updatable.READ_ONLY);
        return columnMetadata;
    }

    public static TypeMetadata createTypeMetadata(int n, String string) throws ErrorException {
        switch (n) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return PGDataTypeUtilities.createTypeMetadata(n, true, string);
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 2003: {
                return PGDataTypeUtilities.createTypeMetadata(n, false, string);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED_NUM.name(), String.valueOf(n), ExceptionType.DATA);
    }

    public static String sqlTypeToString(short s) {
        switch (s) {
            case 2003: {
                return "SQL_ARRAY";
            }
            case -5: {
                return "int8";
            }
            case 3: {
                return "float8";
            }
            case 8: {
                return "float8";
            }
            case 6: {
                return "float4";
            }
            case 4: {
                return "int4";
            }
            case 2: {
                return "numeric";
            }
            case 0: {
                return "NULL";
            }
            case 7: {
                return "float4";
            }
            case 5: {
                return "int2";
            }
            case -2: {
                return "bytea";
            }
            case -7: {
                return "bit";
            }
            case 16: {
                return "bool";
            }
            case 1: {
                return "char";
            }
            case -4: {
                return "bytea";
            }
            case -1: {
                return "varchar";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
            case -6: {
                return "SQL_TINYINT";
            }
            case -3: {
                return "bytea";
            }
            case 12: {
                return "varchar";
            }
            case -11: {
                return "SQL_GUID";
            }
            case -8: {
                return "SQL_WCHAR";
            }
            case -9: {
                return "SQL_WVARCHAR";
            }
            case -10: {
                return "SQL_WLONGVARCHAR";
            }
            case 103: {
                return "SQL_INTERVAL_DAY";
            }
            case 108: {
                return "SQL_INTERVAL_DAY_TO_HOUR";
            }
            case 109: {
                return "SQL_INTERVAL_DAY_TO_MINUTE";
            }
            case 110: {
                return "SQL_INTERVAL_DAY_TO_SECOND";
            }
            case 104: {
                return "SQL_INTERVAL_HOUR";
            }
            case 111: {
                return "SQL_INTERVAL_HOUR_TO_MINUTE";
            }
            case 112: {
                return "SQL_INTERVAL_HOUR_TO_SECOND";
            }
            case 105: {
                return "SQL_INTERVAL_MINUTE";
            }
            case 113: {
                return "SQL_INTERVAL_MINUTE_TO_SECOND";
            }
            case 102: {
                return "SQL_INTERVAL_MONTH";
            }
            case 106: {
                return "SQL_INTERVAL_SECOND";
            }
            case 101: {
                return "SQL_INTERVAL_YEAR";
            }
            case 107: {
                return "SQL_INTERVAL_YEAR_TO_MONTH";
            }
        }
        return null;
    }

    public static TypeMetadata createTypeMetadata(int n, boolean bl, String string) throws ErrorException {
        switch (n) {
            case 2003: {
                TypeMetadata typeMetadata = new TypeMetadata((short)n, string != null ? string : "SQL_ARRAY", 0, 0, 0, bl);
                typeMetadata.setIsSortable(false);
                return typeMetadata;
            }
            case -5: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_BIGINT", 19, 0, 19, bl);
            }
            case -2: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_BINARY", 1, 0, 1, bl);
            }
            case -7: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_BIT", 1, 0, 0, bl);
            }
            case 16: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_BOOLEAN", 1, 0, 0, bl);
            }
            case 1: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_CHAR", 1, 0, 1, bl);
            }
            case 3: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_DECIMAL", 38, 0, 38, bl);
            }
            case 8: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_DOUBLE", 17, 17, 53, bl);
            }
            case 6: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_FLOAT", 15, 0, 53, bl);
            }
            case -11: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_GUID", 36, 0, 36, bl);
            }
            case 4: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_INTEGER", 10, 0, 0, bl);
            }
            case -4: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_LONGVARBINARY", 1, 0, 1, bl);
            }
            case -1: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_LONGVARCHAR", 1, 0, 1, bl);
            }
            case 0: {
                return new TypeMetadata((short)n, string != null ? string : "NULL", 0, 0, 0, bl);
            }
            case 2: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_NUMERIC", 38, 0, 38, bl);
            }
            case 7: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_REAL", 7, 0, 24, bl);
            }
            case 5: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_SMALLINT", 5, 0, 5, bl);
            }
            case -6: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_TINYINT", 3, 0, 3, bl);
            }
            case 91: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_TYPE_DATE", 0, 0, 10, bl);
            }
            case 92: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_TYPE_TIME", 0, 0, 8, bl);
            }
            case 93: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_TYPE_TIMESTAMP", 6, 6, 0, bl);
            }
            case -3: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_VARBINARY", 1, 0, 1, bl);
            }
            case 12: {
                return new TypeMetadata((short)n, null != string ? string : "SQL_VARCHAR", 1, 0, 1, bl);
            }
            case 103: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_INTERVAL_DAY", 0, 0, 2, bl);
            }
            case 108: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_INTERVAL_DAY_TO_HOUR", 0, 0, 2, bl);
            }
            case 109: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_INTERVAL_DAY_TO_MINUTE", 0, 0, 2, bl);
            }
            case 110: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_INTERVAL_DAY_TO_SECOND", 6, 6, 2, bl);
            }
            case 104: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_INTERVAL_HOUR", 0, 0, 2, bl);
            }
            case 111: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_INTERVAL_HOUR_TO_MINUTE", 0, 0, 2, bl);
            }
            case 112: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_INTERVAL_HOUR_TO_SECOND", 6, 6, 2, bl);
            }
            case 105: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_INTERVAL_MINUTE", 0, 0, 2, bl);
            }
            case 113: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_INTERVAL_MINUTE_TO_SECOND", 6, 6, 2, bl);
            }
            case 102: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_INTERVAL_MONTH", 0, 0, 2, bl);
            }
            case 106: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_INTERVAL_SECOND", 6, 6, 2, bl);
            }
            case 101: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_INTERVAL_YEAR", 0, 0, 2, bl);
            }
            case 107: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_INTERVAL_YEAR_TO_MONTH", 0, 0, 2, bl);
            }
            case -8: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_WCHAR", 0, 0, 0, bl);
            }
            case -10: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_WLONGVARCHAR", 0, 0, 0, bl);
            }
            case -9: {
                return new TypeMetadata((short)n, string != null ? string : "SQL_WVARCHAR", 0, 0, 0, bl);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED_NUM.name(), String.valueOf(n), ExceptionType.DATA);
    }

    public static int oidToSQLType(int n) {
        switch (n) {
            case 19: 
            case 24: 
            case 25: 
            case 1033: 
            case 1043: 
            case 2206: {
                return 12;
            }
            case 18: 
            case 1042: {
                return 1;
            }
            case 21: {
                return 5;
            }
            case 23: 
            case 28: {
                return 4;
            }
            case 20: 
            case 26: {
                return -5;
            }
            case 700: {
                return 7;
            }
            case 701: {
                return 8;
            }
            case 1082: {
                return 91;
            }
            case 1083: {
                return 92;
            }
            case 1114: {
                return 93;
            }
            case 702: {
                return 12;
            }
            case 703: 
            case 1186: {
                return 12;
            }
            case 16: 
            case 1560: {
                return -7;
            }
            case 1700: {
                return 2;
            }
            case 27: {
                return 12;
            }
            case 17: {
                return -4;
            }
            case 22: {
                return 12;
            }
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1005: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1021: 
            case 1022: 
            case 1023: 
            case 1024: 
            case 1028: 
            case 1034: 
            case 1115: 
            case 1182: 
            case 1183: 
            case 1231: 
            case 1561: 
            case 2211: {
                return 2003;
            }
        }
        return 12;
    }

    public static ParameterMetadata createParameter(int n, int n2) throws NumericOverflowException, ErrorException {
        ParameterMetadata parameterMetadata = null;
        int n3 = -1;
        switch (n) {
            case 2206: {
                n3 = 255;
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "regtype"), n3, null, false, Nullable.UNKNOWN);
                break;
            }
            case 24: {
                n3 = 255;
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "regproc"), n3, null, false, Nullable.UNKNOWN);
                break;
            }
            case 19: {
                n3 = 64;
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "name"), n3, null, false, Nullable.UNKNOWN);
                break;
            }
            case 25: {
                n3 = 255;
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "text"), n3, null, false, Nullable.UNKNOWN);
                break;
            }
            case 1043: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "varchar"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 27: {
                n3 = 4;
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "tid"), n3, null, false, Nullable.UNKNOWN);
                break;
            }
            case 18: {
                n3 = 1;
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(1, "char"), n3, null, false, Nullable.UNKNOWN);
                break;
            }
            case 1042: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(1, "bpchar"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 21: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(5, "int2"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 23: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(4, "int4"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 28: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(4, "xid"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 26: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(-5, "oid"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 20: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(-5, "int8"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 700: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(7, "float4"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 701: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(8, "float8"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 1082: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(91, "date"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 1083: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(92, "time"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 1114: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(93, "timestamp"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 702: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(93, "abstime"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 1186: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "interval"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 703: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "reltime"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 16: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(-7, "bool"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 1560: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(-7, "bit"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            case 1700: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(2, "numeric"), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
            default: {
                parameterMetadata = new ParameterMetadata(n2, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(1111, null), -1L, null, false, Nullable.UNKNOWN);
                break;
            }
        }
        if (parameterMetadata.getTypeMetadata().isIntervalType() || parameterMetadata.getTypeMetadata().isCharacterType()) {
            parameterMetadata.getTypeMetadata().setIntervalPrecision(n3);
        }
        if (parameterMetadata.getTypeMetadata().isCharacterType()) {
            parameterMetadata.setColumnLength(n3);
        }
        return parameterMetadata;
    }

    public static byte[] toUTF8ByteArray(DataWrapper dataWrapper) throws ErrorException {
        try {
            if (dataWrapper.isNull()) {
                return null;
            }
            switch (dataWrapper.getType()) {
                case 12: {
                    return dataWrapper.getVarChar().getBytes();
                }
                case 1: {
                    return dataWrapper.getChar().getBytes();
                }
                case 5: {
                    return dataWrapper.getSmallInt().toString().getBytes();
                }
                case 4: {
                    return dataWrapper.getInteger().toString().getBytes();
                }
                case -5: {
                    return dataWrapper.getBigInt().toString().getBytes();
                }
                case 7: {
                    return dataWrapper.getReal().toString().getBytes();
                }
                case 8: {
                    return dataWrapper.getDouble().toString().getBytes();
                }
                case 91: {
                    Date date = dataWrapper.getDate();
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(date);
                    String string = DATE_FORMAT.format(date);
                    if (0 == gregorianCalendar.get(0)) {
                        string = string.concat(" BC");
                    }
                    return string.getBytes();
                }
                case 92: {
                    return dataWrapper.getTime().toString().getBytes();
                }
                case 93: {
                    Timestamp timestamp = dataWrapper.getTimestamp();
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(timestamp);
                    String string = TIMESTAMP_FORMAT.format(timestamp);
                    string = string.concat(NANOSECONDS_FORMAT.format(timestamp.getNanos()));
                    if (0 == gregorianCalendar.get(0)) {
                        string = string.concat(" BC");
                    }
                    return string.getBytes();
                }
                case -7: {
                    return dataWrapper.getBit().toString().getBytes();
                }
                case 2: {
                    return dataWrapper.getNumeric().toString().getBytes();
                }
                case 1111: {
                    ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_BYTE_BUFFER_CONVERT_ERR.name(), "Not Supported data type");
                    throw errorException;
                }
            }
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_BYTE_BUFFER_CONVERT_ERR.name(), "Not Supported data type");
            throw errorException;
        }
        catch (IncorrectTypeException incorrectTypeException) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_BYTE_BUFFER_CONVERT_ERR.name(), incorrectTypeException.getMessage());
            errorException.initCause(incorrectTypeException);
            throw errorException;
        }
        catch (NullPointerException nullPointerException) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_BYTE_BUFFER_CONVERT_ERR.name(), nullPointerException.getMessage());
            errorException.initCause(nullPointerException);
            throw errorException;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] toDate(byte[] byArray, int n, int n2) throws ErrorException {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            int n6 = -1;
            int n7 = -1;
            int n8 = n;
            int n9 = 0;
            if (byArray[n8] == 45) {
                ++n8;
            }
            block6: while (n8 < n + n2) {
                if (byArray[n8] == 45) {
                    switch (n9) {
                        case 0: {
                            n6 = n8 - n;
                            ++n9;
                            break;
                        }
                        case 1: {
                            n7 = n8 - n;
                            break block6;
                        }
                    }
                }
                ++n8;
            }
            if (-1 == n6) throw new Exception();
            if (-1 == n7) throw new Exception();
            n3 = PGDataTypeUtilities.toInteger(byArray, n, n6);
            n4 = PGDataTypeUtilities.toInteger(byArray, n + n6 + 1, 2);
            if (n2 > n7 + 3) {
                n5 = PGDataTypeUtilities.toInteger(byArray, n + n7 + 1, 2);
                if (n + n2 - 2 < 0 || byArray[n + n2 - 2] != 66 || byArray[n + n2 - 1] != 67) return new int[]{n3, n4, n5};
                n3 = -n3;
                return new int[]{n3, n4, n5};
            }
            int n10 = n + n7 + 1;
            n5 = PGDataTypeUtilities.toInteger(byArray, n10, n2 - n7 - 1);
            return new int[]{n3, n4, n5};
        }
        catch (Exception exception) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_BYTE_BUFFER_CONVERT_ERR.name(), "GET date Type data error from string " + new String(byArray, n, n2));
        }
    }

    public static Date toSqlDate(int[] nArray) {
        Calendar calendar = GregorianCalendar.getInstance();
        if (nArray[0] < 0) {
            nArray[0] = -nArray[0];
            calendar.set(0, 0);
        }
        calendar.set(1, nArray[0]);
        calendar.set(2, nArray[1] - 1);
        calendar.set(5, nArray[2]);
        Date date = new Date(calendar.getTime().getTime());
        return date;
    }

    public static int[] toTime(byte[] byArray, int n, int n2) throws ErrorException {
        int n3 = 100000;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            n4 = (byArray[n] - 48) * 10 + (byArray[n + 1] - 48) * 1;
            n5 = (byArray[n + 3] - 48) * 10 + (byArray[n + 4] - 48) * 1;
            n6 = (byArray[n + 6] - 48) * 10 + (byArray[n + 7] - 48) * 1;
            if (byArray.length == 15) {
                n7 = (byArray[n + 9] - 48) * n3 + (byArray[n + 10] - 48) * (n3 / 10) + (byArray[n + 11] - 48) * (n3 / 100) + (byArray[n + 12] - 48) * (n3 / 1000) + (byArray[n + 13] - 48) * (n3 / 10000) + (byArray[n + 14] - 48) * (n3 / 100000);
            }
        }
        catch (Exception exception) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_BYTE_BUFFER_CONVERT_ERR.name(), "GET Time Type data error");
        }
        int[] nArray = new int[]{n4, n5, n6, n7 / 1000};
        return nArray;
    }

    public static int[] toTimestamp(byte[] byArray, int n, int n2) throws ErrorException {
        int n3 = 15;
        int n4 = 100000000;
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[8];
        int n5 = 0;
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            int n6;
            if (!bl) {
                if (byArray[n + i] != 32) {
                    byArray2[i] = byArray[n + i];
                    continue;
                }
                bl = true;
                n3 = i;
                continue;
            }
            if (byArray[n + i] != 32 && i < 19) {
                if (byArray[n + i] == 32) continue;
                byArray3[i - 1 - n3] = byArray[n + i];
                continue;
            }
            if (byArray.length <= 19 || i < 19 || (n6 = PGDataTypeUtilities.utf8Lookup(byArray[n + i])) == -1) continue;
            int n7 = n6 * n4;
            n4 /= 10;
            n5 += n7;
        }
        int[] nArray = PGDataTypeUtilities.toDate(byArray2, 0, byArray2.length);
        int[] nArray2 = PGDataTypeUtilities.toTime(byArray3, 0, byArray3.length);
        if (n + n2 - 2 >= 0 && byArray[n + n2 - 2] == 66 && byArray[n + n2 - 1] == 67) {
            nArray[0] = -nArray[0];
        }
        int[] nArray3 = new int[]{nArray[0], nArray[1], nArray[2], nArray2[0], nArray2[1], nArray2[2], n5};
        return nArray3;
    }

    public static Timestamp toSqlTimestamp(int[] nArray) {
        Calendar calendar = GregorianCalendar.getInstance();
        if (nArray[0] < 0) {
            nArray[0] = -nArray[0];
            calendar.set(0, 0);
        }
        calendar.set(1, nArray[0]);
        calendar.set(2, nArray[1] - 1);
        calendar.set(5, nArray[2]);
        calendar.set(11, nArray[3]);
        calendar.set(12, nArray[4]);
        calendar.set(13, nArray[5]);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(nArray[6]);
        return timestamp;
    }

    public static Boolean toBit(byte[] byArray, int n) {
        if (byArray[n] == 116 || byArray[n] == 49) {
            return true;
        }
        if (byArray[n] == 102 || byArray[n] == 48) {
            return false;
        }
        return null;
    }

    public static byte[] transformByteFormat(byte[] byArray, int n, int n2) {
        boolean bl = false;
        int n3 = n;
        if (null == byArray) {
            return null;
        }
        if (0 == n2) {
            return new byte[0];
        }
        if (92 != byArray[n3]) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return byArray2;
        }
        if (120 != byArray[++n3]) {
            if (n2 % 4 != 0) {
                byte[] byArray3 = new byte[n2];
                System.arraycopy(byArray, n, byArray3, 0, n2);
                return byArray3;
            }
            byte[] byArray4 = new byte[n2 / 4];
            int n4 = 0;
            while (n3 < n + n2) {
                int n5 = PGDataTypeUtilities.hexEncodingLookup(byArray[n3]) << 6;
                bl = (byte)n5 == 127 || bl;
                int n6 = PGDataTypeUtilities.hexEncodingLookup(byArray[++n3]) << 3;
                bl = (byte)n6 == 127 || bl;
                int n7 = PGDataTypeUtilities.hexEncodingLookup(byArray[++n3]);
                bl = (byte)n7 == 127 || bl;
                ++n3;
                int n8 = (n5 | n6) & 0xF0;
                int n9 = (n6 | n7) & 0xF;
                byArray4[n4] = (byte)(n8 | n9);
                ++n3;
                ++n4;
            }
            if (bl) {
                byte[] byArray5 = new byte[n2];
                System.arraycopy(byArray, n, byArray5, 0, n2);
                return byArray5;
            }
            return byArray4;
        }
        if (1 == (n + n2 - ++n3) % 2) {
            byte[] byArray6 = new byte[n2];
            System.arraycopy(byArray, n, byArray6, 0, n2);
            return byArray6;
        }
        byte[] byArray7 = new byte[(n + n2 - n3) / 2];
        bl = false;
        int n10 = 0;
        while (n3 < n + n2) {
            int n11 = PGDataTypeUtilities.hexEncodingLookup(byArray[n3]) << 4;
            bl = (byte)n11 == 127 || bl;
            int n12 = PGDataTypeUtilities.hexEncodingLookup(byArray[++n3]);
            bl = (byte)n12 == 127 || bl;
            ++n3;
            byArray7[n10] = (byte)(n11 | n12);
            ++n10;
        }
        if (bl) {
            byte[] byArray8 = new byte[n2];
            System.arraycopy(byArray, n, byArray8, 0, n2);
            return byArray8;
        }
        return byArray7;
    }

    public static int toInt(byte[] byArray, int n) {
        if (byArray.length - n > 3) {
            return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        }
        if (byArray.length - n == 3) {
            return (byArray[n] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 2] & 0xFF;
        }
        if (byArray.length - n == 2) {
            return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
        }
        return byArray[n] & 0xFF;
    }

    private static IColumn createBaseArrayColumn(String string, String string2, String string3, String string4, int n, int n2, String string5) throws ErrorException {
        TypeMetadata typeMetadata = PGDataTypeUtilities.createTypeMetadata(n, string5);
        ColumnMetadata columnMetadata = new ColumnMetadata(typeMetadata);
        if (typeMetadata.isIntervalType() || typeMetadata.isCharacterType()) {
            typeMetadata.setIntervalPrecision(n2);
        }
        if (typeMetadata.isCharacterType()) {
            try {
                columnMetadata.setColumnLength(n2);
            }
            catch (NumericOverflowException numericOverflowException) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_METADATA_INITIALIZATION_ERR.name(), numericOverflowException);
            }
        }
        if (typeMetadata.isExactNumericType()) {
            int n3 = n2 - 4 >> 16 & 0xFFFF;
            int n4 = n2 - 4 & 0xFFFF;
            typeMetadata.setPrecision((short)n3);
            typeMetadata.setScale((short)n4);
        }
        columnMetadata.setName(string4);
        columnMetadata.setLabel(columnMetadata.getName());
        columnMetadata.setCatalogName(string);
        columnMetadata.setTableName(string3);
        return columnMetadata;
    }

    private static int hexEncodingLookup(byte by) {
        int n = 127;
        switch (by) {
            case 48: {
                n = 0;
                break;
            }
            case 49: {
                n = 1;
                break;
            }
            case 50: {
                n = 2;
                break;
            }
            case 51: {
                n = 3;
                break;
            }
            case 52: {
                n = 4;
                break;
            }
            case 53: {
                n = 5;
                break;
            }
            case 54: {
                n = 6;
                break;
            }
            case 55: {
                n = 7;
                break;
            }
            case 56: {
                n = 8;
                break;
            }
            case 57: {
                n = 9;
                break;
            }
            case 97: {
                n = 10;
                break;
            }
            case 98: {
                n = 11;
                break;
            }
            case 99: {
                n = 12;
                break;
            }
            case 100: {
                n = 13;
                break;
            }
            case 101: {
                n = 14;
                break;
            }
            case 102: {
                n = 15;
            }
        }
        return n;
    }

    private static int utf8Lookup(byte by) {
        int n = -1;
        switch (by) {
            case 48: {
                n = 0;
                break;
            }
            case 49: {
                n = 1;
                break;
            }
            case 50: {
                n = 2;
                break;
            }
            case 51: {
                n = 3;
                break;
            }
            case 52: {
                n = 4;
                break;
            }
            case 53: {
                n = 5;
                break;
            }
            case 54: {
                n = 6;
                break;
            }
            case 55: {
                n = 7;
                break;
            }
            case 56: {
                n = 8;
                break;
            }
            case 57: {
                n = 9;
            }
        }
        return n;
    }
}

