/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.communications.interfaces;

import com.amazon.jdbc.communications.InboundMessagesContainer;
import com.amazon.jdbc.communications.InboundMessagesPipeline;
import com.amazon.jdbc.communications.channels.AbstractMessagesSocketChannel;
import com.amazon.jdbc.communications.exceptions.MessageBoundarySyncronizationLostException;
import com.amazon.jdbc.communications.interfaces.Closable;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class AbstractInboundDataHandler
implements Closable {
    public static int BLOCKING_QUEUE_TIMEOUT = 100;
    private InboundMessagesContainer m_results;
    protected ILogger m_log;
    protected List<InboundMessagesPipeline> m_pipelines = new ArrayList<InboundMessagesPipeline>();
    protected AbstractMessagesSocketChannel m_socketChannel;
    protected int m_defaultNRowMode;
    protected int m_activeNRowMode;
    protected InboundMessagesPipeline m_currentPipeline;
    private boolean m_close;
    protected int m_filterLevel;

    public AbstractInboundDataHandler(ILogger iLogger, int n, int n2) {
        this.m_log = iLogger;
        this.m_activeNRowMode = this.m_defaultNRowMode = n;
        this.m_filterLevel = n2;
        this.m_close = false;
    }

    protected boolean validateCurrentPipeline() {
        if (null == this.m_currentPipeline && !this.m_pipelines.isEmpty()) {
            this.m_currentPipeline = this.m_pipelines.remove(0);
        }
        if (null != this.m_currentPipeline) {
            this.m_activeNRowMode = this.m_currentPipeline.getNRowMode();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_currentPipeline) {
            this.m_currentPipeline.close();
            this.m_currentPipeline = null;
        }
        if (null != this.m_pipelines) {
            while (this.validateCurrentPipeline()) {
                this.m_currentPipeline.close();
                this.m_currentPipeline = null;
            }
        }
    }

    public void close(ErrorException errorException) {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_currentPipeline) {
            this.m_currentPipeline.close(errorException);
            this.m_currentPipeline = null;
        }
        if (null != this.m_pipelines) {
            while (this.validateCurrentPipeline()) {
                this.m_currentPipeline.close(errorException);
                this.m_currentPipeline = null;
            }
        }
    }

    public void addPipeline(InboundMessagesPipeline inboundMessagesPipeline) {
        if (null != inboundMessagesPipeline && !this.m_pipelines.add(inboundMessagesPipeline)) {
            LogUtilities.logFatal("Could not add to pipeline", this.m_log);
        }
    }

    public void setSocketChannel(AbstractMessagesSocketChannel abstractMessagesSocketChannel) {
        this.m_socketChannel = abstractMessagesSocketChannel;
    }

    public void removeCurrentPipeline() {
        this.m_results = null;
    }

    public void closeOperation() {
        if (null != this.m_currentPipeline) {
            this.m_currentPipeline.closeCurrentOperation();
        }
    }

    public void addToPipeline(IInboundMessage iInboundMessage, boolean bl) {
        this.validateCurrentPipeline();
        if (0 == this.m_activeNRowMode) {
            if (null == this.m_results || !this.m_results.add(iInboundMessage)) {
                this.addToNewPipeline(iInboundMessage);
            }
            ++this.m_currentPipeline.m_totalMessageCount;
            this.addPipelineToBlockingQueue();
        } else if (this.m_currentPipeline.m_currentMessagesContainer.add(iInboundMessage, bl)) {
            ++this.m_currentPipeline.m_totalMessageCount;
        } else if (this.m_log.isEnabled()) {
            LogUtilities.logDebug("Pipeline would not accept message: " + iInboundMessage.toString(), this.m_log);
        }
    }

    private void addToNewPipeline(IInboundMessage iInboundMessage) {
        this.m_results = new InboundMessagesContainer(this.m_activeNRowMode);
        if (!this.m_results.add(iInboundMessage)) {
            LogUtilities.logFatal("addToNewPipeline failed:" + iInboundMessage.getClass().getSimpleName(), this.m_log);
        }
    }

    private void addPipelineToBlockingQueue() {
        if (null != this.m_results && !this.m_results.isInQueue()) {
            while (!this.m_close) {
                try {
                    if (this.m_currentPipeline.m_messageContainers.offer(this.m_results, BLOCKING_QUEUE_TIMEOUT, TimeUnit.MILLISECONDS)) {
                        this.m_results.setInQueue();
                    } else {
                        LogUtilities.logFatal("addPipelineToBlockingQueue failed:", this.m_log);
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    public abstract void handle(ByteBuffer var1) throws MessageBoundarySyncronizationLostException, ErrorException;

    public abstract boolean isOpenOperation();
}

