/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.communications.channels;

import com.amazon.jdbc.communications.channels.AbstractMessagesSocketChannel;
import com.amazon.jdbc.communications.exceptions.MessageBoundarySyncronizationLostException;
import com.amazon.jdbc.communications.exceptions.MessagesFrameworkMessageKey;
import com.amazon.jdbc.communications.interfaces.AbstractInboundDataHandler;
import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;

public class SSLMessagesSocketChannel
extends AbstractMessagesSocketChannel {
    private static final String PROTOCOL_SSL = "SSL";
    private SSLContext m_sslContext;
    private SSLEngine m_sslEngine;
    private SSLSession m_sslSession;
    private ByteBuffer m_sendClearTextBuffer;
    private ByteBuffer m_sendEncryptedBuffer;
    private ByteBuffer m_recvEncryptedBuffer;
    private ByteBuffer m_recvClearTextBuffer;
    private ByteBuffer m_sendHandshakeClearTextBuffer;
    private ByteBuffer m_recvHandshakeClearTextBuffer;
    private SSLWriteEngineLock m_sslengineWriteLock;
    private SSLReadEngineLock m_sslengineReadLock;

    public SSLMessagesSocketChannel(SocketChannel socketChannel, AbstractInboundDataHandler abstractInboundDataHandler, String string, int n, KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, ILogger iLogger) throws ErrorException {
        super(socketChannel, abstractInboundDataHandler, iLogger);
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_sslengineWriteLock = new SSLWriteEngineLock();
        this.m_sslengineReadLock = new SSLReadEngineLock();
        System.setProperty("com.sun.net.ssl.rsaPreMasterSecretFix", "true");
        try {
            this.m_sslContext = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LogUtilities.logFatal(noSuchAlgorithmException, this.m_log);
            ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), noSuchAlgorithmException.getMessage());
            errorException.initCause(noSuchAlgorithmException);
            throw errorException;
        }
        try {
            this.m_sslContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
        }
        catch (KeyManagementException keyManagementException) {
            LogUtilities.logFatal(keyManagementException, this.m_log);
            ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), keyManagementException.getMessage());
            errorException.initCause(keyManagementException);
            throw errorException;
        }
        this.m_sslEngine = this.m_sslContext.createSSLEngine(string, n);
        this.m_sslEngine.setEnabledProtocols(this.removeSSLProtocols(this.m_sslEngine.getEnabledProtocols()));
        this.m_sslEngine.setEnabledProtocols(this.removeSSLProtocols(this.m_sslEngine.getEnabledProtocols()));
        this.m_sslEngine.setUseClientMode(true);
        this.m_sslSession = this.m_sslEngine.getSession();
        this.m_recvEncryptedBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getPacketBufferSize());
        this.m_recvClearTextBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getApplicationBufferSize());
        this.m_sendEncryptedBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getPacketBufferSize());
        this.m_sendClearTextBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getApplicationBufferSize());
        this.m_sendHandshakeClearTextBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getApplicationBufferSize());
        this.m_recvHandshakeClearTextBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getApplicationBufferSize());
        this.m_recvEncryptedBuffer.order(ByteOrder.BIG_ENDIAN);
        this.m_recvClearTextBuffer.order(ByteOrder.BIG_ENDIAN);
        this.m_sendEncryptedBuffer.order(ByteOrder.BIG_ENDIAN);
        this.m_sendClearTextBuffer.order(ByteOrder.BIG_ENDIAN);
        this.doHandshake();
    }

    private String[] removeSSLProtocols(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Input protocols = '");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            stringBuffer.append(string);
            stringBuffer.append(",");
            if (null == string || string.toUpperCase().contains(PROTOCOL_SSL)) continue;
            arrayList.add(string);
        }
        stringBuffer.append("', enabled protocols = '");
        for (String string : arrayList) {
            stringBuffer.append(string);
            stringBuffer.append(",");
        }
        stringBuffer.append("'");
        LogUtilities.logDebug(stringBuffer.toString(), this.m_log);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected synchronized void readMessages() throws ErrorException, MessageBoundarySyncronizationLostException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        SSLEngineResult sSLEngineResult = null;
        int n = -1;
        int n2 = -2;
        SSLReadEngineLock sSLReadEngineLock = this.m_sslengineReadLock;
        synchronized (sSLReadEngineLock) {
            while (true) {
                try {
                    n2 = this.m_internal.read(this.m_recvEncryptedBuffer);
                }
                catch (IOException iOException) {
                    LogUtilities.logFatal(iOException, this.m_log);
                    ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), iOException.getMessage());
                    errorException.initCause(iOException);
                    throw errorException;
                }
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("Bytes read from ssl channel: " + n2, this.m_log);
                }
                if (-1 == n2) {
                    throw EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), "The server closed the connection.");
                }
                block22: do {
                    try {
                        n = this.m_recvEncryptedBuffer.position();
                        this.m_recvEncryptedBuffer.flip();
                        sSLEngineResult = this.m_sslEngine.unwrap(this.m_recvEncryptedBuffer, this.m_recvClearTextBuffer);
                        if (this.m_log.isEnabled()) {
                            LogUtilities.logFatal("ReadMessages:UNWRAP:Consume:" + sSLEngineResult.bytesConsumed() + ":Produced:" + sSLEngineResult.bytesProduced() + ":Position:" + this.m_recvEncryptedBuffer.position(), this.m_log);
                        }
                    }
                    catch (SSLProtocolException sSLProtocolException) {
                        LogUtilities.logFatal(sSLProtocolException, this.m_log);
                        ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), sSLProtocolException.getMessage());
                        errorException.initCause(sSLProtocolException);
                        throw errorException;
                    }
                    catch (SSLException sSLException) {
                        LogUtilities.logFatal(sSLException, this.m_log);
                        ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), sSLException.getMessage());
                        errorException.initCause(sSLException);
                        throw errorException;
                    }
                    catch (ReadOnlyBufferException readOnlyBufferException) {
                        LogUtilities.logFatal(readOnlyBufferException, this.m_log);
                        ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), readOnlyBufferException.getMessage());
                        errorException.initCause(readOnlyBufferException);
                        throw errorException;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LogUtilities.logFatal(illegalArgumentException, this.m_log);
                        ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), illegalArgumentException.getMessage());
                        errorException.initCause(illegalArgumentException);
                        throw errorException;
                    }
                    catch (IllegalStateException illegalStateException) {
                        LogUtilities.logFatal(illegalStateException, this.m_log);
                        ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), illegalStateException.getMessage());
                        errorException.initCause(illegalStateException);
                        throw errorException;
                    }
                    if (null != sSLEngineResult) {
                        switch (sSLEngineResult.getStatus()) {
                            case OK: {
                                LogUtilities.logDebug("ReadMessages:OK:" + (Object)((Object)sSLEngineResult.getHandshakeStatus()), this.m_log);
                                switch (sSLEngineResult.getHandshakeStatus()) {
                                    case NEED_TASK: 
                                    case NEED_UNWRAP: 
                                    case NEED_WRAP: {
                                        if (this.m_log.isEnabled()) {
                                            LogUtilities.logFatal("Handshake request detected: " + (Object)((Object)sSLEngineResult.getHandshakeStatus()) + ":EncReadBuffer.remaining():" + this.m_recvEncryptedBuffer.remaining() + ":ClearTextBuffer.remaining():" + this.m_recvClearTextBuffer.remaining(), this.m_log);
                                        }
                                        try {
                                            if (this.m_log.isEnabled()) {
                                                LogUtilities.logFatal("ReadMessages:OK:NEED_TASK:PreReadMessages:Before:Flip:0:EncHSRecvBuffer.remaining:" + this.m_recvEncryptedBuffer.remaining() + ":EncHSRecvBuffer.pos:" + this.m_recvEncryptedBuffer.position() + ":EncHSRecvBuffer.limit:" + this.m_recvEncryptedBuffer.limit(), this.m_log);
                                            }
                                            this.m_recvEncryptedBuffer.clear();
                                            if (this.m_log.isEnabled()) {
                                                LogUtilities.logFatal("ReadMessages:OK:NEED_TASK:BEGINNING:0:EncHSRecvBuffer.remaining:" + this.m_recvEncryptedBuffer.remaining() + ":EncHSRecvBuffer.pos:" + this.m_recvEncryptedBuffer.position() + ":EncHSRecvBuffer.limit:" + this.m_recvEncryptedBuffer.limit(), this.m_log);
                                            }
                                            this.doHandshake();
                                            break;
                                        }
                                        catch (Exception exception) {
                                            LogUtilities.logFatal(exception, this.m_log);
                                            ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), exception.getMessage());
                                            errorException.initCause(exception);
                                            throw errorException;
                                        }
                                    }
                                    default: {
                                        n = -1;
                                        this.m_recvClearTextBuffer.flip();
                                        this.m_dataHandler.handle(this.m_recvClearTextBuffer);
                                        if (this.m_recvEncryptedBuffer.hasRemaining()) {
                                            this.m_recvEncryptedBuffer.compact();
                                            break;
                                        }
                                        this.m_recvEncryptedBuffer.clear();
                                        break;
                                    }
                                }
                                continue block22;
                            }
                            case BUFFER_OVERFLOW: {
                                LogUtilities.logDebug("ReadMessages:BUFFER_OVERFLOW", this.m_log);
                                if (n != -1) {
                                    this.m_recvEncryptedBuffer.position(n);
                                    this.m_recvEncryptedBuffer.limit(this.m_recvEncryptedBuffer.capacity());
                                }
                                this.m_recvClearTextBuffer = this.resizeBuffer(this.m_recvClearTextBuffer, this.m_sslEngine.getSession().getApplicationBufferSize());
                                continue block22;
                            }
                            case BUFFER_UNDERFLOW: {
                                LogUtilities.logDebug("ReadMessages:BUFFER_UNDERFLOW", this.m_log);
                                if (n == -1) break;
                                this.m_recvEncryptedBuffer.position(n);
                                this.m_recvEncryptedBuffer.limit(this.m_recvEncryptedBuffer.capacity());
                                continue block22;
                            }
                            case CLOSED: {
                                LogUtilities.logDebug("ReadMessages:CLOSED", this.m_log);
                            }
                        }
                        continue;
                    }
                    LogUtilities.logDebug("ReadMessages:Result was null but there was no exception.", this.m_log);
                } while (this.m_recvEncryptedBuffer.position() > 0 && null != sSLEngineResult && sSLEngineResult.getStatus() == SSLEngineResult.Status.OK);
                if (null == sSLEngineResult) continue;
                if (null == sSLEngineResult) return;
                if (sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void writeMessages(AbstractOutboundMessage[] abstractOutboundMessageArray) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null == this.m_sendEncryptedBuffer) {
            this.m_sendEncryptedBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getPacketBufferSize());
            this.m_sendClearTextBuffer = ByteBuffer.allocateDirect(this.m_sslSession.getApplicationBufferSize());
            this.m_sendEncryptedBuffer.order(ByteOrder.BIG_ENDIAN);
            this.m_sendClearTextBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        SSLWriteEngineLock sSLWriteEngineLock = this.m_sslengineWriteLock;
        synchronized (sSLWriteEngineLock) {
            try {
                int n = 0;
                for (AbstractOutboundMessage abstractOutboundMessage : abstractOutboundMessageArray) {
                    if (null == abstractOutboundMessage) continue;
                    n += abstractOutboundMessage.getSize() + 1;
                }
                if (n > this.m_sendClearTextBuffer.capacity()) {
                    this.m_sendClearTextBuffer = ByteBuffer.allocateDirect(n);
                }
                for (AbstractOutboundMessage abstractOutboundMessage : abstractOutboundMessageArray) {
                    if (null == abstractOutboundMessage) continue;
                    abstractOutboundMessage.serialize(this.m_sendClearTextBuffer);
                }
                this.m_sendClearTextBuffer.flip();
                this.m_sendEncryptedBuffer.clear();
                while (this.m_sendClearTextBuffer.hasRemaining()) {
                    Object object = null;
                    object = this.m_sslEngine.wrap(this.m_sendClearTextBuffer, this.m_sendEncryptedBuffer);
                    this.m_sendEncryptedBuffer.flip();
                    switch (((SSLEngineResult)object).getStatus()) {
                        case OK: {
                            LogUtilities.logFatal("WriteMessages:OK:" + (Object)((Object)((SSLEngineResult)object).getHandshakeStatus()), this.m_log);
                            switch (((SSLEngineResult)object).getHandshakeStatus()) {
                                case NEED_TASK: 
                                case NEED_UNWRAP: 
                                case NEED_WRAP: {
                                    try {
                                        if (this.m_log.isEnabled()) {
                                            LogUtilities.logFatal("WriteMessages:OK:NEED_TASK:BEGINNING:0:EncHSRecvBuffer.remaining:" + this.m_recvEncryptedBuffer.remaining() + ":EncHSRecvBuffer.pos:" + this.m_recvEncryptedBuffer.position() + ":EncHSRecvBuffer.limit:" + this.m_recvEncryptedBuffer.limit() + ":TempEncHSRecvBuffer.remaining:", this.m_log);
                                        }
                                        this.doHandshake();
                                        this.m_sendEncryptedBuffer.flip();
                                        this.m_sendEncryptedBuffer.limit(this.m_sendEncryptedBuffer.capacity());
                                        break;
                                    }
                                    catch (Exception exception) {
                                        LogUtilities.logFatal(exception, this.m_log);
                                        ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), exception.getMessage());
                                        errorException.initCause(exception);
                                        throw errorException;
                                    }
                                }
                                default: {
                                    while (this.m_sendEncryptedBuffer.hasRemaining()) {
                                        int n2 = this.m_internal.write(this.m_sendEncryptedBuffer);
                                        if (-1 == n2) {
                                            LogUtilities.logFatal("WriteMessages:OK:Closed", this.m_log);
                                            continue;
                                        }
                                        if (0 == n2) {
                                            LogUtilities.logFatal("WriteMessages:OK:0 Bytes Writted", this.m_log);
                                            continue;
                                        }
                                        LogUtilities.logFatal("WriteMessages:OK:" + n2 + " bytes sent.", this.m_log);
                                        break;
                                    }
                                    LogUtilities.logFatal("Wrote Messages - " + (Object)((Object)this.m_sslEngine.getHandshakeStatus()), this.m_log);
                                    break;
                                }
                            }
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            LogUtilities.logFatal("WriteMessages:BUFFER_OVERFLOW:Expanding to " + this.m_sslEngine.getSession().getPacketBufferSize() + " bytes.", this.m_log);
                            this.m_sendEncryptedBuffer = this.resizeBuffer(this.m_sendEncryptedBuffer, this.m_sslEngine.getSession().getPacketBufferSize());
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            LogUtilities.logFatal("WriteMessages:BUFFER_UNDERFLOW:Should not happen", this.m_log);
                            break;
                        }
                        case CLOSED: {
                            LogUtilities.logFatal("WriteMessages:CLOSED", this.m_log);
                            return;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                LogUtilities.logFatal(iOException, this.m_log);
                ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), iOException.getMessage());
                errorException.initCause(iOException);
                throw errorException;
            }
        }
        this.m_sendClearTextBuffer.compact();
    }

    @Override
    public void close() {
        try {
            this.m_recvClearTextBuffer.flip();
            SSLEngineResult sSLEngineResult = this.m_sslEngine.unwrap(this.m_recvClearTextBuffer, this.m_recvEncryptedBuffer);
            if (sSLEngineResult.getStatus() != SSLEngineResult.Status.CLOSED) {
                this.m_sslEngine.closeOutbound();
                SSLEngineResult sSLEngineResult2 = null;
                block2: while (null == sSLEngineResult2 || sSLEngineResult2.getStatus() != SSLEngineResult.Status.CLOSED || !this.m_sslEngine.isOutboundDone()) {
                    this.m_sendEncryptedBuffer.clear();
                    sSLEngineResult2 = this.m_sslEngine.wrap(this.m_sendClearTextBuffer, this.m_sendEncryptedBuffer);
                    this.m_sendEncryptedBuffer.flip();
                    this.m_sendClearTextBuffer.compact();
                    while (this.m_sendEncryptedBuffer.hasRemaining()) {
                        int n = this.m_internal.write(this.m_sendEncryptedBuffer);
                        if (-1 == n) {
                            LogUtilities.logFatal("WriteMessages:OK:Closed", this.m_log);
                            continue;
                        }
                        if (0 == n) {
                            LogUtilities.logFatal("WriteMessages:OK:0 Bytes Writted", this.m_log);
                            continue;
                        }
                        LogUtilities.logFatal("WriteMessages:OK:" + n + " bytes sent.", this.m_log);
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            LogUtilities.logFatal(exception, this.m_log);
        }
        super.close();
    }

    @Override
    public int getReadBufferCapacity() {
        return this.m_recvEncryptedBuffer.capacity();
    }

    @Override
    public int getWriteBufferCapacity() {
        return this.m_sendEncryptedBuffer.capacity();
    }

    private void doHandshake() throws ErrorException {
        SSLEngineResult.HandshakeStatus handshakeStatus;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        this.logHandshakeAction("BEGIN:", n, n2, n3);
        try {
            this.m_sslEngine.beginHandshake();
        }
        catch (SSLException sSLException) {
            LogUtilities.logFatal(sSLException, this.m_log);
            ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), sSLException.getMessage());
            errorException.initCause(sSLException);
            throw errorException;
        }
        n2 = 0;
        n3 = 0;
        n = this.readBytes("BEGIN:");
        SSLEngineResult.HandshakeStatus handshakeStatus2 = handshakeStatus = this.m_sslEngine.getHandshakeStatus();
        while (SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING != handshakeStatus2 && SSLEngineResult.HandshakeStatus.FINISHED != handshakeStatus2) {
            SSLEngineResult sSLEngineResult = null;
            SSLEngineResult.Status status = null;
            SSLEngineResult.HandshakeStatus handshakeStatus3 = null;
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    this.logHandshakeAction("NEED_UNWRAP:BEFORE:UNWRAP:", n, n2, n3);
                    try {
                        sSLEngineResult = this.m_sslEngine.unwrap(this.m_recvEncryptedBuffer, this.m_recvHandshakeClearTextBuffer);
                    }
                    catch (SSLException sSLException) {
                        LogUtilities.logFatal("Handshake count: 0", this.m_log);
                        LogUtilities.logFatal(sSLException, this.m_log);
                        ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), sSLException.getMessage());
                        errorException.initCause(sSLException);
                        throw errorException;
                    }
                    handshakeStatus3 = sSLEngineResult.getHandshakeStatus();
                    status = sSLEngineResult.getStatus();
                    LogUtilities.logFatal("\nHandshake:NEED_UNWRAP:UNWRAP:RESULT: UnwrapStatus:" + (Object)((Object)status) + " - UnwrapHandshakeStatus:" + (Object)((Object)handshakeStatus3) + "\n\tBytesConsumed:" + sSLEngineResult.bytesConsumed() + "\n\tBytesProduced:" + sSLEngineResult.bytesProduced(), this.m_log);
                    this.logHandshakeAction("NEED_UNWRAP:AFTER:UNWRAP:", n, n2 += sSLEngineResult.bytesConsumed(), n3 += sSLEngineResult.bytesProduced());
                    switch (status) {
                        case OK: {
                            LogUtilities.logDebug("\nHandshake:NEED_UNWRAP:OK", this.m_log);
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            LogUtilities.logDebug("\nHandshake:NEED_UNWRAP:BUFFER_OVERFLOW", this.m_log);
                            this.m_recvHandshakeClearTextBuffer = this.resizeBuffer(this.m_recvHandshakeClearTextBuffer, this.m_sslSession.getApplicationBufferSize());
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            this.logHandshakeAction("NEED_UNWRAP:BUFFER_UNDERFLOW:BEFORE:", n, n2, n3);
                            if (this.m_recvEncryptedBuffer.remaining() == 0 && this.m_recvEncryptedBuffer.position() == this.m_recvEncryptedBuffer.limit()) {
                                LogUtilities.logFatal("\nBuffer has been consumed", this.m_log);
                                this.m_recvEncryptedBuffer.clear();
                                n = -1;
                            } else {
                                LogUtilities.logFatal("\nBuffer has NOT been consumed. Remaining : " + this.m_recvEncryptedBuffer.remaining(), this.m_log);
                            }
                            if (this.m_recvEncryptedBuffer.remaining() > 0 && this.m_recvEncryptedBuffer.remaining() != this.m_recvEncryptedBuffer.capacity()) {
                                this.compact("NEED_UNWRAP:BUFFER_UNDERFLOW", n, n2, n3);
                            }
                            this.logHandshakeAction("NEED_UNWRAP:BUFFER_UNDERFLOW:BEFORE:READ:", n, n2, n3);
                            n2 = 0;
                            n3 = 0;
                            n = this.readBytes("NEED_UNWRAP:BUFFER_UNDERFLOW");
                            break;
                        }
                        case CLOSED: {
                            LogUtilities.logDebug("Handshake:NEED_UNWRAP:CLOSED", this.m_log);
                        }
                    }
                    break;
                }
                case NEED_WRAP: {
                    LogUtilities.logDebug("\nHandshake:NEED_WRAP", this.m_log);
                    this.m_sendEncryptedBuffer.clear();
                    sSLEngineResult = null;
                    try {
                        LogUtilities.logDebug("\nHandshake:NEED_WRAP:WRAP", this.m_log);
                        sSLEngineResult = this.m_sslEngine.wrap(this.m_sendHandshakeClearTextBuffer, this.m_sendEncryptedBuffer);
                        n2 += sSLEngineResult.bytesConsumed();
                        n3 += sSLEngineResult.bytesProduced();
                        handshakeStatus3 = sSLEngineResult.getHandshakeStatus();
                        status = sSLEngineResult.getStatus();
                        LogUtilities.logFatal("\nHandshake:NEED_WRAP:WRAP:RESULT: WrapStatus:" + (Object)((Object)status) + " - WrapHandshakeStatus:" + (Object)((Object)handshakeStatus3) + "\n\tBytesConsumed:" + sSLEngineResult.bytesConsumed() + "\n\tBytesProduced:" + sSLEngineResult.bytesProduced(), this.m_log);
                    }
                    catch (SSLException sSLException) {
                        LogUtilities.logFatal(sSLException, this.m_log);
                        ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), sSLException.getMessage());
                        errorException.initCause(sSLException);
                        throw errorException;
                    }
                    switch (sSLEngineResult.getStatus()) {
                        case OK: {
                            int n4;
                            this.flip("NEED_WRAP:OK", n, n2, n3, false);
                            int n5 = n4 = 0;
                            LogUtilities.logFatal("NEED_WRAP:OK:BEFORE:WRITE:", this.m_log);
                            while (this.m_sendEncryptedBuffer.hasRemaining()) {
                                try {
                                    n5 = this.m_internal.write(this.m_sendEncryptedBuffer);
                                    n4 += n5;
                                    if (n5 < 0) {
                                        LogUtilities.logDebug("\nHandshake:NEED_WRAP:OK:0 Bytes writted, connection closed.", this.m_log);
                                    }
                                    LogUtilities.logFatal("\nHandshake:NEED_WRAP:OK:WRITE\n\tWritten: " + n5 + " bytes." + "\n\tTotal Written: " + n4 + " bytes.", this.m_log);
                                }
                                catch (IOException iOException) {
                                    LogUtilities.logFatal(iOException, this.m_log);
                                    ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), iOException.getMessage());
                                    errorException.initCause(iOException);
                                    throw errorException;
                                }
                            }
                            LogUtilities.logFatal("\nHandshake:NEED_WRAP:OK:AFTER:WRITE\n\tFinal Total Written: " + n4 + " bytes total.", this.m_log);
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            LogUtilities.logDebug("\nHandshake:NEED_WRAP:BUFFER_OVERFLOW", this.m_log);
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            LogUtilities.logDebug("\nHandshake:NEED_WRAP:BUFFER_UNDERFLOW", this.m_log);
                            break;
                        }
                        case CLOSED: {
                            LogUtilities.logDebug("\nHandshake:NEED_WRAP:CLOSED", this.m_log);
                        }
                    }
                    break;
                }
                case NEED_TASK: {
                    this.needTask();
                    break;
                }
                case FINISHED: {
                    LogUtilities.logDebug("\nHandshake:FINISHED", this.m_log);
                    break;
                }
                case NOT_HANDSHAKING: {
                    LogUtilities.logDebug("\nHandshake:NOT_HANDSHAKING", this.m_log);
                }
            }
            handshakeStatus = this.m_sslEngine.getHandshakeStatus();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n");
            stringBuilder.append((Object)handshakeStatus2);
            stringBuilder.append(":SSL_ENGINE_STATUS: ");
            stringBuilder.append("UpdatedHandshakeStatus: ");
            stringBuilder.append((Object)handshakeStatus3);
            stringBuilder.append(" - EngineHandshakeStatus: ");
            stringBuilder.append((Object)handshakeStatus);
            if (null != handshakeStatus3 && handshakeStatus3 != handshakeStatus) {
                stringBuilder.append(" !!!!!!!!!!!!!!!");
            }
            LogUtilities.logDebug(stringBuilder.toString(), this.m_log);
            handshakeStatus2 = handshakeStatus;
        }
        if (n == -1) {
            LogUtilities.logFatal("\nBuffer has been consumed", this.m_log);
            this.m_recvEncryptedBuffer.compact();
        } else {
            this.m_recvEncryptedBuffer.position(n2);
            this.m_recvEncryptedBuffer.limit(n);
            this.m_recvEncryptedBuffer.compact();
        }
        this.logHandshakeAction("FINSIHED:", n, n2, n3);
        LogUtilities.logFatal("\nHandshake: All done.", this.m_log);
    }

    private ByteBuffer resizeBuffer(ByteBuffer byteBuffer, int n) {
        if (n > byteBuffer.remaining()) {
            LogUtilities.logDebug("Buffer resize - Remaining: " + byteBuffer.remaining() + ", Limit: " + byteBuffer.limit() + ", SSLEngine.???Size: " + n + ", new size will be: " + (n + byteBuffer.limit()), this.m_log);
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n + byteBuffer.limit());
            byteBuffer.flip();
            byteBuffer2.put(byteBuffer);
            return byteBuffer2;
        }
        return byteBuffer;
    }

    private void logHandshakeAction(String string, int n, int n2, int n3) {
        if (this.m_log.isEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\nHandshake:");
            stringBuilder.append(string);
            stringBuilder.append("\n\tRead:");
            stringBuilder.append(n);
            if (n != -1 && n < n2) {
                stringBuilder.append(" !!");
            }
            stringBuilder.append("\n\tConsumed Since Read:");
            stringBuilder.append(n2);
            if (n != -1 && n < n2) {
                stringBuilder.append(" !!");
            }
            stringBuilder.append("\n\tProduced Since Read:");
            stringBuilder.append(n3);
            stringBuilder.append("\n\tEncHSRecvBuffer.remaining:");
            stringBuilder.append(this.m_recvEncryptedBuffer.remaining());
            stringBuilder.append("\n\tEncHSRecvBuffer.pos:");
            stringBuilder.append(this.m_recvEncryptedBuffer.position());
            stringBuilder.append("\n\tEncHSRecvBuffer.limit:");
            stringBuilder.append(this.m_recvEncryptedBuffer.limit());
            stringBuilder.append("\n\tEncHSRecvBuffer.capacity:");
            stringBuilder.append(this.m_recvEncryptedBuffer.capacity());
            stringBuilder.append("\n\tClearHSRecvBuffer.remaining:");
            stringBuilder.append(this.m_recvHandshakeClearTextBuffer.remaining());
            stringBuilder.append("\n\tClearHSRecvBuffer.pos:");
            stringBuilder.append(this.m_recvHandshakeClearTextBuffer.position());
            stringBuilder.append("\n\tCLearHSRecvBuffer.limit:");
            stringBuilder.append(this.m_recvHandshakeClearTextBuffer.limit());
            stringBuilder.append("\n\tCLearHSRecvBuffer.capacity:");
            stringBuilder.append(this.m_recvHandshakeClearTextBuffer.capacity());
            LogUtilities.logFatal(stringBuilder.toString(), this.m_log);
        }
    }

    private void compact(String string, int n, int n2, int n3) {
        this.logHandshakeAction(string + ":BEFORE:COMPACT:", n, n2, n3);
        this.m_recvEncryptedBuffer.compact();
        this.logHandshakeAction(string + ":AFTER:COMPACT:", n, n2, n3);
    }

    private void flip(String string, int n, int n2, int n3, boolean bl) {
        if (bl) {
            this.logHandshakeAction(string + ":BEFORE:FLIP:", n, n2, n3);
            this.m_recvEncryptedBuffer.flip();
            this.logHandshakeAction(string + ":AFTER:FLIP:", n, n2, n3);
        } else {
            this.m_sendEncryptedBuffer.flip();
        }
    }

    private void needTask() {
        Runnable runnable;
        LogUtilities.logDebug("\nHandshake:NEED_TASK", this.m_log);
        while ((runnable = this.m_sslEngine.getDelegatedTask()) != null) {
            LogUtilities.logFatal("\nHandshake:NEED_TASK:Starting delegate task.", this.m_log);
            runnable.run();
        }
    }

    private int readBytes(String string) throws ErrorException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            do {
                n2 = 0;
                n = 0;
                n3 = this.m_internal.read(this.m_recvEncryptedBuffer);
                LogUtilities.logFatal("\nHandshake:" + string + ":READ:" + "\n\tRead: " + n3 + " bytes." + "\n\tTotal Read: " + (n4 += n3) + " bytes.", this.m_log);
            } while (n3 > 0);
        }
        catch (IOException iOException) {
            LogUtilities.logFatal("Handshake count: 0", this.m_log);
            LogUtilities.logFatal(iOException, this.m_log);
            ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), iOException.getMessage());
            errorException.initCause(iOException);
            throw errorException;
        }
        LogUtilities.logFatal("\nHandshake:" + string + ":AFTER:READ:" + "\n\tFinal Total Read: " + n4 + " bytes total.", this.m_log);
        if (n4 < 0) {
            LogUtilities.logFatal("Handshake count: 0", this.m_log);
            throw EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), "The server closed the connection.");
        }
        this.flip(string, n4, n2, n, true);
        return n4;
    }

    private class SSLWriteEngineLock {
        private SSLWriteEngineLock() {
        }
    }

    private class SSLReadEngineLock {
        private SSLReadEngineLock() {
        }
    }
}

